/*
 * Decompiled with CFR 0.152.
 */
package org.lobobrowser.html.style;

public final class HtmlLength {
    public static final int PIXELS = 1;
    public static final int LENGTH = 2;
    public static final int MULTI_LENGTH = 0;
    public static final HtmlLength[] EMPTY_ARRAY = new HtmlLength[0];
    private final int lengthType;
    private volatile int value;

    public HtmlLength(String spec) throws IndexOutOfBoundsException, NumberFormatException {
        String parseable;
        spec = spec.trim();
        int length = spec.length();
        char lastChar = spec.charAt(length - 1);
        if (lastChar == '%') {
            this.lengthType = 2;
            parseable = spec.substring(0, length - 1).trim();
        } else if (lastChar == '*') {
            this.lengthType = 0;
            parseable = length <= 1 ? "1" : spec.substring(0, length - 1).trim();
        } else {
            this.lengthType = 1;
            parseable = spec;
        }
        this.value = Integer.parseInt(parseable);
    }

    public HtmlLength(int pixels) {
        this.lengthType = 1;
        this.value = pixels;
    }

    public final int getLengthType() {
        return this.lengthType;
    }

    public final int getRawValue() {
        return this.value;
    }

    public final int getLength(int availLength) {
        int lt = this.lengthType;
        if (lt == 2) {
            return availLength * this.value / 100;
        }
        return this.value;
    }

    public final void divideBy(int denominator) {
        int val = this.value;
        this.value = val /= denominator;
    }

    public final boolean isPreferredOver(HtmlLength otherLength) {
        if (otherLength == null) {
            return true;
        }
        if (this.lengthType > otherLength.lengthType) {
            return true;
        }
        return this.value > otherLength.value;
    }
}

