/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.internal.utils;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.GeneralPath;
import javax.swing.UIManager;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;

public class DoubleArrowResizableIcon
implements ResizableIcon {
    private Dimension initialDim;
    protected int width;
    protected int height;
    protected int direction;

    public DoubleArrowResizableIcon(Dimension initialDim, int direction) {
        this.initialDim = initialDim;
        this.width = initialDim.width;
        this.height = initialDim.height;
        this.direction = direction;
    }

    public DoubleArrowResizableIcon(int initialDim, int direction) {
        this(new Dimension(initialDim, initialDim), direction);
    }

    public void revertToOriginalDimension() {
        this.width = this.initialDim.width;
        this.height = this.initialDim.height;
    }

    @Override
    public void setDimension(Dimension newDimension) {
        this.width = newDimension.width;
        this.height = newDimension.height;
    }

    @Override
    public int getIconHeight() {
        return this.height;
    }

    @Override
    public int getIconWidth() {
        return this.width;
    }

    protected boolean toPaintEnabled(Component c) {
        return c.isEnabled();
    }

    @Override
    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D graphics = (Graphics2D)g.create();
        graphics.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        Color arrowColor = this.toPaintEnabled(c) ? UIManager.getLookAndFeelDefaults().getColor("7-white") : UIManager.getLookAndFeelDefaults().getColor("ribbon-disabled-icon-color");
        graphics.setColor(arrowColor);
        BasicStroke stroke = new BasicStroke((float)this.width / 8.0f, 0, 0);
        graphics.setStroke(stroke);
        graphics.translate(x, y);
        GeneralPath gp = new GeneralPath();
        int arrowHeight = this.height / 2;
        int arrowWidth = this.width / 2;
        int deltaH = (this.height + 2) / 3;
        int deltaW = (this.width + 2) / 3;
        switch (this.direction) {
            case 1: {
                gp.moveTo(0.0f, this.height - 1);
                gp.lineTo(0.5f * (float)(this.width - 1), this.height - 1 - arrowHeight);
                gp.lineTo(this.width - 1, this.height - 1);
                gp.moveTo(0.0f, this.height - 1 - deltaH);
                gp.lineTo(0.5f * (float)(this.width - 1), this.height - 1 - arrowHeight - deltaH);
                gp.lineTo(this.width - 1, this.height - 1 - deltaH);
                break;
            }
            case 5: {
                gp.moveTo(0.0f, 0.0f);
                gp.lineTo(0.5f * (float)(this.width - 1), arrowHeight);
                gp.lineTo(this.width - 1, 0.0f);
                gp.moveTo(0.0f, deltaH);
                gp.lineTo(0.5f * (float)(this.width - 1), arrowHeight + deltaH);
                gp.lineTo(this.width - 1, deltaH);
                break;
            }
            case 3: {
                gp.moveTo(0.0f, 0.0f);
                gp.lineTo(arrowWidth, 0.5f * (float)(this.height - 1));
                gp.lineTo(0.0f, this.height - 1);
                gp.moveTo(deltaW, 0.0f);
                gp.lineTo(arrowWidth + deltaW, 0.5f * (float)(this.height - 1));
                gp.lineTo(deltaW, this.height - 1);
                break;
            }
            case 7: {
                gp.moveTo(this.width - 1, 0.0f);
                gp.lineTo(this.width - 1 - arrowWidth, 0.5f * (float)(this.height - 1));
                gp.lineTo(this.width - 1, this.height - 1);
                gp.moveTo(this.width - 1 - deltaW, 0.0f);
                gp.lineTo(this.width - 1 - arrowWidth - deltaW, 0.5f * (float)(this.height - 1));
                gp.lineTo(this.width - 1 - deltaW, this.height - 1);
            }
        }
        graphics.draw(gp);
        graphics.dispose();
    }
}

