/*
 * Decompiled with CFR 0.152.
 */
package org.pushingpixels.flamingo.api.common;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.util.Date;
import org.pushingpixels.flamingo.api.common.JCommandButton;
import org.pushingpixels.flamingo.api.common.LicenseActionListener;
import org.pushingpixels.flamingo.api.common.icon.ResizableIcon;
import org.pushingpixels.flamingo.internal.utils.RenderingUtils;

public final class LicenseCommandButton
extends JCommandButton {
    private ResizableIcon iconLocal;
    private final LicenseActionListener listener;
    private Date validUntil = null;
    private final Dimension initSize;
    private Dimension setSize;

    public LicenseCommandButton(LicenseActionListener listener) {
        super("", null);
        this.iconLocal = listener.getIcon();
        this.listener = listener;
        this.validUntil = listener.getValidUntil();
        Insets insets = this.getInsets();
        this.initSize = new Dimension(this.iconLocal.getIconWidth() + insets.left + insets.right, this.iconLocal.getIconHeight() + insets.top + insets.bottom);
        this.setToolTipText(listener.getTooltipText());
        listener.setLicenseChangedCallback(() -> this.setToolTipText(listener.getTooltipText()));
    }

    @Override
    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        RenderingUtils.setupTextAntialiasing(g2, null);
        Date newValidUtil = this.listener.getValidUntil();
        if (newValidUtil != null && !newValidUtil.equals(this.validUntil)) {
            this.validUntil = newValidUtil;
            this.iconLocal = this.listener.getIcon();
        }
        int x = Math.max(this.getPreferredSize().width - this.iconLocal.getIconWidth(), 0) / 2;
        int y = Math.max(this.getPreferredSize().height - this.iconLocal.getIconHeight(), 0) / 2;
        this.iconLocal.paintIcon(null, g, x, y);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.setSize != null ? this.setSize : this.initSize;
    }

    @Override
    public void setPreferredSize(Dimension preferredSize) {
        this.setSize = preferredSize;
        super.setPreferredSize(preferredSize);
    }
}

