/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.gen;

import com.paterva.maltego.transform.descriptor.TransformDefinition;
import com.paterva.maltego.transform.gen.TransformSource;
import com.paterva.maltego.transform.gen.TransformSourceRegistryListener;
import com.paterva.maltego.transform.gen.TransformSourceRepository;
import com.paterva.maltego.util.repository.RepositoryEvent;
import com.paterva.maltego.util.repository.RepositoryListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openide.util.Lookup;

public class TransformSourceRegistry
implements RepositoryListener<TransformSource> {
    private static final TransformSourceRegistry INSTANCE = new TransformSourceRegistry();
    private final List<TransformSourceRepository> repositories;
    private final List<TransformSourceRegistryListener> listeners = new LinkedList<TransformSourceRegistryListener>();

    public TransformSourceRegistry() {
        this.repositories = new ArrayList<TransformSourceRepository>(Lookup.getDefault().lookupAll(TransformSourceRepository.class));
        this.repositories.forEach(repository -> repository.addRepositoryListener(this));
    }

    public static TransformSourceRegistry getInstance() {
        return INSTANCE;
    }

    public List<TransformSource> getAll() {
        return this.repositories.stream().map(repo -> repo.getAll()).flatMap(Collection::stream).map(item -> (TransformSource)item).collect(Collectors.toList());
    }

    public Optional<TransformSource> get(String name) {
        return this.getAll().stream().filter(txSource -> txSource.getName().equals(name)).findFirst();
    }

    public Set<TransformDefinition> getAllTransforms() {
        return this.getAll().stream().flatMap(source -> source.getTransforms().stream()).collect(Collectors.toSet());
    }

    public Optional<TransformSource> getForTransform(TransformDefinition transform) {
        return this.getAll().stream().filter(txSource -> txSource.getTransforms().contains(transform)).findFirst();
    }

    public void addTransformSourceRegistryListener(TransformSourceRegistryListener listener) {
        this.listeners.add(listener);
    }

    public void removeTransformSourceRegistryListener(TransformSourceRegistryListener listener) {
        this.listeners.remove(listener);
    }

    public void onItemAdded(RepositoryEvent<TransformSource> evt) {
        this.listeners.forEach(listener -> listener.onItemAdded(evt));
    }

    public void onItemChanged(RepositoryEvent<TransformSource> evt) {
        this.listeners.forEach(listener -> listener.onItemChanged(evt));
    }

    public void onItemRemoved(RepositoryEvent<TransformSource> evt) {
        this.listeners.forEach(listener -> listener.onItemRemoved(evt));
    }
}

