/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.entity.api;

import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoLink;
import com.paterva.maltego.entity.api.MaltegoPartSpec;
import com.paterva.maltego.typing.DisplayDescriptor;
import com.paterva.maltego.typing.DisplayDescriptorCollection;
import com.paterva.maltego.typing.DisplayDescriptorList;
import com.paterva.maltego.typing.EditorDescriptor;
import com.paterva.maltego.typing.GroupDefinitions;
import com.paterva.maltego.typing.PropertyConfiguration;
import com.paterva.maltego.typing.editors.OptionEditorDescriptor;
import com.paterva.maltego.typing.types.DateTime;
import com.paterva.maltego.util.ColorUtilities;
import com.paterva.maltego.util.IconSize;
import java.awt.Color;
import java.awt.Image;
import org.openide.util.ImageUtilities;
import org.openide.util.NbPreferences;

public class MaltegoLinkSpec
extends MaltegoPartSpec<LinkID, MaltegoLink> {
    public static final String PROP_NAME_LABEL = "maltego.link.label";
    public static final String PROP_NAME_MANUAL_TYPE = "maltego.link.manual.type";
    public static final String PROP_NAME_MANUAL_DESCRIPTION = "maltego.link.manual.description";
    public static final String PROP_NAME_TRANSFORM_NAME = "maltego.link.transform.name";
    public static final String PROP_NAME_TRANSFORM_DISPLAY = "maltego.link.transform.display-name";
    public static final String PROP_NAME_TRANSFORM_VERSION = "maltego.link.transform.version";
    public static final String PROP_NAME_TRANSFORM_DATE = "maltego.link.transform.run-date";
    public static final String PROP_NAME_SHOW_LABEL = "maltego.link.show-label";
    public static final String PROP_NAME_COLOR = "maltego.link.color";
    public static final String PROP_NAME_IS_REVERSED = "maltego.link.is_reversed";
    public static final String PROP_NAME_STYLE = "maltego.link.style";
    public static final String PROP_NAME_THICKNESS = "maltego.link.thickness";
    public static final String PROP_NAME_ATTACHMENTS = "maltego.link.attachments";
    public static final String SPEC_NAME_MANUAL = "maltego.link.manual-link";
    public static final String SPEC_NAME_TRANSFORM = "maltego.link.transform-link";
    public static final int PROP_STYLE_THICKNESS_DEFAULT = -1;
    private static final String SPEC_DISPLAY_NAME_MANUAL = "Manual Link";
    private static final String SPEC_DISPLAY_NAME_TRANSFORM = "Transform Link";
    private static final String PREF_MANUAL_LINK_COLOR = "maltego.defaultManualLinkColor";
    private static final String PREF_TRANSFORM_LINK_COLOR = "maltego.defaultTransformLinkColor";
    private static final String DEFAULT_CATEGORY = "Default";
    private static MaltegoLinkSpec _manualLinkSpec;
    private static MaltegoLinkSpec _transformLinkSpec;

    public MaltegoLinkSpec() {
    }

    public MaltegoLinkSpec(String name, DisplayDescriptorCollection properties) {
        super(name, properties);
    }

    public MaltegoLinkSpec(String name, DisplayDescriptorCollection properties, GroupDefinitions groups) {
        super(name, properties, groups);
    }

    public MaltegoLinkSpec(String name, PropertyConfiguration properties) {
        super(name, properties);
    }

    public Image getIcon(int size) {
        String iconResource = this.getTypeName().equals(SPEC_NAME_TRANSFORM) ? "com/paterva/maltego/entity/api/transform_link" : "com/paterva/maltego/entity/api/manual_link";
        if (size > 48) {
            iconResource = iconResource + IconSize.MASSIVE.getSize();
        } else if (size > 32) {
            iconResource = iconResource + IconSize.LARGE.getSize();
        } else if (size > 24) {
            iconResource = iconResource + IconSize.MEDIUM.getSize();
        } else if (size > 16) {
            iconResource = iconResource + IconSize.SMALL.getSize();
        }
        iconResource = iconResource + ".png";
        return ImageUtilities.loadImage((String)iconResource);
    }

    public static synchronized MaltegoLinkSpec getManualSpec() {
        if (_manualLinkSpec == null) {
            DisplayDescriptorList properties = new DisplayDescriptorList();
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_MANUAL_TYPE, "Label"));
            MaltegoLinkSpec.addDefaultLinkProperties((DisplayDescriptorCollection)properties);
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_MANUAL_DESCRIPTION, "Description"));
            _manualLinkSpec = new MaltegoLinkSpec(SPEC_NAME_MANUAL, (DisplayDescriptorCollection)properties);
            _manualLinkSpec.setDisplayName(SPEC_DISPLAY_NAME_MANUAL);
            _manualLinkSpec.setDefaultCategory(DEFAULT_CATEGORY);
            MaltegoLinkSpec.setPropertyDefaults(_manualLinkSpec);
            MaltegoLinkSpec.setPropertyMappings(_manualLinkSpec);
            MaltegoLinkSpec.setPropertyEditors(_manualLinkSpec);
        }
        return _manualLinkSpec;
    }

    public static synchronized MaltegoLinkSpec getTransformSpec() {
        if (_transformLinkSpec == null) {
            DisplayDescriptorList properties = new DisplayDescriptorList();
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_LABEL, "Label"));
            MaltegoLinkSpec.addDefaultLinkProperties((DisplayDescriptorCollection)properties);
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_NAME, "Transform"));
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_DISPLAY, "Transform name"));
            properties.add(new DisplayDescriptor(String.class, PROP_NAME_TRANSFORM_VERSION, "Transform version"));
            properties.add(new DisplayDescriptor(DateTime.class, PROP_NAME_TRANSFORM_DATE, "Date run"));
            properties.get(PROP_NAME_TRANSFORM_NAME).setHidden(true);
            properties.get(PROP_NAME_TRANSFORM_NAME).setReadonly(true);
            properties.get(PROP_NAME_TRANSFORM_DISPLAY).setReadonly(true);
            properties.get(PROP_NAME_TRANSFORM_VERSION).setReadonly(true);
            properties.get(PROP_NAME_TRANSFORM_DATE).setReadonly(true);
            _transformLinkSpec = new MaltegoLinkSpec(SPEC_NAME_TRANSFORM, (DisplayDescriptorCollection)properties);
            _transformLinkSpec.setDisplayName(SPEC_DISPLAY_NAME_TRANSFORM);
            _transformLinkSpec.setDefaultCategory(DEFAULT_CATEGORY);
            MaltegoLinkSpec.setPropertyDefaults(_transformLinkSpec);
            MaltegoLinkSpec.setPropertyMappings(_transformLinkSpec);
            MaltegoLinkSpec.setPropertyEditors(_transformLinkSpec);
        }
        return _transformLinkSpec;
    }

    private static Color getDefaultLinkColor(String prefName) {
        String colorString = NbPreferences.forModule(MaltegoLinkSpec.class).get(prefName, null);
        Color color = null;
        if (colorString != null) {
            color = ColorUtilities.decode((String)colorString);
        }
        return color;
    }

    public static Color getDefaultManualLinkColor() {
        return MaltegoLinkSpec.getDefaultLinkColor(PREF_MANUAL_LINK_COLOR);
    }

    public static Color getDefaultTransformLinkColor() {
        return MaltegoLinkSpec.getDefaultLinkColor(PREF_TRANSFORM_LINK_COLOR);
    }

    private static void setDefaultLinkColor(String prefName, Color color) {
        NbPreferences.forModule(MaltegoLinkSpec.class).put(prefName, ColorUtilities.encode((Color)color));
    }

    public static void setDefaultManualLinkColor(Color color) {
        MaltegoLinkSpec.setDefaultLinkColor(PREF_MANUAL_LINK_COLOR, color);
    }

    public static void setDefaultTransformLinkColor(Color color) {
        MaltegoLinkSpec.setDefaultLinkColor(PREF_TRANSFORM_LINK_COLOR, color);
    }

    private static void addDefaultLinkProperties(DisplayDescriptorCollection properties) {
        properties.add(MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_SHOW_LABEL, "Show Label"));
        properties.add(MaltegoLinkSpec.createDefaultLinkProperty(Color.class, PROP_NAME_COLOR, "Color"));
        properties.add(MaltegoLinkSpec.createDefaultLinkProperty(Boolean.TYPE, PROP_NAME_IS_REVERSED, "Reversed"));
        properties.add(MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_STYLE, "Style"));
        properties.add(MaltegoLinkSpec.createDefaultLinkProperty(Integer.TYPE, PROP_NAME_THICKNESS, "Thickness"));
    }

    private static DisplayDescriptor createDefaultLinkProperty(Class<?> type, String name, String displayName) {
        DisplayDescriptor dd = new DisplayDescriptor(type, name, displayName);
        dd.setGroupName("");
        return dd;
    }

    private static void setPropertyDefaults(MaltegoLinkSpec spec) {
        DisplayDescriptorCollection properties = spec.getProperties();
        if (spec == _manualLinkSpec) {
            properties.get(PROP_NAME_MANUAL_TYPE).setDefaultValue((Object)"");
            properties.get(PROP_NAME_MANUAL_DESCRIPTION).setDefaultValue((Object)"");
        } else {
            properties.get(PROP_NAME_LABEL).setDefaultValue((Object)"");
        }
        properties.get(PROP_NAME_COLOR).setDefaultValue(null);
        properties.get(PROP_NAME_IS_REVERSED).setDefaultValue((Object)false);
        properties.get(PROP_NAME_THICKNESS).setDefaultValue((Object)-1);
        properties.get(PROP_NAME_SHOW_LABEL).setDefaultValue((Object)0);
        properties.get(PROP_NAME_STYLE).setDefaultValue((Object)-1);
    }

    private static void setPropertyMappings(MaltegoLinkSpec spec) {
        DisplayDescriptorCollection properties = spec.getProperties();
        if (spec == _manualLinkSpec) {
            spec.setValueProperty(properties.get(PROP_NAME_MANUAL_TYPE));
        } else if (spec == _transformLinkSpec) {
            spec.setValueProperty(properties.get(PROP_NAME_TRANSFORM_DISPLAY));
            DisplayDescriptor labelProp = properties.get(PROP_NAME_LABEL);
            if (labelProp != null) {
                spec.setDisplayValueExpression(labelProp.getName());
            }
        }
        spec.setShowLabelProperty(properties.get(PROP_NAME_SHOW_LABEL));
        spec.setColorProperty(properties.get(PROP_NAME_COLOR));
        spec.setIsReversed(properties.get(PROP_NAME_IS_REVERSED));
        spec.setStyleProperty(properties.get(PROP_NAME_STYLE));
        spec.setThicknessProperty(properties.get(PROP_NAME_THICKNESS));
    }

    private static void setPropertyEditors(MaltegoLinkSpec spec) {
        int i;
        DisplayDescriptorCollection properties = spec.getProperties();
        DisplayDescriptor property = properties.get(PROP_NAME_SHOW_LABEL);
        OptionEditorDescriptor optionEditor = new OptionEditorDescriptor(property.getType());
        for (i = 0; i < MaltegoLink.ShowLabel.length; ++i) {
            optionEditor.getItems().add(MaltegoLink.ShowLabel[i], (Object)i);
        }
        property.setEditor((EditorDescriptor)optionEditor);
        property = properties.get(PROP_NAME_STYLE);
        optionEditor = new OptionEditorDescriptor(property.getType());
        optionEditor.getItems().add("<Default>", (Object)-1);
        for (i = 0; i < MaltegoLink.LineStyle.length; ++i) {
            optionEditor.getItems().add(MaltegoLink.LineStyle[i], (Object)i);
        }
        property.setEditor((EditorDescriptor)optionEditor);
        property = properties.get(PROP_NAME_THICKNESS);
        optionEditor = new OptionEditorDescriptor(property.getType());
        optionEditor.getItems().add("<Default>", (Object)-1);
        for (i = 1; i <= 5; ++i) {
            optionEditor.getItems().add(Integer.toString(i), (Object)i);
        }
        property.setEditor((EditorDescriptor)optionEditor);
    }

    public void setShowLabelProperty(DisplayDescriptor property) {
        this.setSpecialProperty("show-label", property);
    }

    public DisplayDescriptor getShowLabelProperty() {
        return this.getSpecialProperty("show-label");
    }

    public void setColorProperty(DisplayDescriptor property) {
        this.setSpecialProperty("color", property);
    }

    public void setIsReversed(DisplayDescriptor property) {
        this.setSpecialProperty("reversed", property);
    }

    public DisplayDescriptor getColorProperty() {
        return this.getSpecialProperty("color");
    }

    public void setStyleProperty(DisplayDescriptor property) {
        this.setSpecialProperty("style", property);
    }

    public DisplayDescriptor getStyleProperty() {
        return this.getSpecialProperty("style");
    }

    public void setThicknessProperty(DisplayDescriptor property) {
        this.setSpecialProperty("thickness", property);
    }

    public void setIsReversedProperty(DisplayDescriptor property) {
        this.setSpecialProperty("reversed", property);
    }

    public DisplayDescriptor getThicknessProperty() {
        return this.getSpecialProperty("thickness");
    }
}

