/*
 * Decompiled with CFR 0.152.
 */
package com.paterva.maltego.transform.protocol.v3.api;

import com.maltego.tx3.java.api.execution.Entity;
import com.paterva.maltego.core.EntityID;
import com.paterva.maltego.core.Guid;
import com.paterva.maltego.core.LinkID;
import com.paterva.maltego.core.MaltegoEntity;
import com.paterva.maltego.core.MaltegoLink;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;

public class TransformRunResultPage {
    private final Set<MaltegoEntity> addedEntities = new HashSet<MaltegoEntity>();
    private final Map<MaltegoLink, List<EntityID>> addedLinks = new HashMap<MaltegoLink, List<EntityID>>();
    private final Queue<PageOperation> operationQueue = new LinkedList<PageOperation>();

    void addNewEntity(MaltegoEntity entity) {
        this.addedEntities.add(entity);
        this.operationQueue.add(new PageEntityAddOperation(entity));
    }

    void updateEntity(Entity entity) {
        this.operationQueue.add(new PageEntityUpdateOperation(entity));
    }

    void addNewLink(MaltegoLink link, EntityID sourceEntityId, EntityID targetEntityId) {
        this.addedLinks.put(link, new ArrayList<EntityID>(Arrays.asList(sourceEntityId, targetEntityId)));
        this.operationQueue.add(new PageLinkAddOperation(link, sourceEntityId, targetEntityId));
    }

    void deleteEntity(EntityID entityId) {
        this.operationQueue.add(new PageEntityDeleteOperation((Guid)entityId));
    }

    void deleteLink(LinkID linkId) {
        this.operationQueue.add(new PageLinkDeleteOperation((Guid)linkId));
    }

    Set<MaltegoEntity> getAddedEntities() {
        return this.addedEntities;
    }

    Map<MaltegoLink, List<EntityID>> getAddedLinks() {
        return this.addedLinks;
    }

    Queue<PageOperation> getOperationQueue() {
        return this.operationQueue;
    }

    class PageOperation {
        Guid id;

        PageOperation(Guid id) {
            this.id = id;
        }

        public Guid getId() {
            return this.id;
        }
    }

    class PageLinkDeleteOperation
    extends PageOperation {
        PageLinkDeleteOperation(Guid id) {
            super(id);
        }

        LinkID getLinkId() {
            return (LinkID)this.getId();
        }
    }

    class PageLinkAddOperation
    extends PageOperation {
        private final MaltegoLink link;
        private final EntityID sourceEntityId;
        private final EntityID targetEntityId;

        PageLinkAddOperation(MaltegoLink link, EntityID sourceEntityId, EntityID targetEntityId) {
            super(link.getID());
            this.link = link;
            this.sourceEntityId = sourceEntityId;
            this.targetEntityId = targetEntityId;
        }

        public MaltegoLink getLink() {
            return this.link;
        }

        LinkID getLinkId() {
            return (LinkID)this.getId();
        }

        public EntityID getSourceEntityId() {
            return this.sourceEntityId;
        }

        public EntityID getTargetEntityId() {
            return this.targetEntityId;
        }
    }

    class PageEntityDeleteOperation
    extends PageOperation {
        public PageEntityDeleteOperation(Guid id) {
            super(id);
        }

        EntityID getEntityId() {
            return (EntityID)this.getId();
        }
    }

    class PageEntityUpdateOperation
    extends PageOperation {
        private final Entity entity;

        public PageEntityUpdateOperation(Entity entity) {
            super((Guid)EntityID.parse((String)entity.getId()));
            this.entity = entity;
        }

        EntityID getEntityId() {
            return (EntityID)this.getId();
        }

        public Entity getEntity() {
            return this.entity;
        }
    }

    class PageEntityAddOperation
    extends PageOperation {
        PageEntityAddOperation(MaltegoEntity entity) {
            super(entity.getID());
        }

        EntityID getEntityId() {
            return (EntityID)this.getId();
        }
    }
}

