/*
 * Decompiled with CFR 0.152.
 */
package org.zaproxy.zap.utils;

import java.io.IOException;
import java.io.StringReader;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public final class XmlUtils {
    private XmlUtils() {
    }

    public static DocumentBuilderFactory newXxeDisabledDocumentBuilderFactory() throws ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        factory.setFeature("http://xml.org/sax/features/external-general-entities", false);
        factory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        factory.setExpandEntityReferences(false);
        return factory;
    }

    public static String getXmlKeyString(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        StringBuilder sb = new StringBuilder();
        DocumentBuilderFactory factory = XmlUtils.newXxeDisabledDocumentBuilderFactory();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xmlString));
        Document document = builder.parse(inputSource);
        XmlUtils.appendXmlKeyString(document.getFirstChild(), sb);
        if (sb.length() > 512) {
            return sb.substring(0, 509) + "...";
        }
        return sb.toString();
    }

    private static boolean ignoreChildNodes(Node node) {
        return node == null || !node.hasChildNodes() || node.getChildNodes().getLength() == 1 && node.getFirstChild().getNodeType() == 3;
    }

    private static void appendXmlKeyString(Node node, StringBuilder sb) {
        sb.append('<');
        sb.append(node.getNodeName());
        if (!XmlUtils.ignoreChildNodes(node)) {
            String lastChild = null;
            String postfix = "..";
            for (Node ch = node.getFirstChild(); ch != null && sb.length() < 512; ch = ch.getNextSibling()) {
                if (ch.getNodeType() == 3) continue;
                StringBuilder sb2 = new StringBuilder();
                XmlUtils.appendXmlKeyString(ch, sb2);
                if (lastChild == null) {
                    lastChild = sb2.toString();
                    sb.append(':');
                    sb.append(lastChild);
                    continue;
                }
                if (lastChild.equals(sb2.toString())) {
                    sb.append(postfix);
                    postfix = "";
                    continue;
                }
                lastChild = sb2.toString();
                sb.append(',');
                sb.append(lastChild);
                postfix = "..";
            }
        }
        sb.append('>');
    }
}

