.. -*- rst -*-

============
Action Plans
============

An ``Action Plan`` specifies a flow of ``Actions`` that should be executed
in order to satisfy a given ``Goal``. It also contains an estimated
``global efficacy`` alongside a set of ``efficacy indicators``.

An ``Action Plan`` is generated by Watcher when an ``Audit`` is successful
which implies that the ``Strategy`` which was used has found a ``Solution``
to achieve the ``Goal`` of this ``Audit``.

In the default implementation of Watcher, an action plan is composed of
a graph of linked ``Actions``. Each action may have parent actions, which
should be executed prior to child action.

Start Action Plan
=================

.. rest_method::  POST /v1/action_plans/{actionplan_ident}/start

Starts a created Action Plan resource.

Normal response codes: 200

Error codes: 400,404

Request
-------

.. rest_parameters:: parameters.yaml

   - actionplan_ident: actionplan_ident

Response
--------

The list and example below are representative of the response as of API
version 1:

.. rest_parameters:: parameters.yaml

    - uuid: uuid
    - state: actionplan_state
    - audit_uuid: actionplan_audit_uuid
    - strategy_uuid: strategy_uuid
    - strategy_name: strategy_name
    - efficacy_indicators: actionplan_efficacy_indicators
    - global_efficacy: actionplan_global_efficacy
    - links: links
    - hostname: actionplan_hostname

**Example JSON representation of an Action Plan:**

.. literalinclude:: samples/actionplan-start-response.json
   :language: javascript

List Action Plan
================

.. rest_method::  GET /v1/action_plans

Returns a list of Action Plan resources.

Normal response codes: 200

Error codes: 400,401

Request
-------

.. rest_parameters:: parameters.yaml

   - audit_uuid: r_audit
   - strategy: r_strategy
   - limit: limit
   - marker: marker
   - sort_dir: sort_dir
   - sort_key: sort_key

Response
--------

.. rest_parameters:: parameters.yaml

    - uuid: uuid
    - state: actionplan_state
    - audit_uuid: actionplan_audit_uuid
    - strategy_uuid: strategy_uuid
    - strategy_name: strategy_name
    - efficacy_indicators: actionplan_efficacy_indicators
    - global_efficacy: actionplan_global_efficacy
    - links: links

**Example JSON representation of an Action Plan:**

.. literalinclude:: samples/actionplan-list-response.json
   :language: javascript

List Action Plan detailed
=========================

.. rest_method::  GET /v1/action_plans/detail

Returns a list of Action Plan resources with complete details.

Normal response codes: 200

Error codes: 400,401

Request
-------

.. rest_parameters:: parameters.yaml

   - audit_uuid: r_audit
   - strategy: r_strategy
   - limit: limit
   - marker: marker
   - sort_dir: sort_dir
   - sort_key: sort_key

Response
--------

.. rest_parameters:: parameters.yaml

    - deleted_at: deleted_at
    - updated_at: updated_at
    - created_at: created_at
    - uuid: uuid
    - state: actionplan_state
    - audit_uuid: actionplan_audit_uuid
    - strategy_uuid: strategy_uuid
    - strategy_name: strategy_name
    - efficacy_indicators: actionplan_efficacy_indicators
    - global_efficacy: actionplan_global_efficacy
    - links: links
    - hostname: actionplan_hostname
    - status_message: actionplan_status_message

**Example JSON representation of an Action Plan:**

.. literalinclude:: samples/actionplan-list-detailed-response.json
   :language: javascript

Show Action Plan
================

.. rest_method::  GET /v1/action_plans/{actionplan_ident}

Shows details for an Action Plan.

Normal response codes: 200

Error codes: 404

Request
-------

.. rest_parameters:: parameters.yaml

   - actionplan_ident: actionplan_ident

Response
--------

.. rest_parameters:: parameters.yaml

    - uuid: uuid
    - state: actionplan_state
    - audit_uuid: actionplan_audit_uuid
    - strategy_uuid: strategy_uuid
    - strategy_name: strategy_name
    - efficacy_indicators: actionplan_efficacy_indicators
    - global_efficacy: actionplan_global_efficacy
    - links: links
    - hostname: actionplan_hostname
    - status_message: actionplan_status_message

**Example JSON representation of an Audit:**

.. literalinclude:: samples/actionplan-show-response.json
   :language: javascript

Cancel Action Plan
==================

.. rest_method::  PATCH /v1/action_plans/{actionplan_ident}

Cancels a created Action Plan resource.

.. note:
    If Action Plan is in ONGOING state, then ``state`` attribute should be
    replaced with ``CANCELLING`` value. Otherwise, ``CANCELLED`` is to be
    used.

Normal response codes: 200

Error codes: 400,404

Request
-------

.. rest_parameters:: parameters.yaml

   - actionplan_ident: actionplan_ident

**Example Action Plan ONGOING cancelling request:**

.. literalinclude:: samples/actionplan-cancel-request-cancelling.json
   :language: javascript

**Example Action Plan PENDING cancelling request:**

.. literalinclude:: samples/actionplan-cancel-request-pending.json
   :language: javascript

Response
--------

The list and example below are representative of the response as of API
version 1:

.. rest_parameters:: parameters.yaml

    - uuid: uuid
    - state: actionplan_state
    - audit_uuid: actionplan_audit_uuid
    - strategy_uuid: strategy_uuid
    - strategy_name: strategy_name
    - efficacy_indicators: actionplan_efficacy_indicators
    - global_efficacy: actionplan_global_efficacy
    - links: links
    - hostname: actionplan_hostname
    - status_message: actionplan_status_message

**Example JSON representation of an Action Plan:**

.. literalinclude:: samples/actionplan-start-response.json
   :language: javascript

Delete Action Plan
==================

.. rest_method::  DELETE /v1/action_plans/{actionplan_ident}

Deletes an Action Plan. Action Plan can be deleted only from SUCCEEDED, RECOMMENDED, FAILED, SUPERSEDED, CANCELLED states.

Normal response codes: 204

Error codes: 404

Request
-------

.. rest_parameters:: parameters.yaml

   - actionplan_ident: actionplan_ident
