
//
// File: test_cbormzid.cpp
// Created by: Olivier Langella
// Created on: 27/9/2025
//
/*******************************************************************************
 * Copyright (c) 2025 Olivier Langella <Olivier.Langella@universite-paris-saclay.fr>.
 *
 * This file is part of the PAPPSOms++ library.
 *
 *     PAPPSOms++ is free software: you can redistribute it and/or modify
 *     it under the terms of the GNU General Public License as published by
 *     the Free Software Foundation, either version 3 of the License, or
 *     (at your option) any later version.
 *
 *     PAPPSOms++ is distributed in the hope that it will be useful,
 *     but WITHOUT ANY WARRANTY; without even the implied warranty of
 *     MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *     GNU General Public License for more details.
 *
 *     You should have received a copy of the GNU General Public License
 *     along with PAPPSOms++.  If not, see <http://www.gnu.org/licenses/>.
 *
 ******************************************************************************/

// ./tests/pappsotree/catch2-only-pappsotree [cbormzid] -s

#include <catch2/catch_test_macros.hpp>
#include <pappsomspp/core/processing/cbor/psm/mzidentml/mzidentmlreader.h>
#include <pappsomspp/core/processing/cbor/psm/psmfilereaderbase.h>
#include <pappsomspp/core/processing/uimonitor/uimonitorvoid.h>
#include <odsstream/odsdocwriter.h>
#include <QDebug>

class CborTest : public pappso::cbor::psm::PsmFileReaderBase
{
  public:
  CborTest(CalcWriterInterface &output) : m_output(output)
  {
    m_output.writeSheet("psm list");
    m_output.writeCell("index");
    m_output.writeCell("sample");
    m_output.writeCell("Proforma");
    m_output.writeLine();
  };

  void
  psmReady(pappso::UiMonitorInterface &monitor [[maybe_unused]]) override
  {

    // qDebug() << "coucou";
    m_output.writeCell((std::size_t)m_cborScanId.value("index").toInteger());
    m_output.writeCell(m_currentSampleName);
    m_output.writeCell(m_currentPsmProforma);
    m_output.writeLine();
  };

  private:
  CalcWriterInterface &m_output;
};

TEST_CASE("cbor psm map test suite.", "[cbormzid]")
{
  // Set the debugging message formatting pattern.
  qSetMessagePattern(QString("%{file}@%{line}, %{function}(): %{message}"));

  SECTION("..:: PSM cbor features::..", "[cbormzid]")
  {
    pappso::UiMonitorVoid monitor;

    QFileInfo mzid_file(
      "/gorgone/pappso/versions_logiciels_pappso/tandemng/eme/"
      "20120906_balliau_extract_1_A01_urnb-1.xml.mzid");

    QFile mzid_cbor_file("mzid.cbor");
    mzid_cbor_file.open(QIODevice::WriteOnly);
    pappso::cbor::CborStreamWriter writer(&mzid_cbor_file);


    pappso::cbor::psm::MzIdentMlReader mzid_file_reader(&monitor, &writer, mzid_file);
    mzid_cbor_file.close();
  }
}
