# Joplin user profile

## Understanding the Joplin Profile

A **Joplin profile** contains all data, settings, and resources required for the Joplin desktop application to function. Each profile is self-contained and can be backed up, restored, or copied to replicate a complete Joplin environment. The desktop, mobile and CLI applications all use the same profile structure and it's generally possible to copy it from one device to another.

By default, Joplin stores the active profile in:

* **Linux / macOS:** `~/.config/joplin-desktop`
* **Windows:** `%UserProfile%\.config\joplin-desktop`

### Directory Overview

Below is a breakdown of the main components within a Joplin profile.

### User Data and Configuration Files

These files and folders contain the application's primary data, user-generated content, and personal configuration. They define what the user sees and interacts with — including notes, attachments, plugins, and interface customisations.

**These should be included when backing up files.**

| File / Folder           | Description                                                                                                                                                                                                                                                                    |
| ----------------------- | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------ |
| **database.sqlite**     | The central SQLite database file where all notes, notebooks, tags, and metadata are stored. Includes notes and notebook hierarchy, tags and note relations, synchronisation state, and encryption keys (if end-to-end encryption is enabled).                                  |
| **resources/**          | Contains all attachments linked to notes (images, PDFs, Office documents, etc.). Each file is identified by a unique hash-based name. When encryption is enabled, encrypted copies of resources are created with the `.crypted` extension before being uploaded to the server. |
| **plugins/**            | Contains installed plugin packages (`.jpl` files).                                                                                                                                                                                                                             |
| **settings.json**       | JSON configuration file containing all user preferences and application settings. The full list of supported settings is documented in the [JSON schema](https://joplinapp.org/schema/settings.json).                                                                          |
| **keymap-desktop.json** | Stores user-defined keyboard shortcuts overriding the defaults.                                                                                                                                                                                                                |
| **userchrome.css**      | Optional user stylesheet that allows customisation of the Joplin user interface (e.g. colours, fonts, layout).                                                                                                                                                                 |
| **profile-ID/**       | When [multiple profiles](https://joplinapp.org/help/apps/profiles/) are in use, they are created in these additional folders. Each subdirectory mirrors the main profile structure.                                                                                            |

### Runtime and State Files

These files and folders are created and maintained by the application to manage its internal state, cache, and diagnostic information. They support normal operation but are not directly edited or interacted with by the user.

**These do not need to be included in backups**, as they are either automatically regenerated by the application, or used only for debugging or logging.

| File / Folder          | Description                                                                                                        |
| ---------------------- | ------------------------------------------------------------------------------------------------------------------ |
| **plugin-data/**       | Stores data generated or cached by plugins, such as temporary files, autosaves, or plugin-specific databases.      |
| **cache/**             | Local cache of plugin code and assets extracted from `.jpl` packages.                                              |
| **log files**          | Various diagnostic and runtime logs.                                                                               |
| **ipc_secret_key.txt** | Used internally to manage inter-process communication between multiple instances of the app.                       |
| **lock**               | Used internally to ensure that only one instance of the application is currently accessing the profile folder.     |
| **flags.txt**          | Can be used to specify startup flags when [debugging the application](https://joplinapp.org/help/apps/debugging/). |

## Creating a Default Profile for All Users

Some organisations may wish to create a **default Joplin profile** that will automatically apply to all users. This guide explains how to set up such a profile.

### Steps

1. **Close the Joplin desktop app**
   If Joplin is running, right-click the icon in the system tray and select **Exit**.

2. **Back up the existing configuration**
   Rename or move the current configuration directory:

   ```bash
   mv ~/.config/joplin-desktop ~/.config/joplin-desktop.bak
   ```

3. **Start Joplin**
   Launch the desktop app. A fresh configuration will be created automatically.

4. **Configure Joplin as desired**
   Set up the application, install any plugins, and configure them according to your organisational requirements.

5. **Close Joplin**
   Once configuration is complete, close the app again.

6. **Create a copy of the configured profile**
   Make a copy of the newly created configuration directory. This will serve as your **base profile**:

   ```bash
   cp -r ~/.config/joplin-desktop ~/joplin-default-profile
   ```

7. **(Optional) Restore the original configuration**
   If you backed up your original configuration, you can restore it:

   ```bash
   mv ~/.config/joplin-desktop.bak ~/.config/joplin-desktop
   ```

### Using the Default Profile

You can now distribute the copied `joplin-default-profile` directory to other users or systems. Place it in the appropriate configuration path for each platform.

#### Configuration Paths

| Platform          | Configuration Directory                |
| ----------------- | -------------------------------------- |
| **Linux / macOS** | `~/.config/joplin-desktop`             |
| **Windows**       | `%UserProfile%\.config\joplin-desktop` |

When users launch Joplin, it will use the provided configuration as their starting profile.
