
##
# This file is part of the Metasploit Framework and may be redistributed
# according to the licenses defined in the Authors field below. In the
# case of an unknown or missing license, this file defaults to the same
# license as the core Framework (dual GPLv2 and Artistic). The latest
# version of the Framework can always be obtained from metasploit.com.
##

package Msf::Nop::MIPS;
use strict;
use base 'Msf::Nop';
use Pex::Utils;

my $info = {
  'Name'    => 'MIPS Nop Generator',
  'Version' => '$Revision: 1540 $',
  'Authors' => [ 'H D Moore <hdm [at] metasploit.com>', ],
  'Arch'    => [ 'mips' ],
  'Desc'    =>  'This is an extremely minmal MIPS nop generator',
  'Refs'    => [ ],
};

my $advanced = { };

sub new {
  my $class = shift; 
  return($class->SUPER::new({'Info' => $info, 'Advanced' => $advanced}, @_));
}

sub Nops {
  my $self = shift;
  my $length = shift;

  my $exploit = $self->GetVar('_Exploit');
  my $random  = $self->GetVar('RandomNops');
  my $badRegs = $exploit->NopSaveRegs;
  my $badChars = $exploit->PayloadBadChars;

  # trashes v0 -> addiu   v0,v0,7764
  return(pack('N',0x24421e54) x ($length / 4));
}

1;
