// Copyright 2016 Proyectos y Sistemas de Mantenimiento SL (eProsima).
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/*!
 * @file module_structTypeObjectSupport.cxx
 * Source file containing the implementation to register the TypeObject representation of the described types in the IDL file
 *
 * This file was generated by the tool fastddsgen (version: 4.1.0).
 */

#include "module_structTypeObjectSupport.hpp"

#include <mutex>
#include <string>

#include <fastcdr/xcdr/external.hpp>
#include <fastcdr/xcdr/optional.hpp>
#include <fastdds/dds/domain/DomainParticipantFactory.hpp>
#include <fastdds/dds/log/Log.hpp>
#include <fastdds/dds/xtypes/common.hpp>
#include <fastdds/dds/xtypes/type_representation/ITypeObjectRegistry.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObject.hpp>
#include <fastdds/dds/xtypes/type_representation/TypeObjectUtils.hpp>
#include "module_struct.hpp"


using namespace eprosima::fastdds::dds::xtypes;

namespace TrialModule {
namespace AliasModule {
void register_AliasType_type_identifier(
        TypeIdentifierPair& type_ids_AliasType)
{
    ReturnCode_t return_code_AliasType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_AliasType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::AliasModule::AliasType", type_ids_AliasType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasType)
    {
        AliasTypeFlag alias_flags_AliasType = 0;
        QualifiedTypeName type_name_AliasType = "TrialModule::AliasModule::AliasType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_AliasType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_AliasType;
        CompleteTypeDetail detail_AliasType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_AliasType, ann_custom_AliasType, type_name_AliasType.to_string());
        CompleteAliasHeader header_AliasType = TypeObjectUtils::build_complete_alias_header(detail_AliasType);
        AliasMemberFlag related_flags_AliasType = 0;
        return_code_AliasType =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_AliasType);

        if (eprosima::fastdds::dds::RETCODE_OK != return_code_AliasType)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "TrialModule::AliasModule::AliasType related TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        bool common_AliasType_ec {false};
        CommonAliasBody common_AliasType {TypeObjectUtils::build_common_alias_body(related_flags_AliasType,
                TypeObjectUtils::retrieve_complete_type_identifier(type_ids_AliasType, common_AliasType_ec))};
        if (!common_AliasType_ec)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "TrialModule::AliasModule::AliasType related TypeIdentifier inconsistent.");
            return;
        }
        eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_AliasType;
        ann_custom_AliasType.reset();
        CompleteAliasBody body_AliasType = TypeObjectUtils::build_complete_alias_body(common_AliasType,
                member_ann_builtin_AliasType, ann_custom_AliasType);
        CompleteAliasType alias_type_AliasType = TypeObjectUtils::build_complete_alias_type(alias_flags_AliasType,
                header_AliasType, body_AliasType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_alias_type_object(alias_type_AliasType,
                    type_name_AliasType.to_string(), type_ids_AliasType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "TrialModule::AliasModule::AliasType already registered in TypeObjectRegistry for a different type.");
        }
    }
}


} // namespace AliasModule

} // namespace TrialModule
namespace TrialModule {
namespace BitsetModule {
void register_BitsetType_type_identifier(
        TypeIdentifierPair& type_ids_BitsetType)
{
    ReturnCode_t return_code_BitsetType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitsetType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::BitsetModule::BitsetType", type_ids_BitsetType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitsetType)
    {
        BitsetTypeFlag bitset_flags_BitsetType = 0;
        QualifiedTypeName type_name_BitsetType = "TrialModule::BitsetModule::BitsetType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitsetType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitsetType;
        CompleteTypeDetail detail_BitsetType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitsetType, ann_custom_BitsetType, type_name_BitsetType.to_string());
        CompleteBitsetHeader header_BitsetType = TypeObjectUtils::build_complete_bitset_header(detail_BitsetType);
        CompleteBitfieldSeq field_seq_BitsetType;
        {
            uint16_t position_flag1 = 0;
            BitsetMemberFlag flags_flag1 = 0;
            uint8_t bitcount_flag1 = 3;
            TypeKind holder_type_flag1 = TK_UINT8;
            CommonBitfield common_flag1 = TypeObjectUtils::build_common_bitfield(position_flag1, flags_flag1, bitcount_flag1, holder_type_flag1);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag1;
            ann_custom_BitsetType.reset();
            MemberName name_flag1 = "flag1";
            CompleteMemberDetail detail_flag1 = TypeObjectUtils::build_complete_member_detail(name_flag1, member_ann_builtin_flag1, ann_custom_BitsetType);
            CompleteBitfield bitfield_flag1 = TypeObjectUtils::build_complete_bitfield(common_flag1, detail_flag1);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetType, bitfield_flag1);
        }
        {
            uint16_t position_flag2 = 3;
            BitsetMemberFlag flags_flag2 = 0;
            uint8_t bitcount_flag2 = 10;
            TypeKind holder_type_flag2 = TK_UINT16;
            CommonBitfield common_flag2 = TypeObjectUtils::build_common_bitfield(position_flag2, flags_flag2, bitcount_flag2, holder_type_flag2);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag2;
            ann_custom_BitsetType.reset();
            MemberName name_flag2 = "flag2";
            CompleteMemberDetail detail_flag2 = TypeObjectUtils::build_complete_member_detail(name_flag2, member_ann_builtin_flag2, ann_custom_BitsetType);
            CompleteBitfield bitfield_flag2 = TypeObjectUtils::build_complete_bitfield(common_flag2, detail_flag2);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetType, bitfield_flag2);
        }
        {
            uint16_t position_flag3 = 13;
            BitsetMemberFlag flags_flag3 = 0;
            uint8_t bitcount_flag3 = 12;
            TypeKind holder_type_flag3 = TK_INT32;
            CommonBitfield common_flag3 = TypeObjectUtils::build_common_bitfield(position_flag3, flags_flag3, bitcount_flag3, holder_type_flag3);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_flag3;
            ann_custom_BitsetType.reset();
            MemberName name_flag3 = "flag3";
            CompleteMemberDetail detail_flag3 = TypeObjectUtils::build_complete_member_detail(name_flag3, member_ann_builtin_flag3, ann_custom_BitsetType);
            CompleteBitfield bitfield_flag3 = TypeObjectUtils::build_complete_bitfield(common_flag3, detail_flag3);
            TypeObjectUtils::add_complete_bitfield(field_seq_BitsetType, bitfield_flag3);
        }
        CompleteBitsetType bitset_type_BitsetType = TypeObjectUtils::build_complete_bitset_type(bitset_flags_BitsetType, header_BitsetType, field_seq_BitsetType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitset_type_object(bitset_type_BitsetType,
                    type_name_BitsetType.to_string(), type_ids_BitsetType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "TrialModule::BitsetModule::BitsetType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace BitsetModule

} // namespace TrialModule
namespace TrialModule {
namespace BitmaskModule {
void register_BitmaskType_type_identifier(
        TypeIdentifierPair& type_ids_BitmaskType)
{
    ReturnCode_t return_code_BitmaskType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_BitmaskType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::BitmaskModule::BitmaskType", type_ids_BitmaskType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_BitmaskType)
    {
        BitmaskTypeFlag bitmask_flags_BitmaskType = 0;
        BitBound bit_bound_BitmaskType = 8;
        CommonEnumeratedHeader common_BitmaskType = TypeObjectUtils::build_common_enumerated_header(bit_bound_BitmaskType, true);
        QualifiedTypeName type_name_BitmaskType = "TrialModule::BitmaskModule::BitmaskType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_BitmaskType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_BitmaskType;
        AppliedAnnotationSeq tmp_ann_custom_BitmaskType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_BitmaskType;
        if (!tmp_ann_custom_BitmaskType.empty())
        {
            ann_custom_BitmaskType = tmp_ann_custom_BitmaskType;
        }

        CompleteTypeDetail detail_BitmaskType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_BitmaskType, ann_custom_BitmaskType, type_name_BitmaskType.to_string());
        CompleteEnumeratedHeader header_BitmaskType = TypeObjectUtils::build_complete_enumerated_header(common_BitmaskType, detail_BitmaskType, true);
        CompleteBitflagSeq flag_seq_BitmaskType;
        {
            uint16_t position_FLAG_ONE = 0;
            BitflagFlag flags_FLAG_ONE = 0;
            CommonBitflag common_FLAG_ONE = TypeObjectUtils::build_common_bitflag(position_FLAG_ONE, flags_FLAG_ONE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_FLAG_ONE;
            ann_custom_BitmaskType.reset();
            MemberName name_FLAG_ONE = "FLAG_ONE";
            CompleteMemberDetail detail_FLAG_ONE = TypeObjectUtils::build_complete_member_detail(name_FLAG_ONE, member_ann_builtin_FLAG_ONE, ann_custom_BitmaskType);
            CompleteBitflag bitflag_FLAG_ONE = TypeObjectUtils::build_complete_bitflag(common_FLAG_ONE, detail_FLAG_ONE);
            TypeObjectUtils::add_complete_bitflag(flag_seq_BitmaskType, bitflag_FLAG_ONE);
        }
        {
            uint16_t position_FLAG_TWO = 1;
            BitflagFlag flags_FLAG_TWO = 0;
            CommonBitflag common_FLAG_TWO = TypeObjectUtils::build_common_bitflag(position_FLAG_TWO, flags_FLAG_TWO);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_FLAG_TWO;
            ann_custom_BitmaskType.reset();
            MemberName name_FLAG_TWO = "FLAG_TWO";
            CompleteMemberDetail detail_FLAG_TWO = TypeObjectUtils::build_complete_member_detail(name_FLAG_TWO, member_ann_builtin_FLAG_TWO, ann_custom_BitmaskType);
            CompleteBitflag bitflag_FLAG_TWO = TypeObjectUtils::build_complete_bitflag(common_FLAG_TWO, detail_FLAG_TWO);
            TypeObjectUtils::add_complete_bitflag(flag_seq_BitmaskType, bitflag_FLAG_TWO);
        }
        {
            uint16_t position_FLAG_THREE = 2;
            BitflagFlag flags_FLAG_THREE = 0;
            CommonBitflag common_FLAG_THREE = TypeObjectUtils::build_common_bitflag(position_FLAG_THREE, flags_FLAG_THREE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_FLAG_THREE;
            ann_custom_BitmaskType.reset();
            MemberName name_FLAG_THREE = "FLAG_THREE";
            CompleteMemberDetail detail_FLAG_THREE = TypeObjectUtils::build_complete_member_detail(name_FLAG_THREE, member_ann_builtin_FLAG_THREE, ann_custom_BitmaskType);
            CompleteBitflag bitflag_FLAG_THREE = TypeObjectUtils::build_complete_bitflag(common_FLAG_THREE, detail_FLAG_THREE);
            TypeObjectUtils::add_complete_bitflag(flag_seq_BitmaskType, bitflag_FLAG_THREE);
        }
        CompleteBitmaskType bitmask_type_BitmaskType = TypeObjectUtils::build_complete_bitmask_type(bitmask_flags_BitmaskType, header_BitmaskType, flag_seq_BitmaskType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_bitmask_type_object(bitmask_type_BitmaskType,
                    type_name_BitmaskType.to_string(), type_ids_BitmaskType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "TrialModule::BitmaskModule::BitmaskType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace BitmaskModule

} // namespace TrialModule
namespace TrialModule {
namespace EnumModule {
void register_EnumType_type_identifier(
        TypeIdentifierPair& type_ids_EnumType)
{
    ReturnCode_t return_code_EnumType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_EnumType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::EnumModule::EnumType", type_ids_EnumType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_EnumType)
    {
        EnumTypeFlag enum_flags_EnumType = 0;
        BitBound bit_bound_EnumType = 32;
        CommonEnumeratedHeader common_EnumType = TypeObjectUtils::build_common_enumerated_header(bit_bound_EnumType);
        QualifiedTypeName type_name_EnumType = "TrialModule::EnumModule::EnumType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_EnumType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_EnumType;
        CompleteTypeDetail detail_EnumType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_EnumType, ann_custom_EnumType, type_name_EnumType.to_string());
        CompleteEnumeratedHeader header_EnumType = TypeObjectUtils::build_complete_enumerated_header(common_EnumType, detail_EnumType);
        CompleteEnumeratedLiteralSeq literal_seq_EnumType;
        {
            EnumeratedLiteralFlag flags_VALUE_ONE = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_VALUE_ONE = TypeObjectUtils::build_common_enumerated_literal(0, flags_VALUE_ONE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_VALUE_ONE;
            ann_custom_EnumType.reset();
            MemberName name_VALUE_ONE = "VALUE_ONE";
            CompleteMemberDetail detail_VALUE_ONE = TypeObjectUtils::build_complete_member_detail(name_VALUE_ONE, member_ann_builtin_VALUE_ONE, ann_custom_EnumType);
            CompleteEnumeratedLiteral literal_VALUE_ONE = TypeObjectUtils::build_complete_enumerated_literal(common_VALUE_ONE, detail_VALUE_ONE);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_EnumType, literal_VALUE_ONE);
        }
        {
            EnumeratedLiteralFlag flags_VALUE_TWO = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_VALUE_TWO = TypeObjectUtils::build_common_enumerated_literal(1, flags_VALUE_TWO);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_VALUE_TWO;
            ann_custom_EnumType.reset();
            MemberName name_VALUE_TWO = "VALUE_TWO";
            CompleteMemberDetail detail_VALUE_TWO = TypeObjectUtils::build_complete_member_detail(name_VALUE_TWO, member_ann_builtin_VALUE_TWO, ann_custom_EnumType);
            CompleteEnumeratedLiteral literal_VALUE_TWO = TypeObjectUtils::build_complete_enumerated_literal(common_VALUE_TWO, detail_VALUE_TWO);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_EnumType, literal_VALUE_TWO);
        }
        {
            EnumeratedLiteralFlag flags_VALUE_THREE = TypeObjectUtils::build_enumerated_literal_flag(false);
            CommonEnumeratedLiteral common_VALUE_THREE = TypeObjectUtils::build_common_enumerated_literal(2, flags_VALUE_THREE);
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_VALUE_THREE;
            ann_custom_EnumType.reset();
            MemberName name_VALUE_THREE = "VALUE_THREE";
            CompleteMemberDetail detail_VALUE_THREE = TypeObjectUtils::build_complete_member_detail(name_VALUE_THREE, member_ann_builtin_VALUE_THREE, ann_custom_EnumType);
            CompleteEnumeratedLiteral literal_VALUE_THREE = TypeObjectUtils::build_complete_enumerated_literal(common_VALUE_THREE, detail_VALUE_THREE);
            TypeObjectUtils::add_complete_enumerated_literal(literal_seq_EnumType, literal_VALUE_THREE);
        }
        CompleteEnumeratedType enumerated_type_EnumType = TypeObjectUtils::build_complete_enumerated_type(enum_flags_EnumType, header_EnumType,
                literal_seq_EnumType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_enumerated_type_object(enumerated_type_EnumType, type_name_EnumType.to_string(), type_ids_EnumType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                "TrialModule::EnumModule::EnumType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace EnumModule

} // namespace TrialModule
namespace TrialModule {
namespace StructModule {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_StructType_type_identifier(
        TypeIdentifierPair& type_ids_StructType)
{

    ReturnCode_t return_code_StructType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_StructType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::StructModule::StructType", type_ids_StructType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_StructType)
    {
        StructTypeFlag struct_flags_StructType = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_StructType = "TrialModule::StructModule::StructType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_StructType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_StructType;
        AppliedAnnotationSeq tmp_ann_custom_StructType;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_StructType;
        if (!tmp_ann_custom_StructType.empty())
        {
            ann_custom_StructType = tmp_ann_custom_StructType;
        }

        CompleteTypeDetail detail_StructType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_StructType, ann_custom_StructType, type_name_StructType.to_string());
        CompleteStructHeader header_StructType;
        header_StructType = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_StructType);
        CompleteStructMemberSeq member_seq_StructType;
        {
            TypeIdentifierPair type_ids_struct_data;
            ReturnCode_t return_code_struct_data {eprosima::fastdds::dds::RETCODE_OK};
            return_code_struct_data =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_struct_data);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_data)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_struct_data))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            StructMemberFlag member_flags_struct_data = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_struct_data = 0x00000000;
            bool common_struct_data_ec {false};
            CommonStructMember common_struct_data {TypeObjectUtils::build_common_struct_member(member_id_struct_data, member_flags_struct_data, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_struct_data, common_struct_data_ec))};
            if (!common_struct_data_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure struct_data member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_struct_data = "struct_data";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_struct_data;
            ann_custom_StructType.reset();
            CompleteMemberDetail detail_struct_data = TypeObjectUtils::build_complete_member_detail(name_struct_data, member_ann_builtin_struct_data, ann_custom_StructType);
            CompleteStructMember member_struct_data = TypeObjectUtils::build_complete_struct_member(common_struct_data, detail_struct_data);
            TypeObjectUtils::add_complete_struct_member(member_seq_StructType, member_struct_data);
        }
        CompleteStructType struct_type_StructType = TypeObjectUtils::build_complete_struct_type(struct_flags_StructType, header_StructType, member_seq_StructType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_StructType, type_name_StructType.to_string(), type_ids_StructType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "TrialModule::StructModule::StructType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace StructModule

} // namespace TrialModule
namespace TrialModule {
namespace UnionModule {
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_UnionType_type_identifier(
        TypeIdentifierPair& type_ids_UnionType)
{
    ReturnCode_t return_code_UnionType {eprosima::fastdds::dds::RETCODE_OK};
    return_code_UnionType =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "TrialModule::UnionModule::UnionType", type_ids_UnionType);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionType)
    {
        UnionTypeFlag union_flags_UnionType = TypeObjectUtils::build_union_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_UnionType = "TrialModule::UnionModule::UnionType";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_UnionType;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_UnionType;
        CompleteTypeDetail detail_UnionType = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_UnionType, ann_custom_UnionType, type_name_UnionType.to_string());
        CompleteUnionHeader header_UnionType = TypeObjectUtils::build_complete_union_header(detail_UnionType);
        UnionDiscriminatorFlag member_flags_UnionType = TypeObjectUtils::build_union_discriminator_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                false);
        return_code_UnionType =
            eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
            "_int32_t", type_ids_UnionType);

        if (return_code_UnionType != eprosima::fastdds::dds::RETCODE_OK)
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "Union discriminator TypeIdentifier unknown to TypeObjectRegistry.");
            return;
        }
        CommonDiscriminatorMember common_UnionType;
        if (EK_COMPLETE == type_ids_UnionType.type_identifier1()._d() || TK_NONE == type_ids_UnionType.type_identifier2()._d())
        {
            common_UnionType = TypeObjectUtils::build_common_discriminator_member(member_flags_UnionType, type_ids_UnionType.type_identifier1());
        }
        else if (EK_COMPLETE == type_ids_UnionType.type_identifier2()._d())
        {
            common_UnionType = TypeObjectUtils::build_common_discriminator_member(member_flags_UnionType, type_ids_UnionType.type_identifier2());
        }
        else
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "TrialModule::UnionModule::UnionType discriminator TypeIdentifier inconsistent.");
            return;
        }
        type_ann_builtin_UnionType.reset();
        ann_custom_UnionType.reset();
        CompleteDiscriminatorMember discriminator_UnionType = TypeObjectUtils::build_complete_discriminator_member(common_UnionType,
                type_ann_builtin_UnionType, ann_custom_UnionType);
        CompleteUnionMemberSeq member_seq_UnionType;
        {
            return_code_UnionType =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_int32_t", type_ids_UnionType);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionType)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "case_long Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_case_long = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_case_long;
            TypeObjectUtils::add_union_case_label(label_seq_case_long, static_cast<int32_t>(0));
            MemberId member_id_case_long = 0x00000001;
            bool common_case_long_ec {false};
            CommonUnionMember common_case_long {TypeObjectUtils::build_common_union_member(member_id_case_long,
                    member_flags_case_long, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_UnionType,
                        common_case_long_ec), label_seq_case_long)};
            if (!common_case_long_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union case_long member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_case_long = "case_long";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_case_long;
            ann_custom_UnionType.reset();
            CompleteMemberDetail detail_case_long = TypeObjectUtils::build_complete_member_detail(name_case_long, member_ann_builtin_case_long, ann_custom_UnionType);
            CompleteUnionMember member_case_long = TypeObjectUtils::build_complete_union_member(common_case_long, detail_case_long);
            TypeObjectUtils::add_complete_union_member(member_seq_UnionType, member_case_long);
        }
        {
            return_code_UnionType =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "_float", type_ids_UnionType);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionType)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                        "case_float Union member TypeIdentifier unknown to TypeObjectRegistry.");
                return;
            }
            UnionMemberFlag member_flags_case_float = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false);
            UnionCaseLabelSeq label_seq_case_float;
            TypeObjectUtils::add_union_case_label(label_seq_case_float, static_cast<int32_t>(1));
            MemberId member_id_case_float = 0x00000002;
            bool common_case_float_ec {false};
            CommonUnionMember common_case_float {TypeObjectUtils::build_common_union_member(member_id_case_float,
                    member_flags_case_float, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_UnionType,
                        common_case_float_ec), label_seq_case_float)};
            if (!common_case_float_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union case_float member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_case_float = "case_float";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_case_float;
            ann_custom_UnionType.reset();
            CompleteMemberDetail detail_case_float = TypeObjectUtils::build_complete_member_detail(name_case_float, member_ann_builtin_case_float, ann_custom_UnionType);
            CompleteUnionMember member_case_float = TypeObjectUtils::build_complete_union_member(common_case_float, detail_case_float);
            TypeObjectUtils::add_complete_union_member(member_seq_UnionType, member_case_float);
        }
        {
            return_code_UnionType =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "anonymous_string_unbounded", type_ids_UnionType);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_UnionType)
            {
                {
                    SBound bound = 0;
                    StringSTypeDefn string_sdefn = TypeObjectUtils::build_string_s_type_defn(bound);
                    if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                            TypeObjectUtils::build_and_register_s_string_type_identifier(string_sdefn,
                            "anonymous_string_unbounded", type_ids_UnionType))
                    {
                        EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                            "anonymous_string_unbounded already registered in TypeObjectRegistry for a different type.");
                    }
                }
            }
            UnionMemberFlag member_flags_case_string = TypeObjectUtils::build_union_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    true, false);
            UnionCaseLabelSeq label_seq_case_string;
            MemberId member_id_case_string = 0x00000003;
            bool common_case_string_ec {false};
            CommonUnionMember common_case_string {TypeObjectUtils::build_common_union_member(member_id_case_string,
                    member_flags_case_string, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_UnionType,
                        common_case_string_ec), label_seq_case_string)};
            if (!common_case_string_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Union case_string member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_case_string = "case_string";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_case_string;
            ann_custom_UnionType.reset();
            CompleteMemberDetail detail_case_string = TypeObjectUtils::build_complete_member_detail(name_case_string, member_ann_builtin_case_string, ann_custom_UnionType);
            CompleteUnionMember member_case_string = TypeObjectUtils::build_complete_union_member(common_case_string, detail_case_string);
            TypeObjectUtils::add_complete_union_member(member_seq_UnionType, member_case_string);
        }
        CompleteUnionType union_type_UnionType = TypeObjectUtils::build_complete_union_type(union_flags_UnionType, header_UnionType, discriminator_UnionType,
                member_seq_UnionType);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_union_type_object(union_type_UnionType, type_name_UnionType.to_string(), type_ids_UnionType))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "TrialModule::UnionModule::UnionType already registered in TypeObjectRegistry for a different type.");
        }
    }
}
} // namespace UnionModule

} // namespace TrialModule
// TypeIdentifier is returned by reference: dependent structures/unions are registered in this same method
void register_ModuleStruct_type_identifier(
        TypeIdentifierPair& type_ids_ModuleStruct)
{

    ReturnCode_t return_code_ModuleStruct {eprosima::fastdds::dds::RETCODE_OK};
    return_code_ModuleStruct =
        eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
        "ModuleStruct", type_ids_ModuleStruct);
    if (eprosima::fastdds::dds::RETCODE_OK != return_code_ModuleStruct)
    {
        StructTypeFlag struct_flags_ModuleStruct = TypeObjectUtils::build_struct_type_flag(eprosima::fastdds::dds::xtypes::ExtensibilityKind::APPENDABLE,
                false, false);
        QualifiedTypeName type_name_ModuleStruct = "ModuleStruct";
        eprosima::fastcdr::optional<AppliedBuiltinTypeAnnotations> type_ann_builtin_ModuleStruct;
        eprosima::fastcdr::optional<AppliedAnnotationSeq> ann_custom_ModuleStruct;
        AppliedAnnotationSeq tmp_ann_custom_ModuleStruct;
        eprosima::fastcdr::optional<AppliedVerbatimAnnotation> verbatim_ModuleStruct;
        if (!tmp_ann_custom_ModuleStruct.empty())
        {
            ann_custom_ModuleStruct = tmp_ann_custom_ModuleStruct;
        }

        CompleteTypeDetail detail_ModuleStruct = TypeObjectUtils::build_complete_type_detail(type_ann_builtin_ModuleStruct, ann_custom_ModuleStruct, type_name_ModuleStruct.to_string());
        CompleteStructHeader header_ModuleStruct;
        header_ModuleStruct = TypeObjectUtils::build_complete_struct_header(TypeIdentifier(), detail_ModuleStruct);
        CompleteStructMemberSeq member_seq_ModuleStruct;
        {
            TypeIdentifierPair type_ids_alias_member;
            ReturnCode_t return_code_alias_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_alias_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::AliasModule::AliasType", type_ids_alias_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_alias_member)
            {
                ::TrialModule::AliasModule::register_AliasType_type_identifier(type_ids_alias_member);
            }
            StructMemberFlag member_flags_alias_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_alias_member = 0x00000000;
            bool common_alias_member_ec {false};
            CommonStructMember common_alias_member {TypeObjectUtils::build_common_struct_member(member_id_alias_member, member_flags_alias_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_alias_member, common_alias_member_ec))};
            if (!common_alias_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure alias_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_alias_member = "alias_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_alias_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_alias_member = TypeObjectUtils::build_complete_member_detail(name_alias_member, member_ann_builtin_alias_member, ann_custom_ModuleStruct);
            CompleteStructMember member_alias_member = TypeObjectUtils::build_complete_struct_member(common_alias_member, detail_alias_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_alias_member);
        }
        {
            TypeIdentifierPair type_ids_bitset_member;
            ReturnCode_t return_code_bitset_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bitset_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::BitsetModule::BitsetType", type_ids_bitset_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitset_member)
            {
                ::TrialModule::BitsetModule::register_BitsetType_type_identifier(type_ids_bitset_member);
            }
            StructMemberFlag member_flags_bitset_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bitset_member = 0x00000001;
            bool common_bitset_member_ec {false};
            CommonStructMember common_bitset_member {TypeObjectUtils::build_common_struct_member(member_id_bitset_member, member_flags_bitset_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitset_member, common_bitset_member_ec))};
            if (!common_bitset_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bitset_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bitset_member = "bitset_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bitset_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_bitset_member = TypeObjectUtils::build_complete_member_detail(name_bitset_member, member_ann_builtin_bitset_member, ann_custom_ModuleStruct);
            CompleteStructMember member_bitset_member = TypeObjectUtils::build_complete_struct_member(common_bitset_member, detail_bitset_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_bitset_member);
        }
        {
            TypeIdentifierPair type_ids_bitmask_member;
            ReturnCode_t return_code_bitmask_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_bitmask_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::BitmaskModule::BitmaskType", type_ids_bitmask_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_bitmask_member)
            {
                ::TrialModule::BitmaskModule::register_BitmaskType_type_identifier(type_ids_bitmask_member);
            }
            StructMemberFlag member_flags_bitmask_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_bitmask_member = 0x00000002;
            bool common_bitmask_member_ec {false};
            CommonStructMember common_bitmask_member {TypeObjectUtils::build_common_struct_member(member_id_bitmask_member, member_flags_bitmask_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_bitmask_member, common_bitmask_member_ec))};
            if (!common_bitmask_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure bitmask_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_bitmask_member = "bitmask_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_bitmask_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_bitmask_member = TypeObjectUtils::build_complete_member_detail(name_bitmask_member, member_ann_builtin_bitmask_member, ann_custom_ModuleStruct);
            CompleteStructMember member_bitmask_member = TypeObjectUtils::build_complete_struct_member(common_bitmask_member, detail_bitmask_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_bitmask_member);
        }
        {
            TypeIdentifierPair type_ids_enum_member;
            ReturnCode_t return_code_enum_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_enum_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::EnumModule::EnumType", type_ids_enum_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_enum_member)
            {
                ::TrialModule::EnumModule::register_EnumType_type_identifier(type_ids_enum_member);
            }
            StructMemberFlag member_flags_enum_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_enum_member = 0x00000003;
            bool common_enum_member_ec {false};
            CommonStructMember common_enum_member {TypeObjectUtils::build_common_struct_member(member_id_enum_member, member_flags_enum_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_enum_member, common_enum_member_ec))};
            if (!common_enum_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure enum_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_enum_member = "enum_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_enum_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_enum_member = TypeObjectUtils::build_complete_member_detail(name_enum_member, member_ann_builtin_enum_member, ann_custom_ModuleStruct);
            CompleteStructMember member_enum_member = TypeObjectUtils::build_complete_struct_member(common_enum_member, detail_enum_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_enum_member);
        }
        {
            TypeIdentifierPair type_ids_struct_member;
            ReturnCode_t return_code_struct_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_struct_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::StructModule::StructType", type_ids_struct_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_struct_member)
            {
                ::TrialModule::StructModule::register_StructType_type_identifier(type_ids_struct_member);
            }
            StructMemberFlag member_flags_struct_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_struct_member = 0x00000004;
            bool common_struct_member_ec {false};
            CommonStructMember common_struct_member {TypeObjectUtils::build_common_struct_member(member_id_struct_member, member_flags_struct_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_struct_member, common_struct_member_ec))};
            if (!common_struct_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure struct_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_struct_member = "struct_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_struct_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_struct_member = TypeObjectUtils::build_complete_member_detail(name_struct_member, member_ann_builtin_struct_member, ann_custom_ModuleStruct);
            CompleteStructMember member_struct_member = TypeObjectUtils::build_complete_struct_member(common_struct_member, detail_struct_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_struct_member);
        }
        {
            TypeIdentifierPair type_ids_union_member;
            ReturnCode_t return_code_union_member {eprosima::fastdds::dds::RETCODE_OK};
            return_code_union_member =
                eprosima::fastdds::dds::DomainParticipantFactory::get_instance()->type_object_registry().get_type_identifiers(
                "TrialModule::UnionModule::UnionType", type_ids_union_member);

            if (eprosima::fastdds::dds::RETCODE_OK != return_code_union_member)
            {
                ::TrialModule::UnionModule::register_UnionType_type_identifier(type_ids_union_member);
            }
            StructMemberFlag member_flags_union_member = TypeObjectUtils::build_struct_member_flag(eprosima::fastdds::dds::xtypes::TryConstructFailAction::DISCARD,
                    false, false, false, false);
            MemberId member_id_union_member = 0x00000005;
            bool common_union_member_ec {false};
            CommonStructMember common_union_member {TypeObjectUtils::build_common_struct_member(member_id_union_member, member_flags_union_member, TypeObjectUtils::retrieve_complete_type_identifier(type_ids_union_member, common_union_member_ec))};
            if (!common_union_member_ec)
            {
                EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION, "Structure union_member member TypeIdentifier inconsistent.");
                return;
            }
            MemberName name_union_member = "union_member";
            eprosima::fastcdr::optional<AppliedBuiltinMemberAnnotations> member_ann_builtin_union_member;
            ann_custom_ModuleStruct.reset();
            CompleteMemberDetail detail_union_member = TypeObjectUtils::build_complete_member_detail(name_union_member, member_ann_builtin_union_member, ann_custom_ModuleStruct);
            CompleteStructMember member_union_member = TypeObjectUtils::build_complete_struct_member(common_union_member, detail_union_member);
            TypeObjectUtils::add_complete_struct_member(member_seq_ModuleStruct, member_union_member);
        }
        CompleteStructType struct_type_ModuleStruct = TypeObjectUtils::build_complete_struct_type(struct_flags_ModuleStruct, header_ModuleStruct, member_seq_ModuleStruct);
        if (eprosima::fastdds::dds::RETCODE_BAD_PARAMETER ==
                TypeObjectUtils::build_and_register_struct_type_object(struct_type_ModuleStruct, type_name_ModuleStruct.to_string(), type_ids_ModuleStruct))
        {
            EPROSIMA_LOG_ERROR(XTYPES_TYPE_REPRESENTATION,
                    "ModuleStruct already registered in TypeObjectRegistry for a different type.");
        }
    }
}
