#!/bin/sh -e
#
# DNS Reply Tool (drool)
#
# Copyright (c) 2017-2021, OARC, Inc.
# Copyright (c) 2017, Comcast Corporation
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions
# are met:
#
# 1. Redistributions of source code must retain the above copyright
#    notice, this list of conditions and the following disclaimer.
#
# 2. Redistributions in binary form must reproduce the above copyright
#    notice, this list of conditions and the following disclaimer in
#    the documentation and/or other materials provided with the
#    distribution.
#
# 3. Neither the name of the copyright holder nor the names of its
#    contributors may be used to endorse or promote products derived
#    from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS
# "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT
# LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
# FOR A PARTICULAR PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE
# COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT,
# INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING,
# BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER
# CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
# LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN
# ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
# POSSIBILITY OF SUCH DAMAGE.

. ./env.sh

export LUA_PATH="$srcdir/../lib/?.lua;$LUA_PATH"

if [ -n "$DROOL_TEST_NETWORK" ]; then
    rm -f test2.out test2.out2
    for pcap in ./dns.pcap-dist ./1qtcp.pcap-dist; do
        ../drool replay -n --no-tcp "$pcap" 127.0.0.1 53 | tail -n 7 >>test2.out
        ../drool replay -n --no-tcp "$pcap" ::1 53 | tail -n 7 >>test2.out
        ../drool replay -T -n --no-tcp "$pcap" 127.0.0.1 53 | tail -n 7 >>test2-threads.out
        ../drool replay -T -n --no-tcp "$pcap" ::1 53 | tail -n 7 >>test2-threads.out
    done
    awk '{print $1 " " $2}' <test2.out >test2.out2
    diff test2.out2 "$srcdir/test2.gold"
    awk '{print $1 " " $2}' <test2-threads.out >test2-threads.out2
    diff test2-threads.out2 "$srcdir/test2.gold"
else
    echo "Not testing network (set DROOL_TEST_NETWORK to enable)"
fi
