/*
 * Decompiled with CFR 0.152.
 */
package com.sittinglittleduck.DirBuster;

import com.sittinglittleduck.DirBuster.Config;
import com.sittinglittleduck.DirBuster.FilterResponce;
import com.sittinglittleduck.DirBuster.HTMLparseWorkUnit;
import com.sittinglittleduck.DirBuster.HTTPHeader;
import com.sittinglittleduck.DirBuster.Manager;
import com.sittinglittleduck.DirBuster.WorkUnit;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Vector;
import java.util.concurrent.BlockingQueue;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.Header;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.NoHttpResponseException;
import org.apache.commons.httpclient.URIException;
import org.apache.commons.httpclient.methods.GetMethod;
import org.apache.commons.httpclient.methods.HeadMethod;

public class Worker
implements Runnable {
    private BlockingQueue<WorkUnit> queue;
    private URL url;
    private WorkUnit work;
    private Manager manager = Manager.getInstance();
    private HttpClient httpclient;
    private boolean pleaseWait = false;
    private int threadId;
    private boolean working;
    private boolean stop = false;

    public Worker(int threadId) {
        this.queue = this.manager.workQueue;
        this.httpclient = this.manager.getHttpclient();
        this.threadId = threadId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        this.queue = this.manager.workQueue;
        while (this.manager.hasWorkLeft()) {
            this.working = false;
            if (this.stop) {
                return;
            }
            Worker worker = this;
            synchronized (worker) {
                while (this.pleaseWait) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            }
            GetMethod httpget = null;
            HeadMethod httphead = null;
            try {
                Pattern regexFindFile;
                String line;
                HTTPHeader httpHeader;
                int a;
                Vector HTTPheaders;
                this.work = this.queue.take();
                this.working = true;
                this.url = this.work.getWork();
                int code = 0;
                String responce = "";
                String rawResponce = "";
                String responseHeader = "";
                String responseBody = "";
                if (this.work.getMethod().equalsIgnoreCase("HEAD")) {
                    if (Config.debug) {
                        System.out.println("DEBUG Worker[" + this.threadId + "]: HEAD " + this.url.toString());
                    }
                    httphead = new HeadMethod(this.url.toString());
                    HTTPheaders = this.manager.getHTTPHeaders();
                    for (a = 0; a < HTTPheaders.size(); ++a) {
                        httpHeader = (HTTPHeader)HTTPheaders.elementAt(a);
                        if (httpHeader.getHeader().startsWith("Host")) {
                            httphead.getParams().setVirtualHost(httpHeader.getValue());
                            continue;
                        }
                        httphead.setRequestHeader(httpHeader.getHeader(), httpHeader.getValue());
                    }
                    httphead.setFollowRedirects(Config.followRedirects);
                    if (this.manager.isLimitRequests()) {
                        while ((double)this.manager.getTotalDone() / ((double)(System.currentTimeMillis() - this.manager.getTimestarted()) / 1000.0) > (double)this.manager.getLimitRequestsTo()) {
                            Thread.sleep(100L);
                        }
                    }
                    code = this.httpclient.executeMethod((HttpMethod)httphead);
                    if (Config.debug) {
                        System.out.println("DEBUG Worker[" + this.threadId + "]: " + code + " " + this.url.toString());
                    }
                    httphead.releaseConnection();
                } else if (this.work.getMethod().equalsIgnoreCase("GET")) {
                    Header contentType;
                    if (Config.debug) {
                        System.out.println("DEBUG Worker[" + this.threadId + "]: GET " + this.url.toString());
                    }
                    httpget = new GetMethod(this.url.toString());
                    HTTPheaders = this.manager.getHTTPHeaders();
                    for (int a2 = 0; a2 < HTTPheaders.size(); ++a2) {
                        httpHeader = (HTTPHeader)HTTPheaders.elementAt(a2);
                        if (httpHeader.getHeader().startsWith("Host")) {
                            httpget.getParams().setVirtualHost(httpHeader.getValue());
                            continue;
                        }
                        httpget.setRequestHeader(httpHeader.getHeader(), httpHeader.getValue());
                    }
                    httpget.setFollowRedirects(Config.followRedirects);
                    if (this.manager.isLimitRequests()) {
                        while ((double)this.manager.getTotalDone() / ((double)(System.currentTimeMillis() - this.manager.getTimestarted()) / 1000.0) > (double)this.manager.getLimitRequestsTo()) {
                            Thread.sleep(100L);
                        }
                    }
                    code = this.httpclient.executeMethod((HttpMethod)httpget);
                    if (Config.debug) {
                        System.out.println("DEBUG Worker[" + this.threadId + "]: " + code + " " + this.url.toString());
                    }
                    BufferedReader input = new BufferedReader(new InputStreamReader(httpget.getResponseBodyAsStream()));
                    String rawHeader = httpget.getStatusLine() + "\r\n";
                    Header[] headers = httpget.getResponseHeaders();
                    StringBuffer buf = new StringBuffer();
                    for (int a3 = 0; a3 < headers.length; ++a3) {
                        buf.append(headers[a3].getName() + ": " + headers[a3].getValue() + "\r\n");
                    }
                    responseHeader = rawHeader = rawHeader + buf.toString();
                    buf = new StringBuffer();
                    while ((line = input.readLine()) != null) {
                        buf.append("\r\n" + line);
                    }
                    responseBody = responce = buf.toString();
                    input.close();
                    rawResponce = rawHeader + responce;
                    if (Config.parseHTML && !this.work.getBaseCaseObj().isUseRegexInstead() && (contentType = httpget.getResponseHeader("Content-Type")) != null && contentType.getValue().startsWith("text")) {
                        this.manager.addHTMLToParseQueue(new HTMLparseWorkUnit(responce, this.work));
                    }
                    responce = FilterResponce.CleanResponce(responce, this.work);
                    Thread.sleep(10L);
                    httpget.releaseConnection();
                }
                if (this.work.getMethod().equalsIgnoreCase("GET") && this.work.getBaseCaseObj().useContentAnalysisMode()) {
                    if (code == 200) {
                        if (Config.debug) {
                            System.out.println("DEBUG Worker[" + this.threadId + "]: Base Case Check " + this.url.toString());
                        }
                        regexFindFile = Pattern.compile(".*file not found.*", 2);
                        Matcher m = regexFindFile.matcher(responce);
                        String basecase = FilterResponce.removeItemCheckedFor(this.work.getBaseCaseObj().getBaseCase(), this.work.getItemToCheck());
                        if (!m.find() && !responce.equalsIgnoreCase(basecase)) {
                            if (this.work.isDir()) {
                                if (Config.debug) {
                                    System.out.println("DEBUG Worker[" + this.threadId + "]: Found Dir (base case)" + this.url.toString());
                                }
                                this.manager.foundDir(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                            } else {
                                if (Config.debug) {
                                    System.out.println("DEBUG Worker[" + this.threadId + "]: Found File (base case)" + this.url.toString());
                                }
                                this.manager.foundFile(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                            }
                        }
                    } else if (code != 404 && code != 400) {
                        if (this.work.isDir()) {
                            if (Config.debug) {
                                System.out.println("DEBUG Worker[" + this.threadId + "]: Found Dir (base case)" + this.url.toString());
                            }
                            this.manager.foundDir(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                        } else {
                            if (Config.debug) {
                                System.out.println("DEBUG Worker[" + this.threadId + "]: Found File (base case)" + this.url.toString());
                            }
                            this.manager.foundFile(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                        }
                    }
                } else if (this.work.getBaseCaseObj().isUseRegexInstead()) {
                    regexFindFile = Pattern.compile(this.work.getBaseCaseObj().getRegex());
                    Matcher m = regexFindFile.matcher(rawResponce);
                    if (m.find()) {
                        if (Config.debug) {
                            System.out.println("DEBUG Worker[" + this.threadId + "]: Regex matched so it's a 404, " + this.url.toString());
                        }
                    } else {
                        Header contentType;
                        if (Config.parseHTML && (contentType = httpget.getResponseHeader("Content-Type")) != null && contentType.getValue().startsWith("text")) {
                            this.manager.addHTMLToParseQueue(new HTMLparseWorkUnit(rawResponce, this.work));
                        }
                        if (this.work.isDir()) {
                            if (Config.debug) {
                                System.out.println("DEBUG Worker[" + this.threadId + "]: Found Dir (regex) " + this.url.toString());
                            }
                            this.manager.foundDir(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                        } else {
                            if (Config.debug) {
                                System.out.println("DEBUG Worker[" + this.threadId + "]: Found File (regex) " + this.url.toString());
                            }
                            this.manager.foundFile(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                        }
                    }
                } else if (code != this.work.getBaseCaseObj().getFailCode() && code != 404 && code != 0 && code != 400) {
                    if (this.work.getMethod().equalsIgnoreCase("HEAD")) {
                        int newCode;
                        if (Config.debug) {
                            System.out.println("DEBUG Worker[" + this.threadId + "]: Getting responce via GET " + this.url.toString());
                        }
                        rawResponce = "";
                        httpget = new GetMethod(this.url.toString());
                        HTTPheaders = this.manager.getHTTPHeaders();
                        for (a = 0; a < HTTPheaders.size(); ++a) {
                            httpHeader = (HTTPHeader)HTTPheaders.elementAt(a);
                            httpget.setRequestHeader(httpHeader.getHeader(), httpHeader.getValue());
                        }
                        httpget.setFollowRedirects(Config.followRedirects);
                        if (this.manager.isLimitRequests()) {
                            while ((double)this.manager.getTotalDone() / ((double)(System.currentTimeMillis() - this.manager.getTimestarted()) / 1000.0) > (double)this.manager.getLimitRequestsTo()) {
                                Thread.sleep(100L);
                            }
                        }
                        if ((newCode = this.httpclient.executeMethod((HttpMethod)httpget)) != code) {
                            this.manager.foundError(this.url, "Return code for first HEAD, is different to the second GET: " + code + " - " + newCode);
                        }
                        responseBody = "";
                        responseHeader = "";
                        rawResponce = "";
                        rawResponce = httpget.getStatusLine() + "\r\n";
                        Header[] headers = httpget.getResponseHeaders();
                        StringBuffer buf = new StringBuffer();
                        for (int a4 = 0; a4 < headers.length; ++a4) {
                            buf.append(headers[a4].getName() + ": " + headers[a4].getValue() + "\r\n");
                        }
                        buf.append("\r\n");
                        responseHeader = rawResponce = rawResponce + buf.toString();
                        if (httpget.getResponseContentLength() > 0L) {
                            BufferedReader input = new BufferedReader(new InputStreamReader(httpget.getResponseBodyAsStream()));
                            String tempResponce = "";
                            buf = new StringBuffer();
                            while ((line = input.readLine()) != null) {
                                buf.append("\r\n" + line);
                            }
                            responseBody = tempResponce = buf.toString();
                            input.close();
                            rawResponce = rawResponce + tempResponce;
                            Header contentType = httpget.getResponseHeader("Content-Type");
                            if (Config.parseHTML && (contentType = httpget.getResponseHeader("Content-Type")) != null && contentType.getValue().startsWith("text")) {
                                this.manager.addHTMLToParseQueue(new HTMLparseWorkUnit(tempResponce, this.work));
                            }
                        }
                        httpget.releaseConnection();
                    }
                    if (this.work.isDir()) {
                        this.manager.foundDir(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                    } else {
                        this.manager.foundFile(this.url, code, responseHeader, responseBody, this.work.getBaseCaseObj());
                    }
                }
                this.manager.workDone();
                Thread.sleep(20L);
            }
            catch (NoHttpResponseException e) {
                this.manager.foundError(this.url, "NoHttpResponseException " + e.getMessage());
                this.manager.workDone();
            }
            catch (ConnectTimeoutException e) {
                this.manager.foundError(this.url, "ConnectTimeoutException " + e.getMessage());
                this.manager.workDone();
            }
            catch (URIException e) {
                this.manager.foundError(this.url, "URIException " + e.getMessage());
                this.manager.workDone();
            }
            catch (IOException e) {
                this.manager.foundError(this.url, "IOException " + e.getMessage());
                this.manager.workDone();
            }
            catch (InterruptedException e) {
                this.manager.workDone();
                return;
            }
            catch (IllegalArgumentException e) {
                e.printStackTrace();
                this.manager.foundError(this.url, "IllegalArgumentException " + e.getMessage());
                this.manager.workDone();
            }
            finally {
                if (httpget != null) {
                    httpget.releaseConnection();
                }
                if (httphead == null) continue;
                httphead.releaseConnection();
            }
        }
    }

    public void pause() {
        this.pleaseWait = true;
    }

    public void unPause() {
        this.pleaseWait = false;
    }

    public boolean isWorking() {
        return this.working;
    }

    public void stopThread() {
        this.stop = true;
    }
}

