Starting with recent CA developments, some Certificate Authorities (CAs) now support issuing certificates under different **profiles**.<br>
These profiles may differ in terms of validation rules, supported features, or certificate lifetime.

For example, Let’s Encrypt provides multiple [certificate profiles](https://letsencrypt.org/docs/profiles/) that define validity periods and capabilities.

## Usage

You can select the certificate profile during issuance with the `--cert-profile` parameter:
```
acme.sh --issue -d example.com --cert-profile <profile-name>
```

You can list all certificate profiles supported by your current CA using the following command:
```
acme.sh --list-profiles
``` 

## Example (Let’s Encrypt)
```
acme.sh --issue --server letsencrypt -d example.com -w /home/username/public_html --cert-profile tlsserver
```
This will request a certificate using Let’s Encrypt’s tlsserver profile.

## Important: Certificate Lifetime and `--days`

Some profiles may reduce the validity period of the certificate (e.g. 160 hours lifetimes instead of 90 days).

When using such profiles, you should also set the `--days` parameter to ensure that acme.sh renews the certificate early enough:
```
acme.sh --issue --server letsencrypt -d 203.0.113.195 -w /home/username/public_html --certificate-profile shortlived --days 6
```

## Notes

- The available profile names depend on the selected CA.
- If you do not specify `--cert-profile`, the default profile is used.
- Always check your CA’s documentation for supported profile names and their characteristics.