# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

inherit libtool

DESCRIPTION="Multithreaded multifrontal sparse QR factorization library"
HOMEPAGE="https://people.engr.tamu.edu/davis/suitesparse.html"
SRC_URI="http://202.36.178.9/sage/${P}.tar.bz2"

LICENSE="GPL-2+"
SLOT="0"
KEYWORDS="amd64 arm arm64 ~hppa ~loong ~ppc ppc64 ~riscv ~sparc ~x86 ~amd64-linux ~x86-linux"
IUSE="doc partition tbb"

BDEPEND="virtual/pkgconfig
	doc? ( virtual/latex-base )"
# We require the cholmod supernodal module that is enabled with
# USE=lapack, and cholmod has to have partition support if spqr is going
# to have it (the ./configure script for spqr checks this). Note that
# spqr links to metis directly, too.
DEPEND="
	virtual/lapack
	=sci-libs/cholmod-3*[lapack,partition?]
	partition? ( >=sci-libs/metis-5.1.0 )
	tbb? ( <dev-cpp/tbb-2021:= )"
RDEPEND="${DEPEND}"

src_prepare() {
	default
	elibtoolize

	# Should be able to drop this workaround with newer versions.
	# upstream fix it by replace \htmladdnormallink{...} with \url{}
	sed -e '/^\\usepackage{hyperref}$/i \\\\usepackage{html}' \
		-i Doc/spqr_user_guide.tex || die
}

src_configure() {
	econf \
		$(use_with doc) \
		$(use_with partition) \
		$(use_with tbb)
}

src_install() {
	default

	# no static archives
	find "${D}" -name '*.la' -delete || die
}
