# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

DIST_AUTHOR=RKITOVER
DIST_VERSION=0.74
DIST_EXAMPLES=( "example/*" )
inherit perl-module

DESCRIPTION="Support for the SSH 2 protocol via libssh2"

SLOT="0"
KEYWORDS="~amd64 ~x86"
IUSE="gcrypt"

RDEPEND="
	net-libs/libssh2
	virtual/zlib:=
	!gcrypt? (
		dev-libs/openssl:=
	)
	gcrypt? (
		dev-libs/libgcrypt:=
	)
"
DEPEND="${RDEPEND}"
BDEPEND="dev-perl/Module-Install"

src_configure() {
	local myconf=(
		crypto_backend=$(usex gcrypt gcrypt openssl)
	)

	perl-module_src_configure
}
