# Copyright 1999-2025 Gentoo Authors
# Distributed under the terms of the GNU General Public License v2

EAPI=8

# mgorny: py3.14 fails on hypothesis tests for me (inside crash)
# I suppose we can skip them but let's test a revdep first
PYTHON_COMPAT=( python3_{11..13} )
DISTUTILS_USE_PEP517=setuptools

inherit distutils-r1

DESCRIPTION="A pytest plugin for testing Twisted framework consumers"
HOMEPAGE="
	https://github.com/pytest-dev/pytest-twisted/
	https://pypi.org/project/pytest-twisted/
"
SRC_URI="
	https://github.com/pytest-dev/pytest-twisted/archive/v${PV}.tar.gz
		-> ${P}.gh.tar.gz
"

LICENSE="BSD"
SLOT="0"
KEYWORDS="amd64 ~arm ~arm64 ~riscv x86"

RDEPEND="
	dev-python/decorator[${PYTHON_USEDEP}]
	dev-python/greenlet[${PYTHON_USEDEP}]
	>=dev-python/pytest-2.3[${PYTHON_USEDEP}]
	dev-python/twisted[${PYTHON_USEDEP}]
"
EPYTEST_PLUGIN_LOAD_VIA_ENV=1
EPYTEST_PLUGINS=( "${PN}" hypothesis )
EPYTEST_XDIST=1
distutils_enable_tests pytest
