/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.om;

import com.icl.saxon.Context;
import com.icl.saxon.Controller;
import com.icl.saxon.Mode;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.ProxyEmitter;
import com.icl.saxon.tree.ElementImpl;
import javax.xml.transform.TransformerException;
import org.xml.sax.Attributes;

public class Stripper
extends ProxyEmitter {
    private boolean preserveAll;
    private boolean stripAll;
    private byte[] stripStack = new byte[100];
    private int top = 0;
    private Mode stripperMode;
    private DummyElement element = new DummyElement();
    private Context context;
    private NamePool namePool;

    protected Stripper() {
    }

    public Stripper(Mode mode) {
        this.stripperMode = mode;
        this.preserveAll = mode == null;
        this.stripAll = false;
    }

    public void setPreserveAll() {
        this.preserveAll = true;
        this.stripAll = false;
    }

    public boolean getPreserveAll() {
        return this.preserveAll;
    }

    public void setStripAll() {
        this.preserveAll = false;
        this.stripAll = true;
    }

    public boolean getStripAll() {
        return this.stripAll;
    }

    public void setController(Controller controller) {
        this.context = controller.makeContext(this.element);
        this.namePool = controller.getNamePool();
    }

    public boolean isSpacePreserving(int n) {
        try {
            if (this.preserveAll) {
                return true;
            }
            if (this.stripAll) {
                return false;
            }
            this.element.setNameCode(n);
            Object object = this.stripperMode.getRule(this.element, this.context);
            if (object == null) {
                return true;
            }
            return (Boolean)object;
        }
        catch (TransformerException transformerException) {
            return true;
        }
    }

    public void startDocument() throws TransformerException {
        this.top = 0;
        this.stripStack[this.top] = 1;
        super.startDocument();
    }

    public void startElement(int n, Attributes attributes, int[] nArray, int n2) throws TransformerException {
        super.startElement(n, attributes, nArray, n2);
        byte by = this.stripStack[this.top];
        String string = attributes.getValue("http://www.w3.org/XML/1998/namespace", "space");
        int n3 = by & 2;
        if (string != null) {
            if (string.equals("preserve")) {
                n3 = 2;
            }
            if (string.equals("default")) {
                n3 = 0;
            }
        }
        if (this.isSpacePreserving(n)) {
            n3 = (byte)(n3 | 1);
        }
        ++this.top;
        if (this.top >= this.stripStack.length) {
            byte[] byArray = new byte[this.top * 2];
            System.arraycopy(this.stripStack, 0, byArray, 0, this.top);
            this.stripStack = byArray;
        }
        this.stripStack[this.top] = n3;
    }

    public void endElement(int n) throws TransformerException {
        super.endElement(n);
        --this.top;
    }

    public void characters(char[] cArray, int n, int n2) throws TransformerException {
        if (!(n2 <= 0 || this.stripStack[this.top] == 0 && this.isWhite(cArray, n, n2))) {
            super.characters(cArray, n, n2);
        }
    }

    private boolean isWhite(char[] cArray, int n, int n2) {
        int n3 = n;
        while (n3 < n + n2) {
            if (cArray[n3] > ' ') {
                return false;
            }
            ++n3;
        }
        return true;
    }

    private class DummyElement
    extends ElementImpl {
        private DummyElement() {
        }

        public short getURICode() {
            return Stripper.this.namePool.getURICode(this.getNameCode());
        }
    }
}

