/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.style;

import com.icl.saxon.Context;
import com.icl.saxon.PreparedStyleSheet;
import com.icl.saxon.expr.Expression;
import com.icl.saxon.expr.StringValue;
import com.icl.saxon.om.Name;
import com.icl.saxon.om.NamePool;
import com.icl.saxon.output.Outputter;
import com.icl.saxon.style.StandardNames;
import com.icl.saxon.style.StyleElement;
import com.icl.saxon.style.XSLStyleSheet;
import com.icl.saxon.tree.DocumentImpl;
import com.icl.saxon.tree.TreeBuilder;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.xml.sax.helpers.AttributesImpl;

public class LiteralResultElement
extends StyleElement {
    private int resultNameCode;
    private int[] attributeNames;
    private Expression[] attributeValues;
    private boolean[] attributeChecked;
    private int numberOfAttributes;
    private boolean toplevel;
    private int[] namespaceCodes;

    public boolean mayContainTemplateBody() {
        return true;
    }

    public void prepareAttributes() throws TransformerConfigurationException {
    }

    public void validate() throws TransformerConfigurationException {
        this.toplevel = this.getParentNode() instanceof XSLStyleSheet;
        StandardNames standardNames = this.getStandardNames();
        this.resultNameCode = this.getNameCode();
        NamePool namePool = this.getNamePool();
        short s = namePool.getURICode(this.resultNameCode);
        if (this.toplevel) {
            if (s == 0) {
                this.compileError("Top level elements must have a non-null namespace URI");
            }
        } else {
            short s2;
            int n;
            int n2;
            int n3;
            int n4;
            int n5;
            boolean bl = false;
            if (this.getParent() instanceof LiteralResultElement && (this.namespaceList == null || this.namespaceList.length == 0) && s == namePool.getURICode(this.getParent().getFingerprint())) {
                bl = true;
            }
            if (bl) {
                int n6 = 0;
                while (n6 < this.attributeList.getLength()) {
                    if ((this.attributeList.getNameCode(n6) >> 20 & 0xFF) != 0) {
                        bl = false;
                        break;
                    }
                    ++n6;
                }
            }
            this.namespaceCodes = bl ? new int[0] : this.getNamespaceCodes();
            XSLStyleSheet xSLStyleSheet = this.getPrincipalStyleSheet();
            if (xSLStyleSheet.hasNamespaceAliases()) {
                short s3;
                n5 = 0;
                while (n5 < this.namespaceCodes.length) {
                    s3 = (short)(this.namespaceCodes[n5] & 0xFFFF);
                    n4 = xSLStyleSheet.getNamespaceAlias(s3);
                    if (s3 != n4) {
                        n3 = this.namespaceCodes[n5] & 0xFFFF0000;
                        this.namespaceCodes[n5] = n3 | n4;
                    }
                    ++n5;
                }
                s3 = xSLStyleSheet.getNamespaceAlias(s);
                if (s3 != s) {
                    s = s3;
                    this.resultNameCode = namePool.allocate(this.getPrefix(), s3, this.getLocalName());
                }
            }
            n5 = this.attributeList.getLength();
            this.attributeNames = new int[n5];
            this.attributeValues = new Expression[n5];
            this.attributeChecked = new boolean[n5];
            short[] sArray = new short[n5];
            this.numberOfAttributes = 0;
            n4 = 0;
            while (n4 < n5) {
                n2 = n3 = this.attributeList.getNameCode(n4);
                n = n3 & 0xFFFFF;
                s2 = namePool.getURICode(n3);
                if (n == standardNames.XSL_USE_ATTRIBUTE_SETS) {
                    this.findAttributeSets(this.attributeList.getValue(n4));
                } else if (n != standardNames.XSL_EXTENSION_ELEMENT_PREFIXES && n != standardNames.XSL_EXCLUDE_RESULT_PREFIXES && n != standardNames.XSL_VERSION) {
                    Expression expression;
                    String string;
                    short s4;
                    if (s2 == 2) {
                        this.compileError("Unknown XSL attribute " + namePool.getDisplayName(n3));
                    }
                    if (s2 != 0 && (s4 = xSLStyleSheet.getNamespaceAlias(s2)) != s2) {
                        String string2 = namePool.getDisplayName(n3);
                        string = Name.getPrefix(string2);
                        String string3 = Name.getLocalName(string2);
                        String string4 = namePool.getURIFromNamespaceCode(s4);
                        n2 = namePool.allocate(string, string4, string3);
                        s2 = s4;
                    }
                    this.attributeNames[this.numberOfAttributes] = n2;
                    sArray[this.numberOfAttributes] = s2;
                    this.attributeValues[this.numberOfAttributes] = expression = this.makeAttributeValueTemplate(this.attributeList.getValue(n4));
                    this.attributeChecked[this.numberOfAttributes] = false;
                    boolean bl2 = false;
                    if (expression instanceof StringValue) {
                        string = ((StringValue)expression).asString();
                        int n7 = 0;
                        while (n7 < string.length()) {
                            char c = string.charAt(n7);
                            if (c < '!' || c > '~' || c == '<' || c == '>' || c == '&' || c == '\"') {
                                bl2 = true;
                                break;
                            }
                            ++n7;
                        }
                        this.attributeChecked[this.numberOfAttributes] = !bl2;
                    }
                    ++this.numberOfAttributes;
                }
                ++n4;
            }
            n3 = 0;
            while (n3 < this.namespaceCodes.length) {
                n2 = (short)(this.namespaceCodes[n3] & 0xFFFF);
                if (this.isExcludedNamespace((short)n2)) {
                    n = 1;
                    if (n2 == s) {
                        n = 0;
                    }
                    s2 = 0;
                    while (s2 < this.numberOfAttributes) {
                        if (n2 == sArray[s2]) {
                            n = 0;
                            break;
                        }
                        ++s2;
                    }
                    if (n != 0) {
                        this.namespaceCodes[n3] = -1;
                    }
                }
                ++n3;
            }
        }
    }

    protected void validateChildren() throws TransformerConfigurationException {
        if (!this.toplevel) {
            super.validateChildren();
        }
    }

    public void process(Context context) throws TransformerException {
        if (this.toplevel) {
            return;
        }
        Outputter outputter = context.getOutputter();
        outputter.writeStartTag(this.resultNameCode);
        int n = 0;
        while (n < this.namespaceCodes.length) {
            if (this.namespaceCodes[n] != -1) {
                outputter.writeNamespaceDeclaration(this.namespaceCodes[n]);
            }
            ++n;
        }
        this.processAttributeSets(context);
        int n2 = 0;
        while (n2 < this.numberOfAttributes) {
            int n3 = this.attributeNames[n2];
            String string = this.attributeValues[n2].evaluateAsString(context);
            outputter.writeAttribute(n3, string, this.attributeChecked[n2]);
            ++n2;
        }
        this.processChildren(context);
        outputter.writeEndTag(this.resultNameCode);
    }

    public DocumentImpl makeStyleSheet(PreparedStyleSheet preparedStyleSheet) throws TransformerConfigurationException {
        NamePool namePool = this.getNamePool();
        StandardNames standardNames = this.getStandardNames();
        String string = this.getPrefixForURI("http://www.w3.org/1999/XSL/Transform");
        if (string == null) {
            String string2 = this.getLocalName().equals("stylesheet") || this.getLocalName().equals("transform") ? (this.getPrefixForURI("http://www.w3.org/TR/WD-xsl") != null ? "Saxon is not able to process Microsoft's WD-xsl dialect" : "Namespace for stylesheet element should be http://www.w3.org/1999/XSL/Transform") : "The supplied file does not appear to be a stylesheet";
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException(string2);
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        String string3 = this.getAttributeValue(standardNames.XSL_VERSION);
        if (string3 == null) {
            TransformerConfigurationException transformerConfigurationException = new TransformerConfigurationException("Literal Result Element As Stylesheet: xsl:version attribute is missing");
            try {
                preparedStyleSheet.reportError(transformerConfigurationException);
            }
            catch (TransformerException transformerException) {
                // empty catch block
            }
            throw transformerConfigurationException;
        }
        try {
            TreeBuilder treeBuilder = new TreeBuilder();
            treeBuilder.setDocumentLocator(null);
            treeBuilder.setNamePool(namePool);
            treeBuilder.setNodeFactory(((DocumentImpl)this.getParentNode()).getNodeFactory());
            treeBuilder.setSystemId(this.getSystemId());
            treeBuilder.startDocument();
            AttributesImpl attributesImpl = new AttributesImpl();
            attributesImpl.addAttribute("", "version", "version", "CDATA", string3);
            int[] nArray = new int[]{namePool.getNamespaceCode("xsl", "http://www.w3.org/1999/XSL/Transform")};
            int n = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "stylesheet");
            treeBuilder.startElement(n, attributesImpl, nArray, 1);
            int n2 = namePool.allocate("xsl", "http://www.w3.org/1999/XSL/Transform", "template");
            attributesImpl.clear();
            attributesImpl.addAttribute("", "match", "match", "CDATA", "/");
            treeBuilder.startElement(n2, attributesImpl, nArray, 0);
            treeBuilder.graftElement(this);
            treeBuilder.endElement(n2);
            treeBuilder.endElement(n);
            treeBuilder.endDocument();
            return (DocumentImpl)treeBuilder.getCurrentDocument();
        }
        catch (TransformerException transformerException) {
            throw new TransformerConfigurationException(transformerException);
        }
    }
}

