/*
 * Decompiled with CFR 0.152.
 */
package com.icl.saxon.tinytree;

import com.icl.saxon.om.AxisEnumeration;
import com.icl.saxon.om.NodeInfo;
import com.icl.saxon.pattern.NameTest;
import com.icl.saxon.pattern.NodeTest;
import com.icl.saxon.tinytree.TinyDocumentImpl;

final class AttributeEnumeration
implements AxisEnumeration {
    private TinyDocumentImpl doc;
    private int element;
    private NodeTest nodeTest;
    private int index;
    private int last = -1;

    protected AttributeEnumeration(TinyDocumentImpl tinyDocumentImpl, int n, NodeTest nodeTest) {
        this.nodeTest = nodeTest;
        this.doc = tinyDocumentImpl;
        this.element = n;
        this.index = tinyDocumentImpl.offset[n];
        this.advance();
    }

    public boolean hasMoreElements() {
        return this.index >= 0;
    }

    public NodeInfo nextElement() {
        int n = this.index++;
        if (this.nodeTest instanceof NameTest) {
            this.index = -1;
        } else {
            this.advance();
        }
        return this.doc.getAttributeNode(n);
    }

    private void advance() {
        while (true) {
            if (this.index >= this.doc.numberOfAttributes || this.doc.attParent[this.index] != this.element) {
                this.index = -1;
                return;
            }
            if (this.nodeTest.matches((short)2, this.doc.attCode[this.index])) {
                return;
            }
            ++this.index;
        }
    }

    public boolean isSorted() {
        return true;
    }

    public boolean isReverseSorted() {
        return false;
    }

    public boolean isPeer() {
        return true;
    }

    public int getLastPosition() {
        if (this.last >= 0) {
            return this.last;
        }
        AttributeEnumeration attributeEnumeration = new AttributeEnumeration(this.doc, this.element, this.nodeTest);
        this.last = 0;
        while (attributeEnumeration.hasMoreElements()) {
            attributeEnumeration.nextElement();
            ++this.last;
        }
        return this.last;
    }
}

