/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.expr.instruct;

import java.util.Arrays;
import java.util.Iterator;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.ExpressionVisitor;
import net.sf.saxon.expr.PromotionOffer;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Instruction;
import net.sf.saxon.expr.instruct.LocalParam;
import net.sf.saxon.expr.instruct.TailCall;
import net.sf.saxon.pattern.EmptySequenceTest;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LocalParamBlock
extends Instruction {
    private LocalParam[] children;

    public LocalParamBlock(LocalParam[] params) {
        this.children = params;
        for (int c = 0; c < this.children.length; ++c) {
            this.adoptChildExpression(this.children[c]);
        }
    }

    @Override
    public String getExpressionName() {
        return "block";
    }

    public LocalParam[] getChildren() {
        return this.children;
    }

    @Override
    public int computeSpecialProperties() {
        return 0;
    }

    @Override
    public Iterator<Expression> iterateSubExpressions() {
        return Arrays.asList((Expression[])this.children).iterator();
    }

    @Override
    public boolean replaceSubExpression(Expression original, Expression replacement) {
        boolean found = false;
        if (replacement instanceof LocalParam) {
            for (int c = 0; c < this.children.length; ++c) {
                if (this.children[c] != original) continue;
                this.children[c] = (LocalParam)replacement;
                found = true;
            }
        }
        return found;
    }

    @Override
    public Expression copy() {
        LocalParam[] c2 = new LocalParam[this.children.length];
        for (int c = 0; c < this.children.length; ++c) {
            c2[c] = (LocalParam)this.children[c].copy();
        }
        return new LocalParamBlock(c2);
    }

    @Override
    public final ItemType getItemType(TypeHierarchy th) {
        return EmptySequenceTest.getInstance();
    }

    @Override
    public final int getCardinality() {
        return 8192;
    }

    @Override
    public Expression simplify(ExpressionVisitor visitor) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = (LocalParam)visitor.simplify(this.children[c]);
            this.adoptChildExpression(this.children[c]);
        }
        return this;
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = (LocalParam)visitor.typeCheck(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
        }
        return this;
    }

    @Override
    public Expression optimize(ExpressionVisitor visitor, ItemType contextItemType) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c] = (LocalParam)visitor.optimize(this.children[c], contextItemType);
            this.adoptChildExpression(this.children[c]);
        }
        return this;
    }

    @Override
    protected void promoteInst(PromotionOffer offer) throws XPathException {
        for (int c = 0; c < this.children.length; ++c) {
            LocalParam p = this.children[c];
            p.setSelectExpression(this.doPromotion(p.getSelectExpression(), offer));
        }
    }

    @Override
    public void explain(ExpressionPresenter out) {
        out.startElement("params");
        for (int c = 0; c < this.children.length; ++c) {
            this.children[c].explain(out);
        }
        out.endElement();
    }

    @Override
    public TailCall processLeavingTail(XPathContext context) throws XPathException {
        for (int i = 0; i < this.children.length; ++i) {
            try {
                LocalParam param = this.children[i];
                context.setLocalVariable(param.getSlotNumber(), param.getSelectValue(context));
                continue;
            }
            catch (XPathException e) {
                e.maybeSetLocation(this.children[i]);
                e.maybeSetContext(context);
                throw e;
            }
        }
        return null;
    }

    @Override
    public int getImplementationMethod() {
        return 4;
    }
}

