/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.extensions.fileutils;

import com.xmlcalabash.core.XProcConstants;
import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.io.Pipe;
import com.xmlcalabash.io.WritablePipe;
import com.xmlcalabash.library.DefaultStep;
import com.xmlcalabash.library.HttpRequest;
import com.xmlcalabash.model.RuntimeValue;
import com.xmlcalabash.runtime.XAtomicStep;
import com.xmlcalabash.util.RelevantNodes;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import java.io.File;
import java.net.URI;
import java.util.GregorianCalendar;
import java.util.TimeZone;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;

public class Info
extends DefaultStep {
    private static final QName _href = new QName("href");
    private static final QName _method = new QName("method");
    private static final QName _status_only = new QName("status-only");
    private static final QName _detailed = new QName("detailed");
    private static final QName _status = new QName("status");
    private static final QName _name = new QName("name");
    private static final QName _value = new QName("value");
    private static final QName _username = new QName("username");
    private static final QName _password = new QName("password");
    private static final QName _auth_method = new QName("auth_method");
    private static final QName _send_authorization = new QName("send-authorization");
    private static final QName _fail_on_error = new QName("fail-on-error");
    protected static final QName c_uri = new QName("c", "http://www.w3.org/ns/xproc-step", "uri");
    protected static final QName c_directory = new QName("c", "http://www.w3.org/ns/xproc-step", "directory");
    protected static final QName c_file = new QName("c", "http://www.w3.org/ns/xproc-step", "file");
    protected static final QName c_other = new QName("c", "http://www.w3.org/ns/xproc-step", "other");
    protected static final QName c_error = new QName("c", "http://www.w3.org/ns/xproc-step", "error");
    protected static final QName err_fu01 = new QName("err", "http://www.w3.org/ns/xproc-error", "FU01");
    private static final QName _uri = new QName("uri");
    private static final QName _readable = new QName("readable");
    private static final QName _writable = new QName("writable");
    private static final QName _exists = new QName("exists");
    private static final QName _hidden = new QName("hidden");
    private static final QName _last_modified = new QName("last-modified");
    private static final QName _size = new QName("size");
    private WritablePipe result = null;

    public Info(XProcRuntime xProcRuntime, XAtomicStep xAtomicStep) {
        super(xProcRuntime, xAtomicStep);
    }

    @Override
    public void setOutput(String string, WritablePipe writablePipe) {
        this.result = writablePipe;
    }

    @Override
    public void reset() {
        this.result.resetWriter();
    }

    @Override
    public void run() throws SaxonApiException {
        super.run();
        RuntimeValue runtimeValue = this.getOption(_href);
        URI uRI = runtimeValue.getBaseURI().resolve(runtimeValue.getString());
        boolean bl = this.getOption(_fail_on_error, true);
        this.finest(this.step.getNode(), "Checking info for " + uRI);
        TreeWriter treeWriter = new TreeWriter(this.runtime);
        treeWriter.startDocument(this.step.getNode().getBaseURI());
        if ("file".equals(uRI.getScheme())) {
            File file = new File(uRI.getPath());
            if (!file.exists()) {
                if (bl) {
                    throw new XProcException(err_fu01);
                }
                treeWriter.addStartElement(c_error);
                treeWriter.addText("File not found");
                treeWriter.addEndElement();
                treeWriter.endDocument();
                this.result.write(treeWriter.getResult());
                return;
            }
            if (file.isDirectory()) {
                treeWriter.addStartElement(c_directory);
            } else if (file.isFile()) {
                treeWriter.addStartElement(c_file);
            } else {
                treeWriter.addStartElement(c_other);
            }
            treeWriter.addAttribute(_href, uRI.toASCIIString());
            if (file.canRead()) {
                treeWriter.addAttribute(_readable, "true");
            }
            if (file.canWrite()) {
                treeWriter.addAttribute(_writable, "true");
            }
            if (file.isHidden()) {
                treeWriter.addAttribute(_hidden, "true");
            }
            treeWriter.addAttribute(_size, "" + file.length());
            GregorianCalendar gregorianCalendar = new GregorianCalendar();
            gregorianCalendar.setTimeInMillis(file.lastModified());
            TimeZone timeZone = TimeZone.getDefault();
            long l = file.lastModified() - (long)timeZone.getRawOffset();
            if (timeZone.useDaylightTime() && timeZone.inDaylightTime(gregorianCalendar.getTime())) {
                l -= (long)timeZone.getDSTSavings();
            }
            gregorianCalendar.setTimeInMillis(l);
            treeWriter.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$02d:%5$02d:%6$02dZ", gregorianCalendar.get(1), gregorianCalendar.get(2) + 1, gregorianCalendar.get(5), gregorianCalendar.get(11), gregorianCalendar.get(12), gregorianCalendar.get(13)));
            treeWriter.startContent();
            treeWriter.addEndElement();
        } else {
            String[] stringArray;
            treeWriter.addStartElement(c_uri);
            HttpRequest httpRequest = new HttpRequest(this.runtime, this.step);
            Pipe pipe = new Pipe(this.runtime);
            Pipe pipe2 = new Pipe(this.runtime);
            httpRequest.setInput("source", pipe);
            httpRequest.setOutput("result", pipe2);
            TreeWriter treeWriter2 = new TreeWriter(this.runtime);
            treeWriter2.startDocument(this.step.getNode().getBaseURI());
            treeWriter2.addStartElement(XProcConstants.c_request);
            treeWriter2.addAttribute(_method, "HEAD");
            treeWriter2.addAttribute(_href, uRI.toASCIIString());
            treeWriter2.addAttribute(_status_only, "true");
            treeWriter2.addAttribute(_detailed, "true");
            for (QName qName : new XdmNode[]{_username, _password, _auth_method, _send_authorization}) {
                stringArray = this.getOption(qName);
                if (stringArray == null) continue;
                treeWriter2.addAttribute(qName, stringArray.getString());
            }
            treeWriter2.startContent();
            treeWriter2.addEndElement();
            treeWriter2.endDocument();
            pipe.write(treeWriter2.getResult());
            httpRequest.run();
            XdmNode xdmNode = S9apiUtils.getDocumentElement(pipe2.read());
            int n = Integer.parseInt(xdmNode.getAttributeValue(_status));
            treeWriter.addAttribute(_href, runtimeValue.getString());
            treeWriter.addAttribute(_status, "" + n);
            treeWriter.addAttribute(_readable, n >= 200 && n < 400 ? "true" : "false");
            treeWriter.addAttribute(_exists, n >= 400 && n < 500 ? "false" : "true");
            treeWriter.addAttribute(_uri, uRI.toASCIIString());
            for (QName qName : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                if ("Last-Modified".equals(qName.getAttributeValue(_name))) {
                    stringArray = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
                    String string = qName.getAttributeValue(_value);
                    String string2 = string.substring(5, 7);
                    String string3 = string.substring(8, 11).toUpperCase();
                    String string4 = string.substring(12, 16);
                    String string5 = string.substring(17, 25);
                    String string6 = string.substring(26, 29);
                    int n2 = 0;
                    for (n2 = 0; n2 < 12 && !stringArray[n2].equals(string3); ++n2) {
                    }
                    treeWriter.addAttribute(_last_modified, String.format("%1$04d-%2$02d-%3$02dT%4$s%5$s", Integer.parseInt(string4), n2 + 1, Integer.parseInt(string2), string5, "GMT".equals(string6) ? "Z" : ""));
                }
                if (!"Content-Length".equals(qName.getAttributeValue(_name))) continue;
                treeWriter.addAttribute(_size, qName.getAttributeValue(_value));
            }
            treeWriter.startContent();
            for (QName qName : new RelevantNodes(this.runtime, xdmNode, Axis.CHILD)) {
                treeWriter.addSubtree((XdmNode)qName);
            }
            treeWriter.addEndElement();
        }
        treeWriter.endDocument();
        this.result.write(treeWriter.getResult());
    }
}

