/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.tree.linked;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Builder;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.sort.IntHashMap;
import net.sf.saxon.om.CopyOptions;
import net.sf.saxon.om.DocumentInfo;
import net.sf.saxon.om.MutableDocumentInfo;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.iter.NodeListIterator;
import net.sf.saxon.tree.linked.AttributeImpl;
import net.sf.saxon.tree.linked.ElementImpl;
import net.sf.saxon.tree.linked.LineNumberMap;
import net.sf.saxon.tree.linked.LinkedTreeBuilder;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.tree.linked.ParentNodeImpl;
import net.sf.saxon.tree.linked.SystemIdMap;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.value.Whitespace;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class DocumentImpl
extends ParentNodeImpl
implements DocumentInfo,
MutableDocumentInfo {
    private ElementImpl documentElement;
    private HashMap<String, NodeInfo> idTable;
    private long documentNumber;
    private String baseURI;
    private HashMap<String, String[]> entityTable;
    private IntHashMap<ArrayList<NodeImpl>> elementList;
    private HashMap<String, Object> userData;
    private Configuration config;
    private LineNumberMap lineNumberMap;
    private SystemIdMap systemIdMap = new SystemIdMap();
    private boolean imaginary;

    public DocumentImpl() {
        this.setRawParent(null);
    }

    public void setConfiguration(Configuration config) {
        this.config = config;
        this.documentNumber = config.getDocumentNumberAllocator().allocateDocumentNumber();
    }

    @Override
    public Configuration getConfiguration() {
        return this.config;
    }

    @Override
    public NamePool getNamePool() {
        return this.config.getNamePool();
    }

    @Override
    public Builder newBuilder() {
        LinkedTreeBuilder builder = new LinkedTreeBuilder();
        builder.setAllocateSequenceNumbers(false);
        return builder;
    }

    public void setImaginary(boolean imaginary) {
        this.imaginary = imaginary;
    }

    public boolean isImaginary() {
        return this.imaginary;
    }

    @Override
    public long getDocumentNumber() {
        return this.documentNumber;
    }

    void setDocumentElement(ElementImpl e) {
        this.documentElement = e;
    }

    public void graftLocationMap(DocumentImpl original) {
        this.systemIdMap = original.systemIdMap;
        this.lineNumberMap = original.lineNumberMap;
    }

    @Override
    public void setSystemId(String uri) {
        if (uri == null) {
            uri = "";
        }
        this.systemIdMap.setSystemId(this.getRawSequenceNumber(), uri);
    }

    @Override
    public String getSystemId() {
        return this.systemIdMap.getSystemId(this.getRawSequenceNumber());
    }

    public void setBaseURI(String uri) {
        this.baseURI = uri;
    }

    @Override
    public String getBaseURI() {
        if (this.baseURI != null) {
            return this.baseURI;
        }
        return this.getSystemId();
    }

    void setSystemId(int seq, String uri) {
        if (uri == null) {
            uri = "";
        }
        this.systemIdMap.setSystemId(seq, uri);
    }

    String getSystemId(int seq) {
        return this.systemIdMap.getSystemId(seq);
    }

    public void setLineNumbering() {
        this.lineNumberMap = new LineNumberMap();
        this.lineNumberMap.setLineAndColumn(this.getRawSequenceNumber(), 0, -1);
    }

    void setLineAndColumn(int sequence, int line, int column) {
        if (this.lineNumberMap != null && sequence >= 0) {
            this.lineNumberMap.setLineAndColumn(sequence, line, column);
        }
    }

    int getLineNumber(int sequence) {
        if (this.lineNumberMap != null && sequence >= 0) {
            return this.lineNumberMap.getLineNumber(sequence);
        }
        return -1;
    }

    int getColumnNumber(int sequence) {
        if (this.lineNumberMap != null && sequence >= 0) {
            return this.lineNumberMap.getColumnNumber(sequence);
        }
        return -1;
    }

    @Override
    public int getLineNumber() {
        return 0;
    }

    @Override
    public final int getNodeKind() {
        return 9;
    }

    @Override
    public final NodeInfo getNextSibling() {
        return null;
    }

    @Override
    public final NodeInfo getPreviousSibling() {
        return null;
    }

    public ElementImpl getDocumentElement() {
        return this.documentElement;
    }

    @Override
    public NodeInfo getRoot() {
        return this;
    }

    @Override
    public DocumentInfo getDocumentRoot() {
        return this;
    }

    @Override
    public DocumentImpl getPhysicalRoot() {
        return this;
    }

    @Override
    public void generateId(FastStringBuffer buffer) {
        buffer.append('d');
        buffer.append(Long.toString(this.documentNumber));
    }

    AxisIterator getAllElements(int fingerprint) {
        ArrayList<NodeImpl> list;
        if (this.elementList == null) {
            this.elementList = new IntHashMap(500);
        }
        if ((list = this.elementList.get(fingerprint)) == null) {
            list = new ArrayList(500);
            for (NodeImpl next = this.getNextInDocument(this); next != null; next = next.getNextInDocument(this)) {
                if (next.getNodeKind() != 1 || next.getFingerprint() != fingerprint) continue;
                list.add(next);
            }
            this.elementList.put(fingerprint, list);
        }
        return new NodeListIterator(list);
    }

    public void deIndex(NodeImpl node) {
        if (node instanceof ElementImpl) {
            if (this.elementList != null) {
                Integer elkey = node.getFingerprint();
                ArrayList<NodeImpl> list = this.elementList.get(elkey);
                if (list == null) {
                    return;
                }
                list.remove(node);
            }
            if (node.isId()) {
                this.deregisterID(node.getStringValue());
            }
        } else if (node instanceof AttributeImpl && node.isId()) {
            this.deregisterID(node.getStringValue());
        }
    }

    private void indexIDs() {
        NodeImpl curr;
        if (this.idTable != null) {
            return;
        }
        this.idTable = new HashMap(256);
        NameChecker checker = this.getConfiguration().getNameChecker();
        DocumentImpl root = curr = this;
        while (curr != null) {
            if (curr.getNodeKind() == 1) {
                ElementImpl e = (ElementImpl)curr;
                AttributeCollectionImpl atts = (AttributeCollectionImpl)e.getAttributeList();
                for (int i = 0; i < atts.getLength(); ++i) {
                    if (atts.isDeleted(i) || !atts.isId(i) || !checker.isValidNCName(Whitespace.trim(atts.getValue(i)))) continue;
                    this.registerID(e, Whitespace.trim(atts.getValue(i)));
                }
            }
            curr = curr.getNextInDocument(root);
        }
    }

    protected void registerID(NodeInfo e, String id) {
        NodeInfo old;
        if (this.idTable == null) {
            this.idTable = new HashMap(256);
        }
        if ((old = this.idTable.get(id)) == null) {
            this.idTable.put(id, e);
        }
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        NodeInfo node;
        if (this.idTable == null) {
            this.indexIDs();
        }
        if ((node = this.idTable.get(id)) != null && getParent && node.isId() && node.getStringValue().equals(id)) {
            node = node.getParent();
        }
        return node;
    }

    protected void deregisterID(String id) {
        id = Whitespace.trim(id);
        if (this.idTable != null) {
            this.idTable.remove(id);
        }
    }

    void setUnparsedEntity(String name, String uri, String publicId) {
        if (this.entityTable == null) {
            this.entityTable = new HashMap(10);
        }
        String[] ids = new String[]{uri, publicId};
        this.entityTable.put(name, ids);
    }

    @Override
    public Iterator<String> getUnparsedEntityNames() {
        if (this.entityTable == null) {
            return Collections.EMPTY_LIST.iterator();
        }
        return this.entityTable.keySet().iterator();
    }

    @Override
    public String[] getUnparsedEntity(String name) {
        if (this.entityTable == null) {
            return null;
        }
        return this.entityTable.get(name);
    }

    @Override
    public int getTypeAnnotation() {
        if (this.documentElement == null || this.documentElement.getTypeAnnotation() == 630) {
            return 630;
        }
        return 572;
    }

    @Override
    public void copy(Receiver out, int copyOptions, int locationId) throws XPathException {
        out.startDocument(CopyOptions.getStartDocumentProperties(copyOptions));
        Iterator<String> names = this.getUnparsedEntityNames();
        while (names.hasNext()) {
            String name = names.next();
            String systemId = this.getUnparsedEntity(name)[0];
            String publicId = this.getUnparsedEntity(name)[1];
            out.setUnparsedEntity(name, systemId, publicId);
        }
        for (NodeImpl next = (NodeImpl)this.getFirstChild(); next != null; next = (NodeImpl)next.getNextSibling()) {
            next.copy(out, copyOptions, locationId);
        }
        out.endDocument();
    }

    @Override
    public void replaceStringValue(CharSequence stringValue) {
        throw new UnsupportedOperationException("Cannot replace the value of a document node");
    }

    @Override
    public void resetIndexes() {
        this.idTable = null;
        this.elementList = null;
    }

    @Override
    public void setUserData(String key, Object value) {
        if (this.userData == null) {
            this.userData = new HashMap(4);
        }
        if (value == null) {
            this.userData.remove(key);
        } else {
            this.userData.put(key, value);
        }
    }

    @Override
    public Object getUserData(String key) {
        if (this.userData == null) {
            return null;
        }
        return this.userData.get(key);
    }
}

