/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.model.yaml.internal.things;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.common.registry.AbstractProvider;
import org.openhab.core.config.core.ConfigDescription;
import org.openhab.core.config.core.ConfigDescriptionRegistry;
import org.openhab.core.config.core.ConfigUtil;
import org.openhab.core.config.core.Configuration;
import org.openhab.core.i18n.LocaleProvider;
import org.openhab.core.model.yaml.YamlModelListener;
import org.openhab.core.model.yaml.internal.things.YamlChannelDTO;
import org.openhab.core.model.yaml.internal.things.YamlThingDTO;
import org.openhab.core.service.ReadyMarker;
import org.openhab.core.service.ReadyService;
import org.openhab.core.thing.Channel;
import org.openhab.core.thing.ChannelUID;
import org.openhab.core.thing.Thing;
import org.openhab.core.thing.ThingProvider;
import org.openhab.core.thing.ThingTypeUID;
import org.openhab.core.thing.ThingUID;
import org.openhab.core.thing.binding.ThingHandlerFactory;
import org.openhab.core.thing.binding.builder.BridgeBuilder;
import org.openhab.core.thing.binding.builder.ChannelBuilder;
import org.openhab.core.thing.binding.builder.ThingBuilder;
import org.openhab.core.thing.type.AutoUpdatePolicy;
import org.openhab.core.thing.type.ChannelDefinition;
import org.openhab.core.thing.type.ChannelKind;
import org.openhab.core.thing.type.ChannelType;
import org.openhab.core.thing.type.ChannelTypeRegistry;
import org.openhab.core.thing.type.ChannelTypeUID;
import org.openhab.core.thing.type.ThingType;
import org.openhab.core.thing.type.ThingTypeRegistry;
import org.openhab.core.thing.util.ThingHelper;
import org.openhab.core.util.BundleResolver;
import org.osgi.framework.Bundle;
import org.osgi.service.component.annotations.Activate;
import org.osgi.service.component.annotations.Component;
import org.osgi.service.component.annotations.Deactivate;
import org.osgi.service.component.annotations.Reference;
import org.osgi.service.component.annotations.ReferenceCardinality;
import org.osgi.service.component.annotations.ReferencePolicy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
@Component(immediate=true, service={ThingProvider.class, YamlThingProvider.class, YamlModelListener.class})
public class YamlThingProvider
extends AbstractProvider<Thing>
implements ThingProvider,
YamlModelListener<YamlThingDTO>,
ReadyService.ReadyTracker {
    private static final String XML_THING_TYPE = "openhab.xmlThingTypes";
    private final Logger logger = LoggerFactory.getLogger(YamlThingProvider.class);
    private final BundleResolver bundleResolver;
    private final ThingTypeRegistry thingTypeRegistry;
    private final ChannelTypeRegistry channelTypeRegistry;
    private final ConfigDescriptionRegistry configDescriptionRegistry;
    private final LocaleProvider localeProvider;
    private final List<ThingHandlerFactory> thingHandlerFactories = new CopyOnWriteArrayList<ThingHandlerFactory>();
    private final Set<String> loadedXmlThingTypes = new CopyOnWriteArraySet<String>();
    private final Map<String, Collection<Thing>> thingsMap = new ConcurrentHashMap<String, Collection<Thing>>();
    private final List<QueueContent> queue = new CopyOnWriteArrayList<QueueContent>();
    private final Runnable lazyRetryRunnable = new Runnable(){

        @Override
        public void run() {
            YamlThingProvider.this.logger.debug("Starting lazy retry thread");
            while (!YamlThingProvider.this.queue.isEmpty()) {
                for (QueueContent qc : YamlThingProvider.this.queue) {
                    if (!YamlThingProvider.this.retryCreateThing(qc.thingHandlerFactory, qc.thingTypeUID, qc.configuration, qc.thingUID, qc.bridgeUID)) continue;
                    YamlThingProvider.this.queue.remove(qc);
                }
                if (YamlThingProvider.this.queue.isEmpty()) continue;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
            YamlThingProvider.this.logger.debug("Lazy retry thread ran out of work. Good bye.");
        }
    };
    private boolean modelLoaded = false;
    private @Nullable Thread lazyRetryThread;

    @Activate
    public YamlThingProvider(@Reference BundleResolver bundleResolver, @Reference ThingTypeRegistry thingTypeRegistry, @Reference ChannelTypeRegistry channelTypeRegistry, @Reference ConfigDescriptionRegistry configDescriptionRegistry, @Reference LocaleProvider localeProvider) {
        this.bundleResolver = bundleResolver;
        this.thingTypeRegistry = thingTypeRegistry;
        this.channelTypeRegistry = channelTypeRegistry;
        this.configDescriptionRegistry = configDescriptionRegistry;
        this.localeProvider = localeProvider;
    }

    @Deactivate
    public void deactivate() {
        this.queue.clear();
        this.thingsMap.clear();
        this.loadedXmlThingTypes.clear();
    }

    public Collection<Thing> getAll() {
        return this.thingsMap.values().stream().flatMap(list -> list.stream()).toList();
    }

    @Override
    public Class<YamlThingDTO> getElementClass() {
        return YamlThingDTO.class;
    }

    @Override
    public boolean isVersionSupported(int version) {
        return version >= 1;
    }

    @Override
    public boolean isDeprecated() {
        return false;
    }

    @Override
    public void addedModel(String modelName, Collection<YamlThingDTO> elements) {
        List<Thing> added = elements.stream().map(this::mapThing).filter(Objects::nonNull).toList();
        Collection modelThings = Objects.requireNonNull(this.thingsMap.computeIfAbsent(modelName, k -> new ArrayList()));
        modelThings.addAll(added);
        added.forEach(t -> {
            this.logger.debug("model {} added thing {}", (Object)modelName, (Object)t.getUID());
            this.notifyListenersAboutAddedElement(t);
        });
    }

    @Override
    public void updatedModel(String modelName, Collection<YamlThingDTO> elements) {
        List<Thing> updated = elements.stream().map(this::mapThing).filter(Objects::nonNull).toList();
        Collection modelThings = Objects.requireNonNull(this.thingsMap.computeIfAbsent(modelName, k -> new ArrayList()));
        updated.forEach(t -> modelThings.stream().filter(th -> th.getUID().equals((Object)t.getUID())).findFirst().ifPresentOrElse(oldThing -> {
            modelThings.remove(oldThing);
            modelThings.add(t);
            this.logger.debug("model {} updated thing {}", (Object)modelName, (Object)t.getUID());
            this.notifyListenersAboutUpdatedElement(oldThing, t);
        }, () -> {
            modelThings.add(t);
            this.logger.debug("model {} added thing {}", (Object)modelName, (Object)t.getUID());
            this.notifyListenersAboutAddedElement(t);
        }));
    }

    @Override
    public void removedModel(String modelName, Collection<YamlThingDTO> elements) {
        List<Thing> removed = elements.stream().map(this::mapThing).filter(Objects::nonNull).toList();
        Collection modelThings = this.thingsMap.getOrDefault(modelName, List.of());
        removed.forEach(t -> modelThings.stream().filter(th -> th.getUID().equals((Object)t.getUID())).findFirst().ifPresentOrElse(oldThing -> {
            modelThings.remove(oldThing);
            this.logger.debug("model {} removed thing {}", (Object)modelName, (Object)t.getUID());
            this.notifyListenersAboutRemovedElement(oldThing);
        }, () -> this.logger.debug("model {} thing {} not found", (Object)modelName, (Object)t.getUID())));
        if (modelThings.isEmpty()) {
            this.thingsMap.remove(modelName);
        }
    }

    @Reference(cardinality=ReferenceCardinality.MULTIPLE, policy=ReferencePolicy.DYNAMIC)
    protected void addThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.logger.debug("addThingHandlerFactory {}", (Object)thingHandlerFactory.getClass().getSimpleName());
        this.thingHandlerFactories.add(thingHandlerFactory);
        this.thingHandlerFactoryAdded(thingHandlerFactory);
    }

    protected void removeThingHandlerFactory(ThingHandlerFactory thingHandlerFactory) {
        this.thingHandlerFactories.remove(thingHandlerFactory);
    }

    @Reference
    public void setReadyService(ReadyService readyService) {
        readyService.registerTracker((ReadyService.ReadyTracker)this);
    }

    public void unsetReadyService(ReadyService readyService) {
        readyService.unregisterTracker((ReadyService.ReadyTracker)this);
    }

    public void onReadyMarkerAdded(ReadyMarker readyMarker) {
        String type = readyMarker.getType();
        if ("startlevel".equals(type)) {
            this.modelLoaded = Integer.parseInt(readyMarker.getIdentifier()) >= 20;
        } else if (XML_THING_TYPE.equals(type)) {
            String bsn = readyMarker.getIdentifier();
            this.loadedXmlThingTypes.add(bsn);
            this.thingHandlerFactories.stream().filter(factory -> bsn.equals(this.getBundleName((ThingHandlerFactory)factory))).forEach(factory -> this.thingHandlerFactoryAdded((ThingHandlerFactory)factory));
        }
    }

    public void onReadyMarkerRemoved(ReadyMarker readyMarker) {
        this.loadedXmlThingTypes.remove(readyMarker.getIdentifier());
    }

    private void thingHandlerFactoryAdded(ThingHandlerFactory handlerFactory) {
        this.logger.debug("thingHandlerFactoryAdded {} isThingHandlerFactoryReady={}", (Object)handlerFactory.getClass().getSimpleName(), (Object)this.isThingHandlerFactoryReady(handlerFactory));
        if (this.isThingHandlerFactoryReady(handlerFactory)) {
            if (!this.thingsMap.isEmpty()) {
                this.logger.debug("Refreshing models due to new thing handler factory {}", (Object)handlerFactory.getClass().getSimpleName());
                this.thingsMap.keySet().forEach(modelName -> {
                    List<Thing> things = ((Collection)this.thingsMap.getOrDefault(modelName, List.of())).stream().filter(th -> handlerFactory.supportsThingType(th.getThingTypeUID())).toList();
                    if (!things.isEmpty()) {
                        this.logger.info("Refreshing YAML model {} ({} things with {})", new Object[]{modelName, things.size(), handlerFactory.getClass().getSimpleName()});
                        things.forEach(thing -> {
                            if (!this.retryCreateThing(handlerFactory, thing.getThingTypeUID(), thing.getConfiguration(), thing.getUID(), thing.getBridgeUID())) {
                                this.logger.debug("ThingHandlerFactory '{}' claimed it can handle '{}' type but actually did not. Queued for later refresh.", (Object)handlerFactory.getClass().getSimpleName(), (Object)thing.getThingTypeUID());
                                this.queueRetryThingCreation(handlerFactory, thing.getThingTypeUID(), thing.getConfiguration(), thing.getUID(), thing.getBridgeUID());
                            }
                        });
                    } else {
                        this.logger.debug("No refresh needed from YAML model {}", modelName);
                    }
                });
            } else {
                this.logger.debug("No things yet loaded; no need to trigger a refresh due to new thing handler factory");
            }
        }
    }

    private boolean retryCreateThing(ThingHandlerFactory handlerFactory, ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, @Nullable ThingUID bridgeUID) {
        this.logger.trace("Retry creating thing {}", (Object)thingUID);
        Thing newThing = handlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
        if (newThing != null) {
            this.logger.debug("Successfully loaded thing '{}' during retry", (Object)thingUID);
            Thing oldThing = null;
            for (Collection<Thing> modelThings : this.thingsMap.values()) {
                oldThing = modelThings.stream().filter(t -> t.getUID().equals((Object)newThing.getUID())).findFirst().orElse(null);
                if (oldThing == null) continue;
                this.mergeThing(newThing, oldThing);
                modelThings.remove(oldThing);
                modelThings.add(newThing);
                this.logger.debug("Refreshing thing '{}' after successful retry", (Object)newThing.getUID());
                if (ThingHelper.equals((Thing)oldThing, (Thing)newThing)) break;
                this.notifyListenersAboutUpdatedElement(oldThing, newThing);
                break;
            }
            if (oldThing == null) {
                this.logger.debug("Refreshing thing '{}' after retry failed because thing is not found", (Object)newThing.getUID());
            }
        }
        return newThing != null;
    }

    private boolean isThingHandlerFactoryReady(ThingHandlerFactory thingHandlerFactory) {
        String bundleName = this.getBundleName(thingHandlerFactory);
        return bundleName != null && this.loadedXmlThingTypes.contains(bundleName);
    }

    private @Nullable String getBundleName(ThingHandlerFactory thingHandlerFactory) {
        Bundle bundle = this.bundleResolver.resolveBundle(thingHandlerFactory.getClass());
        return bundle == null ? null : bundle.getSymbolicName();
    }

    private @Nullable Thing mapThing(YamlThingDTO thingDto) {
        BridgeBuilder thingBuilder;
        ThingUID thingUID = new ThingUID(thingDto.uid);
        String[] segments = thingUID.getAsString().split(":");
        ThingTypeUID thingTypeUID = new ThingTypeUID(thingUID.getBindingId(), segments[1]);
        ThingType thingType = this.thingTypeRegistry.getThingType(thingTypeUID, this.localeProvider.getLocale());
        ThingUID bridgeUID = thingDto.bridge != null ? new ThingUID(thingDto.bridge) : null;
        Configuration configuration = new Configuration(thingDto.config);
        Object object = thingBuilder = thingDto.isBridge() ? BridgeBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID) : ThingBuilder.create((ThingTypeUID)thingTypeUID, (ThingUID)thingUID);
        thingBuilder.withLabel(thingDto.label != null ? thingDto.label : (thingType != null ? thingType.getLabel() : null));
        thingBuilder.withLocation(thingDto.location);
        thingBuilder.withBridge(bridgeUID);
        thingBuilder.withConfiguration(configuration);
        List<Channel> channels = this.createChannels(thingTypeUID, thingUID, thingDto.channels != null ? thingDto.channels : Map.of(), thingType != null ? thingType.getChannelDefinitions() : List.of());
        thingBuilder.withChannels(channels);
        Thing thing = thingBuilder.build();
        Thing thingFromHandler = null;
        ThingHandlerFactory handlerFactory = this.thingHandlerFactories.stream().filter(thf -> this.isThingHandlerFactoryReady((ThingHandlerFactory)thf) && thf.supportsThingType(thingTypeUID)).findFirst().orElse(null);
        if (handlerFactory != null) {
            thingFromHandler = handlerFactory.createThing(thingTypeUID, configuration, thingUID, bridgeUID);
            if (thingFromHandler != null) {
                this.mergeThing(thingFromHandler, thing);
                this.logger.debug("Successfully loaded thing '{}'", (Object)thingUID);
            } else {
                this.logger.debug("ThingHandlerFactory '{}' claimed it can handle '{}' type but actually did not. Queued for later refresh.", (Object)handlerFactory.getClass().getSimpleName(), (Object)thingTypeUID);
                this.queueRetryThingCreation(handlerFactory, thingTypeUID, configuration, thingUID, bridgeUID);
            }
        }
        return thingFromHandler != null ? thingFromHandler : thing;
    }

    private List<Channel> createChannels(ThingTypeUID thingTypeUID, ThingUID thingUID, Map<String, YamlChannelDTO> channelsDto, List<ChannelDefinition> channelDefinitions) {
        HashSet addedChannelIds = new HashSet();
        ArrayList<Channel> channels = new ArrayList<Channel>();
        channelsDto.forEach((channelId, channelDto) -> {
            ChannelTypeUID channelTypeUID = channelDto.type == null ? null : new ChannelTypeUID(thingUID.getBindingId(), channelDto.type);
            Channel channel = this.createChannel(thingUID, (String)channelId, channelTypeUID, channelDto.getKind(), channelDto.getItemType(), channelDto.label, channelDto.description, null, new Configuration(channelDto.config), true);
            channels.add(channel);
            addedChannelIds.add(channelId);
        });
        channelDefinitions.forEach(channelDef -> {
            String id = channelDef.getId();
            if (addedChannelIds.add(id)) {
                ChannelType channelType = this.channelTypeRegistry.getChannelType(channelDef.getChannelTypeUID(), this.localeProvider.getLocale());
                if (channelType != null) {
                    Channel channel = ChannelBuilder.create((ChannelUID)new ChannelUID(thingUID, id), (String)channelType.getItemType()).withType(channelDef.getChannelTypeUID()).withAutoUpdatePolicy(channelType.getAutoUpdatePolicy()).build();
                    channels.add(channel);
                } else {
                    this.logger.warn("Could not create channel '{}' for thing '{}', because channel type '{}' could not be found.", new Object[]{id, thingUID, channelDef.getChannelTypeUID()});
                }
            }
        });
        return channels;
    }

    private Channel createChannel(ThingUID thingUID, String channelId, @Nullable ChannelTypeUID channelTypeUID, ChannelKind channelKind, @Nullable String channelItemType, @Nullable String channelLabel, @Nullable String channelDescription, @Nullable AutoUpdatePolicy channelAutoUpdatePolicy, Configuration channelConfiguration, boolean ignoreMissingChannelType) {
        ChannelKind kind = channelKind;
        String itemType = channelItemType;
        String label = channelLabel;
        String description = channelDescription;
        AutoUpdatePolicy autoUpdatePolicy = channelAutoUpdatePolicy;
        Configuration configuration = new Configuration(channelConfiguration);
        if (channelTypeUID != null) {
            ChannelType channelType = this.channelTypeRegistry.getChannelType(channelTypeUID, this.localeProvider.getLocale());
            if (channelType != null) {
                kind = channelType.getKind();
                itemType = channelType.getItemType();
                if (label == null) {
                    label = channelType.getLabel();
                }
                if (description == null) {
                    description = channelType.getDescription();
                }
                autoUpdatePolicy = channelType.getAutoUpdatePolicy();
                URI descUriO = channelType.getConfigDescriptionURI();
                if (descUriO != null) {
                    ConfigUtil.applyDefaultConfiguration((Configuration)configuration, (ConfigDescription)this.configDescriptionRegistry.getConfigDescription(descUriO));
                }
            } else if (!ignoreMissingChannelType) {
                this.logger.warn("Channel type {} could not be found for thing '{}'.", (Object)channelTypeUID, (Object)thingUID);
            }
        }
        ChannelBuilder builder = ChannelBuilder.create((ChannelUID)new ChannelUID(thingUID, channelId), (String)itemType).withKind(kind).withConfiguration(configuration).withType(channelTypeUID).withAutoUpdatePolicy(autoUpdatePolicy);
        if (label != null) {
            builder.withLabel(label);
        }
        if (description != null) {
            builder.withDescription(description);
        }
        return builder.build();
    }

    private void mergeThing(Thing target, Thing source) {
        String label = source.getLabel();
        if (label == null) {
            ThingType thingType = this.thingTypeRegistry.getThingType(target.getThingTypeUID(), this.localeProvider.getLocale());
            label = thingType != null ? thingType.getLabel() : null;
        }
        target.setLabel(label);
        target.setLocation(source.getLocation());
        target.setBridgeUID(source.getBridgeUID());
        source.getConfiguration().keySet().forEach(paramName -> target.getConfiguration().put(paramName, source.getConfiguration().get(paramName)));
        ArrayList channelsToAdd = new ArrayList();
        source.getChannels().forEach(channel -> {
            Channel targetChannel = target.getChannels().stream().filter(c -> c.getUID().equals((Object)channel.getUID())).findFirst().orElse(null);
            if (targetChannel != null) {
                channel.getConfiguration().keySet().forEach(paramName -> targetChannel.getConfiguration().put(paramName, channel.getConfiguration().get(paramName)));
            } else {
                Channel newChannel = channel;
                if (channel.getChannelTypeUID() != null) {
                    newChannel = this.createChannel(target.getUID(), channel.getUID().getIdWithoutGroup(), channel.getChannelTypeUID(), channel.getKind(), channel.getAcceptedItemType(), channel.getLabel(), channel.getDescription(), channel.getAutoUpdatePolicy(), channel.getConfiguration(), false);
                }
                channelsToAdd.add(newChannel);
            }
        });
        ThingHelper.addChannelsToThing((Thing)target, channelsToAdd);
    }

    private void queueRetryThingCreation(ThingHandlerFactory handlerFactory, ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, @Nullable ThingUID bridgeUID) {
        this.queue.add(new QueueContent(handlerFactory, thingTypeUID, configuration, thingUID, bridgeUID));
        Thread thread = this.lazyRetryThread;
        if (thread == null || !thread.isAlive()) {
            this.lazyRetryThread = thread = new Thread(this.lazyRetryRunnable);
            thread.start();
        }
    }

    private record QueueContent(ThingHandlerFactory thingHandlerFactory, ThingTypeUID thingTypeUID, Configuration configuration, ThingUID thingUID, @Nullable ThingUID bridgeUID) {
    }
}

