// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigLocationSlice(dest, src []*otlpprofiles.Location) []*otlpprofiles.Location {
	var newDest []*otlpprofiles.Location
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Location, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLocation()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigLocation(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLocation()
		}
	}
	for i := range src {
		CopyOrigLocation(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestLocationSlice() []*otlpprofiles.Location {
	orig := make([]*otlpprofiles.Location, 5)
	orig[0] = NewOrigLocation()
	orig[1] = GenTestOrigLocation()
	orig[2] = NewOrigLocation()
	orig[3] = GenTestOrigLocation()
	orig[4] = NewOrigLocation()
	return orig
}
