// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
)

func CopyOrigLineSlice(dest, src []*otlpprofiles.Line) []*otlpprofiles.Line {
	var newDest []*otlpprofiles.Line
	if cap(dest) < len(src) {
		newDest = make([]*otlpprofiles.Line, len(src))
		// Copy old pointers to re-use.
		copy(newDest, dest)
		// Add new pointers for missing elements from len(dest) to len(srt).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLine()
		}
	} else {
		newDest = dest[:len(src)]
		// Cleanup the rest of the elements so GC can free the memory.
		// This can happen when len(src) < len(dest) < cap(dest).
		for i := len(src); i < len(dest); i++ {
			DeleteOrigLine(dest[i], true)
			dest[i] = nil
		}
		// Add new pointers for missing elements.
		// This can happen when len(dest) < len(src) < cap(dest).
		for i := len(dest); i < len(src); i++ {
			newDest[i] = NewOrigLine()
		}
	}
	for i := range src {
		CopyOrigLine(newDest[i], src[i])
	}
	return newDest
}

func GenerateOrigTestLineSlice() []*otlpprofiles.Line {
	orig := make([]*otlpprofiles.Line, 5)
	orig[0] = NewOrigLine()
	orig[1] = GenTestOrigLine()
	orig[2] = NewOrigLine()
	orig[3] = GenTestOrigLine()
	orig[4] = NewOrigLine()
	return orig
}
