/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts.config;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.apache.commons.beanutils.ConvertUtils;

public class FormPropertyConfig
implements Serializable {
    protected boolean configured = false;
    protected String initial = null;
    protected String name = null;
    protected int size = 0;
    protected String type = null;

    public FormPropertyConfig() {
    }

    public FormPropertyConfig(String name, String type, String initial) {
        this(name, type, initial, 0);
    }

    public FormPropertyConfig(String name, String type, String initial, int size) {
        this.setName(name);
        this.setType(type);
        this.setInitial(initial);
        this.setSize(size);
    }

    public String getInitial() {
        return this.initial;
    }

    public void setInitial(String initial) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.initial = initial;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.name = name;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        if (size < 0) {
            throw new IllegalArgumentException("size < 0");
        }
        this.size = size;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        if (this.configured) {
            throw new IllegalStateException("Configuration is frozen");
        }
        this.type = type;
    }

    public Class getTypeClass() {
        String baseType = this.getType();
        boolean indexed = false;
        if (baseType.endsWith("[]")) {
            baseType = baseType.substring(0, baseType.length() - 2);
            indexed = true;
        }
        Class<Comparable<Boolean>> baseClass = null;
        if ("boolean".equals(baseType)) {
            baseClass = Boolean.TYPE;
        } else if ("byte".equals(baseType)) {
            baseClass = Byte.TYPE;
        } else if ("char".equals(baseType)) {
            baseClass = Character.TYPE;
        } else if ("double".equals(baseType)) {
            baseClass = Double.TYPE;
        } else if ("float".equals(baseType)) {
            baseClass = Float.TYPE;
        } else if ("int".equals(baseType)) {
            baseClass = Integer.TYPE;
        } else if ("long".equals(baseType)) {
            baseClass = Long.TYPE;
        } else if ("short".equals(baseType)) {
            baseClass = Short.TYPE;
        } else {
            ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            try {
                baseClass = classLoader.loadClass(baseType);
            }
            catch (Throwable t) {
                baseClass = null;
            }
        }
        if (indexed) {
            return Array.newInstance(baseClass, 0).getClass();
        }
        return baseClass;
    }

    public Object initial() {
        Object initialValue;
        block7: {
            initialValue = null;
            try {
                Class clazz = this.getTypeClass();
                if (clazz.isArray()) {
                    if (this.initial != null) {
                        initialValue = ConvertUtils.convert((String)this.initial, (Class)clazz);
                        break block7;
                    }
                    initialValue = Array.newInstance(clazz.getComponentType(), this.size);
                    int i = 0;
                    while (i < this.size) {
                        try {
                            Array.set(initialValue, i, clazz.getComponentType().newInstance());
                        }
                        catch (Throwable t) {
                            // empty catch block
                        }
                        ++i;
                    }
                    break block7;
                }
                initialValue = this.initial != null ? ConvertUtils.convert((String)this.initial, (Class)clazz) : (Object)clazz.newInstance();
            }
            catch (Throwable t) {
                initialValue = null;
            }
        }
        return initialValue;
    }

    public void freeze() {
        this.configured = true;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("FormPropertyConfig[");
        sb.append("name=");
        sb.append(this.name);
        sb.append(",type=");
        sb.append(this.type);
        sb.append(",initial=");
        sb.append(this.initial);
        sb.append("]");
        return sb.toString();
    }
}

