/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.util;

import java.beans.Introspector;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.MetaClass;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.PropertyAccessException;
import net.sf.hibernate.PropertyNotFoundException;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class ReflectHelper {
    private static final Log log;
    private static final Class[] NO_CLASSES;
    private static final Class[] OBJECT;
    private static final Method OBJECT_EQUALS;
    static /* synthetic */ Class class$net$sf$hibernate$util$ReflectHelper;
    static /* synthetic */ Class class$java$lang$Object;

    public static boolean overridesEquals(Class clazz) {
        Method equals;
        try {
            equals = clazz.getMethod("equals", OBJECT);
        }
        catch (NoSuchMethodException nsme) {
            return false;
        }
        return !OBJECT_EQUALS.equals(equals);
    }

    public static Setter getSetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Setter result = ReflectHelper.getSetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find a setter for property " + propertyName + " in class " + theClass.getName());
        }
        return result;
    }

    private static Setter getSetterOrNull(Class theClass, String propertyName) {
        if (theClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object) || theClass == null) {
            return null;
        }
        Method method = ReflectHelper.setterMethod(theClass, propertyName);
        if (method != null) {
            if (!ReflectHelper.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            return new Setter(theClass, method, propertyName);
        }
        Setter setter = ReflectHelper.getSetterOrNull(theClass.getSuperclass(), propertyName);
        if (setter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            int i = 0;
            while (setter == null && i < interfaces.length) {
                setter = ReflectHelper.getSetterOrNull(interfaces[i], propertyName);
                ++i;
            }
        }
        return setter;
    }

    private static Method setterMethod(Class theClass, String propertyName) {
        Getter getter = ReflectHelper.getGetterOrNull(theClass, propertyName);
        Class returnType = getter == null ? null : getter.getReturnType();
        Method[] methods = theClass.getDeclaredMethods();
        Method potentialSetter = null;
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("set")) {
                String testStdMethod = Introspector.decapitalize(methods[i].getName().substring(3));
                String testOldMethod = methods[i].getName().substring(3);
                if ((testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) && methods[i].getParameterTypes().length == 1) {
                    potentialSetter = methods[i];
                    if (returnType == null || methods[i].getParameterTypes()[0].equals(returnType)) {
                        return potentialSetter;
                    }
                }
            }
            ++i;
        }
        return potentialSetter;
    }

    public static Getter getGetter(Class theClass, String propertyName) throws PropertyNotFoundException {
        Getter result = ReflectHelper.getGetterOrNull(theClass, propertyName);
        if (result == null) {
            throw new PropertyNotFoundException("Could not find a getter for " + propertyName + " in class " + theClass.getName());
        }
        return result;
    }

    private static Getter getGetterOrNull(Class theClass, String propertyName) {
        if (theClass == (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object) || theClass == null) {
            return null;
        }
        Method method = ReflectHelper.getterMethod(theClass, propertyName);
        if (method != null) {
            if (!ReflectHelper.isPublic(theClass, method)) {
                method.setAccessible(true);
            }
            return new Getter(theClass, method, propertyName);
        }
        Getter getter = ReflectHelper.getGetterOrNull(theClass.getSuperclass(), propertyName);
        if (getter == null) {
            Class<?>[] interfaces = theClass.getInterfaces();
            int i = 0;
            while (getter == null && i < interfaces.length) {
                getter = ReflectHelper.getGetterOrNull(interfaces[i], propertyName);
                ++i;
            }
        }
        return getter;
    }

    private static Method getterMethod(Class theClass, String propertyName) {
        Method[] methods = theClass.getDeclaredMethods();
        int i = 0;
        while (i < methods.length) {
            if (methods[i].getParameterTypes().length == 0) {
                String testOldMethod;
                String testStdMethod;
                if (methods[i].getName().length() > 3 && methods[i].getName().startsWith("get")) {
                    testStdMethod = Introspector.decapitalize(methods[i].getName().substring(3));
                    testOldMethod = methods[i].getName().substring(3);
                    if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                        return methods[i];
                    }
                }
                if (methods[i].getName().length() > 2 && methods[i].getName().startsWith("is")) {
                    testStdMethod = Introspector.decapitalize(methods[i].getName().substring(2));
                    testOldMethod = methods[i].getName().substring(2);
                    if (testStdMethod.equals(propertyName) || testOldMethod.equals(propertyName)) {
                        return methods[i];
                    }
                }
            }
            ++i;
        }
        return null;
    }

    public static Type reflectedPropertyType(Class theClass, String name) throws MappingException {
        return TypeFactory.hueristicType(ReflectHelper.getGetter(theClass, name).getReturnType().getName());
    }

    public static Class classForName(String name) throws ClassNotFoundException {
        try {
            return Thread.currentThread().getContextClassLoader().loadClass(name);
        }
        catch (Exception e) {
            return Class.forName(name);
        }
    }

    public static boolean isPublic(Class clazz, Member member) {
        return Modifier.isPublic(member.getModifiers()) && Modifier.isPublic(clazz.getModifiers());
    }

    public static Object getConstantValue(String name) {
        Class clazz;
        try {
            clazz = ReflectHelper.classForName(StringHelper.qualifier(name));
        }
        catch (ClassNotFoundException cnfe) {
            return null;
        }
        try {
            return clazz.getField(StringHelper.unqualify(name)).get(null);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Constructor getDefaultConstructor(Class clazz) throws PropertyNotFoundException {
        if (ReflectHelper.isAbstractClass(clazz)) {
            return null;
        }
        try {
            Constructor constructor = clazz.getDeclaredConstructor(NO_CLASSES);
            if (!ReflectHelper.isPublic(clazz, constructor)) {
                constructor.setAccessible(true);
            }
            return constructor;
        }
        catch (NoSuchMethodException nme) {
            throw new PropertyNotFoundException("Object class " + clazz.getName() + " must declare a default (no-argument) constructor");
        }
    }

    public static boolean isAbstractClass(Class clazz) {
        int modifier = clazz.getModifiers();
        return Modifier.isAbstract(modifier) || Modifier.isInterface(modifier);
    }

    public static MetaClass getMetaClass(Class clazz, String[] getterNames, String[] setterNames, Class[] types) {
        try {
            MetaClass optimizer = MetaClass.getInstance((ClassLoader)clazz.getClassLoader(), (Class)clazz, (String[])getterNames, (String[])setterNames, (Class[])types);
            optimizer.setPropertyValues(optimizer.newInstance(), optimizer.getPropertyValues(optimizer.newInstance()));
            return optimizer;
        }
        catch (Throwable t) {
            log.info((Object)("reflection optimizer disabled for: " + clazz.getName() + ", " + StringHelper.unqualify(t.getClass().getName()) + ": " + t.getMessage()));
            return null;
        }
    }

    private ReflectHelper() {
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method eq;
        log = LogFactory.getLog((Class)(class$net$sf$hibernate$util$ReflectHelper == null ? (class$net$sf$hibernate$util$ReflectHelper = ReflectHelper.class$("net.sf.hibernate.util.ReflectHelper")) : class$net$sf$hibernate$util$ReflectHelper));
        NO_CLASSES = new Class[0];
        OBJECT = new Class[]{class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object};
        try {
            eq = (class$java$lang$Object == null ? (class$java$lang$Object = ReflectHelper.class$("java.lang.Object")) : class$java$lang$Object).getMethod("equals", OBJECT);
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not find Object.equals()", e);
        }
        OBJECT_EQUALS = eq;
    }

    public static final class Getter {
        private Class clazz;
        private final Method method;
        private final String propertyName;

        private Getter(Class clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public Object get(Object target) throws HibernateException {
            try {
                return this.method.invoke(target, null);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", false, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", false, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("IllegalArgumentException in class: " + this.clazz.getName() + ", getter method of property: " + this.propertyName));
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred calling", false, this.clazz, this.propertyName);
            }
        }

        public Class getReturnType() {
            return this.method.getReturnType();
        }

        public Method getMethod() {
            return this.method;
        }
    }

    public static final class Setter {
        private Class clazz;
        private final Method method;
        private final String propertyName;

        private Setter(Class clazz, Method method, String propertyName) {
            this.clazz = clazz;
            this.method = method;
            this.propertyName = propertyName;
        }

        public void set(Object target, Object value) throws HibernateException {
            try {
                this.method.invoke(target, value);
            }
            catch (NullPointerException npe) {
                if (value == null && this.method.getParameterTypes()[0].isPrimitive()) {
                    throw new PropertyAccessException(npe, "Null value was assigned to a property of primitive type", true, this.clazz, this.propertyName);
                }
                throw new PropertyAccessException(npe, "NullPointerException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (InvocationTargetException ite) {
                throw new PropertyAccessException(ite, "Exception occurred inside", true, this.clazz, this.propertyName);
            }
            catch (IllegalAccessException iae) {
                throw new PropertyAccessException(iae, "IllegalAccessException occurred while calling", true, this.clazz, this.propertyName);
            }
            catch (IllegalArgumentException iae) {
                log.error((Object)("IllegalArgumentException in class: " + this.clazz.getName() + ", setter method of property: " + this.propertyName));
                log.error((Object)("expected type: " + this.method.getParameterTypes()[0].getName() + ", actual value: " + (value == null ? null : value.getClass().getName())));
                throw new PropertyAccessException(iae, "IllegalArgumentException occurred while calling", true, this.clazz, this.propertyName);
            }
        }

        public Method getMethod() {
            return this.method;
        }
    }
}

