/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.sql;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.sql.Alias;

public class SelectFragment {
    private String suffix;
    private List columns = new ArrayList();
    private List aliases = new ArrayList();
    private List columnAliases = new ArrayList();

    public SelectFragment setSuffix(String suffix) {
        this.suffix = suffix;
        return this;
    }

    public SelectFragment addColumn(String columnName) {
        this.addColumn(null, columnName);
        return this;
    }

    public SelectFragment addColumns(String[] columnNames) {
        int i = 0;
        while (i < columnNames.length) {
            this.addColumn(columnNames[i]);
            ++i;
        }
        return this;
    }

    public SelectFragment addColumn(String tableAlias, String columnName) {
        return this.addColumn(tableAlias, columnName, columnName);
    }

    public SelectFragment addColumn(String tableAlias, String columnName, String columnAlias) {
        this.columns.add(columnName);
        this.aliases.add(tableAlias);
        this.columnAliases.add(columnAlias);
        return this;
    }

    public SelectFragment addColumns(String tableAlias, String[] columnNames) {
        int i = 0;
        while (i < columnNames.length) {
            this.addColumn(tableAlias, columnNames[i]);
            ++i;
        }
        return this;
    }

    public SelectFragment addColumns(String tableAlias, String[] columnNames, String[] columnAliases) {
        int i = 0;
        while (i < columnNames.length) {
            this.addColumn(tableAlias, columnNames[i], columnAliases[i]);
            ++i;
        }
        return this;
    }

    public String toFragmentString() {
        StringBuffer buf = new StringBuffer(this.columns.size() * 10);
        Iterator iter = this.columns.iterator();
        Iterator aliasIter = this.aliases.iterator();
        Iterator columnAliasIter = this.columnAliases.iterator();
        HashMap<String, String> columnsUnique = new HashMap<String, String>();
        while (iter.hasNext()) {
            String qualifiedColumn;
            String otherAlias;
            String column = (String)iter.next();
            String alias = (String)aliasIter.next();
            String columnAlias = (String)columnAliasIter.next();
            if (columnAlias.equals(otherAlias = columnsUnique.put(qualifiedColumn = alias == null ? column : alias + '.' + column, columnAlias))) continue;
            buf.append(", ").append(qualifiedColumn).append(" as ").append(new Alias(this.suffix).toAliasString(columnAlias));
        }
        return buf.toString();
    }
}

