/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.mapping;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.mapping.Association;
import net.sf.hibernate.mapping.Table;
import net.sf.hibernate.mapping.Value;
import net.sf.hibernate.type.AssociationType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.ReflectHelper;

public class OneToOne
extends Association {
    private boolean constrained;
    private AssociationType.ForeignKeyType foreignKeyType;
    private Value identifier;

    public OneToOne(Table table, Value identifier) throws MappingException {
        super(table);
        this.identifier = identifier;
    }

    public void setTypeByReflection(Class propertyClass, String propertyName) throws MappingException {
        try {
            if (this.getType() == null) {
                this.setType(TypeFactory.oneToOne(ReflectHelper.getGetter(propertyClass, propertyName).getReturnType(), this.foreignKeyType));
            }
        }
        catch (HibernateException he) {
            throw new MappingException("Problem trying to set association type by reflection", (Throwable)((Object)he));
        }
    }

    public void createForeignKey() {
        if (this.constrained) {
            this.createForeignKeyOfClass(((EntityType)this.getType()).getPersistentClass());
        }
    }

    public List getConstraintColumns() {
        ArrayList list = new ArrayList();
        Iterator iter = this.identifier.getColumnIterator();
        while (iter.hasNext()) {
            list.add(iter.next());
        }
        return list;
    }

    public boolean isConstrained() {
        return this.constrained;
    }

    public AssociationType.ForeignKeyType getForeignKeyType() {
        return this.foreignKeyType;
    }

    public Value getIdentifier() {
        return this.identifier;
    }

    public void setConstrained(boolean constrained) {
        this.constrained = constrained;
    }

    public void setForeignKeyType(AssociationType.ForeignKeyType foreignKeyType) {
        this.foreignKeyType = foreignKeyType;
    }

    public void setIdentifier(Value identifier) {
        this.identifier = identifier;
    }
}

