/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Criteria;
import net.sf.hibernate.FlushMode;
import net.sf.hibernate.Hibernate;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.Lifecycle;
import net.sf.hibernate.LockMode;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.ObjectDeletedException;
import net.sf.hibernate.ObjectNotFoundException;
import net.sf.hibernate.PersistentObjectException;
import net.sf.hibernate.Query;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.ScrollableResults;
import net.sf.hibernate.Transaction;
import net.sf.hibernate.TransientObjectException;
import net.sf.hibernate.Validatable;
import net.sf.hibernate.cache.CacheException;
import net.sf.hibernate.collection.ArrayHolder;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.collection.PersistentCollection;
import net.sf.hibernate.engine.Batcher;
import net.sf.hibernate.engine.Cascades;
import net.sf.hibernate.engine.CollectionSnapshot;
import net.sf.hibernate.engine.Key;
import net.sf.hibernate.engine.RowSelection;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.SessionImplementor;
import net.sf.hibernate.engine.Versioning;
import net.sf.hibernate.hql.FilterTranslator;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.id.IdentifierGeneratorFactory;
import net.sf.hibernate.impl.BatchingBatcher;
import net.sf.hibernate.impl.CacheEntry;
import net.sf.hibernate.impl.CriteriaImpl;
import net.sf.hibernate.impl.FilterImpl;
import net.sf.hibernate.impl.MessageHelper;
import net.sf.hibernate.impl.NonBatchingBatcher;
import net.sf.hibernate.impl.QueryImpl;
import net.sf.hibernate.impl.ScheduledCollectionRecreate;
import net.sf.hibernate.impl.ScheduledCollectionRemove;
import net.sf.hibernate.impl.ScheduledCollectionUpdate;
import net.sf.hibernate.impl.ScheduledDeletion;
import net.sf.hibernate.impl.ScheduledInsertion;
import net.sf.hibernate.impl.ScheduledUpdate;
import net.sf.hibernate.impl.SessionFactoryImpl;
import net.sf.hibernate.loader.CriteriaLoader;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.Loadable;
import net.sf.hibernate.proxy.CGLIBLazyInitializer;
import net.sf.hibernate.proxy.HibernateProxy;
import net.sf.hibernate.proxy.HibernateProxyHelper;
import net.sf.hibernate.proxy.LazyInitializer;
import net.sf.hibernate.type.AbstractComponentType;
import net.sf.hibernate.type.EntityType;
import net.sf.hibernate.type.PersistentCollectionType;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.type.TypeFactory;
import net.sf.hibernate.util.IdentityMap;
import net.sf.hibernate.util.JoinedIterator;
import net.sf.hibernate.util.StringHelper;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionImpl
implements SessionImplementor {
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$SessionImpl == null ? (class$net$sf$hibernate$impl$SessionImpl = SessionImpl.class$("net.sf.hibernate.impl.SessionImpl")) : class$net$sf$hibernate$impl$SessionImpl));
    private SessionFactoryImpl factory;
    private final boolean autoClose;
    private final long timestamp;
    private boolean closed = false;
    private FlushMode flushMode = FlushMode.AUTO;
    private boolean callAfterTransactionCompletionFromDisconnect = true;
    private final Map entitiesByKey;
    private final Map proxiesByKey;
    private transient Map entries;
    private transient Map arrayHolders;
    private transient Map collections;
    private Set nullifiables = new HashSet();
    private Interceptor interceptor;
    private transient Connection connection;
    private transient boolean connect;
    private transient ArrayList insertions;
    private transient ArrayList deletions;
    private transient Map updates;
    private transient ArrayList collectionCreations;
    private transient ArrayList collectionUpdates;
    private transient ArrayList collectionRemovals;
    private transient ArrayList executions;
    private transient int dontFlushFromFind = 0;
    private transient int cascading = 0;
    private transient Batcher batcher;
    private static final Status LOADED = new Status("LOADED");
    private static final Status DELETED = new Status("DELETED");
    private static final Status GONE = new Status("GONE");
    private static final Status LOADING = new Status("LOADING");
    private static final Status SAVING = new Status("SAVING");
    private static final Object[] NO_ARGS = new Object[0];
    private static final Type[] NO_TYPES = new Type[0];
    private transient Class lastClass;
    private transient ClassPersister lastResultForClass;
    private Map loadingCollections = new HashMap();
    private String loadingRole;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionImpl;

    private void readObject(ObjectInputStream ois) throws IOException, ClassNotFoundException {
        Object e;
        log.trace((Object)"deserializing session");
        ois.defaultReadObject();
        this.entries = IdentityMap.deserialize(ois.readObject());
        this.collections = IdentityMap.deserialize(ois.readObject());
        this.arrayHolders = IdentityMap.deserialize(ois.readObject());
        this.initTransientCollections();
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            try {
                e = iter.next();
                ((PersistentCollection)e.getKey()).setSession(this);
                CollectionEntry ce = (CollectionEntry)e.getValue();
                ce.setLoadedPersister(this.factory.getCollectionPersister(ce.getRole()));
            }
            catch (HibernateException he) {
                throw new InvalidObjectException(he.getMessage());
            }
        }
        iter = this.proxiesByKey.values().iterator();
        while (iter.hasNext()) {
            Map.Entry proxy = iter.next();
            if (proxy instanceof HibernateProxy) {
                HibernateProxyHelper.getLazyInitializer((HibernateProxy)((Object)proxy)).setSession(this);
                continue;
            }
            iter.remove();
        }
        iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            e = (EntityEntry)iter.next().getValue();
            try {
                ((EntityEntry)e).persister = this.factory.getPersister(((EntityEntry)e).className);
            }
            catch (MappingException me) {
                throw new InvalidObjectException(me.getMessage());
            }
        }
    }

    private void writeObject(ObjectOutputStream oos) throws IOException {
        if (this.isConnected()) {
            throw new IllegalStateException("Cannot serialize a Session while connected");
        }
        if (this.insertions.size() != 0 || this.deletions.size() != 0) {
            throw new IllegalStateException("Cannot serialize a Session which has work waiting to be flushed");
        }
        log.trace((Object)"serializing session");
        oos.defaultWriteObject();
        oos.writeObject(IdentityMap.serialize(this.entries));
        oos.writeObject(IdentityMap.serialize(this.collections));
        oos.writeObject(IdentityMap.serialize(this.arrayHolders));
    }

    SessionImpl(Connection connection, SessionFactoryImpl factory, boolean autoclose, long timestamp, Interceptor interceptor) {
        this.connection = connection;
        this.connect = connection == null;
        this.interceptor = interceptor;
        this.autoClose = autoclose;
        this.timestamp = timestamp;
        this.factory = factory;
        this.entitiesByKey = new HashMap(50);
        this.proxiesByKey = new HashMap(10);
        this.entries = IdentityMap.instantiate();
        this.collections = IdentityMap.instantiate();
        this.arrayHolders = IdentityMap.instantiate();
        this.initTransientCollections();
        log.debug((Object)"opened session");
    }

    public Batcher getBatcher() {
        if (this.batcher == null) {
            this.batcher = this.factory.useJdbcBatch() ? new BatchingBatcher(this) : new NonBatchingBatcher(this);
        }
        return this.batcher;
    }

    public SessionFactoryImplementor getFactory() {
        return this.factory;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection close() throws HibernateException {
        log.trace((Object)"closing session");
        try {
            Connection connection = this.connection == null ? null : this.disconnect();
            Object var3_2 = null;
            this.cleanup();
            return connection;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.cleanup();
            throw throwable;
        }
    }

    public void afterTransactionCompletion() {
        log.trace((Object)"transaction completion");
        Iterator<Object> iter = this.entries.values().iterator();
        while (iter.hasNext()) {
            ((EntityEntry)iter.next()).lockMode = LockMode.NONE;
        }
        iter = this.executions.iterator();
        while (iter.hasNext()) {
            try {
                ((Executable)iter.next()).afterTransactionCompletion();
            }
            catch (CacheException ce) {
                log.error((Object)"could not release a cache lock", (Throwable)((Object)ce));
            }
            catch (Exception e) {
                throw new AssertionFailure("Exception releasing cache locks", e);
            }
        }
        this.executions.clear();
        this.callAfterTransactionCompletionFromDisconnect = true;
    }

    private void initTransientCollections() {
        this.insertions = new ArrayList(20);
        this.deletions = new ArrayList(20);
        this.updates = new HashMap(20);
        this.collectionCreations = new ArrayList(20);
        this.collectionRemovals = new ArrayList(20);
        this.collectionUpdates = new ArrayList(20);
        this.executions = new ArrayList(50);
    }

    private void cleanup() {
        this.closed = true;
        this.entitiesByKey.clear();
        this.proxiesByKey.clear();
        this.entries.clear();
        this.arrayHolders.clear();
        this.collections.clear();
        this.nullifiables.clear();
    }

    public LockMode getCurrentLockMode(Object object) throws HibernateException {
        if (object instanceof HibernateProxy && (object = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getImplementation(this)) == null) {
            return LockMode.NONE;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            throw new TransientObjectException("Given object not associated with the session");
        }
        if (e.status != LOADED) {
            throw new ObjectDeletedException("The given object was deleted", e.id);
        }
        return e.lockMode;
    }

    public LockMode getLockMode(Object object) {
        return this.getEntry((Object)object).lockMode;
    }

    private void addEntity(Key key, Object object) {
        this.entitiesByKey.put(key, object);
    }

    public Object getEntity(Key key) {
        return this.entitiesByKey.get(key);
    }

    private Object removeEntity(Key key) {
        return this.entitiesByKey.remove(key);
    }

    public void setLockMode(Object entity, LockMode lockMode) {
        this.getEntry((Object)entity).lockMode = lockMode;
    }

    private EntityEntry addEntry(Object object, Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister) {
        EntityEntry e = new EntityEntry(status, loadedState, id, version, lockMode, existsInDatabase, persister);
        this.entries.put(object, e);
        return e;
    }

    private EntityEntry getEntry(Object object) {
        return (EntityEntry)this.entries.get(object);
    }

    private EntityEntry removeEntry(Object object) {
        return (EntityEntry)this.entries.remove(object);
    }

    private boolean isEntryFor(Object object) {
        return this.entries.containsKey(object);
    }

    private void addNewCollection(PersistentCollection collection) {
        CollectionEntry ce = new CollectionEntry();
        this.collections.put(collection, ce);
        collection.setCollectionSnapshot(ce);
    }

    private CollectionEntry getCollectionEntry(PersistentCollection coll) {
        return (CollectionEntry)this.collections.get(coll);
    }

    public boolean isOpen() {
        return !this.closed;
    }

    public Serializable save(Object obj) throws HibernateException {
        Serializable id;
        if (obj == null) {
            throw new NullPointerException("attempted to save null");
        }
        if (!Hibernate.isInitialized(obj)) {
            throw new PersistentObjectException("uninitialized proxy passed to save()");
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null) {
            if (e.status == DELETED) {
                this.flush();
            } else {
                log.trace((Object)"object already associated with session");
                return e.id;
            }
        }
        try {
            id = this.getPersister(object).getIdentifierGenerator().generate(this, object);
            if (id == IdentifierGeneratorFactory.SHORT_CIRCUIT_INDICATOR) {
                return this.getIdentifier(object);
            }
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not save object", sqle);
        }
        return this.doSave(object, id);
    }

    public void save(Object obj, Serializable id) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to insert null");
        }
        if (id == null) {
            throw new NullPointerException("null identifier passed to insert()");
        }
        if (!Hibernate.isInitialized(obj)) {
            throw new PersistentObjectException("uninitialized proxy passed to save()");
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null) {
            if (e.status == DELETED) {
                this.flush();
            } else {
                if (!id.equals(e.id)) {
                    throw new PersistentObjectException("object passed to save() was already persistent: " + MessageHelper.infoString(e.persister, id));
                }
                log.trace((Object)"object already associated with session");
            }
        }
        this.doSave(object, id);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Serializable doSave(Object object, Serializable id) throws HibernateException {
        boolean identityCol;
        ClassPersister persister = this.getPersister(object);
        Key key = null;
        if (id == null) {
            if (!persister.isIdentifierAssignedByInsert()) throw new AssertionFailure("null id");
            identityCol = true;
        } else {
            identityCol = false;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("saving " + MessageHelper.infoString(persister, id)));
        }
        if (!identityCol) {
            key = new Key(id, persister);
            Object old = this.getEntity(key);
            if (old != null) {
                if (this.getEntry((Object)old).status != DELETED) throw new HibernateException("The generated identifier is already in use: " + MessageHelper.infoString(persister, id));
                this.flush();
            }
            persister.setIdentifier(object, id);
        }
        if (persister.implementsLifecycle() && ((Lifecycle)object).onSave(this)) {
            return id;
        }
        if (persister.implementsValidatable()) {
            ((Validatable)object).validate();
        }
        this.addEntry(object, SAVING, null, id, null, LockMode.WRITE, identityCol, persister);
        ++this.cascading;
        try {
            Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 2);
            Object var8_7 = null;
            --this.cascading;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            --this.cascading;
            throw throwable;
        }
        Object[] values = persister.getPropertyValues(object);
        Type[] types = persister.getPropertyTypes();
        boolean substitute = this.interceptor.onSave(object, id, values, persister.getPropertyNames(), types);
        boolean bl = substitute = persister.isVersioned() && Versioning.seedVersion(values, persister.getVersionProperty(), persister.getVersionType()) || substitute;
        if (this.wrap(values, persister.getPropertyTypes()) || substitute) {
            persister.setPropertyValues(object, values);
        }
        TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), values);
        this.nullifyTransientReferences(values, types, identityCol, object);
        if (identityCol) {
            try {
                id = persister.insert(values, object, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not insert", sqle);
            }
            key = new Key(id, persister);
            if (this.getEntity(key) != null) {
                throw new HibernateException("The natively generated ID is already in use " + MessageHelper.infoString(persister, id));
            }
            persister.setIdentifier(object, id);
        }
        this.addEntity(key, object);
        this.addEntry(object, LOADED, values, id, Versioning.getVersion(values, persister), LockMode.WRITE, identityCol, persister);
        if (!identityCol) {
            this.insertions.add(new ScheduledInsertion(id, values, object, persister, this));
        }
        ++this.cascading;
        try {
            Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 1);
            Object var12_13 = null;
            --this.cascading;
            return id;
        }
        catch (Throwable throwable) {
            Object var12_14 = null;
            --this.cascading;
            throw throwable;
        }
    }

    private void reassociateProxy(Object value) throws MappingException {
        HibernateProxy proxy = (HibernateProxy)value;
        LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
        this.reassociateProxy(li, proxy);
    }

    private Object unproxyAndReassociate(Object maybeProxy) throws HibernateException {
        if (maybeProxy instanceof HibernateProxy) {
            HibernateProxy proxy = (HibernateProxy)maybeProxy;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer(proxy);
            this.reassociateProxy(li, proxy);
            return li.getImplementation();
        }
        return maybeProxy;
    }

    private void reassociateProxy(LazyInitializer li, HibernateProxy proxy) throws MappingException {
        if (li.getSession() != this) {
            ClassPersister persister = this.getPersister(li.getPersistentClass());
            Key key = new Key(li.getIdentifier(), persister);
            if (!this.proxiesByKey.containsKey(key)) {
                this.proxiesByKey.put(key, proxy);
            }
            HibernateProxyHelper.getLazyInitializer(proxy).setSession(this);
        }
    }

    private void nullifyTransientReferences(Object[] values, Type[] types, boolean earlyInsert, Object self) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            values[i] = this.nullifyTransientReferences(values[i], types[i], earlyInsert, self);
            ++i;
        }
    }

    private Object nullifyTransientReferences(Object value, Type type, boolean earlyInsert, Object self) throws HibernateException {
        if (value == null) {
            return null;
        }
        if (type.isEntityType() || type.isObjectType()) {
            return this.isUnsaved(value, earlyInsert, self) ? null : value;
        }
        if (type.isComponentType()) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Object[] subvalues = actype.getPropertyValues(value, this);
            Type[] subtypes = actype.getSubtypes();
            boolean substitute = false;
            int i = 0;
            while (i < subvalues.length) {
                Object replacement = this.nullifyTransientReferences(subvalues[i], subtypes[i], earlyInsert, self);
                if (replacement != subvalues[i]) {
                    substitute = true;
                    subvalues[i] = replacement;
                }
                ++i;
            }
            if (substitute) {
                actype.setPropertyValues(value, subvalues);
            }
            return value;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean isUnsaved(Object object, boolean earlyInsert, Object self) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getImplementation(this) == null) {
                return false;
            }
            try {
                object = li.getImplementation();
            }
            catch (HibernateException he) {
                throw new AssertionFailure("Unexpected HibernateException occurred in isTransient()", (Throwable)((Object)he));
            }
        }
        if (object == self) {
            return earlyInsert;
        }
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            ClassPersister persister = this.getPersister(object);
            if (!persister.hasIdentifierProperty()) return true;
            Serializable id = persister.getIdentifier(object);
            if (id == null) return true;
            e = this.getEntry(this.getEntity(new Key(id, persister)));
            if (e == null) {
                return persister.isUnsaved(id);
            }
        }
        if (e.status == SAVING) return true;
        if (earlyInsert) {
            if (e.existsInDatabase) return false;
            return true;
        } else if (!this.nullifiables.contains(new Key(e.id, e.persister))) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void delete(Object object) throws HibernateException {
        ClassPersister persister;
        if (object == null) {
            throw new NullPointerException("attempted to delete null");
        }
        EntityEntry entry = this.getEntry(object = this.unproxyAndReassociate(object));
        if (entry == null) {
            log.trace((Object)"deleting a transient instance");
            persister = this.getPersister(object);
            Serializable id = persister.getIdentifier(object);
            if (id == null) {
                throw new HibernateException("the transient instance passed to delete() had a null identifier");
            }
            Object old = this.getEntity(new Key(id, persister));
            if (old != null) {
                throw new HibernateException("another object with the same id was already associated with the session: " + MessageHelper.infoString(persister, id));
            }
            this.removeCollectionsFor(persister, id, object);
            this.addEntity(new Key(id, persister), object);
            entry = this.addEntry(object, LOADED, persister.getPropertyValues(object), id, persister.getVersion(object), LockMode.NONE, true, persister);
        } else {
            log.trace((Object)"deleting a persistent instance");
            if (entry.status == DELETED || entry.status == GONE) {
                log.trace((Object)"object was already deleted");
                return;
            }
            persister = entry.persister;
        }
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to delete an object of immutable class: " + MessageHelper.infoString(persister));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("deleting " + MessageHelper.infoString(persister, entry.id)));
        }
        Type[] propTypes = persister.getPropertyTypes();
        Object version = entry.getCurrentVersion();
        if (entry.loadedState == null) {
            entry.deletedState = persister.getPropertyValues(object);
        } else {
            entry.deletedState = new Object[entry.loadedState.length];
            TypeFactory.deepCopy(entry.loadedState, propTypes, persister.getPropertyUpdateability(), entry.deletedState);
        }
        this.interceptor.onDelete(object, entry.id, entry.deletedState, persister.getPropertyNames(), propTypes);
        this.nullifyTransientReferences(entry.deletedState, propTypes, false, object);
        HashSet oldNullifiables = null;
        ArrayList oldDeletions = null;
        if (persister.hasCascades()) {
            oldNullifiables = new HashSet();
            oldNullifiables.addAll(this.nullifiables);
            oldDeletions = (ArrayList)this.deletions.clone();
        }
        this.nullifiables.add(new Key(entry.id, persister));
        entry.status = DELETED;
        ScheduledDeletion delete = new ScheduledDeletion(entry.id, version, object, persister, this);
        this.deletions.add(delete);
        try {
            if (persister.implementsLifecycle() && ((Lifecycle)object).onDelete(this)) {
                this.rollbackDeletion(entry, delete);
                return;
            }
            if (persister.hasCascades()) {
                int start = this.deletions.size();
                Set newNullifiables = this.nullifiables;
                this.nullifiables = oldNullifiables;
                ++this.cascading;
                try {
                    Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_DELETE, 1);
                    Object var12_12 = null;
                    --this.cascading;
                    newNullifiables.addAll(oldNullifiables);
                }
                catch (Throwable throwable) {
                    Object var12_13 = null;
                    --this.cascading;
                    newNullifiables.addAll(oldNullifiables);
                    this.nullifiables = newNullifiables;
                    throw throwable;
                }
                this.nullifiables = newNullifiables;
                int end = this.deletions.size();
                if (end != start) {
                    List middle = this.deletions.subList(oldDeletions.size(), start);
                    List tail = this.deletions.subList(start, end);
                    oldDeletions.addAll(tail);
                    oldDeletions.addAll(middle);
                    if (oldDeletions.size() != end) {
                        throw new AssertionFailure("Bug cascading collection deletions");
                    }
                    this.deletions = oldDeletions;
                }
            }
            Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_DELETE, 2);
        }
        catch (Exception e) {
            this.rollbackDeletion(entry, delete);
            SessionImpl.handle(e);
        }
    }

    private void rollbackDeletion(EntityEntry entry, ScheduledDeletion delete) {
        entry.status = LOADED;
        entry.deletedState = null;
        this.deletions.remove(delete);
    }

    private void removeCollectionsFor(ClassPersister persister, Serializable id, Object object) throws HibernateException {
        if (persister.hasCollections()) {
            Type[] types = persister.getPropertyTypes();
            int i = 0;
            while (i < types.length) {
                this.removeCollectionsFor(types[i], id, persister.getPropertyValue(object, i));
                ++i;
            }
        }
    }

    private void removeCollection(CollectionPersister role, Serializable id) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("collection dereferenced while transient " + MessageHelper.infoString(role, id)));
        }
        this.collectionRemovals.add(new ScheduledCollectionRemove(role, id, false, this));
    }

    private void removeCollectionsFor(Type type, Serializable id, Object value) throws HibernateException {
        if (type.isPersistentCollectionType()) {
            CollectionPersister persister = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
            if (value != null && value instanceof PersistentCollection) {
                PersistentCollection coll = (PersistentCollection)value;
                if (coll.setSession(this)) {
                    CollectionSnapshot snapshot = coll.getCollectionSnapshot();
                    if (snapshot != null && persister.getRole().equals(snapshot.getRole()) && id.equals(snapshot.getKey())) {
                        if (coll.wasInitialized()) {
                            this.addInitializedCollection(coll, snapshot);
                        } else {
                            this.addUninitializedCollection(coll, persister, id);
                        }
                    } else {
                        this.removeCollection(persister, id);
                    }
                } else {
                    this.removeCollection(persister, id);
                }
            } else {
                this.removeCollection(persister, id);
            }
        } else if (type.isEntityType()) {
            ClassPersister persister;
            if (value != null && (persister = this.getPersister(((EntityType)type).getPersistentClass())).hasProxy() && !Hibernate.isInitialized(value)) {
                this.reassociateProxy(value);
            }
        } else if (type.isComponentType() && value != null) {
            AbstractComponentType actype = (AbstractComponentType)type;
            Type[] types = actype.getSubtypes();
            int i = 0;
            while (i < types.length) {
                this.removeCollectionsFor(types[i], id, actype.getPropertyValue(value, i, this));
                ++i;
            }
        }
    }

    public void update(Object obj) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (!Hibernate.isInitialized(obj)) {
            this.reassociateProxy(obj);
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        ClassPersister persister = this.getPersister(object);
        if (this.isEntryFor(object)) {
            log.trace((Object)"object already associated with session");
        } else {
            Serializable id = persister.getIdentifier(object);
            if (id == null) {
                throw new HibernateException("The given object has a null identifier property " + MessageHelper.infoString(persister));
            }
            this.doUpdate(object, id);
        }
    }

    public void saveOrUpdate(Object obj) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (!Hibernate.isInitialized(obj)) {
            this.reassociateProxy(obj);
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e != null && e.status != DELETED) {
            log.trace((Object)"saveOrUpdate() persistent instance");
        } else if (e != null) {
            log.trace((Object)"saveOrUpdate() deleted instance");
            this.save(obj);
        } else {
            Boolean isUnsaved = this.interceptor.isUnsaved(object);
            if (isUnsaved == null) {
                ClassPersister persister = this.getPersister(object);
                if (persister.hasIdentifierProperty()) {
                    Serializable id = persister.getIdentifier(object);
                    if (persister.isUnsaved(id)) {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("saveOrUpdate() unsaved instance with id: " + id));
                        }
                        this.save(obj);
                    } else {
                        if (log.isTraceEnabled()) {
                            log.trace((Object)("saveOrUpdate() previously saved instance with id: " + id));
                        }
                        this.doUpdate(object, id);
                    }
                } else {
                    log.trace((Object)"saveOrUpdate() unsaved instance with no identifier property");
                    this.save(obj);
                }
            } else if (Boolean.TRUE.equals(isUnsaved)) {
                log.trace((Object)"saveOrUpdate() unsaved instance");
                this.save(obj);
            } else {
                log.trace((Object)"saveOrUpdate() previously saved instance");
                this.update(obj);
            }
        }
    }

    public void update(Object obj, Serializable id) throws HibernateException {
        Serializable pid;
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        if (obj == null) {
            throw new NullPointerException("attempted to update null");
        }
        if (obj instanceof HibernateProxy && !id.equals(pid = HibernateProxyHelper.getLazyInitializer((HibernateProxy)obj).getIdentifier())) {
            throw new HibernateException("The given proxy had a different identifier value to the given identifier: " + pid + "!=" + id);
        }
        if (!Hibernate.isInitialized(obj)) {
            this.reassociateProxy(obj);
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.getEntry(object);
        if (e == null) {
            this.doUpdate(object, id);
        } else if (!e.id.equals(id)) {
            throw new PersistentObjectException("The instance passed to update() was already persistent: " + MessageHelper.infoString(e.persister, id));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpdate(Object object, Serializable id) throws HibernateException {
        Key key;
        Object old;
        ClassPersister persister = this.getPersister(object);
        if (!persister.isMutable()) {
            throw new HibernateException("attempted to update an object of immutable class: " + MessageHelper.infoString(persister));
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("updating " + MessageHelper.infoString(persister, id)));
        }
        if ((old = this.getEntity(key = new Key(id, persister))) == object) {
            throw new AssertionFailure("Hibernate has a bug in update() ... or you are using an illegal id type: " + MessageHelper.infoString(persister, id));
        }
        if (old != null) {
            throw new HibernateException("Another object was associated with this id (the object with the given id was already loaded): " + MessageHelper.infoString(persister, id));
        }
        if (persister.implementsLifecycle() && ((Lifecycle)object).onUpdate(this)) {
            return;
        }
        this.removeCollectionsFor(persister, id, object);
        this.addEntity(key, object);
        this.addEntry(object, LOADED, null, id, persister.getVersion(object), LockMode.NONE, true, persister);
        ++this.cascading;
        try {
            Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
            Object var7_6 = null;
            --this.cascading;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            --this.cascading;
            throw throwable;
        }
    }

    public List find(String query) throws HibernateException {
        return this.find(query, NO_ARGS, NO_TYPES);
    }

    public List find(String query, Object value, Type type) throws HibernateException {
        return this.find(query, new Object[]{value}, new Type[]{type});
    }

    public List find(String query, Object[] values, Type[] types) throws HibernateException {
        return this.find(query, values, types, null, null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List find(String query, Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("find: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        QueryTranslator[] q = this.getQueries(query, false);
        List results = Collections.EMPTY_LIST;
        ++this.dontFlushFromFind;
        try {
            int i = 0;
            while (i < q.length) {
                List currentResults;
                try {
                    currentResults = q[i].find(this, values, types, true, selection, namedParams, lockModes);
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not execute query", sqle);
                }
                currentResults.addAll(results);
                results = currentResults;
                ++i;
            }
            Object var13_12 = null;
            --this.dontFlushFromFind;
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
        return results;
    }

    private QueryTranslator[] getQueries(String query, boolean scalar) throws HibernateException {
        String[] concreteQueries = QueryTranslator.concreteQueries(query, this.factory);
        QueryTranslator[] q = new QueryTranslator[concreteQueries.length];
        HashSet qs = new HashSet();
        int i = 0;
        while (i < concreteQueries.length) {
            q[i] = scalar ? this.factory.getShallowQuery(concreteQueries[i]) : this.factory.getQuery(concreteQueries[i]);
            qs.addAll(q[i].getQuerySpaces());
            ++i;
        }
        this.autoFlushIfRequired(qs);
        return q;
    }

    public Iterator iterate(String query) throws HibernateException {
        return this.iterate(query, NO_ARGS, NO_TYPES);
    }

    public Iterator iterate(String query, Object value, Type type) throws HibernateException {
        return this.iterate(query, new Object[]{value}, new Type[]{type});
    }

    public Iterator iterate(String query, Object[] values, Type[] types) throws HibernateException {
        return this.iterate(query, values, types, null, null, null);
    }

    public Iterator iterate(String query, Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes) throws HibernateException {
        boolean many;
        QueryTranslator[] q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("iterate: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if ((q = this.getQueries(query, true)).length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = q.length > 1;
        if (many) {
            results = new Iterator[q.length];
        }
        int i = 0;
        while (i < q.length) {
            try {
                result = q[i].iterate(values, types, selection, namedParams, lockModes, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not execute query", sqle);
            }
            if (many) {
                results[i] = result;
            }
            ++i;
        }
        return many ? new JoinedIterator(results) : result;
    }

    public ScrollableResults scroll(String query, Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes) throws HibernateException {
        String[] concreteQueries;
        if (log.isTraceEnabled()) {
            log.trace((Object)("scroll: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if ((concreteQueries = QueryTranslator.concreteQueries(query, this.factory)).length > 1) {
            throw new HibernateException("This query cannot be scrolled: " + query);
        }
        if (concreteQueries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + query);
        }
        QueryTranslator q = this.factory.getShallowQuery(concreteQueries[0]);
        this.autoFlushIfRequired(q.getQuerySpaces());
        try {
            return q.scroll(values, types, selection, namedParams, lockModes, this);
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not execute query", sqle);
        }
    }

    public int delete(String query) throws HibernateException {
        return this.delete(query, NO_ARGS, NO_TYPES);
    }

    public int delete(String query, Object value, Type type) throws HibernateException {
        return this.delete(query, new Object[]{value}, new Type[]{type});
    }

    public int delete(String query, Object[] values, Type[] types) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("delete: " + query));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        List list = this.find(query, values, types);
        int size = list.size();
        int i = 0;
        while (i < size) {
            this.delete(list.get(i));
            ++i;
        }
        return size;
    }

    public void lock(Object object, LockMode lockMode) throws HibernateException {
        if (object == null) {
            throw new NullPointerException("attempted to lock null");
        }
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for lock()");
        }
        EntityEntry e = this.getEntry(object = this.unproxyAndReassociate(object));
        if (e == null) {
            throw new TransientObjectException("attempted to lock a transient instance");
        }
        ClassPersister persister = e.persister;
        if (lockMode.greaterThan(e.lockMode)) {
            if (e.status != LOADED) {
                throw new TransientObjectException("attempted to lock a deleted instance");
            }
            if (log.isTraceEnabled()) {
                log.trace((Object)("locking " + MessageHelper.infoString(persister, e.id) + " in mode: " + lockMode));
            }
            if (persister.hasCache()) {
                persister.getCache().lock(e.id);
            }
            try {
                try {
                    persister.lock(e.id, e.lastVersion, object, lockMode, this);
                    e.lockMode = lockMode;
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not lock object", sqle);
                }
                Object var7_5 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(e.id);
                }
            }
            catch (Throwable throwable) {
                Object var7_6 = null;
                if (persister.hasCache()) {
                    persister.getCache().release(e.id);
                }
                throw throwable;
            }
        }
    }

    public Query createFilter(Object collection, String queryString) {
        return new FilterImpl(queryString, collection, this);
    }

    public Query createQuery(String queryString) {
        return new QueryImpl(queryString, this);
    }

    public Query getNamedQuery(String queryName) throws MappingException {
        return this.createQuery(this.factory.getNamedQuery(queryName));
    }

    public Object instantiate(Class clazz, Serializable id) throws HibernateException {
        return this.instantiate(this.factory.getPersister(clazz), id);
    }

    public Object instantiate(ClassPersister persister, Serializable id) throws HibernateException {
        Object result = this.interceptor.instantiate(persister.getMappedClass(), id);
        if (result == null) {
            result = persister.instantiate(id);
        }
        return result;
    }

    public void setFlushMode(FlushMode flushMode) {
        this.flushMode = flushMode;
    }

    public FlushMode getFlushMode() {
        return this.flushMode;
    }

    private boolean autoFlushIfRequired(Set querySpaces) throws HibernateException {
        if (this.flushMode == FlushMode.AUTO && this.dontFlushFromFind == 0) {
            int oldSize = this.collectionRemovals.size();
            this.flushEverything();
            if (this.areTablesToBeUpdated(querySpaces)) {
                log.trace((Object)"Need to execute flush");
                this.execute();
                this.postFlush();
                return true;
            }
            log.trace((Object)"Dont need to execute flush");
            this.collectionCreations.clear();
            this.collectionUpdates.clear();
            int i = this.collectionRemovals.size() - 1;
            while (i >= oldSize) {
                this.collectionRemovals.remove(i);
                --i;
            }
        }
        return false;
    }

    public Object narrowProxy(Object proxy, ClassPersister p, Key key, Object object) throws HibernateException {
        if (!p.getConcreteProxyClass().isAssignableFrom(proxy.getClass())) {
            if (log.isWarnEnabled()) {
                log.warn((Object)("Narrowing proxy to " + p.getConcreteProxyClass() + " - this operation breaks =="));
            }
            if (object != null) {
                this.proxiesByKey.remove(key);
                return object;
            }
            proxy = CGLIBLazyInitializer.getProxy(p.getMappedClass(), p.getProxyInterfaces(), p.getProxyGetIdentifierMethod(), key.getIdentifier(), this);
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return proxy;
    }

    public Object proxyFor(ClassPersister persister, Key key, Object impl) throws HibernateException {
        if (!persister.hasProxy()) {
            return impl;
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, impl);
        }
        return impl;
    }

    public Object proxyFor(Object impl) throws HibernateException {
        EntityEntry e = this.getEntry(impl);
        ClassPersister p = this.getPersister(impl);
        return this.proxyFor(p, new Key(e.id, p), impl);
    }

    public void addUninitializedEntity(Key key, Object object, LockMode lockMode) throws HibernateException {
        this.addEntity(key, object);
        this.addEntry(object, LOADING, null, key.getIdentifier(), null, lockMode, true, null);
    }

    public void postHydrate(ClassPersister persister, Serializable id, Object[] values, Object object, LockMode lockMode) throws HibernateException {
        persister.setIdentifier(object, id);
        Object version = Versioning.getVersion(values, persister);
        this.addEntry(object, LOADED, values, id, version, lockMode, true, persister);
        if (log.isTraceEnabled() && version != null) {
            log.trace((Object)("Version: " + version));
        }
    }

    private void throwObjectNotFound(Object o, Serializable id, Class clazz) throws ObjectNotFoundException {
        if (o == null) {
            throw new ObjectNotFoundException("No row with the given identifier exists", id, clazz);
        }
    }

    public void load(Object object, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        this.doLoadByObject(object, id, true, LockMode.NONE);
    }

    public Object load(Class clazz, Serializable id) throws HibernateException {
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        Object result = this.doLoadByClass(clazz, id, true, true);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    public Object immediateLoad(Class clazz, Serializable id) throws HibernateException {
        Object result = this.doLoad(clazz, id, null, LockMode.NONE, false);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    public Object internalLoadOneToOne(Class clazz, Serializable id) throws HibernateException {
        return this.doLoadByClass(clazz, id, false, false);
    }

    public Object internalLoad(Class clazz, Serializable id) throws HibernateException {
        Object result = this.doLoadByClass(clazz, id, false, true);
        this.throwObjectNotFound(result, id, clazz);
        return result;
    }

    private void doLoadByObject(Object object, Serializable id, boolean checkDeleted, LockMode lockMode) throws HibernateException {
        Class<?> clazz = object.getClass();
        if (this.getEntry(object) != null) {
            throw new PersistentObjectException("attempted to load into an instance that was already associated with the Session: " + MessageHelper.infoString(clazz, id));
        }
        Object result = this.doLoad(clazz, id, object, lockMode, checkDeleted);
        this.throwObjectNotFound(result, id, clazz);
        if (result != object) {
            throw new HibernateException("The object with that id was already loaded by the Session: " + MessageHelper.infoString(clazz, id));
        }
    }

    private Object doLoadByClass(Class clazz, Serializable id, boolean checkDeleted, boolean allowProxyCreation) throws HibernateException {
        ClassPersister persister;
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading " + MessageHelper.infoString(clazz, id)));
        }
        if (!(persister = this.getPersister(clazz)).hasProxy()) {
            return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
        }
        Key key = new Key(id, persister);
        if (this.getEntity(key) != null) {
            return this.proxyFor(persister, key, this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted));
        }
        Object proxy = this.proxiesByKey.get(key);
        if (proxy != null) {
            return this.narrowProxy(proxy, persister, key, null);
        }
        if (allowProxyCreation) {
            if (persister.hasProxy()) {
                proxy = CGLIBLazyInitializer.getProxy(clazz, persister.getProxyInterfaces(), persister.getProxyGetIdentifierMethod(), id, this);
            }
            this.proxiesByKey.put(key, proxy);
            return proxy;
        }
        return this.doLoad(clazz, id, null, LockMode.NONE, checkDeleted);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object load(Class clazz, Serializable id, LockMode lockMode) throws HibernateException {
        Object result;
        if (lockMode == LockMode.WRITE) {
            throw new HibernateException("Invalid lock mode for load()");
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("loading " + MessageHelper.infoString(clazz, id) + " in lock mode: " + lockMode));
        }
        if (id == null) {
            throw new NullPointerException("null is not a valid identifier");
        }
        ClassPersister persister = this.getPersister(clazz);
        if (persister.hasCache()) {
            persister.getCache().lock(id);
        }
        try {
            result = this.doLoad(clazz, id, null, lockMode, true);
            Object var7_6 = null;
            if (persister.hasCache()) {
                persister.getCache().release(id);
            }
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            if (persister.hasCache()) {
                persister.getCache().release(id);
            }
            throw throwable;
        }
        this.throwObjectNotFound(result, id, persister.getMappedClass());
        return this.proxyFor(persister, new Key(id, persister), result);
    }

    private Object doLoad(Class theClass, Serializable id, Object optionalObject, LockMode lockMode, boolean checkDeleted) throws HibernateException {
        CacheEntry entry;
        if (log.isTraceEnabled()) {
            log.trace((Object)("attempting to resolve " + MessageHelper.infoString(theClass, id)));
        }
        boolean isOptionalObject = optionalObject != null;
        ClassPersister persister = this.getPersister(theClass);
        Key key = new Key(id, persister);
        Object old = this.getEntity(key);
        if (old != null) {
            Status status = this.getEntry((Object)old).status;
            if (checkDeleted && (status == DELETED || status == GONE)) {
                throw new ObjectDeletedException("The object with that id was deleted", id);
            }
            this.lock(old, lockMode);
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in session cache " + MessageHelper.infoString(persister, id)));
            }
            return old;
        }
        CacheEntry cacheEntry = entry = persister.hasCache() ? (CacheEntry)persister.getCache().get(id, this.timestamp) : null;
        if (entry != null) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("resolved object in JCS cache " + MessageHelper.infoString(persister, id)));
            }
            ClassPersister subclassPersister = this.getPersister(entry.getSubclass());
            Object result = isOptionalObject ? optionalObject : this.instantiate(subclassPersister, id);
            this.addEntry(result, LOADING, null, id, null, LockMode.NONE, true, subclassPersister);
            this.addEntity(new Key(id, persister), result);
            Object[] values = entry.assemble(result, id, subclassPersister, this);
            Type[] types = subclassPersister.getPropertyTypes();
            TypeFactory.deepCopy(values, types, subclassPersister.getPropertyUpdateability(), values);
            Object version = Versioning.getVersion(values, subclassPersister);
            if (log.isTraceEnabled()) {
                log.trace((Object)("Cached Version: " + version));
            }
            this.addEntry(result, LOADED, values, id, version, LockMode.NONE, true, subclassPersister);
            this.lock(result, lockMode);
            return result;
        }
        if (log.isTraceEnabled()) {
            log.trace((Object)("object not resolved in any cache " + MessageHelper.infoString(persister, id)));
        }
        try {
            return persister.load(id, optionalObject, lockMode, this);
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not load object", sqle);
        }
    }

    public void refresh(Object object) throws HibernateException {
        this.refresh(object, LockMode.READ);
    }

    public void refresh(Object obj, LockMode lockMode) throws HibernateException {
        if (obj == null) {
            throw new NullPointerException("attempted to refresh null");
        }
        if (!Hibernate.isInitialized(obj)) {
            this.reassociateProxy(obj);
            return;
        }
        Object object = this.unproxyAndReassociate(obj);
        EntityEntry e = this.removeEntry(object);
        if (e == null) {
            ClassPersister persister = this.getPersister(object);
            Serializable id = persister.getIdentifier(object);
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing transient " + MessageHelper.infoString(persister, id)));
            }
            this.doLoadByObject(object, id, true, lockMode);
        } else {
            if (log.isTraceEnabled()) {
                log.trace((Object)("refreshing " + MessageHelper.infoString(e.persister, e.id)));
            }
            if (!e.existsInDatabase) {
                throw new HibernateException("this instance does not yet exist as a row in the database");
            }
            Key key = new Key(e.id, e.persister);
            this.removeEntity(key);
            this.evictCollections(e.persister.getPropertyValues(obj), e.persister.getPropertyTypes());
            try {
                e.persister.load(e.id, object, lockMode, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not refresh object", sqle);
            }
            this.getEntry((Object)object).lockMode = e.lockMode;
        }
    }

    public void initializeEntity(Object object) throws HibernateException {
        EntityEntry e = this.getEntry(object);
        ClassPersister persister = e.persister;
        Serializable id = e.id;
        Object[] hydratedState = e.loadedState;
        Type[] types = persister.getPropertyTypes();
        if (log.isDebugEnabled()) {
            log.debug((Object)("resolving associations for " + MessageHelper.infoString(persister, id)));
        }
        this.interceptor.onLoad(object, id, hydratedState, persister.getPropertyNames(), types);
        int i = 0;
        while (i < hydratedState.length) {
            hydratedState[i] = types[i].resolveIdentifier(hydratedState[i], this, object);
            ++i;
        }
        persister.setPropertyValues(object, hydratedState);
        TypeFactory.deepCopy(hydratedState, persister.getPropertyTypes(), persister.getPropertyUpdateability(), hydratedState);
        if (persister.hasCache()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("adding entity to JCS cache " + MessageHelper.infoString(persister, id)));
            }
            persister.getCache().put(id, new CacheEntry(object, persister, this), this.timestamp);
        }
        if (persister.implementsLifecycle()) {
            ((Lifecycle)object).onLoad(this, id);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("done materializing entity " + MessageHelper.infoString(persister, id)));
        }
    }

    public Transaction beginTransaction() throws HibernateException {
        this.callAfterTransactionCompletionFromDisconnect = false;
        return this.factory.getTransactionFactory().beginTransaction(this);
    }

    public void flush() throws HibernateException {
        if (this.cascading > 0) {
            throw new HibernateException("Flush during cascade is dangerous - this might occur if an object was deleted and then re-saved by cascade");
        }
        this.flushEverything();
        this.execute();
        this.postFlush();
    }

    private void flushEverything() throws HibernateException {
        log.trace((Object)"flushing session");
        this.interceptor.preFlush(this.entitiesByKey.values().iterator());
        this.preFlushEntities();
        this.preFlushCollections();
        this.flushEntities();
        this.flushCollections();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Flushed: " + this.insertions.size() + " insertions, " + this.updates.size() + " updates, " + this.deletions.size() + " deletions to " + this.entries.size() + " objects"));
            log.debug((Object)("Flushed: " + this.collectionCreations.size() + " (re)creations, " + this.collectionUpdates.size() + " updates, " + this.collectionRemovals.size() + " removals to " + this.collections.size() + " collections"));
        }
    }

    private boolean areTablesToBeUpdated(Set tables) {
        return this.areTablesToUpdated(this.updates.values().iterator(), tables) || this.areTablesToUpdated(this.insertions.iterator(), tables) || this.areTablesToUpdated(this.deletions.iterator(), tables) || this.areTablesToUpdated(this.collectionUpdates.iterator(), tables) || this.areTablesToUpdated(this.collectionCreations.iterator(), tables) || this.areTablesToUpdated(this.collectionRemovals.iterator(), tables);
    }

    private boolean areTablesToUpdated(Iterator iter, Set set) {
        while (iter.hasNext()) {
            Serializable[] spaces = ((Executable)iter.next()).getPropertySpaces();
            int i = 0;
            while (i < spaces.length) {
                if (set.contains(spaces[i])) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private void execute() throws HibernateException {
        log.trace((Object)"executing flush");
        try {
            this.executeAll(this.insertions.iterator());
            this.executeAll(this.updates.values().iterator());
            this.executeAll(this.collectionRemovals.iterator());
            this.executeAll(this.collectionUpdates.iterator());
            this.executeAll(this.collectionCreations.iterator());
            this.executeAll(this.deletions.iterator());
        }
        catch (SQLException sqle) {
            throw new JDBCException("Could not synchronize database state with session", sqle);
        }
    }

    public void postInsert(Object obj) {
        this.getEntry((Object)obj).existsInDatabase = true;
    }

    public void postDelete(Object obj) {
        EntityEntry e = this.removeEntry(obj);
        Key key = new Key(e.id, e.persister);
        this.removeEntity(key);
        this.proxiesByKey.remove(key);
    }

    private void executeAll(Iterator iter) throws SQLException, HibernateException {
        while (iter.hasNext()) {
            Executable e = (Executable)iter.next();
            this.executions.add(e);
            e.execute();
            iter.remove();
        }
        if (this.batcher != null) {
            this.batcher.executeBatch();
        }
    }

    private void flushEntities() throws HibernateException {
        log.trace((Object)"Flushing entities and processing referenced collections");
        Iterator iter = IdentityMap.entries(this.entries).iterator();
        while (iter.hasNext()) {
            boolean cannotDirtyCheck;
            Serializable oid;
            Map.Entry me = (Map.Entry)iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE) continue;
            Object object = me.getKey();
            ClassPersister persister = entry.persister;
            if (persister.hasIdentifierProperty() && !entry.id.equals(oid = persister.getIdentifier(object))) {
                throw new HibernateException("identifier of an instance of " + persister.getClassName() + " altered from " + entry.id + " to " + oid);
            }
            Object[] values = status == DELETED ? entry.deletedState : persister.getPropertyValues(object);
            Type[] types = persister.getPropertyTypes();
            boolean substitute = this.wrap(values, types);
            int[] dirtyProperties = this.interceptor.findDirty(object, entry.id, values, entry.loadedState, persister.getPropertyNames(), types);
            if (dirtyProperties == null) {
                boolean bl = cannotDirtyCheck = entry.loadedState == null;
                if (!cannotDirtyCheck) {
                    dirtyProperties = persister.findDirty(values, entry.loadedState, object, this);
                }
            } else {
                cannotDirtyCheck = false;
            }
            if (persister.isMutable() && (cannotDirtyCheck || dirtyProperties != null && dirtyProperties.length != 0 || status == LOADED && persister.isVersioned() && persister.hasCollections() && this.searchForDirtyCollections(values, types))) {
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Updating entity: " + MessageHelper.infoString(persister, entry.id)));
                }
                boolean bl = substitute = this.interceptor.onFlushDirty(object, entry.id, values, entry.loadedState, persister.getPropertyNames(), types) || substitute;
                if (status == LOADED) {
                    if (persister.implementsValidatable()) {
                        ((Validatable)object).validate();
                    }
                    Object[] copiedValues = new Object[values.length];
                    TypeFactory.deepCopy(values, types, persister.getPropertyUpdateability(), copiedValues);
                    entry.loadedState = copiedValues;
                    entry.nextLockMode = LockMode.WRITE;
                }
                if (persister.isVersioned()) {
                    if (status != DELETED) {
                        entry.nextVersion = Versioning.increment(entry.lastVersion, persister.getVersionType());
                    }
                    Versioning.setVersion(values, entry.getCurrentVersion(), persister);
                }
                this.updates.put(new Key(entry.id, persister), new ScheduledUpdate(entry.id, values, dirtyProperties, entry.lastVersion, object, persister, this));
            }
            if (status == DELETED) {
                entry.status = GONE;
                continue;
            }
            if (substitute) {
                persister.setPropertyValues(object, values);
            }
            this.updateReachables(values, types, object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void preFlushEntities() throws HibernateException {
        Iterator iter = IdentityMap.entries(this.entries).iterator();
        while (iter.hasNext()) {
            Object var7_6;
            Map.Entry me = (Map.Entry)iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Status status = entry.status;
            if (status == LOADING || status == GONE || status == DELETED) continue;
            Object object = me.getKey();
            ++this.cascading;
            try {
                Cascades.cascade((SessionImplementor)this, entry.persister, object, Cascades.ACTION_SAVE_UPDATE, 0);
                var7_6 = null;
                --this.cascading;
            }
            catch (Throwable throwable) {
                var7_6 = null;
                --this.cascading;
                throw throwable;
            }
        }
    }

    private ClassPersister getPersister(Class theClass) throws MappingException {
        if (this.lastClass != theClass) {
            this.lastResultForClass = this.factory.getPersister(theClass);
            this.lastClass = theClass;
        }
        return this.lastResultForClass;
    }

    public ClassPersister getPersister(Object object) throws MappingException {
        return this.getPersister(object.getClass());
    }

    public Serializable getIdentifier(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            if (li.getSession() != this) {
                throw new TransientObjectException("The proxy was not associated with this session");
            }
            return li.getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        if (entry == null) {
            throw new TransientObjectException("The instance was not associated with this session");
        }
        return entry.id;
    }

    public Serializable getEntityIdentifier(Object object) {
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        return entry != null ? entry.id : null;
    }

    public Serializable getEntityIdentifierIfNotUnsaved(Object object) throws HibernateException {
        Boolean isUnsaved;
        Serializable id;
        if (object == null) {
            return null;
        }
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getIdentifier();
        }
        EntityEntry entry = this.getEntry(object);
        if (entry != null) {
            return entry.id;
        }
        ClassPersister persister = this.getPersister(object);
        try {
            id = persister.getIdentifier(object);
        }
        catch (HibernateException he) {
            id = null;
        }
        Boolean bl = isUnsaved = id == null ? Boolean.TRUE : this.interceptor.isUnsaved(object);
        if (isUnsaved != null && isUnsaved.booleanValue() || persister.isUnsaved(id)) {
            throw new TransientObjectException("object references an unsaved transient instance - save the transient instance before flushing");
        }
        return id;
    }

    private void flushCollections() throws HibernateException {
        log.trace((Object)"Processing unreferenced collections");
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            if (((CollectionEntry)e.getValue()).reached) continue;
            this.updateUnreachableCollection((PersistentCollection)e.getKey());
        }
        log.trace((Object)"Scheduling collection removes/(re)creates/updates");
        iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            PersistentCollection coll = (PersistentCollection)me.getKey();
            CollectionEntry ce = (CollectionEntry)me.getValue();
            if (ce.dorecreate) {
                this.collectionCreations.add(new ScheduledCollectionRecreate(coll, ce.currentPersister, ce.currentKey, this));
            }
            if (ce.doremove) {
                this.collectionRemovals.add(new ScheduledCollectionRemove(ce.loadedPersister, ce.loadedKey, ce.snapshotIsEmpty(), this));
            }
            if (!ce.doupdate) continue;
            this.collectionUpdates.add(new ScheduledCollectionUpdate(coll, ce.loadedPersister, ce.loadedKey, ce.snapshotIsEmpty(), this));
        }
    }

    private void postFlush() throws HibernateException {
        Map.Entry me;
        log.trace((Object)"post flush");
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            me = iter.next();
            ((CollectionEntry)me.getValue()).postFlush((PersistentCollection)me.getKey());
        }
        iter = this.entries.entrySet().iterator();
        while (iter.hasNext()) {
            me = iter.next();
            EntityEntry entry = (EntityEntry)me.getValue();
            Object object = me.getKey();
            entry.postFlush(object);
        }
        this.interceptor.postFlush(this.entitiesByKey.values().iterator());
    }

    private void preFlushCollections() throws HibernateException {
        Iterator iter = this.collections.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry e = iter.next();
            ((CollectionEntry)e.getValue()).preFlush((PersistentCollection)e.getKey());
        }
    }

    private boolean wrap(Object[] fields, Type[] types) throws HibernateException {
        boolean substitute = false;
        int i = 0;
        while (i < fields.length) {
            Object result = this.wrap(fields[i], types[i]);
            if (result != fields[i]) {
                fields[i] = result;
                substitute = true;
            }
            ++i;
        }
        return substitute;
    }

    private Object wrap(Object obj, Type type) throws HibernateException {
        AbstractComponentType componentType;
        Object[] values;
        if (obj == null) {
            return null;
        }
        if (type.isComponentType() && this.wrap(values = (componentType = (AbstractComponentType)type).getPropertyValues(obj, this), componentType.getSubtypes())) {
            componentType.setPropertyValues(obj, values);
        }
        if (type.isPersistentCollectionType()) {
            PersistentCollection pc;
            if (obj instanceof PersistentCollection) {
                pc = (PersistentCollection)obj;
                if (pc.setSession(this)) {
                    CollectionSnapshot snapshot = pc.getCollectionSnapshot();
                    if (snapshot.isInitialized()) {
                        this.addNewCollection(pc);
                    } else {
                        Serializable id = snapshot.getKey();
                        if (id == null) {
                            throw new HibernateException("reference created to previously dereferenced uninitialized collection");
                        }
                        this.addUninitializedCollection(pc, this.getCollectionPersister(snapshot.getRole()), id);
                        pc.forceLoad();
                        this.addNewCollection(pc);
                    }
                }
            } else if (obj.getClass().isArray()) {
                ArrayHolder ah = this.getArrayHolder(obj);
                if (ah == null) {
                    ah = new ArrayHolder((SessionImplementor)this, obj);
                    this.addNewCollection(ah);
                    this.addArrayHolder(ah);
                }
            } else {
                pc = ((PersistentCollectionType)type).wrap(this, obj);
                if (log.isTraceEnabled()) {
                    log.trace((Object)("Wrapped collection in role: " + ((PersistentCollectionType)type).getRole()));
                }
                this.addNewCollection(pc);
                obj = pc;
            }
        }
        return obj;
    }

    private void updateReachableCollection(PersistentCollection coll, Type type, Object owner) throws HibernateException {
        CollectionPersister persister;
        CollectionEntry ce = this.getCollectionEntry(coll);
        if (ce.reached) {
            throw new HibernateException("Found shared references to a collection");
        }
        ce.reached = true;
        ce.currentPersister = persister = this.getCollectionPersister(((PersistentCollectionType)type).getRole());
        ce.currentKey = this.getEntityIdentifier(owner);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Collection found: " + MessageHelper.infoString(persister, ce.currentKey) + ", was: " + MessageHelper.infoString(ce.loadedPersister, ce.loadedKey)));
        }
        this.prepareCollectionForUpdate(coll, ce);
    }

    private void updateReachable(Object obj, Type type, Object owner) throws HibernateException {
        if (obj != null) {
            if (type.isPersistentCollectionType()) {
                if (obj.getClass().isArray()) {
                    this.updateReachableCollection(this.getArrayHolder(obj), type, owner);
                } else {
                    this.updateReachableCollection((PersistentCollection)obj, type, owner);
                }
            } else if (type.isComponentType()) {
                Type[] types;
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] values = componentType.getPropertyValues(obj, this);
                if (this.wrap(values, types = componentType.getSubtypes())) {
                    componentType.setPropertyValues(obj, values);
                }
                this.updateReachables(values, types, owner);
            }
        }
    }

    private void updateUnreachableCollection(PersistentCollection coll) throws HibernateException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        if (log.isDebugEnabled() && entry.loadedPersister != null) {
            log.debug((Object)("Collection dereferenced: " + MessageHelper.infoString(entry.loadedPersister, entry.loadedKey)));
        }
        entry.currentPersister = null;
        entry.currentKey = null;
        this.prepareCollectionForUpdate(coll, entry);
    }

    private void prepareCollectionForUpdate(PersistentCollection coll, CollectionEntry entry) throws HibernateException {
        if (entry.processed) {
            throw new AssertionFailure("Hibernate has a bug processing collections");
        }
        entry.processed = true;
        if (entry.loadedPersister != null || entry.currentPersister != null) {
            if (entry.loadedPersister != entry.currentPersister || !entry.currentPersister.getKeyType().equals(entry.loadedKey, entry.currentKey)) {
                if (entry.currentPersister != null) {
                    entry.dorecreate = true;
                }
                if (entry.loadedPersister != null) {
                    entry.doremove = true;
                    if (entry.dorecreate) {
                        log.trace((Object)"Forcing collection initialization");
                        coll.forceLoad();
                    }
                }
            } else if (entry.dirty) {
                entry.doupdate = true;
            }
        }
    }

    private void updateReachables(Object[] fields, Type[] types, Object owner) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            this.updateReachable(fields[i], types[i], owner);
            ++i;
        }
    }

    private boolean collectionIsDirty(PersistentCollection coll) throws HibernateException {
        CollectionEntry entry = this.getCollectionEntry(coll);
        return entry.initialized && entry.dirty;
    }

    private boolean searchForDirtyCollections(Object[] fields, Type[] types) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            if (this.searchForDirtyCollections(fields[i], types[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private boolean searchForDirtyCollections(Object obj, Type type) throws HibernateException {
        if (obj != null) {
            if (type.isPersistentCollectionType()) {
                if (obj.getClass().isArray()) {
                    ArrayHolder ah = this.getArrayHolder(obj);
                    return this.collectionIsDirty(ah);
                }
                return this.collectionIsDirty((PersistentCollection)obj);
            }
            if (type.isComponentType()) {
                AbstractComponentType componentType = (AbstractComponentType)type;
                Object[] values = componentType.getPropertyValues(obj, this);
                Type[] types = componentType.getSubtypes();
                int i = 0;
                while (i < values.length) {
                    if (this.searchForDirtyCollections(values[i], types[i])) {
                        return true;
                    }
                    ++i;
                }
            }
        }
        return false;
    }

    public PersistentCollection getLoadingCollection(CollectionPersister persister, Serializable id) throws HibernateException {
        LoadingCollectionEntry lce = (LoadingCollectionEntry)this.loadingCollections.get(id);
        if (lce == null) {
            PersistentCollection pc = persister.getType().instantiate(this, persister);
            pc.beforeInitialize(persister);
            pc.beginRead();
            if (this.loadingRole != null && !this.loadingRole.equals(persister.getRole())) {
                throw new AssertionFailure("recursive collection load");
            }
            this.loadingCollections.put(id, new LoadingCollectionEntry(pc, id));
            this.loadingRole = persister.getRole();
            return pc;
        }
        return lce.collection;
    }

    public void endLoadingCollections() throws HibernateException {
        if (this.loadingRole != null) {
            CollectionPersister persister = this.getCollectionPersister(this.loadingRole);
            Iterator iter = this.loadingCollections.values().iterator();
            while (iter.hasNext()) {
                LoadingCollectionEntry lce = (LoadingCollectionEntry)iter.next();
                if (!lce.initialize) continue;
                lce.collection.endRead();
                this.addInitializedCollection(lce.collection, persister, lce.id);
            }
            this.loadingCollections.clear();
            this.loadingRole = null;
        }
    }

    public PersistentCollection getLoadingCollection(String role, Serializable id) {
        LoadingCollectionEntry lce = (LoadingCollectionEntry)this.loadingCollections.get(id);
        if (role.equals(this.loadingRole)) {
            lce.initialize = true;
            return lce.collection;
        }
        return null;
    }

    public void addUninitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) {
        CollectionEntry ce = new CollectionEntry(persister, id, false);
        this.collections.put(collection, ce);
        collection.setCollectionSnapshot(ce);
    }

    public void addInitializedCollection(PersistentCollection collection, CollectionPersister persister, Serializable id) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(persister, id, true);
        ce.postInitialize(collection);
        this.collections.put(collection, ce);
        collection.setCollectionSnapshot(ce);
    }

    private void addInitializedCollection(PersistentCollection collection, CollectionSnapshot cs) throws HibernateException {
        CollectionEntry ce = new CollectionEntry(cs, this.factory);
        this.collections.put(collection, ce);
        collection.setCollectionSnapshot(ce);
    }

    public ArrayHolder getArrayHolder(Object array) {
        return (ArrayHolder)this.arrayHolders.get(array);
    }

    public void addArrayHolder(ArrayHolder holder) {
        this.arrayHolders.put(holder.getArray(), holder);
    }

    private CollectionPersister getCollectionPersister(String role) throws MappingException {
        return this.factory.getCollectionPersister(role);
    }

    public void dirty(PersistentCollection coll) {
        this.getCollectionEntry((PersistentCollection)coll).dirty = true;
    }

    public Serializable getSnapshot(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).snapshot;
    }

    public Serializable getLoadedCollectionKey(PersistentCollection coll) {
        return this.getCollectionEntry((PersistentCollection)coll).loadedKey;
    }

    public boolean isInverseCollection(PersistentCollection collection) {
        CollectionEntry ce = this.getCollectionEntry(collection);
        return ce != null && ce.loadedPersister.isInverse();
    }

    public void initialize(PersistentCollection collection, boolean writing) throws HibernateException {
        CollectionEntry ce = this.getCollectionEntry(collection);
        if (!ce.initialized) {
            if (log.isTraceEnabled()) {
                log.trace((Object)("initializing collection " + MessageHelper.infoString(ce.loadedPersister, ce.loadedKey)));
            }
            CollectionPersister persister = ce.loadedPersister;
            Serializable id = ce.loadedKey;
            Object owner = this.getEntity(new Key(id, this.getPersister(persister.getOwnerClass())));
            collection.beforeInitialize(persister);
            try {
                persister.getInitializer().initialize(id, collection, owner, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("SQLException initializing collection", sqle);
            }
            ce.initialized = true;
            ce.postInitialize(collection);
            if (!writing) {
                persister.cache(id, collection, this);
            }
        }
    }

    public Connection connection() throws HibernateException {
        if (this.connection == null) {
            if (this.connect) {
                this.connection = this.factory.openConnection();
                this.connect = false;
            } else {
                throw new HibernateException("Session is currently disconnected");
            }
        }
        return this.connection;
    }

    public boolean isConnected() {
        return this.connection != null || this.connect;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Connection disconnect() throws HibernateException {
        Connection c;
        block10: {
            block9: {
                log.debug((Object)"disconnecting session");
                try {
                    if (!this.connect) break block9;
                    this.connect = false;
                    Connection connection = null;
                    Object var4_3 = null;
                    if (this.callAfterTransactionCompletionFromDisconnect) {
                        this.afterTransactionCompletion();
                    }
                    return connection;
                }
                catch (Throwable throwable) {
                    block11: {
                        Object var4_6 = null;
                        if (!this.callAfterTransactionCompletionFromDisconnect) break block11;
                        this.afterTransactionCompletion();
                    }
                    throw throwable;
                }
            }
            if (this.connection == null) {
                throw new HibernateException("Session already disconnected");
            }
            if (this.batcher != null) {
                this.batcher.closeStatements();
            }
            c = this.connection;
            this.connection = null;
            if (!this.autoClose) break block10;
            this.factory.closeConnection(c);
            Connection connection = null;
            Object var4_4 = null;
            if (this.callAfterTransactionCompletionFromDisconnect) {
                this.afterTransactionCompletion();
            }
            return connection;
        }
        Connection connection = c;
        Object var4_5 = null;
        if (this.callAfterTransactionCompletionFromDisconnect) {
            this.afterTransactionCompletion();
        }
        return connection;
    }

    public void reconnect() throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        log.debug((Object)"reconnecting session");
        this.connect = true;
    }

    public void reconnect(Connection conn) throws HibernateException {
        if (this.isConnected()) {
            throw new HibernateException("Session already connected");
        }
        this.connection = conn;
    }

    protected void finalize() throws Throwable {
        log.debug((Object)"running Session.finalize()");
        if (this.connection != null) {
            this.afterTransactionCompletion();
            if (this.connection.isClosed()) {
                log.warn((Object)"finalizing unclosed session with closed connection");
            } else {
                log.warn((Object)"unclosed connection");
                if (this.autoClose) {
                    this.connection.close();
                }
            }
        }
    }

    public static void handle(Exception e) throws HibernateException {
        if (e instanceof HibernateException) {
            throw (HibernateException)((Object)e);
        }
        log.error((Object)"Unexpected exception", (Throwable)e);
        throw new HibernateException("Unexpected exception", e);
    }

    public Collection filter(Object collection, String filter) throws HibernateException {
        return this.filter(collection, filter, new Object[1], new Type[1], null, null, null);
    }

    public Collection filter(Object collection, String filter, Object value, Type type) throws HibernateException {
        return this.filter(collection, filter, new Object[]{null, value}, new Type[]{null, type}, null, null, null);
    }

    public Collection filter(Object collection, String filter, Object[] values, Type[] types) throws HibernateException {
        Object[] vals = new Object[values.length + 1];
        Type[] typs = new Type[types.length + 1];
        System.arraycopy(values, 0, vals, 1, values.length);
        System.arraycopy(types, 0, typs, 1, types.length);
        return this.filter(collection, filter, vals, typs, null, null, null);
    }

    private FilterTranslator getFilterTranslator(Object collection, String filter, Object[] values, Type[] types, RowSelection selection, Map namedParams, boolean scalar) throws HibernateException {
        FilterTranslator q;
        if (log.isTraceEnabled()) {
            log.trace((Object)("filter: " + filter));
            if (values.length != 0) {
                log.trace((Object)("parameters: " + StringHelper.toString(values)));
            }
        }
        if (!(collection instanceof PersistentCollection) && (collection = this.getArrayHolder(collection)) == null) {
            throw new TransientObjectException("Collection was not yet persistent");
        }
        PersistentCollection coll = (PersistentCollection)collection;
        CollectionEntry e = this.getCollectionEntry(coll);
        if (e == null) {
            throw new TransientObjectException("Collection was not persistent in this session");
        }
        CollectionPersister roleBeforeFlush = e.loadedPersister;
        if (roleBeforeFlush == null) {
            this.flush();
            if (e.loadedPersister == null) {
                throw new QueryException("The collection was unreferenced");
            }
            q = this.factory.getFilter(filter, e.loadedPersister.getRole(), scalar);
        } else {
            q = this.factory.getFilter(filter, roleBeforeFlush.getRole(), scalar);
            if (this.autoFlushIfRequired(q.getQuerySpaces()) && roleBeforeFlush != e.loadedPersister) {
                if (e.loadedPersister == null) {
                    throw new QueryException("The collection was dereferenced");
                }
                q = this.factory.getFilter(filter, e.loadedPersister.getRole(), scalar);
            }
        }
        values[0] = e.loadedKey;
        types[0] = e.loadedPersister.getKeyType();
        return q;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List filter(Object collection, String filter, Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes) throws HibernateException {
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], values, types, selection, namedParams, false);
            ++i;
        }
        ++this.dontFlushFromFind;
        List results = Collections.EMPTY_LIST;
        try {
            int i2 = 0;
            while (i2 < concreteFilters.length) {
                List currentResults;
                try {
                    currentResults = filters[i2].find(this, values, types, true, selection, namedParams, lockModes);
                }
                catch (SQLException sqle) {
                    throw new JDBCException("Could not execute query", sqle);
                }
                currentResults.addAll(results);
                results = currentResults;
                ++i2;
            }
            Object var16_15 = null;
            --this.dontFlushFromFind;
        }
        catch (Throwable throwable) {
            Object var16_16 = null;
            --this.dontFlushFromFind;
            throw throwable;
        }
        return results;
    }

    public Iterator iterateFilter(Object collection, String filter, Object[] values, Type[] types, RowSelection selection, Map namedParams, Map lockModes) throws HibernateException {
        boolean many;
        String[] concreteFilters = QueryTranslator.concreteQueries(filter, this.factory);
        FilterTranslator[] filters = new FilterTranslator[concreteFilters.length];
        int i = 0;
        while (i < concreteFilters.length) {
            filters[i] = this.getFilterTranslator(collection, concreteFilters[i], values, types, selection, namedParams, true);
            ++i;
        }
        if (filters.length == 0) {
            return Collections.EMPTY_LIST.iterator();
        }
        Iterator result = null;
        Iterator[] results = null;
        boolean bl = many = filters.length > 1;
        if (many) {
            results = new Iterator[filters.length];
        }
        int i2 = 0;
        while (i2 < filters.length) {
            try {
                result = filters[i2].iterate(values, types, selection, namedParams, lockModes, this);
            }
            catch (SQLException sqle) {
                throw new JDBCException("Could not execute query", sqle);
            }
            if (many) {
                results[i2] = result;
            }
            ++i2;
        }
        return many ? new JoinedIterator(results) : result;
    }

    public Criteria createCriteria(Class persistentClass) {
        return new CriteriaImpl(persistentClass, this);
    }

    public List find(CriteriaImpl criteria) throws HibernateException {
        Class persistentClass = criteria.getPersistentClass();
        if (log.isTraceEnabled()) {
            log.trace((Object)("search: " + persistentClass.getName()));
            log.trace((Object)("criteria: " + criteria));
        }
        Loadable persister = (Loadable)this.getPersister(persistentClass);
        CriteriaLoader loader = new CriteriaLoader(persister, this.factory, criteria);
        Serializable[] spaces = persister.getPropertySpaces();
        HashSet<Serializable> set = new HashSet<Serializable>();
        int i = 0;
        while (i < spaces.length) {
            set.add(spaces[i]);
            ++i;
        }
        this.autoFlushIfRequired(set);
        ++this.dontFlushFromFind;
        try {
            List list = loader.list(this);
            Object var10_10 = null;
            --this.dontFlushFromFind;
            return list;
        }
        catch (SQLException sqle) {
            try {
                throw new JDBCException(sqle);
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                --this.dontFlushFromFind;
                throw throwable;
            }
        }
    }

    public boolean contains(Object object) {
        if (object instanceof HibernateProxy) {
            return HibernateProxyHelper.getLazyInitializer((HibernateProxy)object).getSession() == this;
        }
        return this.entries.containsKey(object);
    }

    public void evict(Object object) throws HibernateException {
        if (object instanceof HibernateProxy) {
            Object entity;
            LazyInitializer li = HibernateProxyHelper.getLazyInitializer((HibernateProxy)object);
            Serializable id = li.getIdentifier();
            ClassPersister persister = this.getPersister(li.getPersistentClass());
            Key key = new Key(id, persister);
            this.proxiesByKey.remove(key);
            if (!li.isUninitialized() && (entity = this.removeEntity(key)) != null) {
                this.removeEntry(entity);
                this.doEvict(persister, entity);
            }
        } else {
            EntityEntry e = this.removeEntry(object);
            if (e != null) {
                this.removeEntity(new Key(e.id, e.persister));
                this.doEvict(e.persister, object);
            }
        }
    }

    private void doEvict(ClassPersister persister, Object object) throws HibernateException {
        if (log.isTraceEnabled()) {
            log.trace((Object)("evicting " + MessageHelper.infoString(persister)));
        }
        this.evictCollections(persister.getPropertyValues(object), persister.getPropertyTypes());
        Cascades.cascade((SessionImplementor)this, persister, object, Cascades.ACTION_EVICT, 0);
    }

    private void evictCollections(Object[] values, Type[] types) throws HibernateException {
        int i = 0;
        while (i < types.length) {
            if (values[i] != null) {
                if (types[i].isPersistentCollectionType()) {
                    Object pc = null;
                    if (((PersistentCollectionType)types[i]).isArrayType()) {
                        pc = this.arrayHolders.remove(values[i]);
                    } else if (values[i] instanceof PersistentCollection) {
                        pc = values[i];
                    }
                    if (pc != null && ((PersistentCollection)pc).unsetSession(this)) {
                        this.collections.remove(pc);
                    }
                } else if (types[i].isComponentType()) {
                    AbstractComponentType actype = (AbstractComponentType)types[i];
                    this.evictCollections(actype.getPropertyValues(values[i], this), actype.getSubtypes());
                }
            }
            ++i;
        }
    }

    public Object getVersion(Object entity) {
        return this.getEntry((Object)entity).lastVersion;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class LoadingCollectionEntry {
        PersistentCollection collection;
        boolean initialize;
        Serializable id;

        LoadingCollectionEntry(PersistentCollection collection, Serializable id) {
            this.collection = collection;
            this.id = id;
        }
    }

    public static final class CollectionEntry
    implements CollectionSnapshot,
    Serializable {
        boolean dirty;
        transient boolean reached;
        transient boolean processed;
        transient boolean doupdate;
        transient boolean doremove;
        transient boolean dorecreate;
        boolean initialized;
        transient CollectionPersister currentPersister;
        transient CollectionPersister loadedPersister;
        transient Serializable currentKey;
        Serializable loadedKey;
        Serializable snapshot;
        private String role;

        CollectionEntry() {
            this.dirty = false;
            this.initialized = true;
        }

        CollectionEntry(CollectionPersister loadedPersister, Serializable loadedID, boolean initialized) {
            this.dirty = false;
            this.initialized = initialized;
            this.loadedKey = loadedID;
            this.setLoadedPersister(loadedPersister);
        }

        CollectionEntry(CollectionSnapshot cs, SessionFactoryImplementor factory) throws MappingException {
            this.dirty = cs.getDirty();
            this.snapshot = cs.getSnapshot();
            this.loadedKey = cs.getKey();
            this.setLoadedPersister(factory.getCollectionPersister(cs.getRole()));
            this.initialized = true;
        }

        boolean isDirty(PersistentCollection coll) throws HibernateException {
            if (this.dirty || !coll.isDirectlyAccessible() && !this.loadedPersister.getElementType().isMutable()) {
                return this.dirty;
            }
            return !coll.equalsSnapshot(this.loadedPersister.getElementType());
        }

        void preFlush(PersistentCollection collection) throws HibernateException {
            boolean bl = this.dirty = this.initialized && this.loadedPersister != null && this.isDirty(collection) || !this.initialized && this.dirty;
            if (log.isDebugEnabled() && this.dirty && this.loadedPersister != null) {
                log.debug((Object)("Collection dirty: " + MessageHelper.infoString(this.loadedPersister, this.loadedKey)));
            }
            this.doupdate = false;
            this.doremove = false;
            this.dorecreate = false;
            this.reached = false;
            this.processed = false;
        }

        void postInitialize(PersistentCollection collection) throws HibernateException {
            this.snapshot = collection.getSnapshot(this.loadedPersister);
        }

        void postFlush(PersistentCollection collection) throws HibernateException {
            if (!this.processed) {
                throw new AssertionFailure("Hibernate has a bug processing collections");
            }
            this.loadedKey = this.currentKey;
            this.setLoadedPersister(this.currentPersister);
            this.dirty = false;
            if (this.initialized && (this.doremove || this.dorecreate || this.doupdate)) {
                this.snapshot = collection.getSnapshot(this.loadedPersister);
            }
        }

        public boolean getDirty() {
            return this.dirty;
        }

        public Serializable getKey() {
            return this.loadedKey;
        }

        public String getRole() {
            return this.role;
        }

        public Serializable getSnapshot() {
            return this.snapshot;
        }

        public boolean snapshotIsEmpty() {
            return this.initialized && this.snapshot != null && (this.snapshot instanceof Collection && ((Collection)((Object)this.snapshot)).size() == 0 || this.snapshot instanceof Map && ((Map)((Object)this.snapshot)).size() == 0 || this.snapshot.getClass().isArray() && Array.getLength(this.snapshot) == 0);
        }

        public void setDirty() {
            this.dirty = true;
        }

        void setLoadedPersister(CollectionPersister persister) {
            this.loadedPersister = persister;
            if (persister != null) {
                this.role = persister.getRole();
            }
        }

        public boolean isInitialized() {
            return this.initialized;
        }
    }

    static final class EntityEntry
    implements Serializable {
        LockMode lockMode;
        transient LockMode nextLockMode;
        Status status;
        Serializable id;
        Object[] loadedState;
        Object[] deletedState;
        boolean existsInDatabase;
        Object lastVersion;
        transient Object nextVersion;
        transient ClassPersister persister;
        String className;

        EntityEntry(Status status, Object[] loadedState, Serializable id, Object version, LockMode lockMode, boolean existsInDatabase, ClassPersister persister) {
            this.status = status;
            this.loadedState = loadedState;
            this.id = id;
            this.existsInDatabase = existsInDatabase;
            this.lastVersion = version;
            this.lockMode = lockMode;
            this.persister = persister;
            if (persister != null) {
                this.className = persister.getClassName();
            }
        }

        void postFlush(Object object) throws HibernateException {
            if (this.nextVersion != null) {
                this.lastVersion = this.nextVersion;
                Versioning.setVersion(this.loadedState, this.nextVersion, this.persister);
                this.persister.setPropertyValue(object, this.persister.getVersionProperty(), this.nextVersion);
                this.nextVersion = null;
            }
            if (this.nextLockMode != null) {
                this.lockMode = this.nextLockMode;
                this.nextLockMode = null;
            }
        }

        Object getCurrentVersion() {
            return this.nextVersion == null ? this.lastVersion : this.nextVersion;
        }
    }

    static interface Executable {
        public void execute() throws SQLException, HibernateException;

        public void afterTransactionCompletion() throws HibernateException;

        public Serializable[] getPropertySpaces();
    }

    static final class Status
    implements Serializable {
        private String name;

        Status(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        private Object readResolve() throws ObjectStreamException {
            if (this.name.equals(LOADED.name)) {
                return LOADED;
            }
            if (this.name.equals(DELETED.name)) {
                return DELETED;
            }
            if (this.name.equals(GONE.name)) {
                return GONE;
            }
            if (this.name.equals(LOADING.name)) {
                return LOADING;
            }
            throw new InvalidObjectException("invalid Status");
        }
    }
}

