/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.impl;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import javax.naming.NamingException;
import javax.naming.Reference;
import javax.naming.StringRefAddr;
import javax.xml.transform.Templates;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.stream.StreamSource;
import net.sf.cglib.KeyFactory;
import net.sf.hibernate.AssertionFailure;
import net.sf.hibernate.Databinder;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.Interceptor;
import net.sf.hibernate.JDBCException;
import net.sf.hibernate.MappingException;
import net.sf.hibernate.QueryException;
import net.sf.hibernate.Session;
import net.sf.hibernate.SessionFactory;
import net.sf.hibernate.cache.Timestamper;
import net.sf.hibernate.cfg.Configuration;
import net.sf.hibernate.collection.CollectionPersister;
import net.sf.hibernate.connection.ConnectionProvider;
import net.sf.hibernate.connection.ConnectionProviderFactory;
import net.sf.hibernate.dialect.Dialect;
import net.sf.hibernate.dialect.GenericDialect;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.hql.FilterTranslator;
import net.sf.hibernate.hql.QueryTranslator;
import net.sf.hibernate.id.IdentifierGenerator;
import net.sf.hibernate.id.UUIDHexGenerator;
import net.sf.hibernate.impl.SessionFactoryObjectFactory;
import net.sf.hibernate.impl.SessionImpl;
import net.sf.hibernate.mapping.PersistentClass;
import net.sf.hibernate.metadata.ClassMetadata;
import net.sf.hibernate.metadata.CollectionMetadata;
import net.sf.hibernate.persister.ClassPersister;
import net.sf.hibernate.persister.EntityPersister;
import net.sf.hibernate.persister.NormalizedEntityPersister;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.ps.PreparedStatementCache;
import net.sf.hibernate.transaction.JDBCTransactionFactory;
import net.sf.hibernate.transaction.TransactionFactory;
import net.sf.hibernate.type.Type;
import net.sf.hibernate.util.JDBCExceptionReporter;
import net.sf.hibernate.util.PropertiesHelper;
import net.sf.hibernate.util.ReflectHelper;
import net.sf.hibernate.xml.XMLDatabinder;
import org.apache.commons.collections.ReferenceMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class SessionFactoryImpl
implements SessionFactory,
SessionFactoryImplementor {
    private final String name;
    private final String uuid;
    private final transient Map classPersisters;
    private final transient Map classPersistersByName;
    private final transient Map collectionPersisters;
    private final transient Map namedQueries;
    private final transient Map imports;
    private final transient ConnectionProvider connections;
    private final transient Properties properties;
    private final transient boolean showSql;
    private final transient boolean useOuterJoin;
    private final transient Templates templates;
    private final transient Map querySubstitutions;
    private final transient Dialect dialect;
    private final transient PreparedStatementCache statementCache;
    private final transient TransactionFactory transactionFactory;
    private final transient int jdbcBatchSize;
    private final transient boolean useScrollableResultSets;
    private final transient String defaultSchema;
    private final transient Integer statementFetchSize;
    private final transient Interceptor interceptor;
    private static final IdentifierGenerator UUID_GENERATOR = new UUIDHexGenerator();
    private static final Class[] PERSISTER_CONSTRUCTOR_ARGS = new Class[]{class$net$sf$hibernate$mapping$PersistentClass == null ? (class$net$sf$hibernate$mapping$PersistentClass = SessionFactoryImpl.class$("net.sf.hibernate.mapping.PersistentClass")) : class$net$sf$hibernate$mapping$PersistentClass, class$net$sf$hibernate$engine$SessionFactoryImplementor == null ? (class$net$sf$hibernate$engine$SessionFactoryImplementor = SessionFactoryImpl.class$("net.sf.hibernate.engine.SessionFactoryImplementor")) : class$net$sf$hibernate$engine$SessionFactoryImplementor};
    private static final Log log = LogFactory.getLog((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl")) : class$net$sf$hibernate$impl$SessionFactoryImpl));
    private static final int MAX_STRONG_REF_COUNT = 128;
    private final transient Object[] strongRefs = new Object[128];
    private transient int strongRefIndex = 0;
    private final transient Map softQueryCache = new ReferenceMap(1, 1);
    private static final QueryCacheKeyFactory QUERY_KEY_FACTORY = (QueryCacheKeyFactory)KeyFactory.create((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$QueryCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory), (ClassLoader)(class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$QueryCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory).getClassLoader());
    private static final FilterCacheKeyFactory FILTER_KEY_FACTORY = (FilterCacheKeyFactory)KeyFactory.create((Class)(class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$FilterCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory), (ClassLoader)(class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl$FilterCacheKeyFactory")) : class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory).getClassLoader());
    static /* synthetic */ Class class$net$sf$hibernate$mapping$PersistentClass;
    static /* synthetic */ Class class$net$sf$hibernate$engine$SessionFactoryImplementor;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl;
    static /* synthetic */ Class class$net$sf$hibernate$persister$EntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$persister$NormalizedEntityPersister;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl$QueryCacheKeyFactory;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryImpl$FilterCacheKeyFactory;
    static /* synthetic */ Class class$net$sf$hibernate$impl$SessionFactoryObjectFactory;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SessionFactoryImpl(Configuration cfg, Properties properties, Interceptor interceptor) throws HibernateException {
        log.info((Object)"building session factory");
        if (log.isDebugEnabled()) {
            log.debug((Object)("instantiating session factory with properties: " + properties));
        }
        this.interceptor = interceptor;
        Dialect dl = null;
        try {
            dl = Dialect.getDialect(properties);
            Properties temp = new Properties();
            temp.putAll((Map<?, ?>)dl.getDefaultProperties());
            temp.putAll((Map<?, ?>)properties);
            properties = temp;
        }
        catch (HibernateException he) {
            log.warn((Object)("No dialect set - using GenericDialect: " + he.getMessage()));
            dl = new GenericDialect();
        }
        this.dialect = dl;
        this.connections = ConnectionProviderFactory.newConnectionProvider(properties);
        int cacheSize = PropertiesHelper.getInt("hibernate.statement_cache.size", properties, 0);
        this.statementCache = cacheSize < 1 || this.connections.isStatementCache() ? null : new PreparedStatementCache(cacheSize);
        this.statementFetchSize = PropertiesHelper.getInteger("hibernate.jdbc.fetch_size", properties);
        if (this.statementFetchSize != null) {
            log.info((Object)("JDBC result set fetch size: " + this.statementFetchSize));
        }
        this.useOuterJoin = PropertiesHelper.getBoolean("hibernate.use_outer_join", properties);
        log.info((Object)("Use outer join fetching: " + this.useOuterJoin));
        boolean usrs = PropertiesHelper.getBoolean("hibernate.jdbc.use_scrollable_resultset", properties);
        int batchSize = PropertiesHelper.getInt("hibernate.jdbc.batch_size", properties, 0);
        try {
            Connection conn = this.connections.getConnection();
            try {
                DatabaseMetaData meta = conn.getMetaData();
                boolean bl = usrs = usrs || meta.supportsResultSetType(1004);
                if (batchSize > 0 && !meta.supportsBatchUpdates()) {
                    batchSize = 0;
                }
                Object var11_14 = null;
            }
            catch (Throwable throwable) {
                Object var11_15 = null;
                this.connections.closeConnection(conn);
                throw throwable;
            }
            this.connections.closeConnection(conn);
            {
            }
        }
        catch (SQLException sqle) {
            log.warn((Object)"Could not obtain connection metadata", (Throwable)sqle);
        }
        catch (UnsupportedOperationException uoe) {
            // empty catch block
        }
        this.useScrollableResultSets = usrs;
        this.jdbcBatchSize = batchSize;
        log.info((Object)("Use scrollable result sets: " + this.useScrollableResultSets));
        if (batchSize > 0) {
            log.info((Object)("JDBC 2 max batch size: " + batchSize));
        }
        this.defaultSchema = properties.getProperty("hibernate.default_schema");
        if (this.defaultSchema != null) {
            log.info((Object)("Default schema set to: " + this.defaultSchema));
        }
        this.transactionFactory = this.buildTransactionFactory(properties);
        this.showSql = PropertiesHelper.getBoolean("hibernate.show_sql", properties);
        if (this.showSql) {
            log.info((Object)"echoing all SQL to stdout");
        }
        this.properties = properties;
        this.classPersisters = new HashMap();
        this.classPersistersByName = new HashMap();
        Iterator iter = cfg.getClassMappings();
        while (iter.hasNext()) {
            PersistentClass model = (PersistentClass)iter.next();
            Class persisterClass = model.getPersister();
            ClassPersister cp = persisterClass == null || persisterClass == (class$net$sf$hibernate$persister$EntityPersister == null ? SessionFactoryImpl.class$("net.sf.hibernate.persister.EntityPersister") : class$net$sf$hibernate$persister$EntityPersister) ? new EntityPersister(model, this) : (persisterClass == (class$net$sf$hibernate$persister$NormalizedEntityPersister == null ? SessionFactoryImpl.class$("net.sf.hibernate.persister.NormalizedEntityPersister") : class$net$sf$hibernate$persister$NormalizedEntityPersister) ? new NormalizedEntityPersister(model, this) : this.instantiatePersister(persisterClass, model));
            this.classPersisters.put(model.getPersistentClass(), cp);
            this.classPersistersByName.put(model.getName(), cp);
        }
        this.collectionPersisters = new HashMap();
        iter = cfg.getCollectionMappings();
        while (iter.hasNext()) {
            net.sf.hibernate.mapping.Collection map = (net.sf.hibernate.mapping.Collection)iter.next();
            this.collectionPersisters.put(map.getRole(), new CollectionPersister(map, cfg, this));
        }
        iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ((ClassPersister)iter.next()).postInstantiate(this);
        }
        String xsltInputFile = properties.getProperty("hibernate.xml.output_stylesheet");
        Templates tmpl = null;
        try {
            InputStream stream;
            if (xsltInputFile != null) {
                stream = this.getClass().getResourceAsStream(xsltInputFile);
                if (stream == null) {
                    stream = new FileInputStream(xsltInputFile);
                }
            } else {
                stream = this.getClass().getClassLoader().getResourceAsStream("net/sf/hibernate/hibernate-default.xslt");
            }
            tmpl = TransformerFactory.newInstance().newTemplates(new StreamSource(stream));
        }
        catch (Exception e) {
            log.warn((Object)"Problem opening output stylesheet - databinding disabled", (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError tfce) {
            log.warn((Object)"no XSLT implementation found - databinding disabled");
        }
        this.templates = tmpl;
        this.name = properties.getProperty("hibernate.session_factory_name");
        try {
            this.uuid = (String)((Object)UUID_GENERATOR.generate(null, null));
        }
        catch (Exception e) {
            throw new AssertionFailure("Could not generate UUID");
        }
        SessionFactoryObjectFactory.addInstance(this.uuid, this.name, this, properties);
        this.querySubstitutions = PropertiesHelper.toMap("hibernate.query.substitutions", " ,=;:\n\t\r\f", properties);
        log.info((Object)("Query language substitutions: " + this.querySubstitutions));
        this.namedQueries = new HashMap(cfg.getNamedQueries());
        this.imports = new HashMap(cfg.getImports());
        log.debug((Object)"instantiated session factory");
    }

    private synchronized Object get(Object key) {
        Object result = this.softQueryCache.get(key);
        if (result != null) {
            this.strongRefs[++this.strongRefIndex % 128] = result;
        }
        return result;
    }

    private synchronized void put(Object key, Object value) {
        this.softQueryCache.put(key, value);
        this.strongRefs[++this.strongRefIndex % 128] = value;
    }

    public QueryTranslator getQuery(String query) throws QueryException, MappingException {
        return this.getQuery(query, false);
    }

    public QueryTranslator getShallowQuery(String query) throws QueryException, MappingException {
        return this.getQuery(query, true);
    }

    private QueryTranslator getQuery(String query, boolean shallow) throws QueryException, MappingException {
        Object cacheKey = QUERY_KEY_FACTORY.newInstance(query, shallow);
        QueryTranslator q = (QueryTranslator)this.get(cacheKey);
        if (q == null) {
            q = new QueryTranslator();
            this.put(cacheKey, q);
        }
        q.compile(this, query, this.querySubstitutions, shallow);
        return q;
    }

    public FilterTranslator getFilter(String query, String collectionRole, boolean scalar) throws QueryException, MappingException {
        Object cacheKey = FILTER_KEY_FACTORY.newInstance(collectionRole, query, scalar);
        FilterTranslator q = (FilterTranslator)this.get(cacheKey);
        if (q == null) {
            q = new FilterTranslator();
            this.put(cacheKey, q);
        }
        q.compile(collectionRole, this, query, this.querySubstitutions, scalar);
        return q;
    }

    private Session openSession(Connection connection, boolean autoClose, long timestamp, Interceptor interceptor) {
        return new SessionImpl(connection, this, autoClose, timestamp, interceptor);
    }

    public Session openSession(Connection connection, Interceptor interceptor) {
        return this.openSession(connection, false, Long.MIN_VALUE, interceptor);
    }

    public Session openSession(Interceptor interceptor) throws HibernateException {
        long timestamp = Timestamper.next();
        return this.openSession(null, true, timestamp, interceptor);
    }

    public Session openSession(Connection connection) {
        return this.openSession(connection, this.interceptor);
    }

    public Session openSession() throws HibernateException {
        return this.openSession(this.interceptor);
    }

    public Connection openConnection() throws HibernateException {
        try {
            return this.connections.getConnection();
        }
        catch (SQLException sqle) {
            throw new JDBCException("Cannot open connection", sqle);
        }
    }

    public void closeConnection(Connection conn) throws HibernateException {
        try {
            JDBCExceptionReporter.logWarnings(conn.getWarnings());
            conn.clearWarnings();
            this.connections.closeConnection(conn);
        }
        catch (SQLException sqle) {
            throw new JDBCException("Cannot close connection", sqle);
        }
    }

    public ClassPersister getPersister(String className) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersistersByName.get(className);
        if (result == null) {
            throw new MappingException("No persister for: " + className);
        }
        return result;
    }

    public ClassPersister getPersister(Class theClass) throws MappingException {
        ClassPersister result = (ClassPersister)this.classPersisters.get(theClass);
        if (result == null) {
            throw new MappingException("No persister for: " + theClass.getName());
        }
        return result;
    }

    public CollectionPersister getCollectionPersister(String role) throws MappingException {
        CollectionPersister result = (CollectionPersister)this.collectionPersisters.get(role);
        if (result == null) {
            throw new MappingException("No persister for collection role: " + role);
        }
        return result;
    }

    public Databinder openDatabinder() throws HibernateException {
        if (this.templates == null) {
            throw new HibernateException("No output stylesheet configured. Use the property hibernate.output_stylesheet and ensure xalan.jar is in classpath");
        }
        try {
            return new XMLDatabinder(this, this.templates.newTransformer());
        }
        catch (Exception e) {
            log.error((Object)"Could not open Databinder", (Throwable)e);
            throw new HibernateException("Could not open Databinder", e);
        }
    }

    public Dialect getDialect() {
        return this.dialect;
    }

    private TransactionFactory buildTransactionFactory(Properties transactionProps) throws HibernateException {
        TransactionFactory factory;
        String strategyClassName = transactionProps.getProperty("hibernate.transaction.factory_class");
        if (strategyClassName == null) {
            return new JDBCTransactionFactory();
        }
        log.info((Object)("Transaction strategy: " + strategyClassName));
        try {
            factory = (TransactionFactory)ReflectHelper.classForName(strategyClassName).newInstance();
        }
        catch (ClassNotFoundException e) {
            log.error((Object)"TransactionFactory class not found", (Throwable)e);
            throw new HibernateException("TransactionFactory class not found: " + strategyClassName);
        }
        catch (IllegalAccessException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        catch (InstantiationException e) {
            log.error((Object)"Failed to instantiate TransactionFactory", (Throwable)e);
            throw new HibernateException("Failed to instantiate TransactionFactory: " + e);
        }
        factory.configure(transactionProps);
        return factory;
    }

    public TransactionFactory getTransactionFactory() {
        return this.transactionFactory;
    }

    public Reference getReference() throws NamingException {
        log.debug((Object)"Returning a Reference to the SessionFactory");
        return new Reference((class$net$sf$hibernate$impl$SessionFactoryImpl == null ? (class$net$sf$hibernate$impl$SessionFactoryImpl = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryImpl")) : class$net$sf$hibernate$impl$SessionFactoryImpl).getName(), new StringRefAddr("uuid", this.uuid), (class$net$sf$hibernate$impl$SessionFactoryObjectFactory == null ? (class$net$sf$hibernate$impl$SessionFactoryObjectFactory = SessionFactoryImpl.class$("net.sf.hibernate.impl.SessionFactoryObjectFactory")) : class$net$sf$hibernate$impl$SessionFactoryObjectFactory).getName(), null);
    }

    private Object readResolve() throws ObjectStreamException {
        log.trace((Object)"Resolving serialized SessionFactory");
        Object result = SessionFactoryObjectFactory.getInstance(this.uuid);
        if (result == null) {
            result = SessionFactoryObjectFactory.getNamedInstance(this.name);
            if (result == null) {
                throw new InvalidObjectException("Could not find a SessionFactory named: " + this.name);
            }
            log.debug((Object)"resolved SessionFactory by name");
        } else {
            log.debug((Object)"resolved SessionFactory by uid");
        }
        return result;
    }

    public PreparedStatement getPreparedStatement(Connection conn, String sql, boolean scrollable) throws SQLException {
        if (scrollable && !this.useScrollableResultSets) {
            throw new AssertionFailure("Hibernate tried to grab a scrollable result set when it knew there were none");
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)((scrollable ? "scrollable " : "") + "prepared statement get: " + sql));
        }
        if (this.showSql) {
            System.out.println("Hibernate: " + sql);
        }
        if (this.statementCache != null) {
            return this.statementCache.getPreparedStatement(sql, conn, scrollable);
        }
        try {
            log.trace((Object)"preparing statement");
            return scrollable ? conn.prepareStatement(sql, 1004, 1007) : conn.prepareStatement(sql);
        }
        catch (SQLException sqle) {
            JDBCExceptionReporter.logExceptions(sqle);
            throw sqle;
        }
    }

    public void closePreparedStatement(PreparedStatement ps) throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.closePreparedStatement(ps);
        } else {
            try {
                log.trace((Object)"closing statement");
                ps.close();
            }
            catch (SQLException sqle) {
                JDBCExceptionReporter.logExceptions(sqle);
                throw sqle;
            }
        }
    }

    public boolean useJdbcBatch() {
        return this.jdbcBatchSize > 0;
    }

    public int getJdbcBatchSize() {
        return this.jdbcBatchSize;
    }

    public boolean useScrollableResultSets() {
        return this.useScrollableResultSets;
    }

    public boolean enableJoinedFetch() {
        return this.useOuterJoin;
    }

    public String getNamedQuery(String name) throws MappingException {
        String queryString = (String)this.namedQueries.get(name);
        if (queryString == null) {
            throw new MappingException("Named query not known: " + name);
        }
        return queryString;
    }

    public Type getIdentifierType(Class ObjectClass) throws MappingException {
        return this.getPersister(ObjectClass).getIdentifierType();
    }

    private final void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        log.trace((Object)"deserializing");
        in.defaultReadObject();
        log.debug((Object)("deserialized: " + this.uuid));
    }

    private final void writeObject(ObjectOutputStream out) throws IOException {
        log.debug((Object)("serializing: " + this.uuid));
        out.defaultWriteObject();
        log.trace((Object)"serialized");
    }

    public Type[] getReturnTypes(String queryString) throws HibernateException {
        String[] queries = QueryTranslator.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getShallowQuery(queries[0]).getReturnTypes();
    }

    public Collection getNamedParameters(String queryString) throws HibernateException {
        String[] queries = QueryTranslator.concreteQueries(queryString, this);
        if (queries.length == 0) {
            throw new HibernateException("Query does not refer to any persistent classes: " + queryString);
        }
        return this.getShallowQuery(queries[0]).getNamedParameters();
    }

    public String getDefaultSchema() {
        return this.defaultSchema;
    }

    public void setFetchSize(PreparedStatement statement) throws SQLException {
        if (this.statementFetchSize != null) {
            statement.setFetchSize(this.statementFetchSize);
        }
    }

    private ClassPersister instantiatePersister(Class persisterClass, PersistentClass model) throws HibernateException {
        Constructor pc;
        try {
            pc = persisterClass.getConstructor(PERSISTER_CONSTRUCTOR_ARGS);
        }
        catch (Exception e) {
            throw new MappingException("Could not get constructor for " + persisterClass.getName(), e);
        }
        try {
            return (ClassPersister)pc.newInstance(model, this);
        }
        catch (InvocationTargetException ite) {
            Throwable e = ite.getTargetException();
            if (e instanceof HibernateException) {
                throw (HibernateException)((Object)e);
            }
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
        catch (Exception e) {
            throw new MappingException("Could not instantiate persister " + persisterClass.getName(), e);
        }
    }

    public ClassMetadata getClassMetadata(Class persistentClass) throws HibernateException {
        return this.getPersister(persistentClass).getClassMetadata();
    }

    public CollectionMetadata getCollectionMetadata(String roleName) throws HibernateException {
        return this.getCollectionPersister(roleName);
    }

    public String[] getImplementors(Class clazz) {
        ArrayList<String> results = new ArrayList<String>();
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            ClassPersister p = (ClassPersister)iter.next();
            if (!(p instanceof Queryable)) continue;
            Queryable q = (Queryable)p;
            String className = q.getClassName();
            boolean isMappedClass = clazz.equals(q.getMappedClass());
            if (q.isExplicitPolymorphism()) {
                if (!isMappedClass) continue;
                return new String[]{className};
            }
            if (isMappedClass) {
                results.add(className);
                continue;
            }
            if (!clazz.isAssignableFrom(q.getMappedClass()) || q.isInherited() && clazz.isAssignableFrom(q.getMappedSuperclass())) continue;
            results.add(className);
        }
        return results.toArray(new String[results.size()]);
    }

    public String getImportedClassName(String name) {
        String result = (String)this.imports.get(name);
        return result == null ? name : result;
    }

    public Map getAllClassMetadata() throws HibernateException {
        return Collections.unmodifiableMap(this.classPersisters);
    }

    public Map getAllCollectionMetadata() throws HibernateException {
        return Collections.unmodifiableMap(this.collectionPersisters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws HibernateException {
        Object p;
        log.info((Object)"closing");
        Iterator iter = this.classPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (ClassPersister)iter.next();
            if (!p.hasCache()) continue;
            p.getCache().destroy();
        }
        iter = this.collectionPersisters.values().iterator();
        while (iter.hasNext()) {
            p = (CollectionPersister)iter.next();
            if (!((CollectionPersister)p).hasCache()) continue;
            ((CollectionPersister)p).getCache().destroy();
        }
        if (this.statementCache != null) {
            this.statementCache.close();
        }
        try {
            this.connections.close();
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
            throw throwable;
        }
        SessionFactoryObjectFactory.removeInstance(this.uuid, this.name, this.properties);
    }

    public void evict(Class persistentClass, Serializable id) throws HibernateException {
        ClassPersister p = this.getPersister(persistentClass);
        if (p.hasCache()) {
            p.getCache().remove(id);
        }
    }

    public void evict(Class persistentClass) throws HibernateException {
        ClassPersister p = this.getPersister(persistentClass);
        if (p.hasCache()) {
            p.getCache().clear();
        }
    }

    public void evictCollection(String roleName, Serializable id) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            p.getCache().remove(id);
        }
    }

    public void evictCollection(String roleName) throws HibernateException {
        CollectionPersister p = this.getCollectionPersister(roleName);
        if (p.hasCache()) {
            p.getCache().clear();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static interface FilterCacheKeyFactory {
        public Object newInstance(String var1, String var2, boolean var3);
    }

    static interface QueryCacheKeyFactory {
        public Object newInstance(String var1, boolean var2);
    }
}

