/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.AndExpression;
import net.sf.hibernate.expression.BetweenExpression;
import net.sf.hibernate.expression.Conjunction;
import net.sf.hibernate.expression.Disjunction;
import net.sf.hibernate.expression.EqExpression;
import net.sf.hibernate.expression.EqPropertyExpression;
import net.sf.hibernate.expression.GeExpression;
import net.sf.hibernate.expression.GtExpression;
import net.sf.hibernate.expression.IlikeExpression;
import net.sf.hibernate.expression.InExpression;
import net.sf.hibernate.expression.LeExpression;
import net.sf.hibernate.expression.LePropertyExpression;
import net.sf.hibernate.expression.LikeExpression;
import net.sf.hibernate.expression.LtExpression;
import net.sf.hibernate.expression.LtPropertyExpression;
import net.sf.hibernate.expression.NotExpression;
import net.sf.hibernate.expression.NotNullExpression;
import net.sf.hibernate.expression.NullExpression;
import net.sf.hibernate.expression.OrExpression;
import net.sf.hibernate.expression.SQLExpression;
import net.sf.hibernate.persister.Queryable;
import net.sf.hibernate.type.Type;

public abstract class Expression {
    private static final Object[] NO_OBJECTS = new Object[0];
    private static final Type[] NO_TYPES = new Type[0];

    public static Expression eq(String propertyName, Object value) {
        return new EqExpression(propertyName, value);
    }

    public static Expression like(String propertyName, Object value) {
        return new LikeExpression(propertyName, value);
    }

    public static Expression ilike(String propertyName, Object value) {
        return new IlikeExpression(propertyName, value);
    }

    public static Expression gt(String propertyName, Object value) {
        return new GtExpression(propertyName, value);
    }

    public static Expression lt(String propertyName, Object value) {
        return new LtExpression(propertyName, value);
    }

    public static Expression le(String propertyName, Object value) {
        return new LeExpression(propertyName, value);
    }

    public static Expression ge(String propertyName, Object value) {
        return new GeExpression(propertyName, value);
    }

    public static Expression between(String propertyName, Object lo, Object hi) {
        return new BetweenExpression(propertyName, lo, hi);
    }

    public static Expression in(String propertyName, Object[] values) {
        return new InExpression(propertyName, values);
    }

    public static Expression in(String propertyName, Collection values) {
        return new InExpression(propertyName, values.toArray());
    }

    public static Expression isNull(String propertyName) {
        return new NullExpression(propertyName);
    }

    public static Expression eqProperty(String propertyName, String otherPropertyName) {
        return new EqPropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression ltProperty(String propertyName, String otherPropertyName) {
        return new LtPropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression leProperty(String propertyName, String otherPropertyName) {
        return new LePropertyExpression(propertyName, otherPropertyName);
    }

    public static Expression isNotNull(String propertyName) {
        return new NotNullExpression(propertyName);
    }

    public static Expression and(Expression lhs, Expression rhs) {
        return new AndExpression(lhs, rhs);
    }

    public static Expression or(Expression lhs, Expression rhs) {
        return new OrExpression(lhs, rhs);
    }

    public static Expression not(Expression expression) {
        return new NotExpression(expression);
    }

    public static Expression sql(String sql, Object[] values, Type[] types) {
        return new SQLExpression(sql, values, types);
    }

    public static Expression sql(String sql, Object value, Type type) {
        return new SQLExpression(sql, new Object[]{value}, new Type[]{type});
    }

    public static Expression sql(String sql) {
        return new SQLExpression(sql, NO_OBJECTS, NO_TYPES);
    }

    public static Conjunction conjunction() {
        return new Conjunction();
    }

    public static Disjunction disjunction() {
        return new Disjunction();
    }

    public static Expression allEq(Map propertyNameValues) {
        Conjunction conj = Expression.conjunction();
        Iterator iter = propertyNameValues.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry me = iter.next();
            conj.add(Expression.eq((String)me.getKey(), me.getValue()));
        }
        return conj;
    }

    public abstract String toSqlString(SessionFactoryImplementor var1, Class var2, String var3) throws HibernateException;

    public abstract TypedValue[] getTypedValues(SessionFactoryImplementor var1, Class var2) throws HibernateException;

    public abstract String toString();

    protected static String[] getColumns(SessionFactoryImplementor sessionFactory, Class persistentClass, String property, String alias) throws HibernateException {
        return ((Queryable)sessionFactory.getPersister(persistentClass)).toColumns(alias, property);
    }

    protected static TypedValue getTypedValue(SessionFactoryImplementor sessionFactory, Class persistentClass, String propertyName, Object value) throws HibernateException {
        return new TypedValue(((Queryable)sessionFactory.getPersister(persistentClass)).getPropertyType(propertyName), value);
    }
}

