/*
 * Decompiled with CFR 0.152.
 */
package com.sun.tools.javac.util;

import com.sun.tools.javac.api.DiagnosticFormatter;
import com.sun.tools.javac.api.Formattable;
import com.sun.tools.javac.file.PathFileObject;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.util.AbstractDiagnosticFormatter;
import com.sun.tools.javac.util.JCDiagnostic;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Locale;
import javax.tools.JavaFileObject;

public final class RawDiagnosticFormatter
extends AbstractDiagnosticFormatter {
    public RawDiagnosticFormatter(Options options) {
        super(null, new AbstractDiagnosticFormatter.SimpleConfiguration(options, EnumSet.of(DiagnosticFormatter.Configuration.DiagnosticPart.SUMMARY, DiagnosticFormatter.Configuration.DiagnosticPart.DETAILS, DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS)));
    }

    @Override
    public String formatDiagnostic(JCDiagnostic jCDiagnostic, Locale locale) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            if (jCDiagnostic.getPosition() != -1L) {
                stringBuilder.append(this.formatSource(jCDiagnostic, false, (Locale)null));
                stringBuilder.append(':');
                stringBuilder.append(this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.LINE, (Locale)null));
                stringBuilder.append(':');
                stringBuilder.append(this.formatPosition(jCDiagnostic, DiagnosticFormatter.PositionKind.COLUMN, (Locale)null));
                stringBuilder.append(':');
            } else if (jCDiagnostic.getSource() != null && jCDiagnostic.getSource().getKind() == JavaFileObject.Kind.CLASS) {
                stringBuilder.append(this.formatSource(jCDiagnostic, false, (Locale)null));
                stringBuilder.append(":-:-:");
            } else {
                stringBuilder.append('-');
            }
            stringBuilder.append(' ');
            stringBuilder.append(this.formatMessage(jCDiagnostic, (Locale)null));
            if (this.displaySource(jCDiagnostic)) {
                stringBuilder.append("\n");
                stringBuilder.append(this.formatSourceLine(jCDiagnostic, 0));
            }
            return stringBuilder.toString();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String formatMessage(JCDiagnostic jCDiagnostic, Locale locale) {
        List<String> list;
        StringBuilder stringBuilder = new StringBuilder();
        Collection<String> collection = this.formatArguments(jCDiagnostic, locale);
        stringBuilder.append(this.localize(null, jCDiagnostic.getCode(), collection.toArray()));
        if (jCDiagnostic.isMultiline() && ((AbstractCollection)((Object)this.getConfiguration().getVisible())).contains((Object)DiagnosticFormatter.Configuration.DiagnosticPart.SUBDIAGNOSTICS) && (list = this.formatSubdiagnostics(jCDiagnostic, null)).nonEmpty()) {
            String string = "";
            stringBuilder.append(",{");
            for (String string2 : this.formatSubdiagnostics(jCDiagnostic, null)) {
                stringBuilder.append(string);
                stringBuilder.append("(");
                stringBuilder.append(string2);
                stringBuilder.append(")");
                string = ",";
            }
            stringBuilder.append('}');
        }
        return stringBuilder.toString();
    }

    @Override
    protected String formatArgument(JCDiagnostic jCDiagnostic, Object object, Locale locale) {
        String string;
        if (object instanceof Formattable) {
            string = object.toString();
        } else if (object instanceof JCTree.JCExpression) {
            JCTree.JCExpression jCExpression = (JCTree.JCExpression)object;
            string = "@" + jCExpression.getStartPosition();
        } else {
            string = object instanceof PathFileObject ? ((PathFileObject)object).getShortName() : super.formatArgument(jCDiagnostic, object, null);
        }
        return object instanceof JCDiagnostic ? "(" + string + ")" : string;
    }

    @Override
    protected String localize(Locale locale, String string, Object ... objectArray) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(string);
        String string2 = ": ";
        for (Object object : objectArray) {
            stringBuilder.append(string2);
            stringBuilder.append(object);
            string2 = ", ";
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean isRaw() {
        return true;
    }
}

