/*
 * Decompiled with CFR 0.152.
 */
package gnu.io.rfc2217;

import gnu.io.rfc2217.ComPortCommand;
import gnu.io.rfc2217.ComPortCommandSwitch;

public class ControlCommand
extends ComPortCommand {
    private int control;

    public ControlCommand(int[] bytes) {
        super("SET-CONTROL", 5, bytes);
        this.control = bytes[2];
        switch (this.control) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: {
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid control value " + this.control);
            }
        }
    }

    public ControlCommand(boolean client, int command) {
        this(new int[]{44, client ? 5 : 105, command});
    }

    @Override
    public String toString() {
        String desc;
        switch (this.control) {
            case 0: {
                desc = "OUTBOUND-FLOW-REQUEST";
                break;
            }
            case 1: {
                desc = "OUTBOUND-FLOW-NONE";
                break;
            }
            case 2: {
                desc = "OUTBOUND-FLOW-XON-XOFF";
                break;
            }
            case 3: {
                desc = "OUTBOUND-FLOW-HARDWARE";
                break;
            }
            case 4: {
                desc = "OUTBOUND-BREAK-REQUEST";
                break;
            }
            case 5: {
                desc = "OUTBOUND-BREAK-ON";
                break;
            }
            case 6: {
                desc = "OUTBOUND-BREAK-OFF";
                break;
            }
            case 7: {
                desc = "OUTBOUND-DTR-REQUEST";
                break;
            }
            case 8: {
                desc = "OUTBOUND-DTR-ON";
                break;
            }
            case 9: {
                desc = "OUTBOUND-DTR-OFF";
                break;
            }
            case 10: {
                desc = "OUTBOUND-RTS-REQUEST";
                break;
            }
            case 11: {
                desc = "OUTBOUND-RTS-ON";
                break;
            }
            case 12: {
                desc = "OUTBOUND-RTS-OFF";
                break;
            }
            case 13: {
                desc = "INBOUND-FLOW-REQUEST";
                break;
            }
            case 14: {
                desc = "INBOUND-FLOW-NONE";
                break;
            }
            case 15: {
                desc = "INBOUND-FLOW-XON-OFF";
                break;
            }
            case 16: {
                desc = "INBOUND-FLOW-HARDWARE";
                break;
            }
            case 17: {
                desc = "OUTBOUND-FLOW-DCD";
                break;
            }
            case 18: {
                desc = "INBOUND-FLOW-DTR";
                break;
            }
            case 19: {
                desc = "OUTBOUND-FLOW-DSR";
                break;
            }
            default: {
                desc = "?";
            }
        }
        return this.getName() + " " + desc;
    }

    @Override
    public void visit(ComPortCommandSwitch sw) {
        sw.caseControl(this);
    }

    public int getControl() {
        return this.control;
    }

    @Override
    int getMinPayloadLength() {
        return 1;
    }

    @Override
    int getMaxPayloadLength() {
        return 1;
    }
}

