/*
 * Decompiled with CFR 0.152.
 */
package org.pgpainless.encryption_signing;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.Nonnull;
import org.bouncycastle.openpgp.PGPException;
import org.pgpainless.PGPainless;
import org.pgpainless.algorithm.CompressionAlgorithm;
import org.pgpainless.algorithm.SymmetricKeyAlgorithm;
import org.pgpainless.algorithm.negotiation.SymmetricKeyAlgorithmNegotiator;
import org.pgpainless.encryption_signing.EncryptionBuilderInterface;
import org.pgpainless.encryption_signing.EncryptionOptions;
import org.pgpainless.encryption_signing.EncryptionStream;
import org.pgpainless.encryption_signing.ProducerOptions;
import org.pgpainless.key.SubkeyIdentifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionBuilder
implements EncryptionBuilderInterface {
    private static final Logger LOGGER = LoggerFactory.getLogger(EncryptionBuilder.class);
    private OutputStream outputStream;

    @Override
    public EncryptionBuilderInterface.WithOptions onOutputStream(@Nonnull OutputStream outputStream) {
        this.outputStream = outputStream;
        return new WithOptionsImpl();
    }

    public static SymmetricKeyAlgorithm negotiateSymmetricEncryptionAlgorithm(EncryptionOptions encryptionOptions) {
        ArrayList<Set<SymmetricKeyAlgorithm>> preferences = new ArrayList<Set<SymmetricKeyAlgorithm>>();
        for (SubkeyIdentifier key : encryptionOptions.getKeyViews().keySet()) {
            preferences.add(encryptionOptions.getKeyViews().get(key).getPreferredSymmetricKeyAlgorithms());
        }
        SymmetricKeyAlgorithm algorithm = SymmetricKeyAlgorithmNegotiator.byPopularity().negotiate(PGPainless.getPolicy().getSymmetricKeyEncryptionAlgorithmPolicy(), encryptionOptions.getEncryptionAlgorithmOverride(), preferences);
        LOGGER.debug("Negotiation resulted in {} being the symmetric encryption algorithm of choice.", (Object)algorithm);
        return algorithm;
    }

    public static CompressionAlgorithm negotiateCompressionAlgorithm(ProducerOptions producerOptions) {
        CompressionAlgorithm compressionAlgorithmOverride = producerOptions.getCompressionAlgorithmOverride();
        if (compressionAlgorithmOverride != null) {
            return compressionAlgorithmOverride;
        }
        return PGPainless.getPolicy().getCompressionAlgorithmPolicy().defaultCompressionAlgorithm();
    }

    class WithOptionsImpl
    implements EncryptionBuilderInterface.WithOptions {
        WithOptionsImpl() {
        }

        @Override
        public EncryptionStream withOptions(ProducerOptions options) throws PGPException, IOException {
            if (options == null) {
                throw new NullPointerException("ProducerOptions cannot be null.");
            }
            return new EncryptionStream(EncryptionBuilder.this.outputStream, options);
        }
    }
}

