/*
 * Decompiled with CFR 0.152.
 */
package org.jivesoftware.smackx.muc;

import org.jivesoftware.smack.SmackException;
import org.jivesoftware.smackx.muc.MultiUserChat;
import org.jxmpp.jid.DomainBareJid;

public abstract class MultiUserChatException
extends SmackException {
    private static final long serialVersionUID = 1L;

    protected MultiUserChatException() {
    }

    protected MultiUserChatException(String message) {
        super(message);
    }

    public static class NotAMucServiceException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        NotAMucServiceException(DomainBareJid service) {
            super("Can't perform operation because " + String.valueOf(service) + " does not provide a MUC (XEP-45) service.");
        }

        NotAMucServiceException(MultiUserChat multiUserChat) {
            super("Can not join '" + String.valueOf(multiUserChat.getRoom()) + "', because '" + String.valueOf(multiUserChat.getRoom().asDomainBareJid()) + "' does not provide a MUC (XEP-45) service.");
        }
    }

    public static class MucConfigurationNotSupportedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        public MucConfigurationNotSupportedException(String configString) {
            super("The MUC configuration '" + configString + "' is not supported by the MUC service");
        }
    }

    public static class MissingMucCreationAcknowledgeException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;
    }

    public static class MucNotJoinedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;

        public MucNotJoinedException(MultiUserChat multiUserChat) {
            super("Client not currently joined " + String.valueOf(multiUserChat.getRoom()));
        }
    }

    public static class MucAlreadyJoinedException
    extends MultiUserChatException {
        private static final long serialVersionUID = 1L;
    }
}

