/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.editors.erd.command;

import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.gef.commands.Command;
import org.jkiss.dbeaver.model.erd.ERDNote;
import org.jkiss.dbeaver.ui.editors.erd.part.DiagramPart;
import org.jkiss.dbeaver.ui.editors.erd.part.NotePart;

public class NoteCreateCommand
extends Command {
    private DiagramPart diagramPart;
    private ERDNote note;
    private Point location;
    private Dimension size;

    public NoteCreateCommand(DiagramPart diagram, ERDNote note, Point location, Dimension size) {
        this.diagramPart = diagram;
        this.note = note;
        this.location = location;
        this.size = size;
    }

    public void execute() {
        this.diagramPart.getDiagram().addNote(this.note, true);
        if (this.location != null) {
            for (Object diagramChild : this.diagramPart.getChildren()) {
                NotePart notePart;
                if (!(diagramChild instanceof NotePart) || (notePart = (NotePart)diagramChild).getNote() != this.note) continue;
                Dimension size = this.size;
                if (size == null || size.width <= 0 || size.height <= 0) {
                    size = notePart.getFigure().getPreferredSize();
                }
                Rectangle newBounds = new Rectangle(this.location.x, this.location.y, size.width, size.height);
                notePart.modifyBounds(newBounds);
                break;
            }
        }
    }

    public void undo() {
        this.diagramPart.getDiagram().removeNote(this.note, true);
    }
}

