#
#  Copyright (c) 2018-2025, Intel Corporation
#
#  SPDX-License-Identifier: BSD-3-Clause

#
# ispc ADDISPCTest.cmake
#
function(add_ispc_example)
    set(options USE_COMMON_SETTINGS)
    set(oneValueArgs NAME ISPC_SRC_NAME DATA_DIR)
    set(multiValueArgs ISPC_IA_TARGETS ISPC_ARM_TARGETS ISPC_FLAGS TARGET_SOURCES LIBRARIES DATA_FILES RUN_ARGS)
    cmake_parse_arguments("example" "${options}" "${oneValueArgs}" "${multiValueArgs}" ${ARGN} )

    set(ISPC_KNOWN_TARGETS "sse2" "sse4" "avx1-" "avx2" "avx512skx" "neon")
    set(ISPC_HEADER_NAME "${CMAKE_CURRENT_BINARY_DIR}/${ISPC_SRC_NAME}_ispc.h")
    set(ISPC_OBJ_NAME "${CMAKE_CURRENT_BINARY_DIR}/${ISPC_SRC_NAME}.ispc${CMAKE_CXX_OUTPUT_EXTENSION}")
    set(ISPC_FLAGS ${example_ISPC_FLAGS})
    if (UNIX)
      list(APPEND ISPC_FLAGS --pic)
    endif()

    # Collect list of expected outputs
    list(APPEND ISPC_BUILD_OUTPUT ${ISPC_HEADER_NAME} ${ISPC_OBJ_NAME})
    if (example_USE_COMMON_SETTINGS)
        if ("${ISPC_ARCH}" MATCHES "x86")
            set(ISPC_TARGETS ${example_ISPC_IA_TARGETS})
            string(FIND ${example_ISPC_IA_TARGETS} "," MULTI_TARGET)
            if (${MULTI_TARGET} GREATER -1)
                foreach (ispc_target ${ISPC_KNOWN_TARGETS})
                    string(FIND ${example_ISPC_IA_TARGETS} ${ispc_target} FOUND_TARGET)
                    if (${FOUND_TARGET} GREATER -1)
                        set(OUTPUT_TARGET ${ispc_target})
                        if (${ispc_target} STREQUAL "avx1-")
                            set(OUTPUT_TARGET "avx")
                        endif()
                        list(APPEND ISPC_BUILD_OUTPUT "${CMAKE_CURRENT_BINARY_DIR}/${ISPC_SRC_NAME}_ispc_${OUTPUT_TARGET}.h"
                                    "${CMAKE_CURRENT_BINARY_DIR}/${ISPC_SRC_NAME}.ispc_${OUTPUT_TARGET}${CMAKE_CXX_OUTPUT_EXTENSION}")
                    endif()
                endforeach()
            endif()
        elseif ("${ISPC_ARCH}" STREQUAL "arm" OR "${ISPC_ARCH}" STREQUAL "aarch64")
            set(ISPC_TARGETS ${example_ISPC_ARM_TARGETS})
        else()
            message(FATAL_ERROR "Unknown architecture ${ISPC_ARCH}")
        endif()
    else()
        if ("${ISPC_ARCH}" MATCHES "x86")
            set(ISPC_TARGETS ${example_ISPC_IA_TARGETS})
        elseif ("${ISPC_ARCH}" STREQUAL "arm" OR "${ISPC_ARCH}" STREQUAL "aarch64")
            set(ISPC_TARGETS ${example_ISPC_ARM_TARGETS})
        else()
            message(FATAL_ERROR "Unknown architecture ${ISPC_ARCH}")
        endif()

    endif()
    # ISPC command
    add_custom_command(OUTPUT ${ISPC_BUILD_OUTPUT}
        COMMAND ${ISPC_EXECUTABLE} ${CMAKE_CURRENT_SOURCE_DIR}/${ISPC_SRC_NAME}.ispc ${ISPC_FLAGS} --target=${ISPC_TARGETS} --arch=${ISPC_ARCH}
                                   -h ${ISPC_HEADER_NAME} -o ${ISPC_OBJ_NAME}
        VERBATIM
        DEPENDS ${ISPC_EXECUTABLE} ${ISPC_DEPS}
        DEPENDS "${CMAKE_CURRENT_SOURCE_DIR}/${ISPC_SRC_NAME}.ispc")

    # To show ispc source in VS solution:
    if (WIN32)
        set_source_files_properties("${CMAKE_CURRENT_SOURCE_DIR}/${ISPC_SRC_NAME}.ispc" PROPERTIES HEADER_FILE_ONLY TRUE)
    endif()

    add_executable(${example_NAME} ${ISPC_BUILD_OUTPUT} "${CMAKE_CURRENT_SOURCE_DIR}/${ISPC_SRC_NAME}.ispc")
    target_sources(${example_NAME} PRIVATE ${example_TARGET_SOURCES})
    target_include_directories(${example_NAME} PRIVATE ${CMAKE_CURRENT_BINARY_DIR})


    # Compile options
    set_property(TARGET ${example_NAME} PROPERTY POSITION_INDEPENDENT_CODE ON)
    if (UNIX)
        if (${ISPC_ARCH_BIT} EQUAL 32)
            target_compile_options(${example_NAME} PRIVATE -m32)
        else()
            target_compile_options(${example_NAME} PRIVATE -m64)
        endif()
    else()
        target_compile_options(${example_NAME} PRIVATE /fp:fast /Oi)
    endif()

    # Common settings
    if (example_USE_COMMON_SETTINGS)
        target_sources(${example_NAME} PRIVATE ${EXAMPLES_ROOT}/common/tasksys.cpp)
        target_sources(${example_NAME} PRIVATE ${EXAMPLES_ROOT}/common/timing.h)
        if (UNIX)
            target_compile_options(${example_NAME} PRIVATE -O2)
            target_link_libraries(${example_NAME} pthread m stdc++)
        endif()
    endif()

    # Link libraries
    if (example_LIBRARIES)
        target_link_libraries(${example_NAME} ${example_LIBRARIES})
    endif()

    set_target_properties(${example_NAME} PROPERTIES FOLDER "Examples")
    if(MSVC)
        # Group ISPC files inside Visual Studio
        source_group("ISPC" FILES "${CMAKE_CURRENT_SOURCE_DIR}/${ISPC_SRC_NAME}.ispc")
    endif()


    # Add ctest test for this example
    if(example_RUN_ARGS)
        add_test(NAME ${example_NAME}
                 COMMAND $<TARGET_FILE:${example_NAME}> ${example_RUN_ARGS}
                 WORKING_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})
    else()
        add_test(NAME ${example_NAME}
                 COMMAND $<TARGET_FILE:${example_NAME}>
                 WORKING_DIRECTORY ${CMAKE_CURRENT_BINARY_DIR})
    endif()

    # Set test properties
    set_tests_properties(${example_NAME} PROPERTIES
        TIMEOUT 300  # 5 minute timeout
        LABELS "cpu_example"
    )

    # Install example
    # We do not need to include examples binaries to the package
    if (NOT ISPC_PREPARE_PACKAGE)
        install(TARGETS ${example_NAME} RUNTIME DESTINATION examples/${example_NAME})
        if (example_DATA_FILES)
            install(FILES ${example_DATA_FILES}
                    DESTINATION examples/${example_NAME})
        endif()

        if (example_DATA_DIR)
            install(DIRECTORY ${example_DATA_DIR}
                    DESTINATION examples/${example_NAME})
        endif()
    endif()

endfunction()
