/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_kea extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_hy = "arméniu";
        final String metaValue_bn = "bengali";
        final String metaValue_ka = "jorjianu";
        final String metaValue_el = "gregu";
        final String metaValue_gu = "gujarati";
        final String metaValue_he = "ebraiku";
        final String metaValue_ja = "japones";
        final String metaValue_km = "kmer";
        final String metaValue_kn = "kanares";
        final String metaValue_ko = "korianu";
        final String metaValue_lo = "lausianu";
        final String metaValue_ml = "malaialam";
        final String metaValue_my = "birmanes";
        final String metaValue_si = "singales";
        final String metaValue_ta = "tamil";
        final String metaValue_te = "telugu";
        final String metaValue_th = "tailandes";
        final String metaValue_bo = "tibetanu";
        final Object[][] data = new Object[][] {
            { "001", "Mundu" },
            { "002", "Áfrika" },
            { "003", "Merka di Norti" },
            { "005", "Merka di Sul" },
            { "009", "Oseania" },
            { "011", "Áfrika Osidental" },
            { "013", "Merka Sentral" },
            { "014", "Áfrika Oriental" },
            { "015", "Norti di Áfrika" },
            { "017", "Áfrika Sentral" },
            { "018", "Sul di Áfrika" },
            { "019", "Merkas" },
            { "021", "Norti di Merka" },
            { "029", "Karaibas" },
            { "030", "Ázia Oriental" },
            { "034", "Sul di Ázia" },
            { "035", "Sudesti Aziátiku" },
            { "039", "Europa di Sul" },
            { "053", "Australázia" },
            { "054", "Melanézia" },
            { "057", "Rejion di Mikronézia" },
            { "061", "Polinézia" },
            { "142", "Ázia" },
            { "143", "Ázia Sentral" },
            { "145", "Ázia Osidental" },
            { "150", "Europa" },
            { "151", "Europa Oriental" },
            { "154", "Europa di Norti" },
            { "155", "Europa Osidental" },
            { "202", "Áfrika Subisariana" },
            { "419", "Merka Latinu" },
            { "AC", "Ilha di Asenson" },
            { "AD", "Andora" },
            { "AE", "Emiradus Árabi Unidu" },
            { "AF", "Afeganistãu" },
            { "AG", "Antigua i Barbuda" },
            { "AI", "Angila" },
            { "AL", "Albánia" },
            { "AM", "Arménia" },
            { "AO", "Angola" },
            { "AQ", "Antártika" },
            { "AR", "Arjentina" },
            { "AS", "Samoa Merkanu" },
            { "AT", "Áustria" },
            { "AU", "Austrália" },
            { "AW", "Aruba" },
            { "AX", "Ilhas Åland" },
            { "AZ", "Azerbaidjan" },
            { "BA", "Bósnia i Erzegovina" },
            { "BB", "Barbadus" },
            { "BD", "Bangladexi" },
            { "BE", "Béljika" },
            { "BF", "Burkina Fasu" },
            { "BG", "Bulgária" },
            { "BH", "Barain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "San Bartolomeu" },
            { "BM", "Bermudas" },
            { "BN", "Brunei" },
            { "BO", "Bolívia" },
            { "BQ", "Karaibas Olandezas" },
            { "BR", "Brazil" },
            { "BS", "Baamas" },
            { "BT", "Butan" },
            { "BV", "Ilha Buvê" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belizi" },
            { "CA", "Kanadá" },
            { "CC", "Ilhas Kokus (Keeling)" },
            { "CD", "Kongu - Kinxasa" },
            { "CF", "Republika Sentru-Afrikanu" },
            { "CG", "Kongu - Brazavili" },
            { "CH", "Suisa" },
            { "CI", "Kosta di Marfin" },
            { "CK", "Ilhas Kuk" },
            { "CL", "Xili" },
            { "CM", "Kamarons" },
            { "CN", "Xina" },
            { "CO", "Kolómbia" },
            { "CP", "Ilha Kliperton" },
            { "CR", "Kosta Rika" },
            { "CU", "Kuba" },
            { "CV", "Kabu Verdi" },
            { "CW", "Kurasau" },
            { "CX", "Ilha di Natal" },
            { "CY", "Xipri" },
            { "CZ", "Txékia" },
            { "DE", "Alimanha" },
            { "DG", "Diegu Garsia" },
            { "DJ", "Djibuti" },
            { "DK", "Dinamarka" },
            { "DM", "Dominika" },
            { "DO", "Repúblika Dominikana" },
            { "DZ", "Arjélia" },
            { "EA", "Seuta i Melilha" },
            { "EC", "Ekuador" },
            { "EE", "Stónia" },
            { "EG", "Ejitu" },
            { "EH", "Sara Osidental" },
            { "ER", "Iritreia" },
            { "ES", "Spanha" },
            { "ET", "Etiópia" },
            { "EU", "Union Europeia" },
            { "EZ", "Eurozona" },
            { "FI", "Finlándia" },
            { "FJ", "Fidji" },
            { "FK", "Ilhas Malvinas" },
            { "FM", "Mikronézia" },
            { "FO", "Ilhas Faroe" },
            { "FR", "Fransa" },
            { "GA", "Gabon" },
            { "GB", "Reinu Unidu" },
            { "GD", "Granada" },
            { "GE", "Jiórjia" },
            { "GF", "Giana Franseza" },
            { "GG", "Gernzi" },
            { "GH", "Gana" },
            { "GI", "Jibraltar" },
            { "GL", "Gronelándia" },
            { "GM", "Gámbia" },
            { "GN", "Gine" },
            { "GP", "Guadalupi" },
            { "GQ", "Gine Ekuatorial" },
            { "GR", "Grésia" },
            { "GS", "Ilhas Jeórjia di Sul i Sanduixi di Sul" },
            { "GT", "Guatimala" },
            { "GU", "Guam" },
            { "GW", "Gine-Bisau" },
            { "GY", "Giana" },
            { "HK", "Hong Kong, Rejion Administrativu Spesial di Xina" },
            { "HM", "Ilhas Heard i McDonald" },
            { "HN", "Onduras" },
            { "HR", "Kroásia" },
            { "HT", "Aití" },
            { "HU", "Ungria" },
            { "IC", "Kanárias" },
            { "ID", "Indonézia" },
            { "IE", "Irlanda" },
            { "IL", "Israel" },
            { "IM", "Ilha di Man" },
            { "IN", "Índia" },
            { "IO", "Ilhas Británikas di Índiku" },
            { "IQ", "Iraki" },
            { "IR", "Irãu" },
            { "IS", "Islándia" },
            { "IT", "Itália" },
            { "JE", "Jersi" },
            { "JM", "Jamaika" },
            { "JO", "Jordánia" },
            { "JP", "Japon" },
            { "KE", "Kénia" },
            { "KG", "Kirgistan" },
            { "KH", "Kambodja" },
            { "KI", "Kiribati" },
            { "KM", "Kamoris" },
            { "KN", "San Kristovan i Nevis" },
            { "KP", "Koreia di Norti" },
            { "KR", "Koreia di Sul" },
            { "KW", "Kueiti" },
            { "KY", "Ilhas Kaimon" },
            { "KZ", "Kazakistan" },
            { "LA", "Laus" },
            { "LB", "Líbanu" },
            { "LC", "Santa Lúsia" },
            { "LI", "Lixenstain" },
            { "LK", "Sri Lanka" },
            { "LR", "Libéria" },
            { "LS", "Lezotu" },
            { "LT", "Lituánia" },
            { "LU", "Luxemburgu" },
            { "LV", "Letónia" },
            { "LY", "Líbia" },
            { "MA", "Marokus" },
            { "MC", "Mónaku" },
            { "MD", "Moldávia" },
            { "ME", "Montenegru" },
            { "MF", "San Martinhu (Fransa)" },
            { "MG", "Madagaskar" },
            { "MH", "Ilhas Marxal" },
            { "MK", "Masidónia di Norti" },
            { "ML", "Mali" },
            { "MM", "Mianmar (Birmánia)" },
            { "MN", "Mongólia" },
            { "MO", "Makau, Rejion Administrativu Spesial di Xina" },
            { "MP", "Ilhas Marianas di Norti" },
            { "MQ", "Martinika" },
            { "MR", "Mauritánia" },
            { "MS", "Monserat" },
            { "MT", "Malta" },
            { "MU", "Maurísia" },
            { "MV", "Maldivas" },
            { "MW", "Malaui" },
            { "MX", "Méxiku" },
            { "MY", "Malázia" },
            { "MZ", "Musambiki" },
            { "NA", "Namíbia" },
            { "NC", "Nova Kalidónia" },
            { "NE", "Nijer" },
            { "NF", "Ilhas Norfolk" },
            { "NG", "Nijéria" },
            { "NI", "Nikarágua" },
            { "NL", "Olanda" },
            { "NO", "Noruega" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", "Niue" },
            { "NZ", "Nova Zilándia" },
            { "OM", "Oman" },
            { "PA", "Panamá" },
            { "PE", "Peru" },
            { "PF", "Polinézia Franseza" },
            { "PG", "Papua-Nova Gine" },
            { "PH", "Filipinas" },
            { "PK", "Pakistan" },
            { "PL", "Pulónia" },
            { "PM", "San Piere i Mikelon" },
            { "PN", "Ilhas Pitkairn" },
            { "PR", "Portu Riku" },
            { "PS", "Tiritóriu palistinianu" },
            { "PT", "Purtugal" },
            { "PW", "Palau" },
            { "PY", "Paraguai" },
            { "QA", "Katar" },
            { "QO", "Ilhas di Oseania" },
            { "RE", "Runion" },
            { "RO", "Ruménia" },
            { "RS", "Sérvia" },
            { "RU", "Rúsia" },
            { "RW", "Ruanda" },
            { "SA", "Arábia Saudita" },
            { "SB", "Ilhas Salumãu" },
            { "SC", "Seixelis" },
            { "SD", "Sudon" },
            { "SE", "Suésia" },
            { "SG", "Singapura" },
            { "SH", "Santa Ilena" },
            { "SI", "Slovénia" },
            { "SJ", "Svalbard i Jan Maien" },
            { "SK", "Slovákia" },
            { "SL", "Sera Lioa" },
            { "SM", "San Marinu" },
            { "SN", "Senegal" },
            { "SO", "Sumália" },
            { "SR", "Surinami" },
            { "SS", "Sudon di Sul" },
            { "ST", "San Tume i Prínsipi" },
            { "SV", "El Salvador" },
            { "SX", "San Martinhu (Olanda)" },
            { "SY", "Síria" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Kunha" },
            { "TC", "Ilhas Turkas i Kaikus" },
            { "TD", "Txadi" },
            { "TF", "Terras Franses di Sul" },
            { "TG", "Togu" },
            { "TH", "Tailándia" },
            { "TJ", "Tadjikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor Lesti" },
            { "TM", "Turkumenistan" },
            { "TN", "Tunízia" },
            { "TO", "Tonga" },
            { "TR", "Turkia" },
            { "TT", "Trinidad i Tobagu" },
            { "TV", "Tuvalu" },
            { "TW", "Taiuan" },
            { "TZ", "Tanzánia" },
            { "UA", "Ukránia" },
            { "UG", "Uganda" },
            { "UM", "Ilhas Minoris Distantis de Stadus Unidus" },
            { "UN", "Nasons Unidas" },
            { "US", "Stadus Unidos di Merka" },
            { "UY", "Uruguai" },
            { "UZ", "Uzbekistan" },
            { "VA", "Vatikanu" },
            { "VC", "San Bisenti i Granadinas" },
            { "VE", "Vinizuela" },
            { "VG", "Ilhas Virjens Británikas" },
            { "VI", "Ilhas Virjens Merkanas" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Ualis i Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-sotakis" },
            { "XB", "Pseudo-bidiresional" },
            { "XK", "Kozovu" },
            { "YE", "Iémen" },
            { "YT", "Maiote" },
            { "ZA", "Áfrika di Sul" },
            { "ZM", "Zámbia" },
            { "ZW", "Zimbábui" },
            { "ZZ", "Rejion Diskonxedu" },
            { "ab", "abkáziu" },
            { "af", "afrikaner" },
            { "ak", "akan" },
            { "am", "amáriku" },
            { "ar", "árabi" },
            { "as", "asames" },
            { "ay", "aimara" },
            { "az", "azerbaijanu" },
            { "ba", "baxkir" },
            { "be", "bielorusu" },
            { "bg", "búlgaru" },
            { "bm", "bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "bretãu" },
            { "bs", "bosniu" },
            { "ca", "katalãu" },
            { "ce", "txetxenu" },
            { "co", "kórsiku" },
            { "cs", "txeku" },
            { "cu", "slavu klériku" },
            { "cv", "txuvaxi" },
            { "cy", "gales" },
            { "da", "dinamarkes" },
            { "de", "alemon" },
            { "dz", "dzonka" },
            { "ee", "eve" },
            { "el", metaValue_el },
            { "en", "ingles" },
            { "eo", "sperantu" },
            { "es", "spanhol" },
            { "et", "stonianu" },
            { "eu", "basku" },
            { "fa", "persa" },
            { "ff", "fula" },
            { "fi", "finlandes" },
            { "fj", "fijianu" },
            { "fo", "faroes" },
            { "fr", "franses" },
            { "fy", "fríziu osidental" },
            { "ga", "irlandes" },
            { "gl", "galegu" },
            { "gn", "guarani" },
            { "gu", metaValue_gu },
            { "gv", "manks" },
            { "ha", "auza" },
            { "he", metaValue_he },
            { "hi", "indi" },
            { "hr", "kroata" },
            { "ht", "aitianu" },
            { "hu", "úngaru" },
            { "hy", metaValue_hy },
            { "ia", "interlingua" },
            { "id", "indonéziu" },
            { "ig", "ibo" },
            { "ii", "nuosu" },
            { "is", "islandes" },
            { "it", "italianu" },
            { "iu", "inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "javanes" },
            { "ka", metaValue_ka },
            { "ki", "kikuiu" },
            { "kk", "kazak" },
            { "kl", "groenlandes" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "ks", "kaxmira" },
            { "ku", "kurdu" },
            { "kw", "kórniku" },
            { "ky", "kirgiz" },
            { "la", "latin" },
            { "lb", "luxemburges" },
            { "lg", "luganda" },
            { "ln", "lingala" },
            { "lo", metaValue_lo },
            { "lt", "lituanu" },
            { "lu", "luba-katanga" },
            { "lv", "letãu" },
            { "mg", "malgaxi" },
            { "mi", "maori" },
            { "mk", "masedóniu" },
            { "ml", metaValue_ml },
            { "mr", "marati" },
            { "ms", "maláiu" },
            { "mt", "maltes" },
            { "my", metaValue_my },
            { "nb", "norueges bokmål" },
            { "ne", "nepales" },
            { "nl", "olandes" },
            { "nn", "norueges nynorsk" },
            { "om", "oromo" },
            { "or", "odía" },
            { "os", "osétiku" },
            { "pa", "pandjabi" },
            { "pl", "pulaku" },
            { "ps", "paxto" },
            { "pt", "purtuges" },
            { "qu", "kexua" },
            { "rm", "romanxi" },
            { "rn", "rundi" },
            { "ro", "rumenu" },
            { "ru", "rusu" },
            { "rw", "kiniaruanda" },
            { "sa", "sánskritu" },
            { "sd", "sindi" },
            { "si", metaValue_si },
            { "sk", "slovaku" },
            { "sl", "slovéniu" },
            { "so", "somali" },
            { "sq", "albanes" },
            { "sr", "sérviu" },
            { "su", "sundanes" },
            { "sv", "sueku" },
            { "sw", "suaíli" },
            { "ta", metaValue_ta },
            { "te", metaValue_te },
            { "tg", "tadjiki" },
            { "th", metaValue_th },
            { "ti", "tigrinia" },
            { "tk", "turkmenu" },
            { "to", "tonganes" },
            { "tr", "turku" },
            { "tt", "tatar" },
            { "ug", "uigur" },
            { "uk", "ukranianu" },
            { "ur", "urdu" },
            { "uz", "uzbeki" },
            { "vi", "vietnamita" },
            { "wo", "uolof" },
            { "xh", "koza" },
            { "yo", "ioruba" },
            { "zh", "xines" },
            { "zu", "zulu" },
            { "agq", "aghem" },
            { "arn", "araukanu" },
            { "asa", "asu" },
            { "ast", "asturianu" },
            { "ban", "balines" },
            { "bas", "basa" },
            { "bem", "bemba" },
            { "bez", "bena" },
            { "brx", "bodo" },
            { "ccp", "xakma" },
            { "ceb", "sebuanu" },
            { "cgg", "xiga" },
            { "chr", "xeroki" },
            { "ckb", "kurdu sentral" },
            { "dav", "taita" },
            { "dje", "zarma" },
            { "dsb", "sórbiu baxu" },
            { "dua", "duala" },
            { "dyo", "jola-fonyi" },
            { "ebu", "embu" },
            { "ewo", "ewondo" },
            { "fil", "filipinu" },
            { "fur", "friulanu" },
            { "gag", "gagauz" },
            { "gsw", "alemon suisu" },
            { "guz", "gusii" },
            { "haw", "avaianu" },
            { "hmn", "hmong" },
            { "hsb", "sórbiu altu" },
            { "jgo", "ñomba" },
            { "jmc", "matxame" },
            { "kab", "kabila" },
            { "kam", "kamba" },
            { "kde", "makonde" },
            { "kea", "kabuverdianu" },
            { "khq", "koira txiini" },
            { "kkj", "kako" },
            { "kln", "kalenjin" },
            { "koi", "komi-permiak" },
            { "kok", "konkani" },
            { "ksf", "bafia" },
            { "ksh", "kolonhanu" },
            { "lag", "langi" },
            { "lkt", "lakota" },
            { "luy", "luyia" },
            { "mgh", "makua" },
            { "nds", "alemon baxu" },
            { "nmg", "kuazio" },
            { "prg", "prusianu" },
            { "quc", "kitxe" },
            { "rof", "rombu" },
            { "rwk", "rwa" },
            { "ses", "koiraboro seni" },
            { "smn", "inari sami" },
            { "tzm", "tamaziti di Atlas Sentral" },
            { "und", "língua diskonxedu" },
            { "yue", "kantunes" },
            { "zgh", "tamazait marokinu padron" },
            { "zxx", "sen kontiudu linguístiku" },
            { "Arab", "arábiku" },
            { "Armn", metaValue_hy },
            { "Beng", metaValue_bn },
            { "Bopo", "bopomofo" },
            { "Brai", "braille" },
            { "Cyrl", "siríliku" },
            { "Deva", "devanagari" },
            { "Ethi", "etiópiku" },
            { "Geor", metaValue_ka },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "gurmuki" },
            { "Hang", "hangul" },
            { "Hani", "han" },
            { "Hans", "simplifikadu" },
            { "Hant", "tradisional" },
            { "Hebr", metaValue_he },
            { "Hira", "iragana" },
            { "Hrkt", "silabáriu japunes" },
            { "Jpan", metaValue_ja },
            { "Kana", "katakana" },
            { "Khmr", metaValue_km },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Laoo", metaValue_lo },
            { "Latn", "latinu" },
            { "Mlym", metaValue_ml },
            { "Mong", "mongol" },
            { "Mymr", metaValue_my },
            { "Orya", "oriya" },
            { "Sinh", metaValue_si },
            { "Taml", metaValue_ta },
            { "Telu", metaValue_te },
            { "Thaa", "taana" },
            { "Thai", metaValue_th },
            { "Tibt", metaValue_bo },
            { "Zmth", "notason matimátiku" },
            { "Zsye", "emoji" },
            { "Zsym", "símbulus" },
            { "Zxxx", "nãu skritu" },
            { "Zyyy", "komun" },
            { "Zzzz", "skrita diskonxedu" },
            { "de_AT", "alemon austríaku" },
            { "de_CH", "alemon altu suisu" },
            { "en_AU", "ingles australianu" },
            { "en_CA", "ingles kanadianu" },
            { "en_GB", "ingles britániku" },
            { "en_US", "ingles merkanu" },
            { "es_ES", "spanhol europeu" },
            { "es_MX", "spanhol mexikanu" },
            { "fr_CA", "franses kanadianu" },
            { "fr_CH", "franses suisu" },
            { "nl_BE", "flamengu" },
            { "pt_BR", "purtuges brazileru" },
            { "pt_PT", "purtuges europeu" },
            { "ro_MD", "rumenu moldáviku" },
            { "sw_CD", "suaíli kongoles" },
            { "ar_001", "árabi mudernu" },
            { "es_419", "spanhol latinu-merkanu" },
            { "key.ca", "Kalendáriu" },
            { "key.cf", "Formatu di mueda" },
            { "key.co", "Ordenason" },
            { "key.cu", "Mueda" },
            { "key.hc", "Siklu oráriu (12 o 24)" },
            { "key.lb", "Stilu di kebra di linha" },
            { "key.ms", "Sistema di midida" },
            { "key.nu", "Nunbru" },
            { "zh_Hans", "xines simplifikadu" },
            { "zh_Hant", "xines tradisional" },
            { "type.ca.roc", "Kalendáriu di Repúblika di Xina" },
            { "type.hc.h11", "Sistema di 12 ora (0–11)" },
            { "type.hc.h12", "Sistema di 12 ora (1–12)" },
            { "type.hc.h23", "Sistema di 24 ora (0–23)" },
            { "type.hc.h24", "Sistema di 24 ora (1–24)" },
            { "type.nu.latn", "Nunbru osidental" },
            { "type.ca.dangi", "Kalendáriu dangi" },
            { "type.co.ducet", "Órdi padron di Unicode" },
            { "type.lb.loose", "Stilu fleksível di kebra di linha" },
            { "type.ca.coptic", "Kalendáriu kopta" },
            { "type.ca.hebrew", "Kalendáriu ebraiku" },
            { "type.ca.indian", "Kalendáriu nasional indianu" },
            { "type.co.search", "Piskiza di uzu jeral" },
            { "type.lb.normal", "Stilu padron di kebra di linha" },
            { "type.lb.strict", "Stilu ríjidu di kebra di linha" },
            { "type.ms.metric", "Sistema métriku" },
            { "type.ca.chinese", "Kalendáriu xines" },
            { "type.ca.islamic", "Kalendáriu islámiku" },
            { "type.ca.iso8601", "Kalendáriu ISO-8601" },
            { "type.ca.persian", "Kalendáriu persa" },
            { "type.cf.account", "Formatu di mueda kontabilístiku" },
            { "type.ca.buddhist", "Kalendáriu budista" },
            { "type.ca.ethiopic", "Kalendáriu etiópiku" },
            { "type.ca.japanese", "Kalendáriu japones" },
            { "type.cf.standard", "Formatu di mueda padron" },
            { "type.co.standard", "Órdi padron" },
            { "type.ms.uksystem", "Sistema di midida britániku" },
            { "type.ms.ussystem", "Sistema di midida merkanu" },
            { "type.ca.gregorian", "Kalendáriu Gregorianu" },
            { "type.ca.islamic-tbla", "Kalendáriu islámiku (astronómiku)" },
            { "type.ca.islamic-civil", "Kalendáriu islámiku (sivil)" },
            { "type.ca.islamic-umalqura", "Kalendáriu islámiku (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "Kalendáriu etíopi ameti alem" },
        };
        return data;
    }
}
