// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by sidekick. DO NOT EDIT.

#![allow(rustdoc::redundant_explicit_links)]
#![allow(rustdoc::broken_intra_doc_links)]
use crate as wkt;

mod debug;
mod deserialize;
mod serialize;

/// Api is a light-weight descriptor for an API Interface.
///
/// Interfaces are also described as "protocol buffer services" in some contexts,
/// such as by the "service" keyword in a .proto file, but they are different
/// from API Services, which represent a concrete implementation of an interface
/// as opposed to simply a description of methods and bindings. They are also
/// sometimes simply referred to as "APIs" in other contexts, such as the name of
/// this message itself. See <https://cloud.google.com/apis/design/glossary> for
/// detailed terminology.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Api {
    /// The fully qualified name of this interface, including package name
    /// followed by the interface's simple name.
    pub name: std::string::String,

    /// The methods of this interface, in unspecified order.
    pub methods: std::vec::Vec<crate::Method>,

    /// Any metadata attached to the interface.
    pub options: std::vec::Vec<crate::Option>,

    /// A version string for this interface. If specified, must have the form
    /// `major-version.minor-version`, as in `1.10`. If the minor version is
    /// omitted, it defaults to zero. If the entire version field is empty, the
    /// major version is derived from the package name, as outlined below. If the
    /// field is not empty, the version in the package name will be verified to be
    /// consistent with what is provided here.
    ///
    /// The versioning schema uses [semantic
    /// versioning](http://semver.org) where the major version number
    /// indicates a breaking change and the minor version an additive,
    /// non-breaking change. Both version numbers are signals to users
    /// what to expect from different versions, and should be carefully
    /// chosen based on the product plan.
    ///
    /// The major version is also reflected in the package name of the
    /// interface, which must end in `v<major-version>`, as in
    /// `google.feature.v1`. For major versions 0 and 1, the suffix can
    /// be omitted. Zero major versions must only be used for
    /// experimental, non-GA interfaces.
    pub version: std::string::String,

    /// Source context for the protocol buffer service represented by this
    /// message.
    pub source_context: std::option::Option<crate::SourceContext>,

    /// Included interfaces. See [Mixin][].
    ///
    /// [Mixin]: crate::Mixin
    pub mixins: std::vec::Vec<crate::Mixin>,

    /// The source syntax of the service.
    pub syntax: crate::Syntax,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Api {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Api::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [methods][crate::Api::methods].
    pub fn set_methods<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Method>,
    {
        use std::iter::Iterator;
        self.methods = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::Api::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [version][crate::Api::version].
    pub fn set_version<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.version = v.into();
        self
    }

    /// Sets the value of [source_context][crate::Api::source_context].
    pub fn set_source_context<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [source_context][crate::Api::source_context].
    pub fn set_or_clear_source_context<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = v.map(|x| x.into());
        self
    }

    /// Sets the value of [mixins][crate::Api::mixins].
    pub fn set_mixins<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Mixin>,
    {
        use std::iter::Iterator;
        self.mixins = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [syntax][crate::Api::syntax].
    pub fn set_syntax<T: std::convert::Into<crate::Syntax>>(mut self, v: T) -> Self {
        self.syntax = v.into();
        self
    }
}

impl wkt::message::Message for Api {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Api"
    }
}

/// Method represents a method of an API interface.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Method {
    /// The simple name of this method.
    pub name: std::string::String,

    /// A URL of the input message type.
    pub request_type_url: std::string::String,

    /// If true, the request is streamed.
    pub request_streaming: bool,

    /// The URL of the output message type.
    pub response_type_url: std::string::String,

    /// If true, the response is streamed.
    pub response_streaming: bool,

    /// Any metadata attached to the method.
    pub options: std::vec::Vec<crate::Option>,

    /// The source syntax of this method.
    pub syntax: crate::Syntax,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Method {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Method::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [request_type_url][crate::Method::request_type_url].
    pub fn set_request_type_url<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.request_type_url = v.into();
        self
    }

    /// Sets the value of [request_streaming][crate::Method::request_streaming].
    pub fn set_request_streaming<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.request_streaming = v.into();
        self
    }

    /// Sets the value of [response_type_url][crate::Method::response_type_url].
    pub fn set_response_type_url<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.response_type_url = v.into();
        self
    }

    /// Sets the value of [response_streaming][crate::Method::response_streaming].
    pub fn set_response_streaming<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.response_streaming = v.into();
        self
    }

    /// Sets the value of [options][crate::Method::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [syntax][crate::Method::syntax].
    pub fn set_syntax<T: std::convert::Into<crate::Syntax>>(mut self, v: T) -> Self {
        self.syntax = v.into();
        self
    }
}

impl wkt::message::Message for Method {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Method"
    }
}

/// Declares an API Interface to be included in this interface. The including
/// interface must redeclare all the methods from the included interface, but
/// documentation and options are inherited as follows:
///
/// - If after comment and whitespace stripping, the documentation
///   string of the redeclared method is empty, it will be inherited
///   from the original method.
///
/// - Each annotation belonging to the service config (http,
///   visibility) which is not set in the redeclared method will be
///   inherited.
///
/// - If an http annotation is inherited, the path pattern will be
///   modified as follows. Any version prefix will be replaced by the
///   version of the including interface plus the [root][] path if
///   specified.
///
///
/// Example of a simple mixin:
///
/// ```norust
/// package google.acl.v1;
/// service AccessControl {
///   // Get the underlying ACL object.
///   rpc GetAcl(GetAclRequest) returns (Acl) {
///     option (google.api.http).get = "/v1/{resource=**}:getAcl";
///   }
/// }
///
/// package google.storage.v2;
/// service Storage {
///   rpc GetAcl(GetAclRequest) returns (Acl);
///
///   // Get a data record.
///   rpc GetData(GetDataRequest) returns (Data) {
///     option (google.api.http).get = "/v2/{resource=**}";
///   }
/// }
/// ```
///
/// Example of a mixin configuration:
///
/// ```norust
/// apis:
/// - name: google.storage.v2.Storage
///   mixins:
///   - name: google.acl.v1.AccessControl
/// ```
///
/// The mixin construct implies that all methods in `AccessControl` are
/// also declared with same name and request/response types in
/// `Storage`. A documentation generator or annotation processor will
/// see the effective `Storage.GetAcl` method after inheriting
/// documentation and annotations as follows:
///
/// ```norust
/// service Storage {
///   // Get the underlying ACL object.
///   rpc GetAcl(GetAclRequest) returns (Acl) {
///     option (google.api.http).get = "/v2/{resource=**}:getAcl";
///   }
///   ...
/// }
/// ```
///
/// Note how the version in the path pattern changed from `v1` to `v2`.
///
/// If the `root` field in the mixin is specified, it should be a
/// relative path under which inherited HTTP paths are placed. Example:
///
/// ```norust
/// apis:
/// - name: google.storage.v2.Storage
///   mixins:
///   - name: google.acl.v1.AccessControl
///     root: acls
/// ```
///
/// This implies the following inherited HTTP annotation:
///
/// ```norust
/// service Storage {
///   // Get the underlying ACL object.
///   rpc GetAcl(GetAclRequest) returns (Acl) {
///     option (google.api.http).get = "/v2/acls/{resource=**}:getAcl";
///   }
///   ...
/// }
/// ```
///
/// [root]: wkt::Mixin::root
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Mixin {
    /// The fully qualified name of the interface which is included.
    pub name: std::string::String,

    /// If non-empty specifies a path under which inherited HTTP paths
    /// are rooted.
    pub root: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Mixin {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Mixin::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [root][crate::Mixin::root].
    pub fn set_root<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.root = v.into();
        self
    }
}

impl wkt::message::Message for Mixin {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Mixin"
    }
}

/// The protocol compiler can output a FileDescriptorSet containing the .proto
/// files it parses.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FileDescriptorSet {
    pub file: std::vec::Vec<crate::FileDescriptorProto>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FileDescriptorSet {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [file][crate::FileDescriptorSet::file].
    pub fn set_file<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::FileDescriptorProto>,
    {
        use std::iter::Iterator;
        self.file = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for FileDescriptorSet {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FileDescriptorSet"
    }
}

/// Describes a complete .proto file.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FileDescriptorProto {
    pub name: std::string::String,

    pub package: std::string::String,

    /// Names of files imported by this file.
    pub dependency: std::vec::Vec<std::string::String>,

    /// Indexes of the public imported files in the dependency list above.
    pub public_dependency: std::vec::Vec<i32>,

    /// Indexes of the weak imported files in the dependency list.
    /// For Google-internal migration only. Do not use.
    pub weak_dependency: std::vec::Vec<i32>,

    /// All top-level definitions in this file.
    pub message_type: std::vec::Vec<crate::DescriptorProto>,

    pub enum_type: std::vec::Vec<crate::EnumDescriptorProto>,

    pub service: std::vec::Vec<crate::ServiceDescriptorProto>,

    pub extension: std::vec::Vec<crate::FieldDescriptorProto>,

    pub options: std::option::Option<crate::FileOptions>,

    /// This field contains optional information about the original source code.
    /// You may safely remove this entire field without harming runtime
    /// functionality of the descriptors -- the information is needed only by
    /// development tools.
    pub source_code_info: std::option::Option<crate::SourceCodeInfo>,

    /// The syntax of the proto file.
    /// The supported values are "proto2", "proto3", and "editions".
    ///
    /// If `edition` is present, this value must be "editions".
    pub syntax: std::string::String,

    /// The edition of the proto file.
    pub edition: crate::Edition,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FileDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::FileDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [package][crate::FileDescriptorProto::package].
    pub fn set_package<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.package = v.into();
        self
    }

    /// Sets the value of [dependency][crate::FileDescriptorProto::dependency].
    pub fn set_dependency<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.dependency = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [public_dependency][crate::FileDescriptorProto::public_dependency].
    pub fn set_public_dependency<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<i32>,
    {
        use std::iter::Iterator;
        self.public_dependency = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [weak_dependency][crate::FileDescriptorProto::weak_dependency].
    pub fn set_weak_dependency<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<i32>,
    {
        use std::iter::Iterator;
        self.weak_dependency = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [message_type][crate::FileDescriptorProto::message_type].
    pub fn set_message_type<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::DescriptorProto>,
    {
        use std::iter::Iterator;
        self.message_type = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [enum_type][crate::FileDescriptorProto::enum_type].
    pub fn set_enum_type<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::EnumDescriptorProto>,
    {
        use std::iter::Iterator;
        self.enum_type = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [service][crate::FileDescriptorProto::service].
    pub fn set_service<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::ServiceDescriptorProto>,
    {
        use std::iter::Iterator;
        self.service = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [extension][crate::FileDescriptorProto::extension].
    pub fn set_extension<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::FieldDescriptorProto>,
    {
        use std::iter::Iterator;
        self.extension = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::FileDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FileOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::FileDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FileOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }

    /// Sets the value of [source_code_info][crate::FileDescriptorProto::source_code_info].
    pub fn set_source_code_info<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::SourceCodeInfo>,
    {
        self.source_code_info = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [source_code_info][crate::FileDescriptorProto::source_code_info].
    pub fn set_or_clear_source_code_info<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::SourceCodeInfo>,
    {
        self.source_code_info = v.map(|x| x.into());
        self
    }

    /// Sets the value of [syntax][crate::FileDescriptorProto::syntax].
    pub fn set_syntax<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.syntax = v.into();
        self
    }

    /// Sets the value of [edition][crate::FileDescriptorProto::edition].
    pub fn set_edition<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
        self.edition = v.into();
        self
    }
}

impl wkt::message::Message for FileDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FileDescriptorProto"
    }
}

/// Describes a message type.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct DescriptorProto {
    pub name: std::string::String,

    pub field: std::vec::Vec<crate::FieldDescriptorProto>,

    pub extension: std::vec::Vec<crate::FieldDescriptorProto>,

    pub nested_type: std::vec::Vec<crate::DescriptorProto>,

    pub enum_type: std::vec::Vec<crate::EnumDescriptorProto>,

    pub extension_range: std::vec::Vec<crate::descriptor_proto::ExtensionRange>,

    pub oneof_decl: std::vec::Vec<crate::OneofDescriptorProto>,

    pub options: std::option::Option<crate::MessageOptions>,

    pub reserved_range: std::vec::Vec<crate::descriptor_proto::ReservedRange>,

    /// Reserved field names, which may not be used by fields in the same message.
    /// A given name may only be reserved once.
    pub reserved_name: std::vec::Vec<std::string::String>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl DescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::DescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [field][crate::DescriptorProto::field].
    pub fn set_field<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::FieldDescriptorProto>,
    {
        use std::iter::Iterator;
        self.field = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [extension][crate::DescriptorProto::extension].
    pub fn set_extension<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::FieldDescriptorProto>,
    {
        use std::iter::Iterator;
        self.extension = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [nested_type][crate::DescriptorProto::nested_type].
    pub fn set_nested_type<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::DescriptorProto>,
    {
        use std::iter::Iterator;
        self.nested_type = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [enum_type][crate::DescriptorProto::enum_type].
    pub fn set_enum_type<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::EnumDescriptorProto>,
    {
        use std::iter::Iterator;
        self.enum_type = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [extension_range][crate::DescriptorProto::extension_range].
    pub fn set_extension_range<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::descriptor_proto::ExtensionRange>,
    {
        use std::iter::Iterator;
        self.extension_range = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [oneof_decl][crate::DescriptorProto::oneof_decl].
    pub fn set_oneof_decl<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::OneofDescriptorProto>,
    {
        use std::iter::Iterator;
        self.oneof_decl = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::DescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::MessageOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::DescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::MessageOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }

    /// Sets the value of [reserved_range][crate::DescriptorProto::reserved_range].
    pub fn set_reserved_range<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::descriptor_proto::ReservedRange>,
    {
        use std::iter::Iterator;
        self.reserved_range = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [reserved_name][crate::DescriptorProto::reserved_name].
    pub fn set_reserved_name<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.reserved_name = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for DescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.DescriptorProto"
    }
}

/// Defines additional types related to [DescriptorProto].
pub mod descriptor_proto {
    #[allow(unused_imports)]
    use super::*;

    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct ExtensionRange {
        pub start: i32,

        pub end: i32,

        pub options: std::option::Option<crate::ExtensionRangeOptions>,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl ExtensionRange {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [start][crate::descriptor_proto::ExtensionRange::start].
        pub fn set_start<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.start = v.into();
            self
        }

        /// Sets the value of [end][crate::descriptor_proto::ExtensionRange::end].
        pub fn set_end<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.end = v.into();
            self
        }

        /// Sets the value of [options][crate::descriptor_proto::ExtensionRange::options].
        pub fn set_options<T>(mut self, v: T) -> Self
        where
            T: std::convert::Into<crate::ExtensionRangeOptions>,
        {
            self.options = std::option::Option::Some(v.into());
            self
        }

        /// Sets or clears the value of [options][crate::descriptor_proto::ExtensionRange::options].
        pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
        where
            T: std::convert::Into<crate::ExtensionRangeOptions>,
        {
            self.options = v.map(|x| x.into());
            self
        }
    }

    impl wkt::message::Message for ExtensionRange {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.DescriptorProto.ExtensionRange"
        }
    }

    /// Range of reserved tag numbers. Reserved tag numbers may not be used by
    /// fields or extension ranges in the same message. Reserved ranges may
    /// not overlap.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct ReservedRange {
        pub start: i32,

        pub end: i32,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl ReservedRange {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [start][crate::descriptor_proto::ReservedRange::start].
        pub fn set_start<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.start = v.into();
            self
        }

        /// Sets the value of [end][crate::descriptor_proto::ReservedRange::end].
        pub fn set_end<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.end = v.into();
            self
        }
    }

    impl wkt::message::Message for ReservedRange {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.DescriptorProto.ReservedRange"
        }
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct ExtensionRangeOptions {
    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    /// For external users: DO NOT USE. We are in the process of open sourcing
    /// extension declaration and executing internal cleanups before it can be
    /// used externally.
    pub declaration: std::vec::Vec<crate::extension_range_options::Declaration>,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The verification state of the range.
    /// TODO: flip the default to DECLARATION once all empty ranges
    /// are marked as UNVERIFIED.
    pub verification: crate::extension_range_options::VerificationState,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl ExtensionRangeOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [uninterpreted_option][crate::ExtensionRangeOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [declaration][crate::ExtensionRangeOptions::declaration].
    pub fn set_declaration<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::extension_range_options::Declaration>,
    {
        use std::iter::Iterator;
        self.declaration = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [features][crate::ExtensionRangeOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::ExtensionRangeOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [verification][crate::ExtensionRangeOptions::verification].
    pub fn set_verification<
        T: std::convert::Into<crate::extension_range_options::VerificationState>,
    >(
        mut self,
        v: T,
    ) -> Self {
        self.verification = v.into();
        self
    }
}

impl wkt::message::Message for ExtensionRangeOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.ExtensionRangeOptions"
    }
}

/// Defines additional types related to [ExtensionRangeOptions].
pub mod extension_range_options {
    #[allow(unused_imports)]
    use super::*;

    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Declaration {
        /// The extension number declared within the extension range.
        pub number: i32,

        /// The fully-qualified name of the extension field. There must be a leading
        /// dot in front of the full name.
        pub full_name: std::string::String,

        /// The fully-qualified type name of the extension field. Unlike
        /// Metadata.type, Declaration.type must have a leading dot for messages
        /// and enums.
        pub r#type: std::string::String,

        /// If true, indicates that the number is reserved in the extension range,
        /// and any extension field with the number will fail to compile. Set this
        /// when a declared extension field is deleted.
        pub reserved: bool,

        /// If true, indicates that the extension must be defined as repeated.
        /// Otherwise the extension must be defined as optional.
        pub repeated: bool,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Declaration {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [number][crate::extension_range_options::Declaration::number].
        pub fn set_number<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.number = v.into();
            self
        }

        /// Sets the value of [full_name][crate::extension_range_options::Declaration::full_name].
        pub fn set_full_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.full_name = v.into();
            self
        }

        /// Sets the value of [r#type][crate::extension_range_options::Declaration::type].
        pub fn set_type<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.r#type = v.into();
            self
        }

        /// Sets the value of [reserved][crate::extension_range_options::Declaration::reserved].
        pub fn set_reserved<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
            self.reserved = v.into();
            self
        }

        /// Sets the value of [repeated][crate::extension_range_options::Declaration::repeated].
        pub fn set_repeated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
            self.repeated = v.into();
            self
        }
    }

    impl wkt::message::Message for Declaration {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.ExtensionRangeOptions.Declaration"
        }
    }

    /// The verification state of the extension range.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum VerificationState {
        /// All the extensions of the range must be declared.
        Declaration,
        Unverified,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [VerificationState::value] or
        /// [VerificationState::name].
        UnknownValue(verification_state::UnknownValue),
    }

    #[doc(hidden)]
    pub mod verification_state {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl VerificationState {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Declaration => std::option::Option::Some(0),
                Self::Unverified => std::option::Option::Some(1),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Declaration => std::option::Option::Some("DECLARATION"),
                Self::Unverified => std::option::Option::Some("UNVERIFIED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for VerificationState {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for VerificationState {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for VerificationState {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Declaration,
                1 => Self::Unverified,
                _ => Self::UnknownValue(verification_state::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for VerificationState {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "DECLARATION" => Self::Declaration,
                "UNVERIFIED" => Self::Unverified,
                _ => Self::UnknownValue(verification_state::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for VerificationState {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Declaration => serializer.serialize_i32(0),
                Self::Unverified => serializer.serialize_i32(1),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for VerificationState {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<VerificationState>::new(
                ".google.protobuf.ExtensionRangeOptions.VerificationState",
            ))
        }
    }
}

/// Describes a field within a message.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FieldDescriptorProto {
    pub name: std::string::String,

    pub number: i32,

    pub label: crate::field_descriptor_proto::Label,

    /// If type_name is set, this need not be set.  If both this and type_name
    /// are set, this must be one of TYPE_ENUM, TYPE_MESSAGE or TYPE_GROUP.
    pub r#type: crate::field_descriptor_proto::Type,

    /// For message and enum types, this is the name of the type.  If the name
    /// starts with a '.', it is fully-qualified.  Otherwise, C++-like scoping
    /// rules are used to find the type (i.e. first the nested types within this
    /// message are searched, then within the parent, on up to the root
    /// namespace).
    pub type_name: std::string::String,

    /// For extensions, this is the name of the type being extended.  It is
    /// resolved in the same manner as type_name.
    pub extendee: std::string::String,

    /// For numeric types, contains the original text representation of the value.
    /// For booleans, "true" or "false".
    /// For strings, contains the default text contents (not escaped in any way).
    /// For bytes, contains the C escaped value.  All bytes >= 128 are escaped.
    pub default_value: std::string::String,

    /// If set, gives the index of a oneof in the containing type's oneof_decl
    /// list.  This field is a member of that oneof.
    pub oneof_index: i32,

    /// JSON name of this field. The value is set by protocol compiler. If the
    /// user has set a "json_name" option on this field, that option's value
    /// will be used. Otherwise, it's deduced from the field's name by converting
    /// it to camelCase.
    pub json_name: std::string::String,

    pub options: std::option::Option<crate::FieldOptions>,

    /// If true, this is a proto3 "optional". When a proto3 field is optional, it
    /// tracks presence regardless of field type.
    ///
    /// When proto3_optional is true, this field must belong to a oneof to signal
    /// to old proto3 clients that presence is tracked for this field. This oneof
    /// is known as a "synthetic" oneof, and this field must be its sole member
    /// (each proto3 optional field gets its own synthetic oneof). Synthetic oneofs
    /// exist in the descriptor only, and do not generate any API. Synthetic oneofs
    /// must be ordered after all "real" oneofs.
    ///
    /// For message fields, proto3_optional doesn't create any semantic change,
    /// since non-repeated message fields always track presence. However it still
    /// indicates the semantic detail of whether the user wrote "optional" or not.
    /// This can be useful for round-tripping the .proto file. For consistency we
    /// give message fields a synthetic oneof also, even though it is not required
    /// to track presence. This is especially important because the parser can't
    /// tell if a field is a message or an enum, so it must always create a
    /// synthetic oneof.
    ///
    /// Proto2 optional fields do not set this flag, because they already indicate
    /// optional with `LABEL_OPTIONAL`.
    pub proto3_optional: bool,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FieldDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::FieldDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [number][crate::FieldDescriptorProto::number].
    pub fn set_number<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.number = v.into();
        self
    }

    /// Sets the value of [label][crate::FieldDescriptorProto::label].
    pub fn set_label<T: std::convert::Into<crate::field_descriptor_proto::Label>>(
        mut self,
        v: T,
    ) -> Self {
        self.label = v.into();
        self
    }

    /// Sets the value of [r#type][crate::FieldDescriptorProto::type].
    pub fn set_type<T: std::convert::Into<crate::field_descriptor_proto::Type>>(
        mut self,
        v: T,
    ) -> Self {
        self.r#type = v.into();
        self
    }

    /// Sets the value of [type_name][crate::FieldDescriptorProto::type_name].
    pub fn set_type_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.type_name = v.into();
        self
    }

    /// Sets the value of [extendee][crate::FieldDescriptorProto::extendee].
    pub fn set_extendee<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.extendee = v.into();
        self
    }

    /// Sets the value of [default_value][crate::FieldDescriptorProto::default_value].
    pub fn set_default_value<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.default_value = v.into();
        self
    }

    /// Sets the value of [oneof_index][crate::FieldDescriptorProto::oneof_index].
    pub fn set_oneof_index<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.oneof_index = v.into();
        self
    }

    /// Sets the value of [json_name][crate::FieldDescriptorProto::json_name].
    pub fn set_json_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.json_name = v.into();
        self
    }

    /// Sets the value of [options][crate::FieldDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FieldOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::FieldDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FieldOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }

    /// Sets the value of [proto3_optional][crate::FieldDescriptorProto::proto3_optional].
    pub fn set_proto3_optional<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.proto3_optional = v.into();
        self
    }
}

impl wkt::message::Message for FieldDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FieldDescriptorProto"
    }
}

/// Defines additional types related to [FieldDescriptorProto].
pub mod field_descriptor_proto {
    #[allow(unused_imports)]
    use super::*;

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum Type {
        /// 0 is reserved for errors.
        /// Order is weird for historical reasons.
        Double,
        Float,
        /// Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT64 if
        /// negative values are likely.
        Int64,
        Uint64,
        /// Not ZigZag encoded.  Negative numbers take 10 bytes.  Use TYPE_SINT32 if
        /// negative values are likely.
        Int32,
        Fixed64,
        Fixed32,
        Bool,
        String,
        /// Tag-delimited aggregate.
        /// Group type is deprecated and not supported after google.protobuf. However, Proto3
        /// implementations should still be able to parse the group wire format and
        /// treat group fields as unknown fields.  In Editions, the group wire format
        /// can be enabled via the `message_encoding` feature.
        Group,
        Message,
        /// New in version 2.
        Bytes,
        Uint32,
        Enum,
        Sfixed32,
        Sfixed64,
        Sint32,
        Sint64,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [Type::value] or
        /// [Type::name].
        UnknownValue(r#type::UnknownValue),
    }

    #[doc(hidden)]
    pub mod r#type {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl Type {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Double => std::option::Option::Some(1),
                Self::Float => std::option::Option::Some(2),
                Self::Int64 => std::option::Option::Some(3),
                Self::Uint64 => std::option::Option::Some(4),
                Self::Int32 => std::option::Option::Some(5),
                Self::Fixed64 => std::option::Option::Some(6),
                Self::Fixed32 => std::option::Option::Some(7),
                Self::Bool => std::option::Option::Some(8),
                Self::String => std::option::Option::Some(9),
                Self::Group => std::option::Option::Some(10),
                Self::Message => std::option::Option::Some(11),
                Self::Bytes => std::option::Option::Some(12),
                Self::Uint32 => std::option::Option::Some(13),
                Self::Enum => std::option::Option::Some(14),
                Self::Sfixed32 => std::option::Option::Some(15),
                Self::Sfixed64 => std::option::Option::Some(16),
                Self::Sint32 => std::option::Option::Some(17),
                Self::Sint64 => std::option::Option::Some(18),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Double => std::option::Option::Some("TYPE_DOUBLE"),
                Self::Float => std::option::Option::Some("TYPE_FLOAT"),
                Self::Int64 => std::option::Option::Some("TYPE_INT64"),
                Self::Uint64 => std::option::Option::Some("TYPE_UINT64"),
                Self::Int32 => std::option::Option::Some("TYPE_INT32"),
                Self::Fixed64 => std::option::Option::Some("TYPE_FIXED64"),
                Self::Fixed32 => std::option::Option::Some("TYPE_FIXED32"),
                Self::Bool => std::option::Option::Some("TYPE_BOOL"),
                Self::String => std::option::Option::Some("TYPE_STRING"),
                Self::Group => std::option::Option::Some("TYPE_GROUP"),
                Self::Message => std::option::Option::Some("TYPE_MESSAGE"),
                Self::Bytes => std::option::Option::Some("TYPE_BYTES"),
                Self::Uint32 => std::option::Option::Some("TYPE_UINT32"),
                Self::Enum => std::option::Option::Some("TYPE_ENUM"),
                Self::Sfixed32 => std::option::Option::Some("TYPE_SFIXED32"),
                Self::Sfixed64 => std::option::Option::Some("TYPE_SFIXED64"),
                Self::Sint32 => std::option::Option::Some("TYPE_SINT32"),
                Self::Sint64 => std::option::Option::Some("TYPE_SINT64"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for Type {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for Type {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for Type {
        fn from(value: i32) -> Self {
            match value {
                1 => Self::Double,
                2 => Self::Float,
                3 => Self::Int64,
                4 => Self::Uint64,
                5 => Self::Int32,
                6 => Self::Fixed64,
                7 => Self::Fixed32,
                8 => Self::Bool,
                9 => Self::String,
                10 => Self::Group,
                11 => Self::Message,
                12 => Self::Bytes,
                13 => Self::Uint32,
                14 => Self::Enum,
                15 => Self::Sfixed32,
                16 => Self::Sfixed64,
                17 => Self::Sint32,
                18 => Self::Sint64,
                _ => Self::UnknownValue(r#type::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for Type {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "TYPE_DOUBLE" => Self::Double,
                "TYPE_FLOAT" => Self::Float,
                "TYPE_INT64" => Self::Int64,
                "TYPE_UINT64" => Self::Uint64,
                "TYPE_INT32" => Self::Int32,
                "TYPE_FIXED64" => Self::Fixed64,
                "TYPE_FIXED32" => Self::Fixed32,
                "TYPE_BOOL" => Self::Bool,
                "TYPE_STRING" => Self::String,
                "TYPE_GROUP" => Self::Group,
                "TYPE_MESSAGE" => Self::Message,
                "TYPE_BYTES" => Self::Bytes,
                "TYPE_UINT32" => Self::Uint32,
                "TYPE_ENUM" => Self::Enum,
                "TYPE_SFIXED32" => Self::Sfixed32,
                "TYPE_SFIXED64" => Self::Sfixed64,
                "TYPE_SINT32" => Self::Sint32,
                "TYPE_SINT64" => Self::Sint64,
                _ => Self::UnknownValue(r#type::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for Type {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Double => serializer.serialize_i32(1),
                Self::Float => serializer.serialize_i32(2),
                Self::Int64 => serializer.serialize_i32(3),
                Self::Uint64 => serializer.serialize_i32(4),
                Self::Int32 => serializer.serialize_i32(5),
                Self::Fixed64 => serializer.serialize_i32(6),
                Self::Fixed32 => serializer.serialize_i32(7),
                Self::Bool => serializer.serialize_i32(8),
                Self::String => serializer.serialize_i32(9),
                Self::Group => serializer.serialize_i32(10),
                Self::Message => serializer.serialize_i32(11),
                Self::Bytes => serializer.serialize_i32(12),
                Self::Uint32 => serializer.serialize_i32(13),
                Self::Enum => serializer.serialize_i32(14),
                Self::Sfixed32 => serializer.serialize_i32(15),
                Self::Sfixed64 => serializer.serialize_i32(16),
                Self::Sint32 => serializer.serialize_i32(17),
                Self::Sint64 => serializer.serialize_i32(18),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for Type {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<Type>::new(
                ".google.protobuf.FieldDescriptorProto.Type",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum Label {
        /// 0 is reserved for errors
        Optional,
        Repeated,
        /// The required label is only allowed in google.protobuf.  In proto3 and Editions
        /// it's explicitly prohibited.  In Editions, the `field_presence` feature
        /// can be used to get this behavior.
        Required,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [Label::value] or
        /// [Label::name].
        UnknownValue(label::UnknownValue),
    }

    #[doc(hidden)]
    pub mod label {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl Label {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Optional => std::option::Option::Some(1),
                Self::Repeated => std::option::Option::Some(3),
                Self::Required => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Optional => std::option::Option::Some("LABEL_OPTIONAL"),
                Self::Repeated => std::option::Option::Some("LABEL_REPEATED"),
                Self::Required => std::option::Option::Some("LABEL_REQUIRED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for Label {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for Label {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for Label {
        fn from(value: i32) -> Self {
            match value {
                1 => Self::Optional,
                2 => Self::Required,
                3 => Self::Repeated,
                _ => Self::UnknownValue(label::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for Label {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "LABEL_OPTIONAL" => Self::Optional,
                "LABEL_REPEATED" => Self::Repeated,
                "LABEL_REQUIRED" => Self::Required,
                _ => Self::UnknownValue(label::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for Label {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Optional => serializer.serialize_i32(1),
                Self::Repeated => serializer.serialize_i32(3),
                Self::Required => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for Label {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<Label>::new(
                ".google.protobuf.FieldDescriptorProto.Label",
            ))
        }
    }
}

/// Describes a oneof.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct OneofDescriptorProto {
    pub name: std::string::String,

    pub options: std::option::Option<crate::OneofOptions>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl OneofDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::OneofDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [options][crate::OneofDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::OneofOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::OneofDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::OneofOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }
}

impl wkt::message::Message for OneofDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.OneofDescriptorProto"
    }
}

/// Describes an enum type.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct EnumDescriptorProto {
    pub name: std::string::String,

    pub value: std::vec::Vec<crate::EnumValueDescriptorProto>,

    pub options: std::option::Option<crate::EnumOptions>,

    /// Range of reserved numeric values. Reserved numeric values may not be used
    /// by enum values in the same enum declaration. Reserved ranges may not
    /// overlap.
    pub reserved_range: std::vec::Vec<crate::enum_descriptor_proto::EnumReservedRange>,

    /// Reserved enum value names, which may not be reused. A given name may only
    /// be reserved once.
    pub reserved_name: std::vec::Vec<std::string::String>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl EnumDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::EnumDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [value][crate::EnumDescriptorProto::value].
    pub fn set_value<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::EnumValueDescriptorProto>,
    {
        use std::iter::Iterator;
        self.value = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::EnumDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::EnumOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::EnumDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::EnumOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }

    /// Sets the value of [reserved_range][crate::EnumDescriptorProto::reserved_range].
    pub fn set_reserved_range<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::enum_descriptor_proto::EnumReservedRange>,
    {
        use std::iter::Iterator;
        self.reserved_range = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [reserved_name][crate::EnumDescriptorProto::reserved_name].
    pub fn set_reserved_name<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.reserved_name = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for EnumDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.EnumDescriptorProto"
    }
}

/// Defines additional types related to [EnumDescriptorProto].
pub mod enum_descriptor_proto {
    #[allow(unused_imports)]
    use super::*;

    /// Range of reserved numeric values. Reserved values may not be used by
    /// entries in the same enum. Reserved ranges may not overlap.
    ///
    /// Note that this is distinct from DescriptorProto.ReservedRange in that it
    /// is inclusive such that it can appropriately represent the entire int32
    /// domain.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct EnumReservedRange {
        pub start: i32,

        pub end: i32,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl EnumReservedRange {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [start][crate::enum_descriptor_proto::EnumReservedRange::start].
        pub fn set_start<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.start = v.into();
            self
        }

        /// Sets the value of [end][crate::enum_descriptor_proto::EnumReservedRange::end].
        pub fn set_end<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.end = v.into();
            self
        }
    }

    impl wkt::message::Message for EnumReservedRange {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.EnumDescriptorProto.EnumReservedRange"
        }
    }
}

/// Describes a value within an enum.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct EnumValueDescriptorProto {
    pub name: std::string::String,

    pub number: i32,

    pub options: std::option::Option<crate::EnumValueOptions>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl EnumValueDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::EnumValueDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [number][crate::EnumValueDescriptorProto::number].
    pub fn set_number<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.number = v.into();
        self
    }

    /// Sets the value of [options][crate::EnumValueDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::EnumValueOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::EnumValueDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::EnumValueOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }
}

impl wkt::message::Message for EnumValueDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.EnumValueDescriptorProto"
    }
}

/// Describes a service.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct ServiceDescriptorProto {
    pub name: std::string::String,

    pub method: std::vec::Vec<crate::MethodDescriptorProto>,

    pub options: std::option::Option<crate::ServiceOptions>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl ServiceDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::ServiceDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [method][crate::ServiceDescriptorProto::method].
    pub fn set_method<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::MethodDescriptorProto>,
    {
        use std::iter::Iterator;
        self.method = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::ServiceDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::ServiceOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::ServiceDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::ServiceOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }
}

impl wkt::message::Message for ServiceDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.ServiceDescriptorProto"
    }
}

/// Describes a method of a service.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct MethodDescriptorProto {
    pub name: std::string::String,

    /// Input and output type names.  These are resolved in the same way as
    /// FieldDescriptorProto.type_name, but must refer to a message type.
    pub input_type: std::string::String,

    pub output_type: std::string::String,

    pub options: std::option::Option<crate::MethodOptions>,

    /// Identifies if client streams multiple client messages
    pub client_streaming: bool,

    /// Identifies if server streams multiple server messages
    pub server_streaming: bool,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl MethodDescriptorProto {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::MethodDescriptorProto::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [input_type][crate::MethodDescriptorProto::input_type].
    pub fn set_input_type<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.input_type = v.into();
        self
    }

    /// Sets the value of [output_type][crate::MethodDescriptorProto::output_type].
    pub fn set_output_type<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.output_type = v.into();
        self
    }

    /// Sets the value of [options][crate::MethodDescriptorProto::options].
    pub fn set_options<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::MethodOptions>,
    {
        self.options = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [options][crate::MethodDescriptorProto::options].
    pub fn set_or_clear_options<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::MethodOptions>,
    {
        self.options = v.map(|x| x.into());
        self
    }

    /// Sets the value of [client_streaming][crate::MethodDescriptorProto::client_streaming].
    pub fn set_client_streaming<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.client_streaming = v.into();
        self
    }

    /// Sets the value of [server_streaming][crate::MethodDescriptorProto::server_streaming].
    pub fn set_server_streaming<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.server_streaming = v.into();
        self
    }
}

impl wkt::message::Message for MethodDescriptorProto {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.MethodDescriptorProto"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FileOptions {
    /// Sets the Java package where classes generated from this .proto will be
    /// placed.  By default, the proto package is used, but this is often
    /// inappropriate because proto packages do not normally start with backwards
    /// domain names.
    pub java_package: std::string::String,

    /// Controls the name of the wrapper Java class generated for the .proto file.
    /// That class will always contain the .proto file's getDescriptor() method as
    /// well as any top-level extensions defined in the .proto file.
    /// If java_multiple_files is disabled, then all the other classes from the
    /// .proto file will be nested inside the single wrapper outer class.
    pub java_outer_classname: std::string::String,

    /// If enabled, then the Java code generator will generate a separate .java
    /// file for each top-level message, enum, and service defined in the .proto
    /// file.  Thus, these types will *not* be nested inside the wrapper class
    /// named by java_outer_classname.  However, the wrapper class will still be
    /// generated to contain the file's getDescriptor() method as well as any
    /// top-level extensions defined in the file.
    pub java_multiple_files: bool,

    /// This option does nothing.
    #[deprecated]
    pub java_generate_equals_and_hash: bool,

    /// A proto2 file can set this to true to opt in to UTF-8 checking for Java,
    /// which will throw an exception if invalid UTF-8 is parsed from the wire or
    /// assigned to a string field.
    ///
    /// TODO: clarify exactly what kinds of field types this option
    /// applies to, and update these docs accordingly.
    ///
    /// Proto3 files already perform these checks. Setting the option explicitly to
    /// false has no effect: it cannot be used to opt proto3 files out of UTF-8
    /// checks.
    pub java_string_check_utf8: bool,

    pub optimize_for: crate::file_options::OptimizeMode,

    /// Sets the Go package where structs generated from this .proto will be
    /// placed. If omitted, the Go package will be derived from the following:
    ///
    /// - The basename of the package import path, if provided.
    /// - Otherwise, the package statement in the .proto file, if present.
    /// - Otherwise, the basename of the .proto file, without extension.
    pub go_package: std::string::String,

    /// Should generic services be generated in each language?  "Generic" services
    /// are not specific to any particular RPC system.  They are generated by the
    /// main code generators in each language (without additional plugins).
    /// Generic services were the only kind of service generation supported by
    /// early versions of google.protobuf.
    ///
    /// Generic services are now considered deprecated in favor of using plugins
    /// that generate code specific to your particular RPC system.  Therefore,
    /// these default to false.  Old code which depends on generic services should
    /// explicitly set them to true.
    pub cc_generic_services: bool,

    pub java_generic_services: bool,

    pub py_generic_services: bool,

    /// Is this file deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for everything in the file, or it will be completely ignored; in the very
    /// least, this is a formalization for deprecating files.
    pub deprecated: bool,

    /// Enables the use of arenas for the proto messages in this file. This applies
    /// only to generated classes for C++.
    pub cc_enable_arenas: bool,

    /// Sets the objective c class prefix which is prepended to all objective c
    /// generated classes from this .proto. There is no default.
    pub objc_class_prefix: std::string::String,

    /// Namespace for generated classes; defaults to the package.
    pub csharp_namespace: std::string::String,

    /// By default Swift generators will take the proto package and CamelCase it
    /// replacing '.' with underscore and use that to prefix the types/symbols
    /// defined. When this options is provided, they will use this value instead
    /// to prefix the types/symbols defined.
    pub swift_prefix: std::string::String,

    /// Sets the php class prefix which is prepended to all php generated classes
    /// from this .proto. Default is empty.
    pub php_class_prefix: std::string::String,

    /// Use this option to change the namespace of php generated classes. Default
    /// is empty. When this option is empty, the package name will be used for
    /// determining the namespace.
    pub php_namespace: std::string::String,

    /// Use this option to change the namespace of php generated metadata classes.
    /// Default is empty. When this option is empty, the proto file name will be
    /// used for determining the namespace.
    pub php_metadata_namespace: std::string::String,

    /// Use this option to change the package of ruby generated classes. Default
    /// is empty. When this option is not set, the package name will be used for
    /// determining the ruby package.
    pub ruby_package: std::string::String,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The parser stores options it doesn't recognize here.
    /// See the documentation for the "Options" section above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FileOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [java_package][crate::FileOptions::java_package].
    pub fn set_java_package<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.java_package = v.into();
        self
    }

    /// Sets the value of [java_outer_classname][crate::FileOptions::java_outer_classname].
    pub fn set_java_outer_classname<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.java_outer_classname = v.into();
        self
    }

    /// Sets the value of [java_multiple_files][crate::FileOptions::java_multiple_files].
    pub fn set_java_multiple_files<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.java_multiple_files = v.into();
        self
    }

    /// Sets the value of [java_generate_equals_and_hash][crate::FileOptions::java_generate_equals_and_hash].
    #[deprecated]
    pub fn set_java_generate_equals_and_hash<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.java_generate_equals_and_hash = v.into();
        self
    }

    /// Sets the value of [java_string_check_utf8][crate::FileOptions::java_string_check_utf8].
    pub fn set_java_string_check_utf8<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.java_string_check_utf8 = v.into();
        self
    }

    /// Sets the value of [optimize_for][crate::FileOptions::optimize_for].
    pub fn set_optimize_for<T: std::convert::Into<crate::file_options::OptimizeMode>>(
        mut self,
        v: T,
    ) -> Self {
        self.optimize_for = v.into();
        self
    }

    /// Sets the value of [go_package][crate::FileOptions::go_package].
    pub fn set_go_package<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.go_package = v.into();
        self
    }

    /// Sets the value of [cc_generic_services][crate::FileOptions::cc_generic_services].
    pub fn set_cc_generic_services<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.cc_generic_services = v.into();
        self
    }

    /// Sets the value of [java_generic_services][crate::FileOptions::java_generic_services].
    pub fn set_java_generic_services<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.java_generic_services = v.into();
        self
    }

    /// Sets the value of [py_generic_services][crate::FileOptions::py_generic_services].
    pub fn set_py_generic_services<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.py_generic_services = v.into();
        self
    }

    /// Sets the value of [deprecated][crate::FileOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [cc_enable_arenas][crate::FileOptions::cc_enable_arenas].
    pub fn set_cc_enable_arenas<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.cc_enable_arenas = v.into();
        self
    }

    /// Sets the value of [objc_class_prefix][crate::FileOptions::objc_class_prefix].
    pub fn set_objc_class_prefix<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.objc_class_prefix = v.into();
        self
    }

    /// Sets the value of [csharp_namespace][crate::FileOptions::csharp_namespace].
    pub fn set_csharp_namespace<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.csharp_namespace = v.into();
        self
    }

    /// Sets the value of [swift_prefix][crate::FileOptions::swift_prefix].
    pub fn set_swift_prefix<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.swift_prefix = v.into();
        self
    }

    /// Sets the value of [php_class_prefix][crate::FileOptions::php_class_prefix].
    pub fn set_php_class_prefix<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.php_class_prefix = v.into();
        self
    }

    /// Sets the value of [php_namespace][crate::FileOptions::php_namespace].
    pub fn set_php_namespace<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.php_namespace = v.into();
        self
    }

    /// Sets the value of [php_metadata_namespace][crate::FileOptions::php_metadata_namespace].
    pub fn set_php_metadata_namespace<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.php_metadata_namespace = v.into();
        self
    }

    /// Sets the value of [ruby_package][crate::FileOptions::ruby_package].
    pub fn set_ruby_package<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.ruby_package = v.into();
        self
    }

    /// Sets the value of [features][crate::FileOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::FileOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::FileOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for FileOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FileOptions"
    }
}

/// Defines additional types related to [FileOptions].
pub mod file_options {
    #[allow(unused_imports)]
    use super::*;

    /// Generated classes can be optimized for speed or code size.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum OptimizeMode {
        Speed,
        /// etc.
        CodeSize,
        LiteRuntime,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [OptimizeMode::value] or
        /// [OptimizeMode::name].
        UnknownValue(optimize_mode::UnknownValue),
    }

    #[doc(hidden)]
    pub mod optimize_mode {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl OptimizeMode {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Speed => std::option::Option::Some(1),
                Self::CodeSize => std::option::Option::Some(2),
                Self::LiteRuntime => std::option::Option::Some(3),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Speed => std::option::Option::Some("SPEED"),
                Self::CodeSize => std::option::Option::Some("CODE_SIZE"),
                Self::LiteRuntime => std::option::Option::Some("LITE_RUNTIME"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for OptimizeMode {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for OptimizeMode {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for OptimizeMode {
        fn from(value: i32) -> Self {
            match value {
                1 => Self::Speed,
                2 => Self::CodeSize,
                3 => Self::LiteRuntime,
                _ => Self::UnknownValue(optimize_mode::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for OptimizeMode {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "SPEED" => Self::Speed,
                "CODE_SIZE" => Self::CodeSize,
                "LITE_RUNTIME" => Self::LiteRuntime,
                _ => Self::UnknownValue(optimize_mode::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for OptimizeMode {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Speed => serializer.serialize_i32(1),
                Self::CodeSize => serializer.serialize_i32(2),
                Self::LiteRuntime => serializer.serialize_i32(3),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for OptimizeMode {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<OptimizeMode>::new(
                ".google.protobuf.FileOptions.OptimizeMode",
            ))
        }
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct MessageOptions {
    /// Set true to use the old proto1 MessageSet wire format for extensions.
    /// This is provided for backwards-compatibility with the MessageSet wire
    /// format.  You should not use this for any other reason:  It's less
    /// efficient, has fewer features, and is more complicated.
    ///
    /// The message must be defined exactly as follows:
    /// message Foo {
    /// option message_set_wire_format = true;
    /// extensions 4 to max;
    /// }
    /// Note that the message cannot have any defined fields; MessageSets only
    /// have extensions.
    ///
    /// All extensions of your type must be singular messages; e.g. they cannot
    /// be int32s, enums, or repeated messages.
    ///
    /// Because this is an option, the above two restrictions are not enforced by
    /// the protocol compiler.
    pub message_set_wire_format: bool,

    /// Disables the generation of the standard "descriptor()" accessor, which can
    /// conflict with a field of the same name.  This is meant to make migration
    /// from proto1 easier; new code should avoid fields named "descriptor".
    pub no_standard_descriptor_accessor: bool,

    /// Is this message deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for the message, or it will be completely ignored; in the very least,
    /// this is a formalization for deprecating messages.
    pub deprecated: bool,

    /// Whether the message is an automatically generated map entry type for the
    /// maps field.
    ///
    /// For maps fields:
    /// map<KeyType, ValueType> map_field = 1;
    /// The parsed descriptor looks like:
    /// message MapFieldEntry {
    /// option map_entry = true;
    /// optional KeyType key = 1;
    /// optional ValueType value = 2;
    /// }
    /// repeated MapFieldEntry map_field = 1;
    ///
    /// Implementations may choose not to generate the map_entry=true message, but
    /// use a native map in the target language to hold the keys and values.
    /// The reflection APIs in such implementations still need to work as
    /// if the field is a repeated message field.
    ///
    /// NOTE: Do not set the option in .proto files. Always use the maps syntax
    /// instead. The option should only be implicitly set by the proto compiler
    /// parser.
    pub map_entry: bool,

    /// Enable the legacy handling of JSON field name conflicts.  This lowercases
    /// and strips underscored from the fields before comparison in proto3 only.
    /// The new behavior takes `json_name` into account and applies to proto2 as
    /// well.
    ///
    /// This should only be used as a temporary measure against broken builds due
    /// to the change in behavior for JSON field name conflicts.
    ///
    /// TODO This is legacy behavior we plan to remove once downstream
    /// teams have had time to migrate.
    #[deprecated]
    pub deprecated_legacy_json_field_conflicts: bool,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl MessageOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [message_set_wire_format][crate::MessageOptions::message_set_wire_format].
    pub fn set_message_set_wire_format<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.message_set_wire_format = v.into();
        self
    }

    /// Sets the value of [no_standard_descriptor_accessor][crate::MessageOptions::no_standard_descriptor_accessor].
    pub fn set_no_standard_descriptor_accessor<T: std::convert::Into<bool>>(
        mut self,
        v: T,
    ) -> Self {
        self.no_standard_descriptor_accessor = v.into();
        self
    }

    /// Sets the value of [deprecated][crate::MessageOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [map_entry][crate::MessageOptions::map_entry].
    pub fn set_map_entry<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.map_entry = v.into();
        self
    }

    /// Sets the value of [deprecated_legacy_json_field_conflicts][crate::MessageOptions::deprecated_legacy_json_field_conflicts].
    #[deprecated]
    pub fn set_deprecated_legacy_json_field_conflicts<T: std::convert::Into<bool>>(
        mut self,
        v: T,
    ) -> Self {
        self.deprecated_legacy_json_field_conflicts = v.into();
        self
    }

    /// Sets the value of [features][crate::MessageOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::MessageOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::MessageOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for MessageOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.MessageOptions"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FieldOptions {
    /// NOTE: ctype is deprecated. Use `features.(pb.cpp).string_type` instead.
    /// The ctype option instructs the C++ code generator to use a different
    /// representation of the field than it normally would.  See the specific
    /// options below.  This option is only implemented to support use of
    /// [ctype=CORD] and [ctype=STRING] (the default) on non-repeated fields of
    /// type "bytes" in the open source release.
    /// TODO: make ctype actually deprecated.
    pub ctype: crate::field_options::CType,

    /// The packed option can be enabled for repeated primitive fields to enable
    /// a more efficient representation on the wire. Rather than repeatedly
    /// writing the tag and type for each element, the entire array is encoded as
    /// a single length-delimited blob. In proto3, only explicit setting it to
    /// false will avoid using packed encoding.  This option is prohibited in
    /// Editions, but the `repeated_field_encoding` feature can be used to control
    /// the behavior.
    pub packed: bool,

    /// The jstype option determines the JavaScript type used for values of the
    /// field.  The option is permitted only for 64 bit integral and fixed types
    /// (int64, uint64, sint64, fixed64, sfixed64).  A field with jstype JS_STRING
    /// is represented as JavaScript string, which avoids loss of precision that
    /// can happen when a large value is converted to a floating point JavaScript.
    /// Specifying JS_NUMBER for the jstype causes the generated JavaScript code to
    /// use the JavaScript "number" type.  The behavior of the default option
    /// JS_NORMAL is implementation dependent.
    ///
    /// This option is an enum to permit additional types to be added, e.g.
    /// goog.math.Integer.
    pub jstype: crate::field_options::JSType,

    /// Should this field be parsed lazily?  Lazy applies only to message-type
    /// fields.  It means that when the outer message is initially parsed, the
    /// inner message's contents will not be parsed but instead stored in encoded
    /// form.  The inner message will actually be parsed when it is first accessed.
    ///
    /// This is only a hint.  Implementations are free to choose whether to use
    /// eager or lazy parsing regardless of the value of this option.  However,
    /// setting this option true suggests that the protocol author believes that
    /// using lazy parsing on this field is worth the additional bookkeeping
    /// overhead typically needed to implement it.
    ///
    /// This option does not affect the public interface of any generated code;
    /// all method signatures remain the same.  Furthermore, thread-safety of the
    /// interface is not affected by this option; const methods remain safe to
    /// call from multiple threads concurrently, while non-const methods continue
    /// to require exclusive access.
    ///
    /// Note that lazy message fields are still eagerly verified to check
    /// ill-formed wireformat or missing required fields. Calling IsInitialized()
    /// on the outer message would fail if the inner message has missing required
    /// fields. Failed verification would result in parsing failure (except when
    /// uninitialized messages are acceptable).
    pub lazy: bool,

    /// unverified_lazy does no correctness checks on the byte stream. This should
    /// only be used where lazy with verification is prohibitive for performance
    /// reasons.
    pub unverified_lazy: bool,

    /// Is this field deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for accessors, or it will be completely ignored; in the very least, this
    /// is a formalization for deprecating fields.
    pub deprecated: bool,

    /// For Google-internal migration only. Do not use.
    pub weak: bool,

    /// Indicate that the field value should not be printed out when using debug
    /// formats, e.g. when the field contains sensitive credentials.
    pub debug_redact: bool,

    pub retention: crate::field_options::OptionRetention,

    pub targets: std::vec::Vec<crate::field_options::OptionTargetType>,

    pub edition_defaults: std::vec::Vec<crate::field_options::EditionDefault>,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    pub feature_support: std::option::Option<crate::field_options::FeatureSupport>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FieldOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [ctype][crate::FieldOptions::ctype].
    pub fn set_ctype<T: std::convert::Into<crate::field_options::CType>>(mut self, v: T) -> Self {
        self.ctype = v.into();
        self
    }

    /// Sets the value of [packed][crate::FieldOptions::packed].
    pub fn set_packed<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.packed = v.into();
        self
    }

    /// Sets the value of [jstype][crate::FieldOptions::jstype].
    pub fn set_jstype<T: std::convert::Into<crate::field_options::JSType>>(mut self, v: T) -> Self {
        self.jstype = v.into();
        self
    }

    /// Sets the value of [lazy][crate::FieldOptions::lazy].
    pub fn set_lazy<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.lazy = v.into();
        self
    }

    /// Sets the value of [unverified_lazy][crate::FieldOptions::unverified_lazy].
    pub fn set_unverified_lazy<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.unverified_lazy = v.into();
        self
    }

    /// Sets the value of [deprecated][crate::FieldOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [weak][crate::FieldOptions::weak].
    pub fn set_weak<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.weak = v.into();
        self
    }

    /// Sets the value of [debug_redact][crate::FieldOptions::debug_redact].
    pub fn set_debug_redact<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.debug_redact = v.into();
        self
    }

    /// Sets the value of [retention][crate::FieldOptions::retention].
    pub fn set_retention<T: std::convert::Into<crate::field_options::OptionRetention>>(
        mut self,
        v: T,
    ) -> Self {
        self.retention = v.into();
        self
    }

    /// Sets the value of [targets][crate::FieldOptions::targets].
    pub fn set_targets<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::field_options::OptionTargetType>,
    {
        use std::iter::Iterator;
        self.targets = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [edition_defaults][crate::FieldOptions::edition_defaults].
    pub fn set_edition_defaults<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::field_options::EditionDefault>,
    {
        use std::iter::Iterator;
        self.edition_defaults = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [features][crate::FieldOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::FieldOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [feature_support][crate::FieldOptions::feature_support].
    pub fn set_feature_support<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::field_options::FeatureSupport>,
    {
        self.feature_support = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [feature_support][crate::FieldOptions::feature_support].
    pub fn set_or_clear_feature_support<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::field_options::FeatureSupport>,
    {
        self.feature_support = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::FieldOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for FieldOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FieldOptions"
    }
}

/// Defines additional types related to [FieldOptions].
pub mod field_options {
    #[allow(unused_imports)]
    use super::*;

    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct EditionDefault {
        pub edition: crate::Edition,

        pub value: std::string::String,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl EditionDefault {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [edition][crate::field_options::EditionDefault::edition].
        pub fn set_edition<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
            self.edition = v.into();
            self
        }

        /// Sets the value of [value][crate::field_options::EditionDefault::value].
        pub fn set_value<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.value = v.into();
            self
        }
    }

    impl wkt::message::Message for EditionDefault {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.FieldOptions.EditionDefault"
        }
    }

    /// Information about the support window of a feature.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct FeatureSupport {
        /// The edition that this feature was first available in.  In editions
        /// earlier than this one, the default assigned to EDITION_LEGACY will be
        /// used, and proto files will not be able to override it.
        pub edition_introduced: crate::Edition,

        /// The edition this feature becomes deprecated in.  Using this after this
        /// edition may trigger warnings.
        pub edition_deprecated: crate::Edition,

        /// The deprecation warning text if this feature is used after the edition it
        /// was marked deprecated in.
        pub deprecation_warning: std::string::String,

        /// The edition this feature is no longer available in.  In editions after
        /// this one, the last default assigned will be used, and proto files will
        /// not be able to override it.
        pub edition_removed: crate::Edition,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl FeatureSupport {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [edition_introduced][crate::field_options::FeatureSupport::edition_introduced].
        pub fn set_edition_introduced<T: std::convert::Into<crate::Edition>>(
            mut self,
            v: T,
        ) -> Self {
            self.edition_introduced = v.into();
            self
        }

        /// Sets the value of [edition_deprecated][crate::field_options::FeatureSupport::edition_deprecated].
        pub fn set_edition_deprecated<T: std::convert::Into<crate::Edition>>(
            mut self,
            v: T,
        ) -> Self {
            self.edition_deprecated = v.into();
            self
        }

        /// Sets the value of [deprecation_warning][crate::field_options::FeatureSupport::deprecation_warning].
        pub fn set_deprecation_warning<T: std::convert::Into<std::string::String>>(
            mut self,
            v: T,
        ) -> Self {
            self.deprecation_warning = v.into();
            self
        }

        /// Sets the value of [edition_removed][crate::field_options::FeatureSupport::edition_removed].
        pub fn set_edition_removed<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
            self.edition_removed = v.into();
            self
        }
    }

    impl wkt::message::Message for FeatureSupport {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.FieldOptions.FeatureSupport"
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum CType {
        /// Default mode.
        String,
        /// The option [ctype=CORD] may be applied to a non-repeated field of type
        /// "bytes". It indicates that in C++, the data should be stored in a Cord
        /// instead of a string.  For very large strings, this may reduce memory
        /// fragmentation. It may also allow better performance when parsing from a
        /// Cord, or when parsing with aliasing enabled, as the parsed Cord may then
        /// alias the original buffer.
        Cord,
        StringPiece,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [CType::value] or
        /// [CType::name].
        UnknownValue(c_type::UnknownValue),
    }

    #[doc(hidden)]
    pub mod c_type {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl CType {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::String => std::option::Option::Some(0),
                Self::Cord => std::option::Option::Some(1),
                Self::StringPiece => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::String => std::option::Option::Some("STRING"),
                Self::Cord => std::option::Option::Some("CORD"),
                Self::StringPiece => std::option::Option::Some("STRING_PIECE"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for CType {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for CType {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for CType {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::String,
                1 => Self::Cord,
                2 => Self::StringPiece,
                _ => Self::UnknownValue(c_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for CType {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "STRING" => Self::String,
                "CORD" => Self::Cord,
                "STRING_PIECE" => Self::StringPiece,
                _ => Self::UnknownValue(c_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for CType {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::String => serializer.serialize_i32(0),
                Self::Cord => serializer.serialize_i32(1),
                Self::StringPiece => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for CType {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<CType>::new(
                ".google.protobuf.FieldOptions.CType",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum JSType {
        /// Use the default type.
        JsNormal,
        /// Use JavaScript strings.
        JsString,
        /// Use JavaScript numbers.
        JsNumber,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [JSType::value] or
        /// [JSType::name].
        UnknownValue(js_type::UnknownValue),
    }

    #[doc(hidden)]
    pub mod js_type {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl JSType {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::JsNormal => std::option::Option::Some(0),
                Self::JsString => std::option::Option::Some(1),
                Self::JsNumber => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::JsNormal => std::option::Option::Some("JS_NORMAL"),
                Self::JsString => std::option::Option::Some("JS_STRING"),
                Self::JsNumber => std::option::Option::Some("JS_NUMBER"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for JSType {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for JSType {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for JSType {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::JsNormal,
                1 => Self::JsString,
                2 => Self::JsNumber,
                _ => Self::UnknownValue(js_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for JSType {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "JS_NORMAL" => Self::JsNormal,
                "JS_STRING" => Self::JsString,
                "JS_NUMBER" => Self::JsNumber,
                _ => Self::UnknownValue(js_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for JSType {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::JsNormal => serializer.serialize_i32(0),
                Self::JsString => serializer.serialize_i32(1),
                Self::JsNumber => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for JSType {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<JSType>::new(
                ".google.protobuf.FieldOptions.JSType",
            ))
        }
    }

    /// If set to RETENTION_SOURCE, the option will be omitted from the binary.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum OptionRetention {
        RetentionUnknown,
        RetentionRuntime,
        RetentionSource,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [OptionRetention::value] or
        /// [OptionRetention::name].
        UnknownValue(option_retention::UnknownValue),
    }

    #[doc(hidden)]
    pub mod option_retention {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl OptionRetention {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::RetentionUnknown => std::option::Option::Some(0),
                Self::RetentionRuntime => std::option::Option::Some(1),
                Self::RetentionSource => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::RetentionUnknown => std::option::Option::Some("RETENTION_UNKNOWN"),
                Self::RetentionRuntime => std::option::Option::Some("RETENTION_RUNTIME"),
                Self::RetentionSource => std::option::Option::Some("RETENTION_SOURCE"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for OptionRetention {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for OptionRetention {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for OptionRetention {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::RetentionUnknown,
                1 => Self::RetentionRuntime,
                2 => Self::RetentionSource,
                _ => Self::UnknownValue(option_retention::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for OptionRetention {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "RETENTION_UNKNOWN" => Self::RetentionUnknown,
                "RETENTION_RUNTIME" => Self::RetentionRuntime,
                "RETENTION_SOURCE" => Self::RetentionSource,
                _ => Self::UnknownValue(option_retention::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for OptionRetention {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::RetentionUnknown => serializer.serialize_i32(0),
                Self::RetentionRuntime => serializer.serialize_i32(1),
                Self::RetentionSource => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for OptionRetention {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<OptionRetention>::new(
                ".google.protobuf.FieldOptions.OptionRetention",
            ))
        }
    }

    /// This indicates the types of entities that the field may apply to when used
    /// as an option. If it is unset, then the field may be freely used as an
    /// option on any kind of entity.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum OptionTargetType {
        TargetTypeUnknown,
        TargetTypeFile,
        TargetTypeExtensionRange,
        TargetTypeMessage,
        TargetTypeField,
        TargetTypeOneof,
        TargetTypeEnum,
        TargetTypeEnumEntry,
        TargetTypeService,
        TargetTypeMethod,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [OptionTargetType::value] or
        /// [OptionTargetType::name].
        UnknownValue(option_target_type::UnknownValue),
    }

    #[doc(hidden)]
    pub mod option_target_type {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl OptionTargetType {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::TargetTypeUnknown => std::option::Option::Some(0),
                Self::TargetTypeFile => std::option::Option::Some(1),
                Self::TargetTypeExtensionRange => std::option::Option::Some(2),
                Self::TargetTypeMessage => std::option::Option::Some(3),
                Self::TargetTypeField => std::option::Option::Some(4),
                Self::TargetTypeOneof => std::option::Option::Some(5),
                Self::TargetTypeEnum => std::option::Option::Some(6),
                Self::TargetTypeEnumEntry => std::option::Option::Some(7),
                Self::TargetTypeService => std::option::Option::Some(8),
                Self::TargetTypeMethod => std::option::Option::Some(9),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::TargetTypeUnknown => std::option::Option::Some("TARGET_TYPE_UNKNOWN"),
                Self::TargetTypeFile => std::option::Option::Some("TARGET_TYPE_FILE"),
                Self::TargetTypeExtensionRange => {
                    std::option::Option::Some("TARGET_TYPE_EXTENSION_RANGE")
                }
                Self::TargetTypeMessage => std::option::Option::Some("TARGET_TYPE_MESSAGE"),
                Self::TargetTypeField => std::option::Option::Some("TARGET_TYPE_FIELD"),
                Self::TargetTypeOneof => std::option::Option::Some("TARGET_TYPE_ONEOF"),
                Self::TargetTypeEnum => std::option::Option::Some("TARGET_TYPE_ENUM"),
                Self::TargetTypeEnumEntry => std::option::Option::Some("TARGET_TYPE_ENUM_ENTRY"),
                Self::TargetTypeService => std::option::Option::Some("TARGET_TYPE_SERVICE"),
                Self::TargetTypeMethod => std::option::Option::Some("TARGET_TYPE_METHOD"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for OptionTargetType {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for OptionTargetType {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for OptionTargetType {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::TargetTypeUnknown,
                1 => Self::TargetTypeFile,
                2 => Self::TargetTypeExtensionRange,
                3 => Self::TargetTypeMessage,
                4 => Self::TargetTypeField,
                5 => Self::TargetTypeOneof,
                6 => Self::TargetTypeEnum,
                7 => Self::TargetTypeEnumEntry,
                8 => Self::TargetTypeService,
                9 => Self::TargetTypeMethod,
                _ => Self::UnknownValue(option_target_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for OptionTargetType {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "TARGET_TYPE_UNKNOWN" => Self::TargetTypeUnknown,
                "TARGET_TYPE_FILE" => Self::TargetTypeFile,
                "TARGET_TYPE_EXTENSION_RANGE" => Self::TargetTypeExtensionRange,
                "TARGET_TYPE_MESSAGE" => Self::TargetTypeMessage,
                "TARGET_TYPE_FIELD" => Self::TargetTypeField,
                "TARGET_TYPE_ONEOF" => Self::TargetTypeOneof,
                "TARGET_TYPE_ENUM" => Self::TargetTypeEnum,
                "TARGET_TYPE_ENUM_ENTRY" => Self::TargetTypeEnumEntry,
                "TARGET_TYPE_SERVICE" => Self::TargetTypeService,
                "TARGET_TYPE_METHOD" => Self::TargetTypeMethod,
                _ => Self::UnknownValue(option_target_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for OptionTargetType {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::TargetTypeUnknown => serializer.serialize_i32(0),
                Self::TargetTypeFile => serializer.serialize_i32(1),
                Self::TargetTypeExtensionRange => serializer.serialize_i32(2),
                Self::TargetTypeMessage => serializer.serialize_i32(3),
                Self::TargetTypeField => serializer.serialize_i32(4),
                Self::TargetTypeOneof => serializer.serialize_i32(5),
                Self::TargetTypeEnum => serializer.serialize_i32(6),
                Self::TargetTypeEnumEntry => serializer.serialize_i32(7),
                Self::TargetTypeService => serializer.serialize_i32(8),
                Self::TargetTypeMethod => serializer.serialize_i32(9),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for OptionTargetType {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<OptionTargetType>::new(
                ".google.protobuf.FieldOptions.OptionTargetType",
            ))
        }
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct OneofOptions {
    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl OneofOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [features][crate::OneofOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::OneofOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::OneofOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for OneofOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.OneofOptions"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct EnumOptions {
    /// Set this option to true to allow mapping different tag names to the same
    /// value.
    pub allow_alias: bool,

    /// Is this enum deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for the enum, or it will be completely ignored; in the very least, this
    /// is a formalization for deprecating enums.
    pub deprecated: bool,

    /// Enable the legacy handling of JSON field name conflicts.  This lowercases
    /// and strips underscored from the fields before comparison in proto3 only.
    /// The new behavior takes `json_name` into account and applies to proto2 as
    /// well.
    /// TODO Remove this legacy behavior once downstream teams have
    /// had time to migrate.
    #[deprecated]
    pub deprecated_legacy_json_field_conflicts: bool,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl EnumOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [allow_alias][crate::EnumOptions::allow_alias].
    pub fn set_allow_alias<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.allow_alias = v.into();
        self
    }

    /// Sets the value of [deprecated][crate::EnumOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [deprecated_legacy_json_field_conflicts][crate::EnumOptions::deprecated_legacy_json_field_conflicts].
    #[deprecated]
    pub fn set_deprecated_legacy_json_field_conflicts<T: std::convert::Into<bool>>(
        mut self,
        v: T,
    ) -> Self {
        self.deprecated_legacy_json_field_conflicts = v.into();
        self
    }

    /// Sets the value of [features][crate::EnumOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::EnumOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::EnumOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for EnumOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.EnumOptions"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct EnumValueOptions {
    /// Is this enum value deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for the enum value, or it will be completely ignored; in the very least,
    /// this is a formalization for deprecating enum values.
    pub deprecated: bool,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// Indicate that fields annotated with this enum value should not be printed
    /// out when using debug formats, e.g. when the field contains sensitive
    /// credentials.
    pub debug_redact: bool,

    /// Information about the support window of a feature value.
    pub feature_support: std::option::Option<crate::field_options::FeatureSupport>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl EnumValueOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [deprecated][crate::EnumValueOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [features][crate::EnumValueOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::EnumValueOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [debug_redact][crate::EnumValueOptions::debug_redact].
    pub fn set_debug_redact<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.debug_redact = v.into();
        self
    }

    /// Sets the value of [feature_support][crate::EnumValueOptions::feature_support].
    pub fn set_feature_support<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::field_options::FeatureSupport>,
    {
        self.feature_support = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [feature_support][crate::EnumValueOptions::feature_support].
    pub fn set_or_clear_feature_support<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::field_options::FeatureSupport>,
    {
        self.feature_support = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::EnumValueOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for EnumValueOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.EnumValueOptions"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct ServiceOptions {
    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// Is this service deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for the service, or it will be completely ignored; in the very least,
    /// this is a formalization for deprecating services.
    pub deprecated: bool,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl ServiceOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [features][crate::ServiceOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::ServiceOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [deprecated][crate::ServiceOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [uninterpreted_option][crate::ServiceOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for ServiceOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.ServiceOptions"
    }
}

#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct MethodOptions {
    /// Is this method deprecated?
    /// Depending on the target platform, this can emit Deprecated annotations
    /// for the method, or it will be completely ignored; in the very least,
    /// this is a formalization for deprecating methods.
    pub deprecated: bool,

    pub idempotency_level: crate::method_options::IdempotencyLevel,

    /// Any features defined in the specific edition.
    pub features: std::option::Option<crate::FeatureSet>,

    /// The parser stores options it doesn't recognize here. See above.
    pub uninterpreted_option: std::vec::Vec<crate::UninterpretedOption>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl MethodOptions {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [deprecated][crate::MethodOptions::deprecated].
    pub fn set_deprecated<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.deprecated = v.into();
        self
    }

    /// Sets the value of [idempotency_level][crate::MethodOptions::idempotency_level].
    pub fn set_idempotency_level<T: std::convert::Into<crate::method_options::IdempotencyLevel>>(
        mut self,
        v: T,
    ) -> Self {
        self.idempotency_level = v.into();
        self
    }

    /// Sets the value of [features][crate::MethodOptions::features].
    pub fn set_features<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [features][crate::MethodOptions::features].
    pub fn set_or_clear_features<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::FeatureSet>,
    {
        self.features = v.map(|x| x.into());
        self
    }

    /// Sets the value of [uninterpreted_option][crate::MethodOptions::uninterpreted_option].
    pub fn set_uninterpreted_option<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::UninterpretedOption>,
    {
        use std::iter::Iterator;
        self.uninterpreted_option = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for MethodOptions {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.MethodOptions"
    }
}

/// Defines additional types related to [MethodOptions].
pub mod method_options {
    #[allow(unused_imports)]
    use super::*;

    /// Is this method side-effect-free (or safe in HTTP parlance), or idempotent,
    /// or neither? HTTP based RPC implementation may choose GET verb for safe
    /// methods, and PUT verb for idempotent methods instead of the default POST.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum IdempotencyLevel {
        IdempotencyUnknown,
        NoSideEffects,
        Idempotent,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [IdempotencyLevel::value] or
        /// [IdempotencyLevel::name].
        UnknownValue(idempotency_level::UnknownValue),
    }

    #[doc(hidden)]
    pub mod idempotency_level {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl IdempotencyLevel {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::IdempotencyUnknown => std::option::Option::Some(0),
                Self::NoSideEffects => std::option::Option::Some(1),
                Self::Idempotent => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::IdempotencyUnknown => std::option::Option::Some("IDEMPOTENCY_UNKNOWN"),
                Self::NoSideEffects => std::option::Option::Some("NO_SIDE_EFFECTS"),
                Self::Idempotent => std::option::Option::Some("IDEMPOTENT"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for IdempotencyLevel {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for IdempotencyLevel {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for IdempotencyLevel {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::IdempotencyUnknown,
                1 => Self::NoSideEffects,
                2 => Self::Idempotent,
                _ => Self::UnknownValue(idempotency_level::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for IdempotencyLevel {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "IDEMPOTENCY_UNKNOWN" => Self::IdempotencyUnknown,
                "NO_SIDE_EFFECTS" => Self::NoSideEffects,
                "IDEMPOTENT" => Self::Idempotent,
                _ => Self::UnknownValue(idempotency_level::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for IdempotencyLevel {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::IdempotencyUnknown => serializer.serialize_i32(0),
                Self::NoSideEffects => serializer.serialize_i32(1),
                Self::Idempotent => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for IdempotencyLevel {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<IdempotencyLevel>::new(
                ".google.protobuf.MethodOptions.IdempotencyLevel",
            ))
        }
    }
}

/// A message representing a option the parser does not recognize. This only
/// appears in options protos created by the compiler::Parser class.
/// DescriptorPool resolves these when building Descriptor objects. Therefore,
/// options protos in descriptor objects (e.g. returned by Descriptor::options(),
/// or produced by Descriptor::CopyTo()) will never have UninterpretedOptions
/// in them.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct UninterpretedOption {
    pub name: std::vec::Vec<crate::uninterpreted_option::NamePart>,

    /// The value of the uninterpreted option, in whatever type the tokenizer
    /// identified it as during parsing. Exactly one of these should be set.
    pub identifier_value: std::string::String,

    pub positive_int_value: u64,

    pub negative_int_value: i64,

    pub double_value: f64,

    pub string_value: ::bytes::Bytes,

    pub aggregate_value: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl UninterpretedOption {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::UninterpretedOption::name].
    pub fn set_name<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::uninterpreted_option::NamePart>,
    {
        use std::iter::Iterator;
        self.name = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [identifier_value][crate::UninterpretedOption::identifier_value].
    pub fn set_identifier_value<T: std::convert::Into<std::string::String>>(
        mut self,
        v: T,
    ) -> Self {
        self.identifier_value = v.into();
        self
    }

    /// Sets the value of [positive_int_value][crate::UninterpretedOption::positive_int_value].
    pub fn set_positive_int_value<T: std::convert::Into<u64>>(mut self, v: T) -> Self {
        self.positive_int_value = v.into();
        self
    }

    /// Sets the value of [negative_int_value][crate::UninterpretedOption::negative_int_value].
    pub fn set_negative_int_value<T: std::convert::Into<i64>>(mut self, v: T) -> Self {
        self.negative_int_value = v.into();
        self
    }

    /// Sets the value of [double_value][crate::UninterpretedOption::double_value].
    pub fn set_double_value<T: std::convert::Into<f64>>(mut self, v: T) -> Self {
        self.double_value = v.into();
        self
    }

    /// Sets the value of [string_value][crate::UninterpretedOption::string_value].
    pub fn set_string_value<T: std::convert::Into<::bytes::Bytes>>(mut self, v: T) -> Self {
        self.string_value = v.into();
        self
    }

    /// Sets the value of [aggregate_value][crate::UninterpretedOption::aggregate_value].
    pub fn set_aggregate_value<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.aggregate_value = v.into();
        self
    }
}

impl wkt::message::Message for UninterpretedOption {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.UninterpretedOption"
    }
}

/// Defines additional types related to [UninterpretedOption].
pub mod uninterpreted_option {
    #[allow(unused_imports)]
    use super::*;

    /// The name of the uninterpreted option.  Each string represents a segment in
    /// a dot-separated name.  is_extension is true iff a segment represents an
    /// extension (denoted with parentheses in options specs in .proto files).
    /// E.g.,{ ["foo", false], ["bar.baz", true], ["moo", false] } represents
    /// "foo.(bar.baz).moo".
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct NamePart {
        pub name_part: std::string::String,

        pub is_extension: bool,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl NamePart {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [name_part][crate::uninterpreted_option::NamePart::name_part].
        pub fn set_name_part<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.name_part = v.into();
            self
        }

        /// Sets the value of [is_extension][crate::uninterpreted_option::NamePart::is_extension].
        pub fn set_is_extension<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
            self.is_extension = v.into();
            self
        }
    }

    impl wkt::message::Message for NamePart {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.UninterpretedOption.NamePart"
        }
    }
}

/// TODO Enums in C++ gencode (and potentially other languages) are
/// not well scoped.  This means that each of the feature enums below can clash
/// with each other.  The short names we've chosen maximize call-site
/// readability, but leave us very open to this scenario.  A future feature will
/// be designed and implemented to handle this, hopefully before we ever hit a
/// conflict here.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FeatureSet {
    pub field_presence: crate::feature_set::FieldPresence,

    pub enum_type: crate::feature_set::EnumType,

    pub repeated_field_encoding: crate::feature_set::RepeatedFieldEncoding,

    pub utf8_validation: crate::feature_set::Utf8Validation,

    pub message_encoding: crate::feature_set::MessageEncoding,

    pub json_format: crate::feature_set::JsonFormat,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FeatureSet {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [field_presence][crate::FeatureSet::field_presence].
    pub fn set_field_presence<T: std::convert::Into<crate::feature_set::FieldPresence>>(
        mut self,
        v: T,
    ) -> Self {
        self.field_presence = v.into();
        self
    }

    /// Sets the value of [enum_type][crate::FeatureSet::enum_type].
    pub fn set_enum_type<T: std::convert::Into<crate::feature_set::EnumType>>(
        mut self,
        v: T,
    ) -> Self {
        self.enum_type = v.into();
        self
    }

    /// Sets the value of [repeated_field_encoding][crate::FeatureSet::repeated_field_encoding].
    pub fn set_repeated_field_encoding<
        T: std::convert::Into<crate::feature_set::RepeatedFieldEncoding>,
    >(
        mut self,
        v: T,
    ) -> Self {
        self.repeated_field_encoding = v.into();
        self
    }

    /// Sets the value of [utf8_validation][crate::FeatureSet::utf8_validation].
    pub fn set_utf8_validation<T: std::convert::Into<crate::feature_set::Utf8Validation>>(
        mut self,
        v: T,
    ) -> Self {
        self.utf8_validation = v.into();
        self
    }

    /// Sets the value of [message_encoding][crate::FeatureSet::message_encoding].
    pub fn set_message_encoding<T: std::convert::Into<crate::feature_set::MessageEncoding>>(
        mut self,
        v: T,
    ) -> Self {
        self.message_encoding = v.into();
        self
    }

    /// Sets the value of [json_format][crate::FeatureSet::json_format].
    pub fn set_json_format<T: std::convert::Into<crate::feature_set::JsonFormat>>(
        mut self,
        v: T,
    ) -> Self {
        self.json_format = v.into();
        self
    }
}

impl wkt::message::Message for FeatureSet {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FeatureSet"
    }
}

/// Defines additional types related to [FeatureSet].
pub mod feature_set {
    #[allow(unused_imports)]
    use super::*;

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum FieldPresence {
        Unknown,
        Explicit,
        Implicit,
        LegacyRequired,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [FieldPresence::value] or
        /// [FieldPresence::name].
        UnknownValue(field_presence::UnknownValue),
    }

    #[doc(hidden)]
    pub mod field_presence {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl FieldPresence {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Explicit => std::option::Option::Some(1),
                Self::Implicit => std::option::Option::Some(2),
                Self::LegacyRequired => std::option::Option::Some(3),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("FIELD_PRESENCE_UNKNOWN"),
                Self::Explicit => std::option::Option::Some("EXPLICIT"),
                Self::Implicit => std::option::Option::Some("IMPLICIT"),
                Self::LegacyRequired => std::option::Option::Some("LEGACY_REQUIRED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for FieldPresence {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for FieldPresence {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for FieldPresence {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::Explicit,
                2 => Self::Implicit,
                3 => Self::LegacyRequired,
                _ => Self::UnknownValue(field_presence::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for FieldPresence {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "FIELD_PRESENCE_UNKNOWN" => Self::Unknown,
                "EXPLICIT" => Self::Explicit,
                "IMPLICIT" => Self::Implicit,
                "LEGACY_REQUIRED" => Self::LegacyRequired,
                _ => Self::UnknownValue(field_presence::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for FieldPresence {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Explicit => serializer.serialize_i32(1),
                Self::Implicit => serializer.serialize_i32(2),
                Self::LegacyRequired => serializer.serialize_i32(3),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for FieldPresence {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<FieldPresence>::new(
                ".google.protobuf.FeatureSet.FieldPresence",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum EnumType {
        Unknown,
        Open,
        Closed,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [EnumType::value] or
        /// [EnumType::name].
        UnknownValue(enum_type::UnknownValue),
    }

    #[doc(hidden)]
    pub mod enum_type {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl EnumType {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Open => std::option::Option::Some(1),
                Self::Closed => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("ENUM_TYPE_UNKNOWN"),
                Self::Open => std::option::Option::Some("OPEN"),
                Self::Closed => std::option::Option::Some("CLOSED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for EnumType {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for EnumType {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for EnumType {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::Open,
                2 => Self::Closed,
                _ => Self::UnknownValue(enum_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for EnumType {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "ENUM_TYPE_UNKNOWN" => Self::Unknown,
                "OPEN" => Self::Open,
                "CLOSED" => Self::Closed,
                _ => Self::UnknownValue(enum_type::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for EnumType {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Open => serializer.serialize_i32(1),
                Self::Closed => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for EnumType {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<EnumType>::new(
                ".google.protobuf.FeatureSet.EnumType",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum RepeatedFieldEncoding {
        Unknown,
        Packed,
        Expanded,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [RepeatedFieldEncoding::value] or
        /// [RepeatedFieldEncoding::name].
        UnknownValue(repeated_field_encoding::UnknownValue),
    }

    #[doc(hidden)]
    pub mod repeated_field_encoding {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl RepeatedFieldEncoding {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Packed => std::option::Option::Some(1),
                Self::Expanded => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("REPEATED_FIELD_ENCODING_UNKNOWN"),
                Self::Packed => std::option::Option::Some("PACKED"),
                Self::Expanded => std::option::Option::Some("EXPANDED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for RepeatedFieldEncoding {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for RepeatedFieldEncoding {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for RepeatedFieldEncoding {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::Packed,
                2 => Self::Expanded,
                _ => Self::UnknownValue(repeated_field_encoding::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for RepeatedFieldEncoding {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "REPEATED_FIELD_ENCODING_UNKNOWN" => Self::Unknown,
                "PACKED" => Self::Packed,
                "EXPANDED" => Self::Expanded,
                _ => Self::UnknownValue(repeated_field_encoding::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for RepeatedFieldEncoding {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Packed => serializer.serialize_i32(1),
                Self::Expanded => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for RepeatedFieldEncoding {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<RepeatedFieldEncoding>::new(
                ".google.protobuf.FeatureSet.RepeatedFieldEncoding",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum Utf8Validation {
        Unknown,
        Verify,
        None,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [Utf8Validation::value] or
        /// [Utf8Validation::name].
        UnknownValue(utf_8_validation::UnknownValue),
    }

    #[doc(hidden)]
    pub mod utf_8_validation {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl Utf8Validation {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Verify => std::option::Option::Some(2),
                Self::None => std::option::Option::Some(3),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("UTF8_VALIDATION_UNKNOWN"),
                Self::Verify => std::option::Option::Some("VERIFY"),
                Self::None => std::option::Option::Some("NONE"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for Utf8Validation {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for Utf8Validation {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for Utf8Validation {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                2 => Self::Verify,
                3 => Self::None,
                _ => Self::UnknownValue(utf_8_validation::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for Utf8Validation {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "UTF8_VALIDATION_UNKNOWN" => Self::Unknown,
                "VERIFY" => Self::Verify,
                "NONE" => Self::None,
                _ => Self::UnknownValue(utf_8_validation::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for Utf8Validation {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Verify => serializer.serialize_i32(2),
                Self::None => serializer.serialize_i32(3),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for Utf8Validation {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<Utf8Validation>::new(
                ".google.protobuf.FeatureSet.Utf8Validation",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum MessageEncoding {
        Unknown,
        LengthPrefixed,
        Delimited,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [MessageEncoding::value] or
        /// [MessageEncoding::name].
        UnknownValue(message_encoding::UnknownValue),
    }

    #[doc(hidden)]
    pub mod message_encoding {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl MessageEncoding {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::LengthPrefixed => std::option::Option::Some(1),
                Self::Delimited => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("MESSAGE_ENCODING_UNKNOWN"),
                Self::LengthPrefixed => std::option::Option::Some("LENGTH_PREFIXED"),
                Self::Delimited => std::option::Option::Some("DELIMITED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for MessageEncoding {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for MessageEncoding {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for MessageEncoding {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::LengthPrefixed,
                2 => Self::Delimited,
                _ => Self::UnknownValue(message_encoding::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for MessageEncoding {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "MESSAGE_ENCODING_UNKNOWN" => Self::Unknown,
                "LENGTH_PREFIXED" => Self::LengthPrefixed,
                "DELIMITED" => Self::Delimited,
                _ => Self::UnknownValue(message_encoding::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for MessageEncoding {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::LengthPrefixed => serializer.serialize_i32(1),
                Self::Delimited => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for MessageEncoding {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<MessageEncoding>::new(
                ".google.protobuf.FeatureSet.MessageEncoding",
            ))
        }
    }

    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum JsonFormat {
        Unknown,
        Allow,
        LegacyBestEffort,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [JsonFormat::value] or
        /// [JsonFormat::name].
        UnknownValue(json_format::UnknownValue),
    }

    #[doc(hidden)]
    pub mod json_format {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl JsonFormat {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Allow => std::option::Option::Some(1),
                Self::LegacyBestEffort => std::option::Option::Some(2),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("JSON_FORMAT_UNKNOWN"),
                Self::Allow => std::option::Option::Some("ALLOW"),
                Self::LegacyBestEffort => std::option::Option::Some("LEGACY_BEST_EFFORT"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for JsonFormat {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for JsonFormat {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for JsonFormat {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::Allow,
                2 => Self::LegacyBestEffort,
                _ => Self::UnknownValue(json_format::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for JsonFormat {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "JSON_FORMAT_UNKNOWN" => Self::Unknown,
                "ALLOW" => Self::Allow,
                "LEGACY_BEST_EFFORT" => Self::LegacyBestEffort,
                _ => Self::UnknownValue(json_format::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for JsonFormat {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Allow => serializer.serialize_i32(1),
                Self::LegacyBestEffort => serializer.serialize_i32(2),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for JsonFormat {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<JsonFormat>::new(
                ".google.protobuf.FeatureSet.JsonFormat",
            ))
        }
    }
}

/// A compiled specification for the defaults of a set of features.  These
/// messages are generated from FeatureSet extensions and can be used to seed
/// feature resolution. The resolution with this object becomes a simple search
/// for the closest matching edition, followed by proto merges.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct FeatureSetDefaults {
    pub defaults: std::vec::Vec<crate::feature_set_defaults::FeatureSetEditionDefault>,

    /// The minimum supported edition (inclusive) when this was constructed.
    /// Editions before this will not have defaults.
    pub minimum_edition: crate::Edition,

    /// The maximum known edition (inclusive) when this was constructed. Editions
    /// after this will not have reliable defaults.
    pub maximum_edition: crate::Edition,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl FeatureSetDefaults {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [defaults][crate::FeatureSetDefaults::defaults].
    pub fn set_defaults<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::feature_set_defaults::FeatureSetEditionDefault>,
    {
        use std::iter::Iterator;
        self.defaults = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [minimum_edition][crate::FeatureSetDefaults::minimum_edition].
    pub fn set_minimum_edition<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
        self.minimum_edition = v.into();
        self
    }

    /// Sets the value of [maximum_edition][crate::FeatureSetDefaults::maximum_edition].
    pub fn set_maximum_edition<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
        self.maximum_edition = v.into();
        self
    }
}

impl wkt::message::Message for FeatureSetDefaults {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.FeatureSetDefaults"
    }
}

/// Defines additional types related to [FeatureSetDefaults].
pub mod feature_set_defaults {
    #[allow(unused_imports)]
    use super::*;

    /// A map from every known edition with a unique set of defaults to its
    /// defaults. Not all editions may be contained here.  For a given edition,
    /// the defaults at the closest matching edition ordered at or before it should
    /// be used.  This field must be in strict ascending order by edition.
    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct FeatureSetEditionDefault {
        pub edition: crate::Edition,

        /// Defaults of features that can be overridden in this edition.
        pub overridable_features: std::option::Option<crate::FeatureSet>,

        /// Defaults of features that can't be overridden in this edition.
        pub fixed_features: std::option::Option<crate::FeatureSet>,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl FeatureSetEditionDefault {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [edition][crate::feature_set_defaults::FeatureSetEditionDefault::edition].
        pub fn set_edition<T: std::convert::Into<crate::Edition>>(mut self, v: T) -> Self {
            self.edition = v.into();
            self
        }

        /// Sets the value of [overridable_features][crate::feature_set_defaults::FeatureSetEditionDefault::overridable_features].
        pub fn set_overridable_features<T>(mut self, v: T) -> Self
        where
            T: std::convert::Into<crate::FeatureSet>,
        {
            self.overridable_features = std::option::Option::Some(v.into());
            self
        }

        /// Sets or clears the value of [overridable_features][crate::feature_set_defaults::FeatureSetEditionDefault::overridable_features].
        pub fn set_or_clear_overridable_features<T>(mut self, v: std::option::Option<T>) -> Self
        where
            T: std::convert::Into<crate::FeatureSet>,
        {
            self.overridable_features = v.map(|x| x.into());
            self
        }

        /// Sets the value of [fixed_features][crate::feature_set_defaults::FeatureSetEditionDefault::fixed_features].
        pub fn set_fixed_features<T>(mut self, v: T) -> Self
        where
            T: std::convert::Into<crate::FeatureSet>,
        {
            self.fixed_features = std::option::Option::Some(v.into());
            self
        }

        /// Sets or clears the value of [fixed_features][crate::feature_set_defaults::FeatureSetEditionDefault::fixed_features].
        pub fn set_or_clear_fixed_features<T>(mut self, v: std::option::Option<T>) -> Self
        where
            T: std::convert::Into<crate::FeatureSet>,
        {
            self.fixed_features = v.map(|x| x.into());
            self
        }
    }

    impl wkt::message::Message for FeatureSetEditionDefault {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.FeatureSetDefaults.FeatureSetEditionDefault"
        }
    }
}

/// Encapsulates information about the original source file from which a
/// FileDescriptorProto was generated.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct SourceCodeInfo {
    /// A Location identifies a piece of source code in a .proto file which
    /// corresponds to a particular definition.  This information is intended
    /// to be useful to IDEs, code indexers, documentation generators, and similar
    /// tools.
    ///
    /// For example, say we have a file like:
    /// message Foo {
    /// optional string foo = 1;
    /// }
    /// Let's look at just the field definition:
    /// optional string foo = 1;
    /// ^       ^^     ^^  ^  ^^^
    /// a       bc     de  f  ghi
    /// We have the following locations:
    /// span   path               represents
    /// [a,i)  [ 4, 0, 2, 0 ]     The whole field definition.
    /// [a,b)  [ 4, 0, 2, 0, 4 ]  The label (optional).
    /// [c,d)  [ 4, 0, 2, 0, 5 ]  The type (string).
    /// [e,f)  [ 4, 0, 2, 0, 1 ]  The name (foo).
    /// [g,h)  [ 4, 0, 2, 0, 3 ]  The number (1).
    ///
    /// Notes:
    ///
    /// - A location may refer to a repeated field itself (i.e. not to any
    ///   particular index within it).  This is used whenever a set of elements are
    ///   logically enclosed in a single code segment.  For example, an entire
    ///   extend block (possibly containing multiple extension definitions) will
    ///   have an outer location whose path refers to the "extensions" repeated
    ///   field without an index.
    /// - Multiple locations may have the same path.  This happens when a single
    ///   logical declaration is spread out across multiple places.  The most
    ///   obvious example is the "extend" block again -- there may be multiple
    ///   extend blocks in the same scope, each of which will have the same path.
    /// - A location's span is not always a subset of its parent's span.  For
    ///   example, the "extendee" of an extension declaration appears at the
    ///   beginning of the "extend" block and is shared by all extensions within
    ///   the block.
    /// - Just because a location's span is a subset of some other location's span
    ///   does not mean that it is a descendant.  For example, a "group" defines
    ///   both a type and a field in a single declaration.  Thus, the locations
    ///   corresponding to the type and field and their components will overlap.
    /// - Code which tries to interpret locations should probably be designed to
    ///   ignore those that it doesn't understand, as more types of locations could
    ///   be recorded in the future.
    pub location: std::vec::Vec<crate::source_code_info::Location>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl SourceCodeInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [location][crate::SourceCodeInfo::location].
    pub fn set_location<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::source_code_info::Location>,
    {
        use std::iter::Iterator;
        self.location = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for SourceCodeInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.SourceCodeInfo"
    }
}

/// Defines additional types related to [SourceCodeInfo].
pub mod source_code_info {
    #[allow(unused_imports)]
    use super::*;

    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Location {
        /// Identifies which part of the FileDescriptorProto was defined at this
        /// location.
        ///
        /// Each element is a field number or an index.  They form a path from
        /// the root FileDescriptorProto to the place where the definition appears.
        /// For example, this path:
        /// [ 4, 3, 2, 7, 1 ]
        /// refers to:
        /// file.message_type(3)  // 4, 3
        /// .field(7)         // 2, 7
        /// .name()           // 1
        /// This is because FileDescriptorProto.message_type has field number 4:
        /// repeated DescriptorProto message_type = 4;
        /// and DescriptorProto.field has field number 2:
        /// repeated FieldDescriptorProto field = 2;
        /// and FieldDescriptorProto.name has field number 1:
        /// optional string name = 1;
        ///
        /// Thus, the above path gives the location of a field name.  If we removed
        /// the last element:
        /// [ 4, 3, 2, 7 ]
        /// this path refers to the whole field declaration (from the beginning
        /// of the label to the terminating semicolon).
        pub path: std::vec::Vec<i32>,

        /// Always has exactly three or four elements: start line, start column,
        /// end line (optional, otherwise assumed same as start line), end column.
        /// These are packed into a single field for efficiency.  Note that line
        /// and column numbers are zero-based -- typically you will want to add
        /// 1 to each before displaying to a user.
        pub span: std::vec::Vec<i32>,

        /// If this SourceCodeInfo represents a complete declaration, these are any
        /// comments appearing before and after the declaration which appear to be
        /// attached to the declaration.
        ///
        /// A series of line comments appearing on consecutive lines, with no other
        /// tokens appearing on those lines, will be treated as a single comment.
        ///
        /// leading_detached_comments will keep paragraphs of comments that appear
        /// before (but not connected to) the current element. Each paragraph,
        /// separated by empty lines, will be one comment element in the repeated
        /// field.
        ///
        /// Only the comment content is provided; comment markers (e.g. //) are
        /// stripped out.  For block comments, leading whitespace and an asterisk
        /// will be stripped from the beginning of each line other than the first.
        /// Newlines are included in the output.
        ///
        /// Examples:
        ///
        /// optional int32 foo = 1;  // Comment attached to foo.
        /// // Comment attached to bar.
        /// optional int32 bar = 2;
        ///
        /// optional string baz = 3;
        /// // Comment attached to baz.
        /// // Another line attached to baz.
        ///
        /// // Comment attached to moo.
        /// //
        /// // Another line attached to moo.
        /// optional double moo = 4;
        ///
        /// // Detached comment for corge. This is not leading or trailing comments
        /// // to moo or corge because there are blank lines separating it from
        /// // both.
        ///
        /// // Detached comment for corge paragraph 2.
        ///
        /// optional string corge = 5;
        /// /* Block comment attached
        ///
        /// * to corge.  Leading asterisks
        /// * will be removed. */
        ///   /* Block comment attached to
        /// * grault. */
        ///   optional int32 grault = 6;
        ///
        /// // ignored detached comments.
        pub leading_comments: std::string::String,

        pub trailing_comments: std::string::String,

        pub leading_detached_comments: std::vec::Vec<std::string::String>,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Location {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [path][crate::source_code_info::Location::path].
        pub fn set_path<T, V>(mut self, v: T) -> Self
        where
            T: std::iter::IntoIterator<Item = V>,
            V: std::convert::Into<i32>,
        {
            use std::iter::Iterator;
            self.path = v.into_iter().map(|i| i.into()).collect();
            self
        }

        /// Sets the value of [span][crate::source_code_info::Location::span].
        pub fn set_span<T, V>(mut self, v: T) -> Self
        where
            T: std::iter::IntoIterator<Item = V>,
            V: std::convert::Into<i32>,
        {
            use std::iter::Iterator;
            self.span = v.into_iter().map(|i| i.into()).collect();
            self
        }

        /// Sets the value of [leading_comments][crate::source_code_info::Location::leading_comments].
        pub fn set_leading_comments<T: std::convert::Into<std::string::String>>(
            mut self,
            v: T,
        ) -> Self {
            self.leading_comments = v.into();
            self
        }

        /// Sets the value of [trailing_comments][crate::source_code_info::Location::trailing_comments].
        pub fn set_trailing_comments<T: std::convert::Into<std::string::String>>(
            mut self,
            v: T,
        ) -> Self {
            self.trailing_comments = v.into();
            self
        }

        /// Sets the value of [leading_detached_comments][crate::source_code_info::Location::leading_detached_comments].
        pub fn set_leading_detached_comments<T, V>(mut self, v: T) -> Self
        where
            T: std::iter::IntoIterator<Item = V>,
            V: std::convert::Into<std::string::String>,
        {
            use std::iter::Iterator;
            self.leading_detached_comments = v.into_iter().map(|i| i.into()).collect();
            self
        }
    }

    impl wkt::message::Message for Location {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.SourceCodeInfo.Location"
        }
    }
}

/// Describes the relationship between generated code and its original source
/// file. A GeneratedCodeInfo message is associated with only one generated
/// source file, but may contain references to different source .proto files.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct GeneratedCodeInfo {
    /// An Annotation connects some span of text in generated code to an element
    /// of its generating .proto file.
    pub annotation: std::vec::Vec<crate::generated_code_info::Annotation>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl GeneratedCodeInfo {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [annotation][crate::GeneratedCodeInfo::annotation].
    pub fn set_annotation<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::generated_code_info::Annotation>,
    {
        use std::iter::Iterator;
        self.annotation = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for GeneratedCodeInfo {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.GeneratedCodeInfo"
    }
}

/// Defines additional types related to [GeneratedCodeInfo].
pub mod generated_code_info {
    #[allow(unused_imports)]
    use super::*;

    #[derive(Clone, Default, PartialEq)]
    #[non_exhaustive]
    pub struct Annotation {
        /// Identifies the element in the original source .proto file. This field
        /// is formatted the same as SourceCodeInfo.Location.path.
        pub path: std::vec::Vec<i32>,

        /// Identifies the filesystem path to the original source .proto.
        pub source_file: std::string::String,

        /// Identifies the starting offset in bytes in the generated code
        /// that relates to the identified object.
        pub begin: i32,

        /// Identifies the ending offset in bytes in the generated code that
        /// relates to the identified object. The end offset should be one past
        /// the last relevant byte (so the length of the text = end - begin).
        pub end: i32,

        pub semantic: crate::generated_code_info::annotation::Semantic,

        pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
    }

    impl Annotation {
        pub fn new() -> Self {
            std::default::Default::default()
        }

        /// Sets the value of [path][crate::generated_code_info::Annotation::path].
        pub fn set_path<T, V>(mut self, v: T) -> Self
        where
            T: std::iter::IntoIterator<Item = V>,
            V: std::convert::Into<i32>,
        {
            use std::iter::Iterator;
            self.path = v.into_iter().map(|i| i.into()).collect();
            self
        }

        /// Sets the value of [source_file][crate::generated_code_info::Annotation::source_file].
        pub fn set_source_file<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
            self.source_file = v.into();
            self
        }

        /// Sets the value of [begin][crate::generated_code_info::Annotation::begin].
        pub fn set_begin<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.begin = v.into();
            self
        }

        /// Sets the value of [end][crate::generated_code_info::Annotation::end].
        pub fn set_end<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
            self.end = v.into();
            self
        }

        /// Sets the value of [semantic][crate::generated_code_info::Annotation::semantic].
        pub fn set_semantic<
            T: std::convert::Into<crate::generated_code_info::annotation::Semantic>,
        >(
            mut self,
            v: T,
        ) -> Self {
            self.semantic = v.into();
            self
        }
    }

    impl wkt::message::Message for Annotation {
        fn typename() -> &'static str {
            "type.googleapis.com/google.protobuf.GeneratedCodeInfo.Annotation"
        }
    }

    /// Defines additional types related to [Annotation].
    pub mod annotation {
        #[allow(unused_imports)]
        use super::*;

        /// Represents the identified object's effect on the element in the original
        /// .proto file.
        ///
        /// # Working with unknown values
        ///
        /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
        /// additional enum variants at any time. Adding new variants is not considered
        /// a breaking change. Applications should write their code in anticipation of:
        ///
        /// - New values appearing in future releases of the client library, **and**
        /// - New values received dynamically, without application changes.
        ///
        /// Please consult the [Working with enums] section in the user guide for some
        /// guidelines.
        ///
        /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
        #[derive(Clone, Debug, PartialEq)]
        #[non_exhaustive]
        pub enum Semantic {
            /// There is no effect or the effect is indescribable.
            None,
            /// The element is set or otherwise mutated.
            Set,
            /// An alias to the element is returned.
            Alias,
            /// If set, the enum was initialized with an unknown value.
            ///
            /// Applications can examine the value using [Semantic::value] or
            /// [Semantic::name].
            UnknownValue(semantic::UnknownValue),
        }

        #[doc(hidden)]
        pub mod semantic {
            #[allow(unused_imports)]
            use super::*;
            #[derive(Clone, Debug, PartialEq)]
            pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
        }

        impl Semantic {
            /// Gets the enum value.
            ///
            /// Returns `None` if the enum contains an unknown value deserialized from
            /// the string representation of enums.
            pub fn value(&self) -> std::option::Option<i32> {
                match self {
                    Self::None => std::option::Option::Some(0),
                    Self::Set => std::option::Option::Some(1),
                    Self::Alias => std::option::Option::Some(2),
                    Self::UnknownValue(u) => u.0.value(),
                }
            }

            /// Gets the enum value as a string.
            ///
            /// Returns `None` if the enum contains an unknown value deserialized from
            /// the integer representation of enums.
            pub fn name(&self) -> std::option::Option<&str> {
                match self {
                    Self::None => std::option::Option::Some("NONE"),
                    Self::Set => std::option::Option::Some("SET"),
                    Self::Alias => std::option::Option::Some("ALIAS"),
                    Self::UnknownValue(u) => u.0.name(),
                }
            }
        }

        impl std::default::Default for Semantic {
            fn default() -> Self {
                use std::convert::From;
                Self::from(0)
            }
        }

        impl std::fmt::Display for Semantic {
            fn fmt(
                &self,
                f: &mut std::fmt::Formatter<'_>,
            ) -> std::result::Result<(), std::fmt::Error> {
                wkt::internal::display_enum(f, self.name(), self.value())
            }
        }

        impl std::convert::From<i32> for Semantic {
            fn from(value: i32) -> Self {
                match value {
                    0 => Self::None,
                    1 => Self::Set,
                    2 => Self::Alias,
                    _ => Self::UnknownValue(semantic::UnknownValue(
                        wkt::internal::UnknownEnumValue::Integer(value),
                    )),
                }
            }
        }

        impl std::convert::From<&str> for Semantic {
            fn from(value: &str) -> Self {
                use std::string::ToString;
                match value {
                    "NONE" => Self::None,
                    "SET" => Self::Set,
                    "ALIAS" => Self::Alias,
                    _ => Self::UnknownValue(semantic::UnknownValue(
                        wkt::internal::UnknownEnumValue::String(value.to_string()),
                    )),
                }
            }
        }

        impl serde::ser::Serialize for Semantic {
            fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
            where
                S: serde::Serializer,
            {
                match self {
                    Self::None => serializer.serialize_i32(0),
                    Self::Set => serializer.serialize_i32(1),
                    Self::Alias => serializer.serialize_i32(2),
                    Self::UnknownValue(u) => u.0.serialize(serializer),
                }
            }
        }

        impl<'de> serde::de::Deserialize<'de> for Semantic {
            fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
            where
                D: serde::Deserializer<'de>,
            {
                deserializer.deserialize_any(wkt::internal::EnumVisitor::<Semantic>::new(
                    ".google.protobuf.GeneratedCodeInfo.Annotation.Semantic",
                ))
            }
        }
    }
}

/// `SourceContext` represents information about the source of a
/// protobuf element, like the file in which it is defined.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct SourceContext {
    /// The path-qualified name of the .proto file that contained the associated
    /// protobuf element.  For example: `"google/protobuf/source_context.proto"`.
    pub file_name: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl SourceContext {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [file_name][crate::SourceContext::file_name].
    pub fn set_file_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.file_name = v.into();
        self
    }
}

impl wkt::message::Message for SourceContext {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.SourceContext"
    }
}

/// A protocol buffer message type.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Type {
    /// The fully qualified message name.
    pub name: std::string::String,

    /// The list of fields.
    pub fields: std::vec::Vec<crate::Field>,

    /// The list of types appearing in `oneof` definitions in this type.
    pub oneofs: std::vec::Vec<std::string::String>,

    /// The protocol buffer options.
    pub options: std::vec::Vec<crate::Option>,

    /// The source context.
    pub source_context: std::option::Option<crate::SourceContext>,

    /// The source syntax.
    pub syntax: crate::Syntax,

    /// The source edition string, only valid when syntax is SYNTAX_EDITIONS.
    pub edition: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Type {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Type::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [fields][crate::Type::fields].
    pub fn set_fields<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Field>,
    {
        use std::iter::Iterator;
        self.fields = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [oneofs][crate::Type::oneofs].
    pub fn set_oneofs<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<std::string::String>,
    {
        use std::iter::Iterator;
        self.oneofs = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::Type::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [source_context][crate::Type::source_context].
    pub fn set_source_context<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [source_context][crate::Type::source_context].
    pub fn set_or_clear_source_context<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = v.map(|x| x.into());
        self
    }

    /// Sets the value of [syntax][crate::Type::syntax].
    pub fn set_syntax<T: std::convert::Into<crate::Syntax>>(mut self, v: T) -> Self {
        self.syntax = v.into();
        self
    }

    /// Sets the value of [edition][crate::Type::edition].
    pub fn set_edition<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.edition = v.into();
        self
    }
}

impl wkt::message::Message for Type {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Type"
    }
}

/// A single field of a message type.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Field {
    /// The field type.
    pub kind: crate::field::Kind,

    /// The field cardinality.
    pub cardinality: crate::field::Cardinality,

    /// The field number.
    pub number: i32,

    /// The field name.
    pub name: std::string::String,

    /// The field type URL, without the scheme, for message or enumeration
    /// types. Example: `"type.googleapis.com/google.protobuf.Timestamp"`.
    pub type_url: std::string::String,

    /// The index of the field type in `Type.oneofs`, for message or enumeration
    /// types. The first type has index 1; zero means the type is not in the list.
    pub oneof_index: i32,

    /// Whether to use alternative packed wire representation.
    pub packed: bool,

    /// The protocol buffer options.
    pub options: std::vec::Vec<crate::Option>,

    /// The field JSON name.
    pub json_name: std::string::String,

    /// The string value of the default value of this field. Proto2 syntax only.
    pub default_value: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Field {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [kind][crate::Field::kind].
    pub fn set_kind<T: std::convert::Into<crate::field::Kind>>(mut self, v: T) -> Self {
        self.kind = v.into();
        self
    }

    /// Sets the value of [cardinality][crate::Field::cardinality].
    pub fn set_cardinality<T: std::convert::Into<crate::field::Cardinality>>(
        mut self,
        v: T,
    ) -> Self {
        self.cardinality = v.into();
        self
    }

    /// Sets the value of [number][crate::Field::number].
    pub fn set_number<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.number = v.into();
        self
    }

    /// Sets the value of [name][crate::Field::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [type_url][crate::Field::type_url].
    pub fn set_type_url<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.type_url = v.into();
        self
    }

    /// Sets the value of [oneof_index][crate::Field::oneof_index].
    pub fn set_oneof_index<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.oneof_index = v.into();
        self
    }

    /// Sets the value of [packed][crate::Field::packed].
    pub fn set_packed<T: std::convert::Into<bool>>(mut self, v: T) -> Self {
        self.packed = v.into();
        self
    }

    /// Sets the value of [options][crate::Field::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [json_name][crate::Field::json_name].
    pub fn set_json_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.json_name = v.into();
        self
    }

    /// Sets the value of [default_value][crate::Field::default_value].
    pub fn set_default_value<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.default_value = v.into();
        self
    }
}

impl wkt::message::Message for Field {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Field"
    }
}

/// Defines additional types related to [Field].
pub mod field {
    #[allow(unused_imports)]
    use super::*;

    /// Basic field types.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum Kind {
        /// Field type unknown.
        TypeUnknown,
        /// Field type double.
        TypeDouble,
        /// Field type float.
        TypeFloat,
        /// Field type int64.
        TypeInt64,
        /// Field type uint64.
        TypeUint64,
        /// Field type int32.
        TypeInt32,
        /// Field type fixed64.
        TypeFixed64,
        /// Field type fixed32.
        TypeFixed32,
        /// Field type bool.
        TypeBool,
        /// Field type string.
        TypeString,
        /// Field type group. Proto2 syntax only, and deprecated.
        TypeGroup,
        /// Field type message.
        TypeMessage,
        /// Field type bytes.
        TypeBytes,
        /// Field type uint32.
        TypeUint32,
        /// Field type enum.
        TypeEnum,
        /// Field type sfixed32.
        TypeSfixed32,
        /// Field type sfixed64.
        TypeSfixed64,
        /// Field type sint32.
        TypeSint32,
        /// Field type sint64.
        TypeSint64,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [Kind::value] or
        /// [Kind::name].
        UnknownValue(kind::UnknownValue),
    }

    #[doc(hidden)]
    pub mod kind {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl Kind {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::TypeUnknown => std::option::Option::Some(0),
                Self::TypeDouble => std::option::Option::Some(1),
                Self::TypeFloat => std::option::Option::Some(2),
                Self::TypeInt64 => std::option::Option::Some(3),
                Self::TypeUint64 => std::option::Option::Some(4),
                Self::TypeInt32 => std::option::Option::Some(5),
                Self::TypeFixed64 => std::option::Option::Some(6),
                Self::TypeFixed32 => std::option::Option::Some(7),
                Self::TypeBool => std::option::Option::Some(8),
                Self::TypeString => std::option::Option::Some(9),
                Self::TypeGroup => std::option::Option::Some(10),
                Self::TypeMessage => std::option::Option::Some(11),
                Self::TypeBytes => std::option::Option::Some(12),
                Self::TypeUint32 => std::option::Option::Some(13),
                Self::TypeEnum => std::option::Option::Some(14),
                Self::TypeSfixed32 => std::option::Option::Some(15),
                Self::TypeSfixed64 => std::option::Option::Some(16),
                Self::TypeSint32 => std::option::Option::Some(17),
                Self::TypeSint64 => std::option::Option::Some(18),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::TypeUnknown => std::option::Option::Some("TYPE_UNKNOWN"),
                Self::TypeDouble => std::option::Option::Some("TYPE_DOUBLE"),
                Self::TypeFloat => std::option::Option::Some("TYPE_FLOAT"),
                Self::TypeInt64 => std::option::Option::Some("TYPE_INT64"),
                Self::TypeUint64 => std::option::Option::Some("TYPE_UINT64"),
                Self::TypeInt32 => std::option::Option::Some("TYPE_INT32"),
                Self::TypeFixed64 => std::option::Option::Some("TYPE_FIXED64"),
                Self::TypeFixed32 => std::option::Option::Some("TYPE_FIXED32"),
                Self::TypeBool => std::option::Option::Some("TYPE_BOOL"),
                Self::TypeString => std::option::Option::Some("TYPE_STRING"),
                Self::TypeGroup => std::option::Option::Some("TYPE_GROUP"),
                Self::TypeMessage => std::option::Option::Some("TYPE_MESSAGE"),
                Self::TypeBytes => std::option::Option::Some("TYPE_BYTES"),
                Self::TypeUint32 => std::option::Option::Some("TYPE_UINT32"),
                Self::TypeEnum => std::option::Option::Some("TYPE_ENUM"),
                Self::TypeSfixed32 => std::option::Option::Some("TYPE_SFIXED32"),
                Self::TypeSfixed64 => std::option::Option::Some("TYPE_SFIXED64"),
                Self::TypeSint32 => std::option::Option::Some("TYPE_SINT32"),
                Self::TypeSint64 => std::option::Option::Some("TYPE_SINT64"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for Kind {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for Kind {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for Kind {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::TypeUnknown,
                1 => Self::TypeDouble,
                2 => Self::TypeFloat,
                3 => Self::TypeInt64,
                4 => Self::TypeUint64,
                5 => Self::TypeInt32,
                6 => Self::TypeFixed64,
                7 => Self::TypeFixed32,
                8 => Self::TypeBool,
                9 => Self::TypeString,
                10 => Self::TypeGroup,
                11 => Self::TypeMessage,
                12 => Self::TypeBytes,
                13 => Self::TypeUint32,
                14 => Self::TypeEnum,
                15 => Self::TypeSfixed32,
                16 => Self::TypeSfixed64,
                17 => Self::TypeSint32,
                18 => Self::TypeSint64,
                _ => Self::UnknownValue(kind::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for Kind {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "TYPE_UNKNOWN" => Self::TypeUnknown,
                "TYPE_DOUBLE" => Self::TypeDouble,
                "TYPE_FLOAT" => Self::TypeFloat,
                "TYPE_INT64" => Self::TypeInt64,
                "TYPE_UINT64" => Self::TypeUint64,
                "TYPE_INT32" => Self::TypeInt32,
                "TYPE_FIXED64" => Self::TypeFixed64,
                "TYPE_FIXED32" => Self::TypeFixed32,
                "TYPE_BOOL" => Self::TypeBool,
                "TYPE_STRING" => Self::TypeString,
                "TYPE_GROUP" => Self::TypeGroup,
                "TYPE_MESSAGE" => Self::TypeMessage,
                "TYPE_BYTES" => Self::TypeBytes,
                "TYPE_UINT32" => Self::TypeUint32,
                "TYPE_ENUM" => Self::TypeEnum,
                "TYPE_SFIXED32" => Self::TypeSfixed32,
                "TYPE_SFIXED64" => Self::TypeSfixed64,
                "TYPE_SINT32" => Self::TypeSint32,
                "TYPE_SINT64" => Self::TypeSint64,
                _ => Self::UnknownValue(kind::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for Kind {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::TypeUnknown => serializer.serialize_i32(0),
                Self::TypeDouble => serializer.serialize_i32(1),
                Self::TypeFloat => serializer.serialize_i32(2),
                Self::TypeInt64 => serializer.serialize_i32(3),
                Self::TypeUint64 => serializer.serialize_i32(4),
                Self::TypeInt32 => serializer.serialize_i32(5),
                Self::TypeFixed64 => serializer.serialize_i32(6),
                Self::TypeFixed32 => serializer.serialize_i32(7),
                Self::TypeBool => serializer.serialize_i32(8),
                Self::TypeString => serializer.serialize_i32(9),
                Self::TypeGroup => serializer.serialize_i32(10),
                Self::TypeMessage => serializer.serialize_i32(11),
                Self::TypeBytes => serializer.serialize_i32(12),
                Self::TypeUint32 => serializer.serialize_i32(13),
                Self::TypeEnum => serializer.serialize_i32(14),
                Self::TypeSfixed32 => serializer.serialize_i32(15),
                Self::TypeSfixed64 => serializer.serialize_i32(16),
                Self::TypeSint32 => serializer.serialize_i32(17),
                Self::TypeSint64 => serializer.serialize_i32(18),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for Kind {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<Kind>::new(
                ".google.protobuf.Field.Kind",
            ))
        }
    }

    /// Whether a field is optional, required, or repeated.
    ///
    /// # Working with unknown values
    ///
    /// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
    /// additional enum variants at any time. Adding new variants is not considered
    /// a breaking change. Applications should write their code in anticipation of:
    ///
    /// - New values appearing in future releases of the client library, **and**
    /// - New values received dynamically, without application changes.
    ///
    /// Please consult the [Working with enums] section in the user guide for some
    /// guidelines.
    ///
    /// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
    #[derive(Clone, Debug, PartialEq)]
    #[non_exhaustive]
    pub enum Cardinality {
        /// For fields with unknown cardinality.
        Unknown,
        /// For optional fields.
        Optional,
        /// For required fields. Proto2 syntax only.
        Required,
        /// For repeated fields.
        Repeated,
        /// If set, the enum was initialized with an unknown value.
        ///
        /// Applications can examine the value using [Cardinality::value] or
        /// [Cardinality::name].
        UnknownValue(cardinality::UnknownValue),
    }

    #[doc(hidden)]
    pub mod cardinality {
        #[allow(unused_imports)]
        use super::*;
        #[derive(Clone, Debug, PartialEq)]
        pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
    }

    impl Cardinality {
        /// Gets the enum value.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the string representation of enums.
        pub fn value(&self) -> std::option::Option<i32> {
            match self {
                Self::Unknown => std::option::Option::Some(0),
                Self::Optional => std::option::Option::Some(1),
                Self::Required => std::option::Option::Some(2),
                Self::Repeated => std::option::Option::Some(3),
                Self::UnknownValue(u) => u.0.value(),
            }
        }

        /// Gets the enum value as a string.
        ///
        /// Returns `None` if the enum contains an unknown value deserialized from
        /// the integer representation of enums.
        pub fn name(&self) -> std::option::Option<&str> {
            match self {
                Self::Unknown => std::option::Option::Some("CARDINALITY_UNKNOWN"),
                Self::Optional => std::option::Option::Some("CARDINALITY_OPTIONAL"),
                Self::Required => std::option::Option::Some("CARDINALITY_REQUIRED"),
                Self::Repeated => std::option::Option::Some("CARDINALITY_REPEATED"),
                Self::UnknownValue(u) => u.0.name(),
            }
        }
    }

    impl std::default::Default for Cardinality {
        fn default() -> Self {
            use std::convert::From;
            Self::from(0)
        }
    }

    impl std::fmt::Display for Cardinality {
        fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
            wkt::internal::display_enum(f, self.name(), self.value())
        }
    }

    impl std::convert::From<i32> for Cardinality {
        fn from(value: i32) -> Self {
            match value {
                0 => Self::Unknown,
                1 => Self::Optional,
                2 => Self::Required,
                3 => Self::Repeated,
                _ => Self::UnknownValue(cardinality::UnknownValue(
                    wkt::internal::UnknownEnumValue::Integer(value),
                )),
            }
        }
    }

    impl std::convert::From<&str> for Cardinality {
        fn from(value: &str) -> Self {
            use std::string::ToString;
            match value {
                "CARDINALITY_UNKNOWN" => Self::Unknown,
                "CARDINALITY_OPTIONAL" => Self::Optional,
                "CARDINALITY_REQUIRED" => Self::Required,
                "CARDINALITY_REPEATED" => Self::Repeated,
                _ => Self::UnknownValue(cardinality::UnknownValue(
                    wkt::internal::UnknownEnumValue::String(value.to_string()),
                )),
            }
        }
    }

    impl serde::ser::Serialize for Cardinality {
        fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
        where
            S: serde::Serializer,
        {
            match self {
                Self::Unknown => serializer.serialize_i32(0),
                Self::Optional => serializer.serialize_i32(1),
                Self::Required => serializer.serialize_i32(2),
                Self::Repeated => serializer.serialize_i32(3),
                Self::UnknownValue(u) => u.0.serialize(serializer),
            }
        }
    }

    impl<'de> serde::de::Deserialize<'de> for Cardinality {
        fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
        where
            D: serde::Deserializer<'de>,
        {
            deserializer.deserialize_any(wkt::internal::EnumVisitor::<Cardinality>::new(
                ".google.protobuf.Field.Cardinality",
            ))
        }
    }
}

/// Enum type definition.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Enum {
    /// Enum type name.
    pub name: std::string::String,

    /// Enum value definitions.
    pub enumvalue: std::vec::Vec<crate::EnumValue>,

    /// Protocol buffer options.
    pub options: std::vec::Vec<crate::Option>,

    /// The source context.
    pub source_context: std::option::Option<crate::SourceContext>,

    /// The source syntax.
    pub syntax: crate::Syntax,

    /// The source edition string, only valid when syntax is SYNTAX_EDITIONS.
    pub edition: std::string::String,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Enum {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Enum::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [enumvalue][crate::Enum::enumvalue].
    pub fn set_enumvalue<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::EnumValue>,
    {
        use std::iter::Iterator;
        self.enumvalue = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [options][crate::Enum::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }

    /// Sets the value of [source_context][crate::Enum::source_context].
    pub fn set_source_context<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [source_context][crate::Enum::source_context].
    pub fn set_or_clear_source_context<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::SourceContext>,
    {
        self.source_context = v.map(|x| x.into());
        self
    }

    /// Sets the value of [syntax][crate::Enum::syntax].
    pub fn set_syntax<T: std::convert::Into<crate::Syntax>>(mut self, v: T) -> Self {
        self.syntax = v.into();
        self
    }

    /// Sets the value of [edition][crate::Enum::edition].
    pub fn set_edition<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.edition = v.into();
        self
    }
}

impl wkt::message::Message for Enum {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Enum"
    }
}

/// Enum value definition.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct EnumValue {
    /// Enum value name.
    pub name: std::string::String,

    /// Enum value number.
    pub number: i32,

    /// Protocol buffer options.
    pub options: std::vec::Vec<crate::Option>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl EnumValue {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::EnumValue::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [number][crate::EnumValue::number].
    pub fn set_number<T: std::convert::Into<i32>>(mut self, v: T) -> Self {
        self.number = v.into();
        self
    }

    /// Sets the value of [options][crate::EnumValue::options].
    pub fn set_options<T, V>(mut self, v: T) -> Self
    where
        T: std::iter::IntoIterator<Item = V>,
        V: std::convert::Into<crate::Option>,
    {
        use std::iter::Iterator;
        self.options = v.into_iter().map(|i| i.into()).collect();
        self
    }
}

impl wkt::message::Message for EnumValue {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.EnumValue"
    }
}

/// A protocol buffer option, which can be attached to a message, field,
/// enumeration, etc.
#[derive(Clone, Default, PartialEq)]
#[non_exhaustive]
pub struct Option {
    /// The option's name. For protobuf built-in options (options defined in
    /// descriptor.proto), this is the short name. For example, `"map_entry"`.
    /// For custom options, it should be the fully-qualified name. For example,
    /// `"google.api.http"`.
    pub name: std::string::String,

    /// The option's value packed in an Any message. If the value is a primitive,
    /// the corresponding wrapper type defined in google/protobuf/wrappers.proto
    /// should be used. If the value is an enum, it should be stored as an int32
    /// value using the google.protobuf.Int32Value type.
    pub value: std::option::Option<crate::Any>,

    pub(crate) _unknown_fields: serde_json::Map<std::string::String, serde_json::Value>,
}

impl Option {
    pub fn new() -> Self {
        std::default::Default::default()
    }

    /// Sets the value of [name][crate::Option::name].
    pub fn set_name<T: std::convert::Into<std::string::String>>(mut self, v: T) -> Self {
        self.name = v.into();
        self
    }

    /// Sets the value of [value][crate::Option::value].
    pub fn set_value<T>(mut self, v: T) -> Self
    where
        T: std::convert::Into<crate::Any>,
    {
        self.value = std::option::Option::Some(v.into());
        self
    }

    /// Sets or clears the value of [value][crate::Option::value].
    pub fn set_or_clear_value<T>(mut self, v: std::option::Option<T>) -> Self
    where
        T: std::convert::Into<crate::Any>,
    {
        self.value = v.map(|x| x.into());
        self
    }
}

impl wkt::message::Message for Option {
    fn typename() -> &'static str {
        "type.googleapis.com/google.protobuf.Option"
    }
}

/// The full set of known editions.
///
/// # Working with unknown values
///
/// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
/// additional enum variants at any time. Adding new variants is not considered
/// a breaking change. Applications should write their code in anticipation of:
///
/// - New values appearing in future releases of the client library, **and**
/// - New values received dynamically, without application changes.
///
/// Please consult the [Working with enums] section in the user guide for some
/// guidelines.
///
/// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
#[derive(Clone, Debug, PartialEq)]
#[non_exhaustive]
pub enum Edition {
    /// A placeholder for an unknown edition value.
    Unknown,
    /// A placeholder edition for specifying default behaviors *before* a feature
    /// was first introduced.  This is effectively an "infinite past".
    Legacy,
    /// Legacy syntax "editions".  These pre-date editions, but behave much like
    /// distinct editions.  These can't be used to specify the edition of proto
    /// files, but feature definitions must supply proto2/proto3 defaults for
    /// backwards compatibility.
    Proto2,
    Proto3,
    /// Editions that have been released.  The specific values are arbitrary and
    /// should not be depended on, but they will always be time-ordered for easy
    /// comparison.
    Edition2023,
    Edition2024,
    /// Placeholder editions for testing feature resolution.  These should not be
    /// used or relied on outside of tests.
    Edition1TestOnly,
    Edition2TestOnly,
    Edition99997TestOnly,
    Edition99998TestOnly,
    Edition99999TestOnly,
    /// Placeholder for specifying unbounded edition support.  This should only
    /// ever be used by plugins that can expect to never require any changes to
    /// support a new edition.
    Max,
    /// If set, the enum was initialized with an unknown value.
    ///
    /// Applications can examine the value using [Edition::value] or
    /// [Edition::name].
    UnknownValue(edition::UnknownValue),
}

#[doc(hidden)]
pub mod edition {
    #[allow(unused_imports)]
    use super::*;
    #[derive(Clone, Debug, PartialEq)]
    pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
}

impl Edition {
    /// Gets the enum value.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the string representation of enums.
    pub fn value(&self) -> std::option::Option<i32> {
        match self {
            Self::Unknown => std::option::Option::Some(0),
            Self::Legacy => std::option::Option::Some(900),
            Self::Proto2 => std::option::Option::Some(998),
            Self::Proto3 => std::option::Option::Some(999),
            Self::Edition2023 => std::option::Option::Some(1000),
            Self::Edition2024 => std::option::Option::Some(1001),
            Self::Edition1TestOnly => std::option::Option::Some(1),
            Self::Edition2TestOnly => std::option::Option::Some(2),
            Self::Edition99997TestOnly => std::option::Option::Some(99997),
            Self::Edition99998TestOnly => std::option::Option::Some(99998),
            Self::Edition99999TestOnly => std::option::Option::Some(99999),
            Self::Max => std::option::Option::Some(2147483647),
            Self::UnknownValue(u) => u.0.value(),
        }
    }

    /// Gets the enum value as a string.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the integer representation of enums.
    pub fn name(&self) -> std::option::Option<&str> {
        match self {
            Self::Unknown => std::option::Option::Some("EDITION_UNKNOWN"),
            Self::Legacy => std::option::Option::Some("EDITION_LEGACY"),
            Self::Proto2 => std::option::Option::Some("EDITION_PROTO2"),
            Self::Proto3 => std::option::Option::Some("EDITION_PROTO3"),
            Self::Edition2023 => std::option::Option::Some("EDITION_2023"),
            Self::Edition2024 => std::option::Option::Some("EDITION_2024"),
            Self::Edition1TestOnly => std::option::Option::Some("EDITION_1_TEST_ONLY"),
            Self::Edition2TestOnly => std::option::Option::Some("EDITION_2_TEST_ONLY"),
            Self::Edition99997TestOnly => std::option::Option::Some("EDITION_99997_TEST_ONLY"),
            Self::Edition99998TestOnly => std::option::Option::Some("EDITION_99998_TEST_ONLY"),
            Self::Edition99999TestOnly => std::option::Option::Some("EDITION_99999_TEST_ONLY"),
            Self::Max => std::option::Option::Some("EDITION_MAX"),
            Self::UnknownValue(u) => u.0.name(),
        }
    }
}

impl std::default::Default for Edition {
    fn default() -> Self {
        use std::convert::From;
        Self::from(0)
    }
}

impl std::fmt::Display for Edition {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
        wkt::internal::display_enum(f, self.name(), self.value())
    }
}

impl std::convert::From<i32> for Edition {
    fn from(value: i32) -> Self {
        match value {
            0 => Self::Unknown,
            1 => Self::Edition1TestOnly,
            2 => Self::Edition2TestOnly,
            900 => Self::Legacy,
            998 => Self::Proto2,
            999 => Self::Proto3,
            1000 => Self::Edition2023,
            1001 => Self::Edition2024,
            99997 => Self::Edition99997TestOnly,
            99998 => Self::Edition99998TestOnly,
            99999 => Self::Edition99999TestOnly,
            2147483647 => Self::Max,
            _ => Self::UnknownValue(edition::UnknownValue(
                wkt::internal::UnknownEnumValue::Integer(value),
            )),
        }
    }
}

impl std::convert::From<&str> for Edition {
    fn from(value: &str) -> Self {
        use std::string::ToString;
        match value {
            "EDITION_UNKNOWN" => Self::Unknown,
            "EDITION_LEGACY" => Self::Legacy,
            "EDITION_PROTO2" => Self::Proto2,
            "EDITION_PROTO3" => Self::Proto3,
            "EDITION_2023" => Self::Edition2023,
            "EDITION_2024" => Self::Edition2024,
            "EDITION_1_TEST_ONLY" => Self::Edition1TestOnly,
            "EDITION_2_TEST_ONLY" => Self::Edition2TestOnly,
            "EDITION_99997_TEST_ONLY" => Self::Edition99997TestOnly,
            "EDITION_99998_TEST_ONLY" => Self::Edition99998TestOnly,
            "EDITION_99999_TEST_ONLY" => Self::Edition99999TestOnly,
            "EDITION_MAX" => Self::Max,
            _ => Self::UnknownValue(edition::UnknownValue(
                wkt::internal::UnknownEnumValue::String(value.to_string()),
            )),
        }
    }
}

impl serde::ser::Serialize for Edition {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        match self {
            Self::Unknown => serializer.serialize_i32(0),
            Self::Legacy => serializer.serialize_i32(900),
            Self::Proto2 => serializer.serialize_i32(998),
            Self::Proto3 => serializer.serialize_i32(999),
            Self::Edition2023 => serializer.serialize_i32(1000),
            Self::Edition2024 => serializer.serialize_i32(1001),
            Self::Edition1TestOnly => serializer.serialize_i32(1),
            Self::Edition2TestOnly => serializer.serialize_i32(2),
            Self::Edition99997TestOnly => serializer.serialize_i32(99997),
            Self::Edition99998TestOnly => serializer.serialize_i32(99998),
            Self::Edition99999TestOnly => serializer.serialize_i32(99999),
            Self::Max => serializer.serialize_i32(2147483647),
            Self::UnknownValue(u) => u.0.serialize(serializer),
        }
    }
}

impl<'de> serde::de::Deserialize<'de> for Edition {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        deserializer.deserialize_any(wkt::internal::EnumVisitor::<Edition>::new(
            ".google.protobuf.Edition",
        ))
    }
}

/// The syntax in which a protocol buffer element is defined.
///
/// # Working with unknown values
///
/// This enum is defined as `#[non_exhaustive]` because Google Cloud may add
/// additional enum variants at any time. Adding new variants is not considered
/// a breaking change. Applications should write their code in anticipation of:
///
/// - New values appearing in future releases of the client library, **and**
/// - New values received dynamically, without application changes.
///
/// Please consult the [Working with enums] section in the user guide for some
/// guidelines.
///
/// [Working with enums]: https://google-cloud-rust.github.io/working_with_enums.html
#[derive(Clone, Debug, PartialEq)]
#[non_exhaustive]
pub enum Syntax {
    /// Syntax `proto2`.
    Proto2,
    /// Syntax `proto3`.
    Proto3,
    /// Syntax `editions`.
    Editions,
    /// If set, the enum was initialized with an unknown value.
    ///
    /// Applications can examine the value using [Syntax::value] or
    /// [Syntax::name].
    UnknownValue(syntax::UnknownValue),
}

#[doc(hidden)]
pub mod syntax {
    #[allow(unused_imports)]
    use super::*;
    #[derive(Clone, Debug, PartialEq)]
    pub struct UnknownValue(pub(crate) wkt::internal::UnknownEnumValue);
}

impl Syntax {
    /// Gets the enum value.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the string representation of enums.
    pub fn value(&self) -> std::option::Option<i32> {
        match self {
            Self::Proto2 => std::option::Option::Some(0),
            Self::Proto3 => std::option::Option::Some(1),
            Self::Editions => std::option::Option::Some(2),
            Self::UnknownValue(u) => u.0.value(),
        }
    }

    /// Gets the enum value as a string.
    ///
    /// Returns `None` if the enum contains an unknown value deserialized from
    /// the integer representation of enums.
    pub fn name(&self) -> std::option::Option<&str> {
        match self {
            Self::Proto2 => std::option::Option::Some("SYNTAX_PROTO2"),
            Self::Proto3 => std::option::Option::Some("SYNTAX_PROTO3"),
            Self::Editions => std::option::Option::Some("SYNTAX_EDITIONS"),
            Self::UnknownValue(u) => u.0.name(),
        }
    }
}

impl std::default::Default for Syntax {
    fn default() -> Self {
        use std::convert::From;
        Self::from(0)
    }
}

impl std::fmt::Display for Syntax {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::result::Result<(), std::fmt::Error> {
        wkt::internal::display_enum(f, self.name(), self.value())
    }
}

impl std::convert::From<i32> for Syntax {
    fn from(value: i32) -> Self {
        match value {
            0 => Self::Proto2,
            1 => Self::Proto3,
            2 => Self::Editions,
            _ => Self::UnknownValue(syntax::UnknownValue(
                wkt::internal::UnknownEnumValue::Integer(value),
            )),
        }
    }
}

impl std::convert::From<&str> for Syntax {
    fn from(value: &str) -> Self {
        use std::string::ToString;
        match value {
            "SYNTAX_PROTO2" => Self::Proto2,
            "SYNTAX_PROTO3" => Self::Proto3,
            "SYNTAX_EDITIONS" => Self::Editions,
            _ => Self::UnknownValue(syntax::UnknownValue(
                wkt::internal::UnknownEnumValue::String(value.to_string()),
            )),
        }
    }
}

impl serde::ser::Serialize for Syntax {
    fn serialize<S>(&self, serializer: S) -> std::result::Result<S::Ok, S::Error>
    where
        S: serde::Serializer,
    {
        match self {
            Self::Proto2 => serializer.serialize_i32(0),
            Self::Proto3 => serializer.serialize_i32(1),
            Self::Editions => serializer.serialize_i32(2),
            Self::UnknownValue(u) => u.0.serialize(serializer),
        }
    }
}

impl<'de> serde::de::Deserialize<'de> for Syntax {
    fn deserialize<D>(deserializer: D) -> std::result::Result<Self, D::Error>
    where
        D: serde::Deserializer<'de>,
    {
        deserializer.deserialize_any(wkt::internal::EnumVisitor::<Syntax>::new(
            ".google.protobuf.Syntax",
        ))
    }
}
