// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The identity provider (IdP) reported that authentication failed. This might be because the claim is invalid.</p>
/// <p>If this error is returned for the <code>AssumeRoleWithWebIdentity</code> operation, it can also mean that the claim has expired or has been explicitly revoked.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct IdpRejectedClaimException {
    #[allow(missing_docs)] // documentation missing in model
    pub message: ::std::option::Option<::std::string::String>,
    pub(crate) meta: ::aws_smithy_types::error::ErrorMetadata,
}
impl IdpRejectedClaimException {
    /// Returns the error message.
    pub fn message(&self) -> ::std::option::Option<&str> {
        self.message.as_deref()
    }
}
impl ::std::fmt::Display for IdpRejectedClaimException {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        ::std::write!(f, "IdpRejectedClaimException [IDPRejectedClaimException]")?;
        if let ::std::option::Option::Some(inner_1) = &self.message {
            {
                ::std::write!(f, ": {inner_1}")?;
            }
        }
        Ok(())
    }
}
impl ::std::error::Error for IdpRejectedClaimException {}
impl ::aws_types::request_id::RequestId for crate::types::error::IdpRejectedClaimException {
    fn request_id(&self) -> Option<&str> {
        use ::aws_smithy_types::error::metadata::ProvideErrorMetadata;
        self.meta().request_id()
    }
}
impl ::aws_smithy_types::error::metadata::ProvideErrorMetadata for IdpRejectedClaimException {
    fn meta(&self) -> &::aws_smithy_types::error::ErrorMetadata {
        &self.meta
    }
}
impl IdpRejectedClaimException {
    /// Creates a new builder-style object to manufacture [`IdpRejectedClaimException`](crate::types::error::IdpRejectedClaimException).
    pub fn builder() -> crate::types::error::builders::IdpRejectedClaimExceptionBuilder {
        crate::types::error::builders::IdpRejectedClaimExceptionBuilder::default()
    }
}

/// A builder for [`IdpRejectedClaimException`](crate::types::error::IdpRejectedClaimException).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct IdpRejectedClaimExceptionBuilder {
    pub(crate) message: ::std::option::Option<::std::string::String>,
    meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>,
}
impl IdpRejectedClaimExceptionBuilder {
    #[allow(missing_docs)] // documentation missing in model
    pub fn message(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.message = ::std::option::Option::Some(input.into());
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn set_message(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.message = input;
        self
    }
    #[allow(missing_docs)] // documentation missing in model
    pub fn get_message(&self) -> &::std::option::Option<::std::string::String> {
        &self.message
    }
    /// Sets error metadata
    pub fn meta(mut self, meta: ::aws_smithy_types::error::ErrorMetadata) -> Self {
        self.meta = Some(meta);
        self
    }

    /// Sets error metadata
    pub fn set_meta(&mut self, meta: std::option::Option<::aws_smithy_types::error::ErrorMetadata>) -> &mut Self {
        self.meta = meta;
        self
    }
    /// Consumes the builder and constructs a [`IdpRejectedClaimException`](crate::types::error::IdpRejectedClaimException).
    pub fn build(self) -> crate::types::error::IdpRejectedClaimException {
        crate::types::error::IdpRejectedClaimException {
            message: self.message,
            meta: self.meta.unwrap_or_default(),
        }
    }
}
