// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
#[allow(missing_docs)] // documentation missing in model
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CreateBucketMetadataConfigurationInput {
    /// <p>The general purpose bucket that you want to create the metadata configuration for.</p>
    pub bucket: ::std::option::Option<::std::string::String>,
    /// <p>The <code>Content-MD5</code> header for the metadata configuration.</p>
    pub content_md5: ::std::option::Option<::std::string::String>,
    /// <p>The checksum algorithm to use with your metadata configuration.</p>
    pub checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
    /// <p>The contents of your metadata configuration.</p>
    pub metadata_configuration: ::std::option::Option<crate::types::MetadataConfiguration>,
    /// <p>The expected owner of the general purpose bucket that corresponds to your metadata configuration.</p>
    pub expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl CreateBucketMetadataConfigurationInput {
    /// <p>The general purpose bucket that you want to create the metadata configuration for.</p>
    pub fn bucket(&self) -> ::std::option::Option<&str> {
        self.bucket.as_deref()
    }
    /// <p>The <code>Content-MD5</code> header for the metadata configuration.</p>
    pub fn content_md5(&self) -> ::std::option::Option<&str> {
        self.content_md5.as_deref()
    }
    /// <p>The checksum algorithm to use with your metadata configuration.</p>
    pub fn checksum_algorithm(&self) -> ::std::option::Option<&crate::types::ChecksumAlgorithm> {
        self.checksum_algorithm.as_ref()
    }
    /// <p>The contents of your metadata configuration.</p>
    pub fn metadata_configuration(&self) -> ::std::option::Option<&crate::types::MetadataConfiguration> {
        self.metadata_configuration.as_ref()
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to your metadata configuration.</p>
    pub fn expected_bucket_owner(&self) -> ::std::option::Option<&str> {
        self.expected_bucket_owner.as_deref()
    }
}
impl CreateBucketMetadataConfigurationInput {
    /// Creates a new builder-style object to manufacture [`CreateBucketMetadataConfigurationInput`](crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationInput).
    pub fn builder() -> crate::operation::create_bucket_metadata_configuration::builders::CreateBucketMetadataConfigurationInputBuilder {
        crate::operation::create_bucket_metadata_configuration::builders::CreateBucketMetadataConfigurationInputBuilder::default()
    }
}

/// A builder for [`CreateBucketMetadataConfigurationInput`](crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationInput).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CreateBucketMetadataConfigurationInputBuilder {
    pub(crate) bucket: ::std::option::Option<::std::string::String>,
    pub(crate) content_md5: ::std::option::Option<::std::string::String>,
    pub(crate) checksum_algorithm: ::std::option::Option<crate::types::ChecksumAlgorithm>,
    pub(crate) metadata_configuration: ::std::option::Option<crate::types::MetadataConfiguration>,
    pub(crate) expected_bucket_owner: ::std::option::Option<::std::string::String>,
}
impl CreateBucketMetadataConfigurationInputBuilder {
    /// <p>The general purpose bucket that you want to create the metadata configuration for.</p>
    /// This field is required.
    pub fn bucket(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.bucket = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The general purpose bucket that you want to create the metadata configuration for.</p>
    pub fn set_bucket(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.bucket = input;
        self
    }
    /// <p>The general purpose bucket that you want to create the metadata configuration for.</p>
    pub fn get_bucket(&self) -> &::std::option::Option<::std::string::String> {
        &self.bucket
    }
    /// <p>The <code>Content-MD5</code> header for the metadata configuration.</p>
    pub fn content_md5(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.content_md5 = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The <code>Content-MD5</code> header for the metadata configuration.</p>
    pub fn set_content_md5(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.content_md5 = input;
        self
    }
    /// <p>The <code>Content-MD5</code> header for the metadata configuration.</p>
    pub fn get_content_md5(&self) -> &::std::option::Option<::std::string::String> {
        &self.content_md5
    }
    /// <p>The checksum algorithm to use with your metadata configuration.</p>
    pub fn checksum_algorithm(mut self, input: crate::types::ChecksumAlgorithm) -> Self {
        self.checksum_algorithm = ::std::option::Option::Some(input);
        self
    }
    /// <p>The checksum algorithm to use with your metadata configuration.</p>
    pub fn set_checksum_algorithm(mut self, input: ::std::option::Option<crate::types::ChecksumAlgorithm>) -> Self {
        self.checksum_algorithm = input;
        self
    }
    /// <p>The checksum algorithm to use with your metadata configuration.</p>
    pub fn get_checksum_algorithm(&self) -> &::std::option::Option<crate::types::ChecksumAlgorithm> {
        &self.checksum_algorithm
    }
    /// <p>The contents of your metadata configuration.</p>
    /// This field is required.
    pub fn metadata_configuration(mut self, input: crate::types::MetadataConfiguration) -> Self {
        self.metadata_configuration = ::std::option::Option::Some(input);
        self
    }
    /// <p>The contents of your metadata configuration.</p>
    pub fn set_metadata_configuration(mut self, input: ::std::option::Option<crate::types::MetadataConfiguration>) -> Self {
        self.metadata_configuration = input;
        self
    }
    /// <p>The contents of your metadata configuration.</p>
    pub fn get_metadata_configuration(&self) -> &::std::option::Option<crate::types::MetadataConfiguration> {
        &self.metadata_configuration
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to your metadata configuration.</p>
    pub fn expected_bucket_owner(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.expected_bucket_owner = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to your metadata configuration.</p>
    pub fn set_expected_bucket_owner(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.expected_bucket_owner = input;
        self
    }
    /// <p>The expected owner of the general purpose bucket that corresponds to your metadata configuration.</p>
    pub fn get_expected_bucket_owner(&self) -> &::std::option::Option<::std::string::String> {
        &self.expected_bucket_owner
    }
    /// Consumes the builder and constructs a [`CreateBucketMetadataConfigurationInput`](crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationInput).
    pub fn build(
        self,
    ) -> ::std::result::Result<
        crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationInput,
        ::aws_smithy_types::error::operation::BuildError,
    > {
        ::std::result::Result::Ok(
            crate::operation::create_bucket_metadata_configuration::CreateBucketMetadataConfigurationInput {
                bucket: self.bucket,
                content_md5: self.content_md5,
                checksum_algorithm: self.checksum_algorithm,
                metadata_configuration: self.metadata_configuration,
                expected_bucket_owner: self.expected_bucket_owner,
            },
        )
    }
}
