// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.
impl super::Client {
    /// Constructs a fluent builder for the [`PutBucketAbac`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder) operation.
    ///
    /// - The fluent builder is configurable:
    ///   - [`bucket(impl Into<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::bucket) / [`set_bucket(Option<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::set_bucket):<br>required: **true**<br><p>The name of the general purpose bucket.</p><br>
    ///   - [`content_md5(impl Into<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::content_md5) / [`set_content_md5(Option<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::set_content_md5):<br>required: **false**<br><p>The MD5 hash of the <code>PutBucketAbac</code> request body.</p> <p>For requests made using the Amazon Web Services Command Line Interface (CLI) or Amazon Web Services SDKs, this field is calculated automatically.</p><br>
    ///   - [`checksum_algorithm(ChecksumAlgorithm)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::checksum_algorithm) / [`set_checksum_algorithm(Option<ChecksumAlgorithm>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::set_checksum_algorithm):<br>required: **false**<br><p>Indicates the algorithm that you want Amazon S3 to use to create the checksum. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/checking-object-integrity.html"> Checking object integrity</a> in the <i>Amazon S3 User Guide</i>.</p><br>
    ///   - [`expected_bucket_owner(impl Into<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::expected_bucket_owner) / [`set_expected_bucket_owner(Option<String>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::set_expected_bucket_owner):<br>required: **false**<br><p>The Amazon Web Services account ID of the general purpose bucket's owner.</p><br>
    ///   - [`abac_status(AbacStatus)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::abac_status) / [`set_abac_status(Option<AbacStatus>)`](crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::set_abac_status):<br>required: **true**<br><p>The ABAC status of the general purpose bucket. When ABAC is enabled for the general purpose bucket, you can use tags to manage access to the general purpose buckets as well as for cost tracking purposes. When ABAC is disabled for the general purpose buckets, you can only use tags for cost tracking purposes. For more information, see <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/buckets-tagging.html">Using tags with S3 general purpose buckets</a>.</p><br>
    /// - On success, responds with [`PutBucketAbacOutput`](crate::operation::put_bucket_abac::PutBucketAbacOutput)
    /// - On failure, responds with [`SdkError<PutBucketAbacError>`](crate::operation::put_bucket_abac::PutBucketAbacError)
    pub fn put_bucket_abac(&self) -> crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder {
        crate::operation::put_bucket_abac::builders::PutBucketAbacFluentBuilder::new(self.handle.clone())
    }
}
