/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.store.memento;

import com.jeta.forms.store.memento.ComponentMemento;
import com.jeta.forms.store.memento.PropertiesMemento;
import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectInputStream;
import java.io.ObjectOutput;
import java.util.Collection;

public class BeanMemento
extends ComponentMemento
implements Externalizable {
    static final long serialVersionUID = -92122133275350884L;
    public static final int VERSION = 2;
    private String m_jetabean_class;
    private String m_bean_class;
    private PropertiesMemento m_properties;
    private byte[] m_bean_xml;
    private Collection m_custom_properties;

    public boolean containsProperty(String string) {
        if (this.m_properties != null) {
            return this.m_properties.containsProperty(string);
        }
        return false;
    }

    public Collection getCustomProperties() {
        return this.m_custom_properties;
    }

    public String getJETABeanClass() {
        return this.m_jetabean_class;
    }

    public String getBeanClass() {
        return this.m_bean_class;
    }

    public byte[] getBeanXML() {
        return this.m_bean_xml;
    }

    public PropertiesMemento getProperties() {
        return this.m_properties;
    }

    public void print() {
        System.out.println("     BeanMemento state.................. ");
        System.out.println("           jetabean: " + this.m_jetabean_class);
        System.out.println("           bean_class: " + this.m_bean_class);
    }

    public void setCustomProperties(Collection collection) {
        this.m_custom_properties = collection;
    }

    public void setBeanClass(String string) {
        this.m_bean_class = string;
    }

    public void setJETABeanClass(String string) {
        this.m_jetabean_class = string;
    }

    public void setBeanXML(byte[] byArray) {
        this.m_bean_xml = byArray;
    }

    public void setProperties(PropertiesMemento propertiesMemento) {
        this.m_properties = propertiesMemento;
    }

    public void readExternal(ObjectInput objectInput) throws ClassNotFoundException, IOException {
        super.readExternal(objectInput);
        int n = objectInput.readInt();
        this.m_jetabean_class = (String)objectInput.readObject();
        this.m_bean_class = (String)objectInput.readObject();
        if (n == 1) {
            this.m_bean_xml = (byte[])objectInput.readObject();
            this.m_custom_properties = (Collection)objectInput.readObject();
            this.m_properties = null;
        } else {
            Object object = objectInput.readObject();
            if (object instanceof byte[]) {
                ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream((byte[])object);
                ObjectInputStream objectInputStream = new ObjectInputStream(byteArrayInputStream);
                this.m_properties = (PropertiesMemento)objectInputStream.readObject();
            } else if (object instanceof PropertiesMemento) {
                this.m_properties = (PropertiesMemento)object;
            }
        }
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        super.writeExternal(objectOutput);
        objectOutput.writeInt(2);
        objectOutput.writeObject(this.m_jetabean_class);
        objectOutput.writeObject(this.m_bean_class);
        objectOutput.writeObject(this.m_properties);
    }
}

