/*
 * Decompiled with CFR 0.152.
 */
package com.jeta.forms.gui.formmgr;

import com.jeta.forms.gui.common.FormException;
import com.jeta.forms.gui.common.FormUtils;
import com.jeta.forms.gui.form.FormComponent;
import com.jeta.forms.logger.FormsLogger;
import com.jeta.forms.project.ProjectManager;
import com.jeta.forms.store.memento.FormMemento;
import com.jeta.forms.store.memento.FormPackage;
import com.jeta.open.i18n.I18N;
import com.jeta.open.registry.JETARegistry;
import com.jeta.open.resources.ResourceLoader;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.ObjectInputStream;

public class FormManagerUtils {
    private static final int DEFAULT_BUFFER_SIZE = 20480;

    public static FormComponent openForm(InputStream inputStream) throws FormException {
        try {
            ObjectInputStream objectInputStream = null;
            objectInputStream = inputStream instanceof ObjectInputStream ? (ObjectInputStream)inputStream : new ObjectInputStream(inputStream);
            Object object = objectInputStream.readObject();
            FormMemento formMemento = null;
            formMemento = object instanceof FormPackage ? ((FormPackage)object).getMemento() : (FormMemento)object;
            FormComponent formComponent = FormComponent.create();
            formComponent.setState(formMemento);
            return formComponent;
        }
        catch (Exception exception) {
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            throw new FormException(exception);
        }
    }

    public static FormComponent openPackagedForm(String string) throws FormException {
        FormUtils.safeAssert(!FormUtils.isDesignMode());
        FormUtils.safeAssert(string != null);
        FormUtils.safeAssert(string.length() > 0);
        try {
            Object object;
            Object object2;
            ProjectManager projectManager = (ProjectManager)JETARegistry.lookup("jeta.forms.projectManager");
            FormUtils.safeAssert(projectManager != null);
            if (projectManager != null && (object2 = projectManager.getAbsolutePath(string)) != null && ((File)(object = new File((String)object2))).isFile()) {
                return FormManagerUtils.openForm(new FileInputStream((File)object));
            }
            FormsLogger.debug("FormManagerUtils.loadForm: " + string);
            string = string.replace('\\', '/');
            object2 = (ResourceLoader)JETARegistry.lookup("jeta.resourceloader");
            object = new BufferedInputStream(object2.getResourceAsStream(string), 20480);
            ObjectInputStream objectInputStream = new ObjectInputStream((InputStream)object);
            Object object3 = objectInputStream.readObject();
            FormMemento formMemento = null;
            formMemento = object3 instanceof FormPackage ? ((FormPackage)object3).getMemento() : (FormMemento)object3;
            FormComponent formComponent = FormComponent.create();
            formComponent.setState(formMemento);
            objectInputStream.close();
            return formComponent;
        }
        catch (Exception exception) {
            System.out.println("FormManagerUtils.openPackgedForm failed: " + string);
            exception.printStackTrace();
            if (exception instanceof FormException) {
                throw (FormException)exception;
            }
            FormsLogger.severe(I18N.format("Error_loading_form_1", string));
            throw new FormException(exception);
        }
    }
}

