package checker_test

import (
	"regexp"
)

func goodRegexps() {
	regexp.MustCompile(`[\D0-9]`)
	regexp.MustCompile(`[\D5]`)
	regexp.MustCompile(`(^pt$|_content$|_file$|_disk$)`)
}

func goodFlags() {
	regexp.MustCompile(`(?:(?i)foo)(?i)bar`)
	regexp.MustCompile(`(?m)(?i)(?-m)(?-i)(?m)(?i)`)
	regexp.MustCompile(`(?ms:(?i:foo))(?im:bar)`)
	regexp.MustCompile(`(?i)(?ms:flags1)(?m:flags2)`)
	regexp.MustCompile(`((?m)(?i:a|b(?s:foo))(?i)x)`)
	regexp.MustCompile(`(?i)yy(?-i)x`)
	regexp.MustCompile(`(?i-i)`)
	regexp.MustCompile(`(?i:foo)(?i)bar`)
	regexp.MustCompile(`(?i:(?m:fo(?-i)o))(?mi)x(?-mi)bar`)
	regexp.MustCompile(`(?i-i)(?i)`)
	regexp.MustCompile(`(?:(?i)foo)(?i)x(?-i)`)
}

func goodAnchors() {
	// All `^` below are in a proper position.
	regexp.MustCompile(`^`)
	regexp.MustCompile(`^foo`)
	regexp.MustCompile(`^foo?|bar`)
	regexp.MustCompile(`^foo|^bar`)
	regexp.MustCompile(`(^a|^b)`)
	regexp.MustCompile(`(?i)^foo`)
	regexp.MustCompile(`(?i)((?m)a|^foo)b`)
	regexp.MustCompile(`(?i)(?m)\bfoo|bar|^baz`)
	regexp.MustCompile(`(?i)^(?m)foo|bar|baz`)
	regexp.MustCompile(`(?i:foo|((?:f|^b|(foo|^bar))))`)
	regexp.MustCompile(`(?i)^(?m)foo|bar|^baz`)
	regexp.MustCompile(`(?i)(?:)(^| )\S+`)

	// All `$` below are in a proper position.
	regexp.MustCompile(`$`)
	regexp.MustCompile(`foo$`)
	regexp.MustCompile(`foo?$|bar`)
	regexp.MustCompile(`foo$|bar$`)
	regexp.MustCompile(`(a$|b$)`)
	regexp.MustCompile(`(?i)foo$`)
	regexp.MustCompile(`(?i)((?m)a|foo)b$`)
	regexp.MustCompile(`(?i)(?m)\bfoo$|bar$|baz`)
	regexp.MustCompile(`(?i)(?m)foo|bar$|baz`)
	regexp.MustCompile(`(?i:foo|((?:f|^b|(foo|^bar)))$)`)
	regexp.MustCompile(`(?i)^(?m)foo|bar|^baz$`)
}

func goodRegexpsFromCorpus() {
	regexp.MustCompile(`^.+@.+\..+$`)
	regexp.MustCompile(`^(")`)
	regexp.MustCompile(`^((\").*(\"))`)
	regexp.MustCompile(`^(\+)`)
	regexp.MustCompile(`~~`)
	regexp.MustCompile(`;[^=;{}]+;`)
	regexp.MustCompile(`'''(.*)'''`)
	regexp.MustCompile(`'([ (\[{<])"`)
	regexp.MustCompile(`( ")`)
	regexp.MustCompile(`(\*[^ ][^*]*\*)`)
	regexp.MustCompile(`[<>]+`)
	regexp.MustCompile(`[!&]([^=!&?[)]+)|\[\[(.*?)\]\]`)
	regexp.MustCompile(`[.?,!;:@#$%^&*()]+`)
	regexp.MustCompile(`\*\*[^*]*\*\*`)
	regexp.MustCompile(`\+[^+]*\+`)
	regexp.MustCompile("^([^:]*):`(.*)$")
	regexp.MustCompile("^$")
	regexp.MustCompile("^\\[(.*?)\\]")
	regexp.MustCompile("^\\{\\.?([^{}]+)\\}$|^\\.?([^{}]+)$")
	regexp.MustCompile("<[^>]+>")
	regexp.MustCompile("_")
	regexp.MustCompile("/+")
	regexp.MustCompile("/+$")
	regexp.MustCompile(".*=.*,.*=.*")
	regexp.MustCompile(".+@.+")
	regexp.MustCompile("")
	regexp.MustCompile("(.+)@(.+)#(.+)|(.+)@(.+)")
	regexp.MustCompile("([^:@]*)(:([^@]*))?@(.+)")
	regexp.MustCompile("([\\/\\[\\]\\(\\)\\\\^\\$\\.\\|\\?\\*\\+\\'])")
	regexp.MustCompile("[ ]")
	regexp.MustCompile("[,:]")
	regexp.MustCompile("[:=]")
	regexp.MustCompile("[!#]{(.+?)}")
	regexp.MustCompile("[@:;,]+")
	regexp.MustCompile("[\\\\][_~\\.\\-!$&'\\(\\)*+,;=/?#@%]")
	regexp.MustCompile("\\{(.*?)\\}+")
	regexp.MustCompile("#.*")
	regexp.MustCompile("~[^01]")
	regexp.MustCompile("^[01]{1,64}$")
	regexp.MustCompile(`^(?:[-+]?(?:0|[1-9]\d*))$`)
	regexp.MustCompile("\033.*?m")
	regexp.MustCompile("([0-7]{6}) [^ ]+ [0-9a-f]{40}\t(.*)")
	regexp.MustCompile("^[0-9]+")
	regexp.MustCompile("[*][0-9]+$")
	regexp.MustCompile("[\\.[0-9]+]*")
	regexp.MustCompile("[+-]?[0-9]+")
	regexp.MustCompile("[0-9]+")
	regexp.MustCompile(".* ([0-9]+)\\.([0-9]+)")
	regexp.MustCompile("[+-]?[0-9]*\\.[0-9]+")
	regexp.MustCompile("[0-9]+(.[0-9]+)?")
	regexp.MustCompile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)$")
	regexp.MustCompile("^([0-9][0-9][0-9][0-9])-([0-9][0-9]?)-([0-9][0-9]?)(?:(?:[Tt]|[ \t]+)([0-9][0-9]?):([0-9][0-9]):([0-9][0-9])(?:\\.([0-9]*))?(?:[ \t]*(?:Z|([-+][0-9][0-9]?)(?::([0-9][0-9])?)?))?)?$")
	regexp.MustCompile("[0-9A-Fa-f]")
	regexp.MustCompile("([0-9a-fA-F]{40}) ([0-9a-fA-F]{40}) refs\\/(heads|tags)\\/(.+?)(\x00|$)")
	regexp.MustCompile("^#[0-9a-fA-F]{6}$")
	regexp.MustCompile("^[0-9A-Fa-f]{64}")
	regexp.MustCompile("^([.0-9]+)(?:_(?:RC|OSEr)[0-9]+)?")
	regexp.MustCompile(`0\d{2}-[2-9]\d{2}-\d{4}`)
	regexp.MustCompile(`0\d-[2-9]\d{3}-\d{4}`)
	regexp.MustCompile(`0\d{3}-[2-9]\d-\d{4}`)
	regexp.MustCompile(`0\d{4}-[2-9]-\d{4}`)
	regexp.MustCompile("\\.0*e\\+0*")
	regexp.MustCompile("0x0+([0-9])")
	regexp.MustCompile("^0x[a-h0-9]+( 0x[a-h0-9]+)*$")
	regexp.MustCompile(`^ *(#{1,6}) *([^\n]+?) *#* *(?:\n|$)`)
	regexp.MustCompile("^[1-9][0-9]?")
	regexp.MustCompile("^[1-9][0-9]*%?$")
	regexp.MustCompile(":443$")
	regexp.MustCompile(`^4\d{12}(\d{3})?$`)
	regexp.MustCompile(`^((?: {4}|\t)[^\n]+\n*)+`)
	regexp.MustCompile(`^(5[1-5]\d{4}|677189)\d{10}$`)
	regexp.MustCompile(`^(6011|65\d{2}|64[4-9]\d)\d{12}|(62\d{14})$`)
	regexp.MustCompile("a")
	regexp.MustCompile(`[áàảãạấầẩẫậâăắằẳẵặ]`)
	regexp.MustCompile(`a[act]ggtaaa|tttacc[agt]t`)
	regexp.MustCompile(`a+b+`)
	regexp.MustCompile(`abc{2,5}d?e*f+`)
	regexp.MustCompile(`^absolute(\.|-).*`)
	regexp.MustCompile(`\ACK2txt\n$`)
	regexp.MustCompile(`Acl`)
	regexp.MustCompile("address already in use")
	regexp.MustCompile(`Adm([^i]|$)`)
	regexp.MustCompile(`[aeiou][^aeiou]`)
	regexp.MustCompile(`Aes`)
	regexp.MustCompile("^[a-f,0-9]*$")
	regexp.MustCompile("^[a-f0-9]{64}\\.json$")
	regexp.MustCompile(`^[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}$`)
	regexp.MustCompile(`[a-f0-9]{8}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{4}-[a-f0-9]{12}`)
	regexp.MustCompile("[^a-fA-F0-9]")
	regexp.MustCompile("#([a-fA-F0-9]{6})")
	regexp.MustCompile(`agggtaaa|tttaccct`)
	regexp.MustCompile(`<a href="#.+?\|`)
	regexp.MustCompile("[^-[:alnum:]_.]+")
	regexp.MustCompile("[^[:alnum:]\\-_\\./]")
	regexp.MustCompile(`[^[:alpha:]]`)
	regexp.MustCompile(`^[^ ]*apache2`)
	regexp.MustCompile(`/api/internal/login`)
	regexp.MustCompile(`/api/organizations\?limit=100`)
	regexp.MustCompile("argument|flag|shorthand")
	regexp.MustCompile(`<arrmsg1>([\w\W]+?)</arrmsg1>`)
	regexp.MustCompile(`a[^rst]c`)
	regexp.MustCompile(`[^a-z]+`)
	regexp.MustCompile(`[a-z]+`)
	regexp.MustCompile("// *@([a-z]*) *(.*)$")
	regexp.MustCompile("[a-z]+")
	regexp.MustCompile("^[-a-z0-9_/]+$")
	regexp.MustCompile("[a-z]+[0-9]+$")
	regexp.MustCompile("^[a-z0-9][a-z0-9\\-]{2,62}$")
	regexp.MustCompile("[^a-zA-Z\\_\\ ]")
	regexp.MustCompile("[a-zA-Z]")
	regexp.MustCompile(`[^a-zA-Z0-9]`)
	regexp.MustCompile("^[a-zA-Z0-9_-]+$")
	regexp.MustCompile("^[a-zA-Z0-9_.-]+$")
	regexp.MustCompile("^[a-zA-Z0-9_./:-]+$")
	regexp.MustCompile("^[a-zA-Z0-9-_./]+$")
	regexp.MustCompile("^[a-zA-Z0-9!#$%&'*+/=?^_`{|}~.-]+$")
	regexp.MustCompile("[^.a-zA-Z0-9_-]")
	regexp.MustCompile("[^a-zA-Z0-9_.-]")
	regexp.MustCompile("[^a-zA-Z0-9_]")
	regexp.MustCompile("[^a-zA-Z0-9_\\-\\.]")
	regexp.MustCompile("[^a-zA-Z0-9-]")
	regexp.MustCompile("[^a-zA-Z0-9+=,.@_-]")
	regexp.MustCompile("[a-zA-Z0-9_]")
	regexp.MustCompile("[A-Z][a-z0-9]+")
	regexp.MustCompile("^[a-zA-Z0-9~._-]{43,128}$")
	regexp.MustCompile("^[a-zA-Z0-9._~-]{43,128}$")
	regexp.MustCompile("^[A-Za-z0-9][A-Za-z0-9_\\-\\.]{0,23}$")
	regexp.MustCompile(`>([a-zA-Z0-9]+@[a-zA-Z0-9.]+\.[a-zA-Z0-9]+)<`)
	regexp.MustCompile(`[a-zA-Z0-9]+@[a-zA-Z-0-9.]+\.[a-zA-Z0-9]+`)
	regexp.MustCompile(`[a-zA-Z0-9]+@[a-zA-Z0-9.]+\.[a-zA-Z0-9]+`)
	regexp.MustCompile("^[a-zA-Z0-9]([-a-zA-Z0-9]*[a-zA-Z0-9])$")
	regexp.MustCompile(`^[A-Za-z0-9._%+\-]+@[A-Za-z0-9.\-]+\.[A-Za-z]{2,4}$`)
	regexp.MustCompile("([a-zA-Z]+)(([0-9]+)(x([0-9]+))?)?")
	regexp.MustCompile("^[a-zA-Z]+(\\.[a-zA-Z]+)*$")
	regexp.MustCompile("{([a-zA-Z][a-zA-Z0-9_.]*).*}")
	regexp.MustCompile("@[a-zA-Z]+(-[a-zA-Z0-9]+)*")
	regexp.MustCompile("^[a-zA-Z_][a-zA-Z0-9_]{0,127}$")
	regexp.MustCompile("^[a-zA-Z_]\\w*$")
	regexp.MustCompile("[^A-Z`'\\s]")
	regexp.MustCompile(`\b(720p|1080p|hdtv|x264|dts|bluray)\b.*`)
	regexp.MustCompile(`\\b[A-Fa-f0-9]{32}\\b`)
	regexp.MustCompile(`^\$bgm\s+(\[.*\])$`)
	regexp.MustCompile("^--bind-ro=/host/foo:.*/app/foo(:rbind)?$")
	regexp.MustCompile("^--bind(-ro)?=/host/foo:.*/app/foo:rbind$")
	regexp.MustCompile(`\blimit \?(?:, ?\?| offset \?)?`)
	regexp.MustCompile(`\b(Ma?c)([A-Za-z]+)`)
	regexp.MustCompile(`\bMac[A-Za-z]{2,}[^aciozj]\b`)
	regexp.MustCompile(`\bMc`)
	regexp.MustCompile(`\bsample\b`)
	regexp.MustCompile("BUG")
	regexp.MustCompile("^/+bzz[i]?:/+[^/]+$")
	regexp.MustCompile("^/+bzz[ir]?:/+")
	regexp.MustCompile(`^(\*+)(?: +(CANCELED|DONE|TODO))?(?: +(\[#.\]))?(?: +(.*?))?(?:(:[a-zA-Z0-9_@#%:]+:))??[ \t]*$`)
	regexp.MustCompile(`^C[A-Z0-9]*$`)
	regexp.MustCompile(`[cgt]gggtaaa|tttaccc[acg]`)
	regexp.MustCompile(` CHARACTER SET ([^ ]+)`)
	regexp.MustCompile("charset=([^ ;]*)")
	regexp.MustCompile(`CIFS Session: (?P<sessions>\d+)`)
	regexp.MustCompile(".*cluster is healthy.*")
	regexp.MustCompile(` COLLATE ([^ ]+)`)
	regexp.MustCompile(`\.(com|com\.\w{2})$`)
	regexp.MustCompile("(connection refused|connection reset by peer)$")
	regexp.MustCompile("Could not find an allocated subnet for")
	regexp.MustCompile("^cpu([0-9]*)")
	regexp.MustCompile("Credential=([A-Z0-9]+)/")
	regexp.MustCompile("(\\d+)")
	regexp.MustCompile("[^\\d]+$")
	regexp.MustCompile("\\d+")
	regexp.MustCompile("^D[0-9]+:[0-9]+$")
	regexp.MustCompile(`^\d{1,7}$`)
	regexp.MustCompile(`^\d{3}[- ]?\d{2}[- ]?\d{4}$`)
	regexp.MustCompile(`^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}[+-]\d{2}:\d{2}$`)
	regexp.MustCompile(`^\d{4}-\d{2}-\d{2}T\d{2}:\d{2}:\d{2}Z$`)
	regexp.MustCompile(`^\d{8}T\d{6}Z$`)
	regexp.MustCompile("^(\\d+-)([a-z]*)$")
	regexp.MustCompile("\\d.\\d.\\d")
	regexp.MustCompile("^@@ -(\\d+),?(\\d*) \\+(\\d+),?(\\d*) @@$")
	regexp.MustCompile(`(\d+\.\d+) (\w+)(\(.*)`)
	regexp.MustCompile(`(\d+\.\d+) (\w+)(\(.*) <(.+)>`)
	regexp.MustCompile("Default Guest Additions ISO:(.+)")
	regexp.MustCompile("default = (?P<foo>.+)\n")
	regexp.MustCompile(".+/deployments/(\\d+)")
	regexp.MustCompile(`^\d*H[A-Z0-9]*$`)
	regexp.MustCompile("dial tcp: lookup (\\S+): no such host")
	regexp.MustCompile("dial tcp (\\S+): connection refused")
	regexp.MustCompile("dial tcp (\\S+): (?:connection timed out|i/o timeout|no route to host)")
	regexp.MustCompile("Digest: ([\\S]+)")
	regexp.MustCompile("[^[:digit:].]")
	regexp.MustCompile(`<div class="price_m" id='original-price'>.+\n.+<\/span>(.+)<\/div>`)
	regexp.MustCompile("^docker/[0-9A-Za-z+]")
	regexp.MustCompile("^\\(Docker-Client/[0-9A-Za-z+]")
	regexp.MustCompile(`Domain Name\.*: *(.+)`)
	regexp.MustCompile(`^.+_dsa.*$`)
	regexp.MustCompile("[^\\d-_\\.]")
	regexp.MustCompile(`^.+_ecdsa$`)
	regexp.MustCompile(`^.+_ed25519$`)
	regexp.MustCompile(` edge/(\d+)\.(\d+)`)
	regexp.MustCompile("[eE][+-]?[0-9]+")
	regexp.MustCompile("\\.el[0-9_]*\\.")
	regexp.MustCompile(`(Email|EmailAddress)\(\)`)
	regexp.MustCompile("EnvironmentFile=-(.*openshift-sdn.*)")
	regexp.MustCompile("error: (.*)")
	regexp.MustCompile("^error inheriting socket fd")
	regexp.MustCompile(`ESCAPE_([[:alnum:]]+)`)
	regexp.MustCompile(`(es|ed|ing)$`)
	regexp.MustCompile("^exit status (\\d+)")
	regexp.MustCompile("^export .*$")
	regexp.MustCompile(`^(::f{4}:)?10\.\d{1,3}\.\d{1,3}\.\d{1,3}`)
	regexp.MustCompile("\\.fc[0-9_]*\\.")
	regexp.MustCompile("(.*)ffjson:(\\s*)((skipdecoder)|(nodecoder))(.*)")
	regexp.MustCompile("(.*)ffjson:(\\s*)((skipencoder)|(noencoder))(.*)")
	regexp.MustCompile("(.*)ffjson:(\\s*)((skip)|(ignore))(.*)")
	regexp.MustCompile(".*fluentd-elasticsearch.*")
	regexp.MustCompile("Forwarding from 127.0.0.1:([0-9]+) -> 80")
	regexp.MustCompile("^found invalid count value: LISTEN_FDS=a$")
	regexp.MustCompile("found=([^\n]+)")
	regexp.MustCompile("-gci-dev-([0-9]+)-")
	regexp.MustCompile("git-media|hawser|git-lfs")
	regexp.MustCompile("^go[0-9]+\\.([0-9]+)")
	regexp.MustCompile("//go:generate[^\n]*\n")
	regexp.MustCompile(`\.(gov|gov\.\w{2})$`)
	regexp.MustCompile("^H[0-9]+:[0-9a-fA-F]{1,16}$")
	regexp.MustCompile("hdd0.* image='(.*)' type=*")
	regexp.MustCompile("^(HEAD|GET|PUT|POST|PATCH|OPTIONS|DELETE) ")
	regexp.MustCompile("^/?(.*?)/(HEAD|git-upload-pack|git-receive-pack|info/refs|objects/.*)$")
	regexp.MustCompile("^/hello$")
	regexp.MustCompile("/hello")
	regexp.MustCompile("he|ll|o+")
	regexp.MustCompile("^/hello/(?P<name>[^/]+)$")
	regexp.MustCompile("^/hello/(?P<name>[a-z]+)$")
	regexp.MustCompile("(?:http://|https://|)([0-9]*)\\.dkr\\.ecr\\.(.*)\\.amazonaws\\.com.*")
	regexp.MustCompile("(https?)://([^/]+)(/api/v3)?/repos/([^/]+)/([^/]+)/releases")
	regexp.MustCompile("^https?://foo")
	regexp.MustCompile("^https?://foo/nope")
	regexp.MustCompile("http: TLS handshake error from ([\\d.]+):\\d+: remote error: bad certificate")
	regexp.MustCompile("@(?i:article){.*")
	regexp.MustCompile(`(?i)\bcode\b`)
	regexp.MustCompile(`(?i)\+BEGIN_(CENTER|COMMENT|EXAMPLE|QUOTE|SRC|VERSE)`)
	regexp.MustCompile("(?i)^(circle|disc|square|a|A|i|I|1)$")
	regexp.MustCompile("(?i)^count(.+)$")
	regexp.MustCompile(`(?i)^d('ye)$`)
	regexp.MustCompile(`(?i)([ex](\d{2})(?:\d|$))`)
	regexp.MustCompile(`(?i)<html.*/head>`)
	regexp.MustCompile(`(?i:http).*.git`)
	regexp.MustCompile("(?i) (=|<>|>|<|LIKE|IS|IN) ")
	regexp.MustCompile(`(?i)\([^)]*mix[^)]*\)$`)
	regexp.MustCompile("^import .*$")
	regexp.MustCompile(`(?ims)<!--.*?-->`)
	regexp.MustCompile(`(?ims)<!DOCTYPE.*?>`)
	regexp.MustCompile(`(?ims)<script.*?>.*?</script>`)
	regexp.MustCompile(`(?imsU)\[quote(?:=[^\]]+)?\](.+)\[/quote\]`)
	regexp.MustCompile(`(?imU)^(.*)$`)
	regexp.MustCompile("inet ([0-9.]*/[0-9]*) ")
	regexp.MustCompile("^/([^\\/]+?)/info/refs$")
	regexp.MustCompile(`\{inherits=(\d+)\}`)
	regexp.MustCompile(`(?:(.+); )?InnoDB free: .*`)
	regexp.MustCompile(`^(int)`)
	regexp.MustCompile(`^((inteiro)|(real)|(caractere)|(lógico))(\s*):`)
	regexp.MustCompile(`(?i)(refer):\s+(.*?)(\s|$)`)
	regexp.MustCompile(`(?i)\([^)]*remaster[^)]*\)$`)
	regexp.MustCompile("(?i)rtl|ltr")
	regexp.MustCompile(`(?is)\(.*?\)`)
	regexp.MustCompile(`(?is)<a.+?</a>`)
	regexp.MustCompile(`(?i)(s?(\d{1,2}))[ex]`)
	regexp.MustCompile(`^(?i)(\s*insert\s+into\s+)`)
	regexp.MustCompile("(?i)(^|[,\\s])Upgrade($|[,\\s])")
	regexp.MustCompile(`^(?i)\((\s*\w+(?:\s*,\s*\w+){1,100})\s*\)\s*`)
	regexp.MustCompile(`(?i)windows nt`)
	regexp.MustCompile(`(?i)windows phone`)
	regexp.MustCompile(`k8s_.*\.metadata\.name$`)
	regexp.MustCompile(`k8s_\w+_\w+_deployment\.spec\.selector\.match_labels$`)
	regexp.MustCompile(`kitsu.io/users/(.*?)/library`)
	regexp.MustCompile(".*kube-proxy.*")
	regexp.MustCompile("^language-[a-zA-Z0-9]+$")
	regexp.MustCompile(`^LI[A-Z0-9]*$`)
	regexp.MustCompile(`<li class="neirong2">信息来源[^>]+">([^<]+)<`)
	regexp.MustCompile(`<li class="neirong2">信息标题.*<b>([^<]+)<`)
	regexp.MustCompile("listen tcp :443: bind: permission denied")
	regexp.MustCompile("listen tcp :80: bind: permission denied")
	regexp.MustCompile("master(-...)?$")
	regexp.MustCompile("max-age= *([0-9]+)")
	regexp.MustCompile(`(?m)^Created: *(.*?)$`)
	regexp.MustCompile(`(?m:^%(\.\d)?[sdfgtq]$)`)
	regexp.MustCompile("^MemFree:")
	regexp.MustCompile("^MemTotal:")
	regexp.MustCompile(`^metric .*`)
	regexp.MustCompile(`(?m)^h([0-6])\.(.*)$`)
	regexp.MustCompile("^missing port in address abc$")
	regexp.MustCompile(`^(?:mister )(.*)$`)
	regexp.MustCompile(`(?m)^@@@@\n`)
	regexp.MustCompile("<!-- more -->")
	regexp.MustCompile("(?ms)^(.+)\\=(.*)$")
	regexp.MustCompile("(?ms)\\.{3}")
	regexp.MustCompile(`(?m:^)(\s+)?(?i)(Whois server|whois):\s+(.*?)(\s|$)`)
	regexp.MustCompile("(?ms)^(\\w+)\\=(.*)$")
	regexp.MustCompile("(?m)^[ \t]+$")
	regexp.MustCompile(`(?m:^[ \t]*%(\.\d)?[sdfgtq]$)`)
	regexp.MustCompile(`(?m)^[ \t]*(#+)\s+`)
	regexp.MustCompile("(?m)(^[ \t]*)(?:[^ \t\n])")
	regexp.MustCompile(`^[^\n]+`)
	regexp.MustCompile(`^\n+`)
	regexp.MustCompile(`}\n+$`)
	regexp.MustCompile("\n+")
	regexp.MustCompile(`\n={2,}`)
	regexp.MustCompile("net0.* mac=([0-9A-F]{12}) card=.*")
	regexp.MustCompile("\nfoobar_process_cpu_seconds_total [0-9]")
	regexp.MustCompile("\nfoobar_process_max_fds [1-9]")
	regexp.MustCompile("\nfoobar_process_open_fds [1-9]")
	regexp.MustCompile("\nfoobar_process_resident_memory_bytes [1-9]")
	regexp.MustCompile("\nfoobar_process_start_time_seconds [0-9.]{10,}")
	regexp.MustCompile("\nfoobar_process_virtual_memory_bytes [1-9]")
	regexp.MustCompile("([niftvw])(?: % ([0-9]+))? (!=|=)(.*)")
	regexp.MustCompile(".*node-problem-detector.*")
	regexp.MustCompile("\nprocess_cpu_seconds_total [0-9]")
	regexp.MustCompile("\nprocess_max_fds [1-9]")
	regexp.MustCompile("\nprocess_open_fds [1-9]")
	regexp.MustCompile("\nprocess_resident_memory_bytes [1-9]")
	regexp.MustCompile("\nprocess_start_time_seconds [0-9.]{10,}")
	regexp.MustCompile("\nprocess_virtual_memory_bytes [1-9]")
	regexp.MustCompile(`(\n|\r|\r\n)$`)
	regexp.MustCompile("\n|\u0085|\u2028|\u2029")
	regexp.MustCompile("[oa]+")
	regexp.MustCompile("<p(.*?)>")
	regexp.MustCompile("%p1")
	regexp.MustCompile("parent branch: (?P<foo>.+)\n")
	regexp.MustCompile(`\p{Cyrillic}`)
	regexp.MustCompile("(?P<dockerUA>.+) UpstreamClient(?P<upstreamUA>.+)")
	regexp.MustCompile("peer_ifindex: (\\d+)")
	regexp.MustCompile(`--(?P<var_name>[\\w-]+?):\\s+?(?P<var_val>.+?);`)
	regexp.MustCompile("^remote\\.(.*)\\.url (.*?)$")
	regexp.MustCompile(`<(.|[\r\n])*?>`)
	regexp.MustCompile(" +\r\n")
	regexp.MustCompile("rr")
	regexp.MustCompile(`^.+_rsa$`)
	regexp.MustCompile("^=== RUN:? +(.+)$")
	regexp.MustCompile(".*RUNNING")
	regexp.MustCompile("RUNNING")
	regexp.MustCompile("Running in (.+)")
	regexp.MustCompile(`[.]|,|\s/`)
	regexp.MustCompile("^\\s+$")
	regexp.MustCompile("\\s+")
	regexp.MustCompile("('[^']*')|(\\S+)")
	regexp.MustCompile("[\\s]{2,}")
	regexp.MustCompile("(?s)-----BEGIN CERTIFICATE-----.*-----END CERTIFICATE-----")
	regexp.MustCompile("(?s)-----BEGIN RSA PRIVATE KEY-----.*-----END RSA PRIVATE KEY-----")
	regexp.MustCompile("script_[0-9]{4}.sh")
	regexp.MustCompile("(?s)(-?[\\d.]+)\\)")
	regexp.MustCompile("(?s)\\(([\\d.]+)")
	regexp.MustCompile(`(-\s+(\d+)(?:\d|$))`)
	regexp.MustCompile("[\\S]+: digest: ([\\S]+) size: [0-9]+")
	regexp.MustCompile("^\\s*\\d+\\s*$")
	regexp.MustCompile(`^\s*events\s*{`)
	regexp.MustCompile("^(sha256:|)[a-z0-9]{64}\\n$")
	regexp.MustCompile(`Share \(unique mount targets\): (?P<shares>\d+)`)
	regexp.MustCompile(`^\s*http\s*{`)
	regexp.MustCompile(`\s(if|else|while|catch)\s*([^{;]+;|;)`)
	regexp.MustCompile("Signature=([[0-9a-f]+)")
	regexp.MustCompile(`SMB Request/Response Buffer: (?P<smbBuffer>\d+) Pool size: (?P<smbPoolSize>\d+)`)
	regexp.MustCompile(`<==\sPlayerInventory\.GetPlayerCardsV3\(\d*\)`)
	regexp.MustCompile(`\s*:\s*`)
	regexp.MustCompile("\\s*,\\s*")
	regexp.MustCompile(`^(\S*) (\S*) (\d*) (\S*) IP(\d) (\S*)`)
	regexp.MustCompile(`.*sses$`)
	regexp.MustCompile(`^(\s+\S+:\s+.*)$`)
	regexp.MustCompile("\\s+([^\\s]*)=\\s*(PID[^\\s]*)")
	regexp.MustCompile("Starting \\w+ Master")
	regexp.MustCompile("Starting \\w+ Node")
	regexp.MustCompile("^(stop|terminate)$")
	regexp.MustCompile("Successfully built ([0-9a-f]{12})")
	regexp.MustCompile(`\s*Version:\s*(.+)$`)
	regexp.MustCompile(`\s*\{weight=(\d+)\}\s*`)
	regexp.MustCompile("^\\s*(\\w+)\\s+(\\w+)\\s+(.+)$")
	regexp.MustCompile(`^[ \t]*#`)
	regexp.MustCompile("[ \t]")
	regexp.MustCompile("[\t ]+")
	regexp.MustCompile("\t+")
	regexp.MustCompile("(tarsum)(.([a-z0-9]+))?\\+([a-zA-Z0-9]+):([A-Fa-f0-9]+)")
	regexp.MustCompile("tarsum(?:.[a-z0-9]+)?\\+[a-zA-Z0-9]+:[A-Fa-f0-9]+")
	regexp.MustCompile(`<td><span class="label">性别：</span><span field="">([^<]+)</span></td>`)
	regexp.MustCompile("^Test[0-9]*([A-Z].*$)")
	regexp.MustCompile("^text/plain(;.*)?$")
	regexp.MustCompile("/tmp/.+")
	regexp.MustCompile("/tmp/script_[0-9]{4}.sh")
	regexp.MustCompile("[ \t\n]+")
	regexp.MustCompile("[\t\r\n]")
	regexp.MustCompile("[\u000D\u000A]+")
	regexp.MustCompile("Unable to decode an event from the watch stream: local error: unexpected message")
	regexp.MustCompile(`unifi_devices_adopted{site="Default"} 1`)
	regexp.MustCompile(`unifi_devices{site="Default"} 1`)
	regexp.MustCompile(`unifi_devices_unadopted{site="Default"} 0`)
	regexp.MustCompile("^unknown network foo$")
	regexp.MustCompile("^unknown network invalid_unix_net_for_test$")
	regexp.MustCompile(`^/video/([\w\-]{6,12})\.json$`)
	regexp.MustCompile(`^(?:\"|\')\w+(?:\"|\')$`)
	regexp.MustCompile(`^\w+\(.*\)$`)
	regexp.MustCompile(`#\+(\w+): (.*)`)
	regexp.MustCompile("^[\\w .?]*$")
	regexp.MustCompile(".*\\/watch")
	regexp.MustCompile(".*west.*")
	regexp.MustCompile("\\w[\\w-.]+\\w")
	regexp.MustCompile(`^\w+([-+.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$`)
	regexp.MustCompile("\x00([^:]*):([^\x00]*)\x00")
	regexp.MustCompile("^X:[0-9a-fA-F]+$")
	regexp.MustCompile("\x1B\\[(?:[0-9]{1,2}(?:;[0-9]{1,2})?)*[a-zA-Z]")
	regexp.MustCompile("\x1b[\\[()][0-9;]*[a-zA-Z@]|\x1b.|[\x08\x0e\x0f]")
	regexp.MustCompile("x509: certificate is valid for (\\S+, )+not (\\S+)")
	regexp.MustCompile(`[\xC0-\xC6]`)
	regexp.MustCompile(`[\xC8-\xCB]`)
	regexp.MustCompile(`[\xE0-\xE6]`)
	regexp.MustCompile(`[\xE8-\xEB]`)
	regexp.MustCompile(`[а-яё]`)
	regexp.MustCompile(`开 本：(\d+)开`)
}
