/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ur_IN extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "گرین وچ مین ٹائم",
               "GMT",
               "",
               "BST",
               "",
               "GMT",
            };
        final String[] Gulf = new String[] {
               "خلیج سٹینڈرڈ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Iran = new String[] {
               "ایران سٹینڈرڈ ٹائم",
               "",
               "ایران ڈے لائٹ ٹائم",
               "",
               "ایران ٹائم",
               "",
            };
        final String[] Peru = new String[] {
               "پیرو سٹینڈرڈ ٹائم",
               "",
               "پیرو سمر ٹائم",
               "",
               "پیرو ٹائم",
               "",
            };
        final String[] Chile = new String[] {
               "چلی سٹینڈرڈ ٹائم",
               "",
               "چلی سمر ٹائم",
               "",
               "چلی ٹائم",
               "",
            };
        final String[] India = new String[] {
               "انڈیا سٹینڈرڈ ٹائم",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Nepal = new String[] {
               "نیپال ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Amazon = new String[] {
               "ایمیزون سٹینڈرڈ ٹائم",
               "",
               "ایمیزون سمر ٹائم",
               "",
               "ایمیزون ٹائم",
               "",
            };
        final String[] Bhutan = new String[] {
               "بھوٹان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ایسٹر آئلینڈ سٹینڈرڈ ٹائم",
               "",
               "ایسٹر آئلینڈ سمر ٹائم",
               "",
               "ایسٹر آئلینڈ ٹائم",
               "",
            };
        final String[] Guyana = new String[] {
               "گیانا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Israel = new String[] {
               "اسرائیل سٹینڈرڈ ٹائم",
               "IST",
               "اسرائیل ڈے لائٹ ٹائم",
               "IDT",
               "اسرائیل ٹائم",
               "IT",
            };
        final String[] Vostok = new String[] {
               "ووسٹاک ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "عرب سٹینڈرڈ ٹائم",
               "",
               "عرب ڈے لائٹ ٹائم",
               "",
               "عرب ٹائم",
               "",
            };
        final String[] Armenia = new String[] {
               "آرمینیا سٹینڈرڈ ٹائم",
               "",
               "آرمینیا سمر ٹائم",
               "",
               "آرمینیا ٹائم",
               "",
            };
        final String[] Bolivia = new String[] {
               "بولیویا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ایکواڈور ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "جارجیا سٹینڈرڈ ٹائم",
               "",
               "جارجیا سمر ٹائم",
               "",
               "جارجیا ٹائم",
               "",
            };
        final String[] Noronha = new String[] {
               "فرنانڈو ڈی نورنہا سٹینڈرڈ ٹائم",
               "",
               "فرنانڈو ڈی نورونہا سمر ٹائم",
               "",
               "فرنانڈو ڈی نورنہا ٹائم",
               "",
            };
        final String[] Rothera = new String[] {
               "روتھیرا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "یوروگوئے سٹینڈرڈ ٹائم",
               "",
               "یوروگوئے سمر ٹائم",
               "",
               "یوروگوئے ٹائم",
               "",
            };
        final String[] Brasilia = new String[] {
               "برازیلیا سٹینڈرڈ ٹائم",
               "",
               "برازیلیا سمر ٹائم",
               "",
               "برازیلیا ٹائم",
               "",
            };
        final String[] Colombia = new String[] {
               "کولمبیا سٹینڈرڈ ٹائم",
               "",
               "کولمبیا سمر ٹائم",
               "",
               "کولمبیا ٹائم",
               "",
            };
        final String[] Falkland = new String[] {
               "فاک لینڈ آئلینڈز سٹینڈرڈ ٹائم",
               "",
               "فاک لینڈ آئلینڈز سمر ٹائم",
               "",
               "فاک لینڈ آئلینڈز ٹائم",
               "",
            };
        final String[] Maldives = new String[] {
               "مالدیپ ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pakistan = new String[] {
               "پاکستان سٹینڈرڈ ٹائم",
               "PKT",
               "پاکستان سمر ٹائم",
               "PKST",
               "پاکستان ٹائم",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "پیراگوئے سٹینڈرڈ ٹائم",
               "",
               "پیراگوئے سمر ٹائم",
               "",
               "پیراگوئے ٹائم",
               "",
            };
        final String[] Suriname = new String[] {
               "سورینام ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "گالاپاگوز ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "کرغستان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "وینزوئیلا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "آذربائیجان سٹینڈرڈ ٹائم",
               "",
               "آذربائیجان سمر ٹائم",
               "",
               "آذربائیجان ٹائم",
               "",
            };
        final String[] Bangladesh = new String[] {
               "بنگلہ دیش سٹینڈرڈ ٹائم",
               "",
               "بنگلہ دیش سمر ٹائم",
               "",
               "بنگلہ دیش ٹائم",
               "",
            };
        final String[] EMPTY_ZONE = new String[] {
               "",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "تاجکستان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ازبکستان سٹینڈرڈ ٹائم",
               "",
               "ازبکستان سمر ٹائم",
               "",
               "ازبکستان ٹائم",
               "",
            };
        final String[] Afghanistan = new String[] {
               "افغانستان ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Zealand = new String[] {
               "نیوزی لینڈ سٹینڈرڈ ٹائم",
               "NZST",
               "نیوزی لینڈ ڈے لائٹ ٹائم",
               "NZDT",
               "نیوزی لینڈ ٹائم",
               "NZT",
            };
        final String[] Turkmenistan = new String[] {
               "ترکمانستان سٹینڈرڈ ٹائم",
               "",
               "ترکمانستان سمر ٹائم",
               "",
               "ترکمانستان ٹائم",
               "",
            };
        final String[] French_Guiana = new String[] {
               "فرینچ گیانا ٹائم",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "وسطی یورپ کا معیاری وقت",
               "CET",
               "وسطی یورپ کا موسم گرما کا وقت",
               "CEST",
               "وسطی یورپ کا وقت",
               "CET",
            };
        final Object[][] data = new Object[][] {
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "UTC", EMPTY_ZONE },
            { "GB", GMT },
            { "NZ", New_Zealand },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CET", Europe_Central },
            { "ECT", Europe_Central },
            { "IST", India },
            { "MET", Europe_Central },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "Eire", GMT },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "Israel", Israel },
            { "Poland", Europe_Central },
            { "Etc/GMT", GMT },
            { "GB-Eire", GMT },
            { "Iceland", GMT },
            { "Etc/GMT0", GMT },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Qatar", Arabian },
            { "Africa/Lome", GMT },
            { "Asia/Kuwait", Arabian },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Rome", Europe_Central },
            { "Africa/Accra", GMT },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Tunis", Europe_Central },
            { "America/Lima", Peru },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yerevan", Armenia },
            { "Europe/Malta", Europe_Central },
            { "Europe/Vaduz", Europe_Central },
            { "Africa/Bamako", GMT },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Katmandu", Nepal },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Etc/Greenwich", GMT },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin", GMT },
            { "Europe/Jersey", GMT },
            { "Europe/London", GMT },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "America/Bogota", Colombia },
            { "America/Cuiaba", Amazon },
            { "America/Guyana", Guyana },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Recife", Brasilia },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Samarkand", Uzbekistan },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast", GMT },
            { "Europe/Vatican", Europe_Central },
            { "Indian/Reunion", Gulf },
            { "Pacific/Easter", Easter },
            { "Africa/Freetown", GMT },
            { "Africa/Monrovia", GMT },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Noronha", Noronha },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Guernsey", GMT },
            { "Europe/Sarajevo", Europe_Central },
            { "Indian/Maldives", Maldives },
            { "America/Asuncion", Paraguay },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "Antarctica/Troll", GMT },
            { "Atlantic/Stanley", Falkland },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Indian/Kerguelen", Maldives },
            { "Pacific/Auckland", New_Zealand },
            { "Africa/Nouakchott", GMT },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Fortaleza", Brasilia },
            { "America/Guayaquil", Ecuador },
            { "America/Sao_Paulo", Brasilia },
            { "Antarctica/Vostok", Vostok },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Pacific/Galapagos", Galapagos },
            { "Africa/Ouagadougou", GMT },
            { "America/Montevideo", Uruguay },
            { "America/Paramaribo", Suriname },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man", GMT },
            { "America/Porto_Velho", Amazon },
            { "Arctic/Longyearbyen", Europe_Central },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "Antarctica/South_Pole", New_Zealand },
            { "timezone.excity.Africa/Accra", "اکرا" },
            { "timezone.excity.America/Thule", "تھولے" },
            { "timezone.excity.Europe/Budapest", "بوڈاپیسٹ" },
            { "timezone.excity.America/Glace_Bay", "گلیس بے" },
            { "timezone.excity.America/Goose_Bay", "گوس بے" },
            { "timezone.excity.America/Grand_Turk", "گرینڈ ترک" },
            { "timezone.excity.America/Scoresbysund", "اتتوققورتورمیت" },
            { "timezone.excity.America/Cambridge_Bay", "کیمبرج بے" },
        };
        return data;
    }
}
