/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * UNICODE LICENSE V3
 *
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright © 1991-2025 Unicode, Inc.
 *
 * NOTICE TO USER: Carefully read the following legal agreement. BY
 * DOWNLOADING, INSTALLING, COPYING OR OTHERWISE USING DATA FILES, AND/OR
 * SOFTWARE, YOU UNEQUIVOCALLY ACCEPT, AND AGREE TO BE BOUND BY, ALL OF THE
 * TERMS AND CONDITIONS OF THIS AGREEMENT. IF YOU DO NOT AGREE, DO NOT
 * DOWNLOAD, INSTALL, COPY, DISTRIBUTE OR USE THE DATA FILES OR SOFTWARE.
 *
 * Permission is hereby granted, free of charge, to any person obtaining a
 * copy of data files and any associated documentation (the "Data Files") or
 * software and any associated documentation (the "Software") to deal in the
 * Data Files or Software without restriction, including without limitation
 * the rights to use, copy, modify, merge, publish, distribute, and/or sell
 * copies of the Data Files or Software, and to permit persons to whom the
 * Data Files or Software are furnished to do so, provided that either (a)
 * this copyright and permission notice appear with all copies of the Data
 * Files or Software, or (b) this copyright and permission notice appear in
 * associated Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF ANY
 * KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT OF
 * THIRD PARTY RIGHTS.
 *
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS NOTICE
 * BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL DAMAGES,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION,
 * ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THE DATA
 * FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder shall
 * not be used in advertising or otherwise to promote the sale, use or other
 * dealings in these Data Files or Software without prior written
 * authorization of the copyright holder.
 *
 * SPDX-License-Identifier: Unicode-3.0
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.TimeZoneNamesBundle;

public class TimeZoneNames_ti extends TimeZoneNamesBundle {
    @Override
    protected final Object[][] getContents() {
        final String[] GMT = new String[] {
               "GMT",
               "GMT",
               "",
               "GMT",
               "",
               "GMT",
            };
        final String[] Acre = new String[] {
               "ናይ መደበኛ ግዘ ኣክሪ",
               "",
               "ግዜ ክረምቲ ኣክሪ",
               "",
               "ግዘ አክሪ",
               "",
            };
        final String[] Apia = new String[] {
               "ናይ መደበኛ አፒያ ግዘ",
               "",
               "ናይ መዓልቲ አፒያ ግዘ",
               "",
               "ናይ አፒያ ግዘ",
               "",
            };
        final String[] Cook = new String[] {
               "ናይ መደበኛ ኩክ ደሴት ግዘ",
               "",
               "ናይ ፍርቂ ክረምቲ ኩክ ደሴት ግዘ",
               "",
               "ናይ ኩክ ደሴት ግዘ",
               "",
            };
        final String[] Cuba = new String[] {
               "ናይ መደበኛ ግዘ ኩባ",
               "CST",
               "ናይ መዓልቲ ግዘ ኩባ",
               "CDT",
               "ናይ ኩባ ግዘ",
               "CT",
            };
        final String[] Fiji = new String[] {
               "ናይ መደበኛ ፊጂ ግዘ",
               "",
               "ናይ ክረምቲ ፊጂ ግዘ",
               "",
               "ናይ ፊጂ ግዘ",
               "",
            };
        final String[] Gulf = new String[] {
               "ናይ መደበኛ ገልፍ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hovd = new String[] {
               "ናይ መደበኛ ሆቭድ ግዘ",
               "",
               "ናይ ክረምቲ ሆቭድ ግዘ",
               "",
               "ናይ ሆቭድ ግዘ",
               "",
            };
        final String[] Iran = new String[] {
               "ናይ መደበኛ ኢራን ግዘ",
               "",
               "ናይ መዓልቲ ኢራን ግዘ",
               "",
               "ናይ ኢራን ግዘ",
               "",
            };
        final String[] Niue = new String[] {
               "ናይ ኒዌ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Omsk = new String[] {
               "ናይ መደበኛ ኦምስክ ግዘ",
               "",
               "ናይ ክረምቲ ኦምስክ ግዘ",
               "",
               "ናይ ኦምስክ ግዘ",
               "",
            };
        final String[] Peru = new String[] {
               "ናይ መደበኛ ግዘ ፔሩ",
               "",
               "ግዜ ክረምቲ ፔሩ",
               "",
               "ግዜ ፔሩ",
               "",
            };
        final String[] Truk = new String[] {
               "ናይ ቹክ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wake = new String[] {
               "ናይ ዌክ ደሴት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chile = new String[] {
               "ናይ መደበኛ ግዘ ቺሌ",
               "",
               "ግዜ ክረምቲ ቺሌ",
               "",
               "ግዜ ቺሌ",
               "",
            };
        final String[] China = new String[] {
               "ናይ መደበኛ ቻይና ግዘ",
               "CST",
               "ናይ መዓልቲ ቻይና ግዘ",
               "CDT",
               "ናይ ቻይና ግዘ",
               "CT",
            };
        final String[] Cocos = new String[] {
               "ናይ ኮኮስ ደሴት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Davis = new String[] {
               "ናይ ዴቪስ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] India = new String[] {
               "ናይ መደበኛ ህንድ ግዘ",
               "IST",
               "",
               "IST",
               "",
               "IST",
            };
        final String[] Japan = new String[] {
               "ናይ መደበኛ ጃፓን ግዘ",
               "JST",
               "ናይ መዓልቲ ጃፓን ግዘ",
               "JDT",
               "ናይ ጃፓን ግዘ",
               "JT",
            };
        final String[] Korea = new String[] {
               "ናይ መደበኛ ኮሪያን ግዘ",
               "KST",
               "ናይ መዓልቲ ኮሪያን ግዘ",
               "KST",
               "ናይ ኮሪያን ግዘ",
               "KST",
            };
        final String[] Nauru = new String[] {
               "ናይ ናውሩ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Nepal = new String[] {
               "ናይ ኔፓል ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Palau = new String[] {
               "ናይ ፓላው ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Samoa = new String[] {
               "ናይ መደበኛ ሳሞዋ ግዘ",
               "SST",
               "ናይ መዓልቲ ሳሞዋ ግዘ",
               "SST",
               "ናይ ሳሞዋ ግዘ",
               "SST",
            };
        final String[] Syowa = new String[] {
               "ናይ ስዮዋ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tonga = new String[] {
               "ናይ መደበኛ ቶንጋ ግዘ",
               "",
               "ናይ ክረምቲ ቶንጋ ግዘ",
               "",
               "ናይ ቶንጋ ግዘ",
               "",
            };
        final String[] Yukon = new String[] {
               "ናይ ዩኮን ግዘ",
               "MST",
               "",
               "MST",
               "",
               "MST",
            };
        final String[] Alaska = new String[] {
               "ናይ መደበኛ ግዘ አላስካ",
               "AKST",
               "ናይ መዓልቲ ግዘ አላስካ",
               "AKDT",
               "ግዘ አላስካ",
               "AKT",
            };
        final String[] Amazon = new String[] {
               "ናይ መደበኛ ግዘ ኣማዞን",
               "",
               "ግዜ ክረምቲ ኣማዞን",
               "",
               "ግዜ ኣማዞን",
               "",
            };
        final String[] Azores = new String[] {
               "ናይ መደበኛ ግዘ ኣዞረስ",
               "",
               "ናይ ክረምቲ አዞረስ ግዘ",
               "",
               "ናይ አዞረስ ግዘ",
               "",
            };
        final String[] Bhutan = new String[] {
               "ናይ ቡህታን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Brunei = new String[] {
               "ናይ ብሩኔ ዳሩሳሌም ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Easter = new String[] {
               "ናይ መደበኛ ግዘ ደሴት ፋሲካ",
               "",
               "ግዜ ክረምቲ ደሴት ፋሲካ",
               "",
               "ግዜ ደሴት ፋሲካ",
               "",
            };
        final String[] Guyana = new String[] {
               "ግዜ ጉያና",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii = new String[] {
               "ናይ መደበኛ ሃዋይ-ኣሌውቲያን ግዘ",
               "HST",
               "",
               "HST",
               "",
               "HST",
            };
        final String[] Israel = new String[] {
               "ናይ መደበኛ እስራኤል ግዘ",
               "IST",
               "ናይ መዓልቲ እስራኤል ግዘ",
               "IDT",
               "ናይ እስራኤል ግዘ",
               "IT",
            };
        final String[] Kosrae = new String[] {
               "ናይ ኮርሳይ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mawson = new String[] {
               "ናይ ማውሶን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Moscow = new String[] {
               "ናይ መደበኛ ሞስኮው ግዘ",
               "MSK",
               "ናይ ክረምቲ ሞስኮው ግዘ",
               "MSK",
               "ናይ ሞስኮው ግዘ",
               "MSK",
            };
        final String[] Ponape = new String[] {
               "ናይ ፖናፔ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tahiti = new String[] {
               "ናይ ቲሂቲ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Taipei = new String[] {
               "ናይ መደበኛ ቴፒ ግዘ",
               "CST",
               "ናይ መዓልቲ ቴፒ ግዘ",
               "CDT",
               "ናይ ቴፒ ግዘ",
               "CT",
            };
        final String[] Tuvalu = new String[] {
               "ናይ ቱቫሉ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Vostok = new String[] {
               "ናይ ቮስቶክ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Wallis = new String[] {
               "ናይ ዌልስን ፉቷ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Arabian = new String[] {
               "ናይ መደበኛ አረብ ግዘ",
               "",
               "ናይ መዓልቲ አረብ ግዘ",
               "",
               "ናይ አረብ ግዘ",
               "",
            };
        final String[] Armenia = new String[] {
               "ናይ መደበኛ አርሜኒያ ግዘ",
               "",
               "ናይ ክረምቲ አርሜኒያ ግዘ",
               "",
               "ናይ አርሜኒያ ግዘ",
               "",
            };
        final String[] Bolivia = new String[] {
               "ግዜ ቦሊቭያ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Chatham = new String[] {
               "ናይ መደበኛ ቻትሃም ግዘ",
               "",
               "ናይ መዓልቲ ቻትሃም ግዘ",
               "",
               "ናይ ቻትሃም ግዘ",
               "",
            };
        final String[] ETC_UTC = new String[] {
               "ዝተሳነየ ኣድማሳዊ ግዜ",
               "UTC",
               "",
               "",
               "",
               "",
            };
        final String[] Ecuador = new String[] {
               "ግዜ ኤኳዶር",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gambier = new String[] {
               "ናይ ጋምቢየር ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Georgia = new String[] {
               "ናይ መደበኛ ጆርጂያ ግዘ",
               "",
               "ናይ ክረምቲ ጆርጂያ ግዘ",
               "",
               "ናይ ጆርጂያ ግዘ",
               "",
            };
        final String[] Irkutsk = new String[] {
               "ናይ መደበኛ ኢርኩትስክ ግዘ",
               "",
               "ናይ ክረምቲ ኢርኩትስክ ግዘ",
               "",
               "ናይ ኢርኩትስክ ግዘ",
               "",
            };
        final String[] Magadan = new String[] {
               "ናይ መደበኛ ሜጋዳን ግዘ",
               "",
               "ናይ ክረምቲ ሜጋዳን ግዘ",
               "",
               "ናይ ሜጋዳን ግዘ",
               "",
            };
        final String[] Myanmar = new String[] {
               "ናይ ምያንማር ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Norfolk = new String[] {
               "ናይ መደበኛ ኖርፎልክ ደሴት ግዘ",
               "",
               "ናይ መዓልቲ ኖርፎልክ ደሴት ግዘ",
               "",
               "ናይ ኖርፎልክ ደሴት ግዘ",
               "",
            };
        final String[] Noronha = new String[] {
               "ናይ መደበኛ ግዘ ፈርናንዶ ደ ኖሮንያ",
               "",
               "ግዜ ክረምቲ ፈርናንዶ ደ ኖሮንያ",
               "",
               "ግዜ ፈርናንዶ ደ ኖሮንያ",
               "",
            };
        final String[] Reunion = new String[] {
               "ግዜ ርዩንየን",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Rothera = new String[] {
               "ናይ ሮቴራ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Solomon = new String[] {
               "ናይ ሶሎሞን ደሴታት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tokelau = new String[] {
               "ናይ ቶኬላው ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uruguay = new String[] {
               "ናይ መደበኛ ግዘ ኡራጓይ",
               "",
               "ግዜ ክረምቲ ኡራጓይ",
               "",
               "ግዜ ኡራጓይ",
               "",
            };
        final String[] Vanuatu = new String[] {
               "ናይ መደበኛ ቫኗታው ግዘ",
               "",
               "ናይ ክረምቲ ቫኗታው ግዘ",
               "",
               "ናይ ቫኗታው ግዘ",
               "",
            };
        final String[] Yakutsk = new String[] {
               "ናይ መደበኛ ያኩትስክ ግዘ",
               "",
               "ናይ ክረምቲ ያኩትስክ ግዘ",
               "",
               "ናይ ያኩትስክ ግዘ",
               "",
            };
        final String[] Atlantic = new String[] {
               "ናይ መደበኛ ግዘ አትላንቲክ",
               "AST",
               "ናይ መዓልቲ ግዘ አትላንቲክ",
               "AST",
               "ናይ አትላንቲክ ግዘ",
               "AST",
            };
        final String[] Brasilia = new String[] {
               "ናይ መደበኛ ግዘ ብራዚልያ",
               "",
               "ግዜ ክረምቲ ብራዚልያ",
               "",
               "ግዜ ብራዚልያ",
               "",
            };
        final String[] Chamorro = new String[] {
               "ናይ መደበኛ ቻሞሮ ግዘ",
               "ChST",
               "",
               "ChST",
               "",
               "ChST",
            };
        final String[] Colombia = new String[] {
               "ናይ መደበኛ ግዘ ኮሎምብያ",
               "",
               "ግዜ ክረምቲ ኮሎምብያ",
               "",
               "ግዜ ኮሎምብያ",
               "",
            };
        final String[] Falkland = new String[] {
               "ናይ መደበኛ ግዘ ደሴታት ፎክላንድ",
               "",
               "ግዜ ከረምቲ ደሴታት ፎክላንድ",
               "",
               "ግዜ ደሴታት ፎክላንድ",
               "",
            };
        final String[] Malaysia = new String[] {
               "ናይ ማሌዢያ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Maldives = new String[] {
               "ናይ ሞልዲቭስ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mongolia = new String[] {
               "ናይ መደበኛ ኡላንባታር ግዘ",
               "",
               "ናይ ክረምቲ ኡላንባታር ግዘ",
               "",
               "ናይ ኡላንባታር ግዘ",
               "",
            };
        final String[] Pakistan = new String[] {
               "ናይ መደበኛ ፓኪስታን ግዘ",
               "PKT",
               "ናይ ክረምቲ ፓኪስታን ግዘ",
               "PKST",
               "ናይ ፓኪስታን ግዘ",
               "PKT",
            };
        final String[] Paraguay = new String[] {
               "ናይ መደበኛ ግዘ ፓራጓይ",
               "",
               "ግዜ ክረምቲ ፓራጓይ",
               "",
               "ግዜ ፓራጓይ",
               "",
            };
        final String[] Pitcairn = new String[] {
               "ናይ ፒትቻይርን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Suriname = new String[] {
               "ግዜ ሱሪናም",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Argentina = new String[] {
               "ናይ መደበኛ ግዘ ኣርጀንቲና",
               "",
               "ግዜ ክረምቲ ኣርጀንቲና",
               "",
               "ግዜ ኣርጀንቲና",
               "",
            };
        final String[] Christmas = new String[] {
               "ናይ ልደት ደሴት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Galapagos = new String[] {
               "ግዜ ጋላፓጎስ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hong_Kong = new String[] {
               "ናይ መደበኛ ሆንግ ኮንግ ግዘ",
               "HKT",
               "ናይ ክረምቲ ሆንግ ኮንግ ግዘ",
               "HKST",
               "ናይ ሆንግ ኮንግ ግዘ",
               "HKT",
            };
        final String[] Indochina = new String[] {
               "ናይ ኢንዶቻይና ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kyrgystan = new String[] {
               "ናይ ክርጅስታን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Lord_Howe = new String[] {
               "ናይ መድበኛ ሎርድ ሆው ግዘ",
               "",
               "ናይ መዓልቲ ሎርድ ሆው ግዘ",
               "",
               "ናይ ሎርድ ሆው ግዘ",
               "",
            };
        final String[] Marquesas = new String[] {
               "ናይ ማርኩዌሳስ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Mauritius = new String[] {
               "ናይ መደበኛ ግዘ ማውሪሸስ",
               "",
               "ግዜ ክረምቲ ማውሪሸስ",
               "",
               "ግዜ ማውሪሸስ",
               "",
            };
        final String[] Singapore = new String[] {
               "ናይ መደበኛ ሲጋፖር ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Venezuela = new String[] {
               "ግዜ ቬኔዝዌላ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Azerbaijan = new String[] {
               "ናይ መደበኛ አዘርባዣን ግዘ",
               "",
               "ናይ ክረምቲ አዘርባዣን ግዘ",
               "",
               "ናይ አዘርባዣን ግዘ",
               "",
            };
        final String[] Bangladesh = new String[] {
               "ናይ መደበኛ ባንግላዲሽ ግዘ",
               "",
               "ናይ ክረምቲ ባንግላዲሽ ግዘ",
               "",
               "ናይ ባንግላዲሽ ግዘ",
               "",
            };
        final String[] Cape_Verde = new String[] {
               "ናይ መደበኛ ግዘ ኬፕ ቨርደ",
               "",
               "ግዜ ክረምቲ ኬፕ ቨርደ",
               "",
               "ግዜ ኬፕ ቨርደ",
               "",
            };
        final String[] East_Timor = new String[] {
               "ናይ ምብራቅ ቲሞር ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Kazakhstan = new String[] {
               "ናይ ካዛኪስታን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Seychelles = new String[] {
               "ግዜ ሲሸልስ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Tajikistan = new String[] {
               "ናይ ታጃክስታን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Uzbekistan = new String[] {
               "ናይ መደበኛ ኡዝቤኪስታን ግዘ",
               "",
               "ናይ ክረምቲ ኡዝቤኪስታን ግዘ",
               "",
               "ናይ ኡዝቤኪስታን ግዘ",
               "",
            };
        final String[] Afghanistan = new String[] {
               "ናይ አፍጋኒስታን ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Krasnoyarsk = new String[] {
               "ናይ መደበኛ ክራንስኖያርክ ግዘ",
               "",
               "ናይ ክረምቲ ክራንስኖያርክ ግዘ",
               "",
               "ናይ ክራንስኖያርክ ግዘ",
               "",
            };
        final String[] New_Zealand = new String[] {
               "ናይ መደበኛ ኒው ዚላንድ ግዘ",
               "NZST",
               "ናይ መዓልቲ ኒው ዚላንድ ግዘ",
               "NZDT",
               "ናይ ኒው ዚላንድ ግዘ",
               "NZT",
            };
        final String[] Philippines = new String[] {
               "ናይ መደበኛ ፊሊፒን ግዘ",
               "PST",
               "ናይ ክረምቲ ፊሊፒን ግዘ",
               "PDT",
               "ናይ ፊሊፒን ግዘ",
               "PT",
            };
        final String[] Vladivostok = new String[] {
               "ናይ መደበኛ ቭላዲቮስቶክ ግዘ",
               "",
               "ናይ ክረምቲ ቭላዲቮስቶክ ግዘ",
               "",
               "ናይ ቭላዲቮስቶክ ግዘ",
               "",
            };
        final String[] Indian_Ocean = new String[] {
               "ግዜ ህንዳዊ ውቅያኖስ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Line_Islands = new String[] {
               "ናይ ላይን ደሴታት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Newfoundland = new String[] {
               "ናይ መደበኛ ኒውፋውንድላንድ ግዘ",
               "NST",
               "ናይ መዓልቲ ኒውፋውንድላንድ ግዘ",
               "NDT",
               "ናይ ኒውፋውንድላንድ ግዘ",
               "NT",
            };
        final String[] Turkmenistan = new String[] {
               "ናይ መደበኛ ቱርክሜኒስታን ግዘ",
               "",
               "ናይ ክረምቲ ቱርክሜኒስታን ግዘ",
               "",
               "ናይ ቱርክሜኒስታን ግዘ",
               "",
            };
        final String[] French_Guiana = new String[] {
               "ግዜ ፈረንሳዊት ጊያና",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] New_Caledonia = new String[] {
               "ናይ መደበኛ ኒው ካሌዶኒያ ግዘ",
               "",
               "ናይ ክረምቲ ኒው ካሌዶኒያ ግዘ",
               "",
               "ናይ ኒው ካሌዶኒያ ግዘ",
               "",
            };
        final String[] South_Georgia = new String[] {
               "ግዜ ደቡብ ጆርጅያ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Yekaterinburg = new String[] {
               "ናይ መደበኛ ያክተርኒበርግ ግዘ",
               "",
               "ናይ ክረምቲ ያክተርኒበርግ ግዘ",
               "",
               "ናይ ያክተርኒበርግ ግዘ",
               "",
            };
        final String[] Africa_Central = new String[] {
               "ግዜ ማእከላይ ኣፍሪቃ",
               "CAT",
               "",
               "CAT",
               "",
               "CAT",
            };
        final String[] Africa_Eastern = new String[] {
               "ግዜ ምብራቕ ኣፍሪቃ",
               "EAT",
               "",
               "EAT",
               "",
               "EAT",
            };
        final String[] Africa_Western = new String[] {
               "ግዜ ምዕራብ ኣፍሪቃ",
               "WAT",
               "",
               "WAT",
               "",
               "WAT",
            };
        final String[] DumontDUrville = new String[] {
               "ናይ ዱሞ-ዱርቪል ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Europe_Central = new String[] {
               "ናይ መደበኛ ግዘ ማእከላይ ኤውሮጳ",
               "CET",
               "ግዜ ክረምቲ ኤውሮጳ",
               "CEST",
               "ናይ ማእከላይ ኤውሮጳ ግዘ",
               "CET",
            };
        final String[] Europe_Eastern = new String[] {
               "ናይ መደበኛ ግዘ ምብራቕ ኤውሮጳ",
               "EET",
               "ግዜ ክረምቲ ምብራቕ ኤውሮጳ",
               "EEST",
               "ናይ ምብራቕ ኤውሮጳ ግዘ",
               "EET",
            };
        final String[] Europe_Western = new String[] {
               "ናይ መደበኛ ምዕራባዊ ኤውሮጳዊ ግዘ",
               "WET",
               "ናይ ክረምቲ ምዕራባዊ ኤውሮጳዊ ግዘ",
               "WEST",
               "ናይ ምዕራባዊ ኤውሮጳዊ ግዘ",
               "WET",
            };
        final String[] Mexico_Pacific = new String[] {
               "ናይ መደበኛ ሜክሲኮ ፓስፊክ ግዘ",
               "MST",
               "ናይ መዓልቲ ሜክሲኮ ፓስፊክ ግዘ",
               "MDT",
               "ናይ ሜክሲኮ ፓስፊክ ግዘ",
               "MT",
            };
        final String[] Africa_Southern = new String[] {
               "ግዜ ደቡብ ኣፍሪቃ",
               "SAST",
               "",
               "SAST",
               "",
               "SAST",
            };
        final String[] America_Central = new String[] {
               "ናይ መደበኛ ግዘ ማእከላይ አመሪካ",
               "CST",
               "ናይ መዓልቲ ግዘ ማእከላይ አመሪካ",
               "CDT",
               "ማእከላይ አመሪካ ግዘ",
               "CT",
            };
        final String[] America_Eastern = new String[] {
               "ናይ መደበኛ ግዘ ምብራቓዊ ኣመሪካ",
               "EST",
               "ናይ መዓልቲ ግዘ ምብራቓዊ አመሪካ",
               "EST",
               "ናይ ምብራቓዊ ግዘ",
               "EST",
            };
        final String[] America_Pacific = new String[] {
               "ናይ መደበኛ ግዘ ፓስፊክ",
               "PST",
               "ናይ መዓልቲ ግዘ ፓስፊክ",
               "PDT",
               "ናይ ፓስፊክ ግዘ",
               "PT",
            };
        final String[] French_Southern = new String[] {
               "ናይ ደቡባዊን ኣንታርቲክ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Gilbert_Islands = new String[] {
               "ናይ ጊልበርት ደሴታት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Hawaii_Aleutian = new String[] {
               "ናይ መደበኛ ሃዋይ-ኣሌውቲያን ግዘ",
               "HST",
               "ናይ መዓልቲ ሃዋይ-ኣሌውቲያን ግዘ",
               "HDT",
               "ናይ ሃዋይ-ኣሌውቲያን ግዘ",
               "HT",
            };
        final String[] Phoenix_Islands = new String[] {
               "ናይ ፊኒክስ ደሴታት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Pierre_Miquelon = new String[] {
               "ናይ መደበኛ ቅዱስ ፒየርን ሚከሎን ግዘ",
               "",
               "ናይ መዓልቲ ቅዱስ ፒየርን ሚከሎን ግዘ",
               "",
               "ናይ ቅዱስ ፒየርን ሚከሎን ግዘ",
               "",
            };
        final String[] America_Mountain = new String[] {
               "ናይ መደበኛ ግዘ ጎቦ ኣመሪካ",
               "MST",
               "ናይ መዓልቲ ግዘ ጎቦ አመሪካ",
               "MST",
               "ናይ ጎቦ ግዘ",
               "MST",
            };
        final String[] Marshall_Islands = new String[] {
               "ናይ ማርሻል ደሴታት ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Papua_New_Guinea = new String[] {
               "ናይ ፓፗ ኒው ጊኒ ግዘ",
               "",
               "",
               "",
               "",
               "",
            };
        final String[] Australia_Central = new String[] {
               "ናይ ማዕከላይ መደበኛ አውስራሊያ ግዘ",
               "ACST",
               "ናይ ማዕከላይ መዓልቲ አውስራሊያ ግዘ",
               "ACDT",
               "ናይ አውስራሊያ ግዘ",
               "ACT",
            };
        final String[] Australia_Eastern = new String[] {
               "ናይ ምብራቓዊ መደበኛ ኣውስትራልያ ግዘ",
               "AEST",
               "ናይ ምብራቓዊ መዓልቲ ኣውስትራልያ ግዘ",
               "AEDT",
               "ናይ ምብራቓዊ ኣውስትራልያ ግዘ",
               "AET",
            };
        final String[] Australia_Western = new String[] {
               "ናይ ምዕራባዊ መደበኛ አውስትራሊያ ግዘ",
               "AWST",
               "ናይ ምዕራባዊ መዓልቲ አውስትራሊያ ግዘ",
               "AWDT",
               "ናይ ምዕራባዊ አውስትራሊያ ግዘ",
               "AWT",
            };
        final String[] Indonesia_Central = new String[] {
               "ናይ ማእከላይ ኢንዶነዥያ ግዘ",
               "WITA",
               "",
               "WITA",
               "",
               "WITA",
            };
        final String[] Indonesia_Eastern = new String[] {
               "ናይ ምብራቓዊ ኢንዶነዥያ ግዘ",
               "WIT",
               "",
               "WIT",
               "",
               "WIT",
            };
        final String[] Indonesia_Western = new String[] {
               "ናይ ምዕራባዊ ኢንዶነዥያ ግዘ",
               "WIB",
               "",
               "WIB",
               "",
               "WIB",
            };
        final String[] Australia_CentralWestern = new String[] {
               "ናይ ምዕራባዊ መደበኛ አውስራሊያ ግዘ",
               "",
               "ናይ ምዕራባዊ መዓልቲ አውስራሊያ ግዘ",
               "",
               "ናይ ምዕራባዊ አውስራሊያ ግዘ",
               "",
            };
        final Object[][] data = new Object[][] {
            { "America/Los_Angeles", America_Pacific },
            { "America/Denver", America_Mountain },
            { "America/Phoenix", America_Mountain },
            { "America/Chicago", America_Central },
            { "America/New_York", America_Eastern },
            { "America/Indianapolis", America_Eastern },
            { "Pacific/Honolulu", Hawaii },
            { "America/Anchorage", Alaska },
            { "America/Halifax", Atlantic },
            { "America/Sitka", Alaska },
            { "America/St_Johns", Newfoundland },
            { "Europe/Paris", Europe_Central },
            { "GMT", GMT },
            { "Asia/Jerusalem", Israel },
            { "Asia/Tokyo", Japan },
            { "Europe/Bucharest", Europe_Eastern },
            { "Asia/Shanghai", China },
            { "UTC", ETC_UTC },
            { "GB",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "NZ", New_Zealand },
            { "ACT", Australia_Central },
            { "AET", Australia_Eastern },
            { "AGT", Argentina },
            { "ART", Europe_Eastern },
            { "AST", Alaska },
            { "BET", Brasilia },
            { "BST", Bangladesh },
            { "CAT", Africa_Central },
            { "CET", Europe_Central },
            { "CNT", Newfoundland },
            { "CST", America_Central },
            { "CTT", China },
            { "EAT", Africa_Eastern },
            { "ECT", Europe_Central },
            { "EET", Europe_Eastern },
            { "EST", America_Eastern },
            { "HST", Hawaii },
            { "IET", America_Eastern },
            { "IST", India },
            { "JST", Japan },
            { "MET", Europe_Central },
            { "MIT", Apia },
            { "MST", America_Mountain },
            { "NET", Armenia },
            { "NST", New_Zealand },
            { "PLT", Pakistan },
            { "PNT", America_Mountain },
            { "PRC", China },
            { "PRT", Atlantic },
            { "PST", America_Pacific },
            { "ROK", Korea },
            { "SST", Solomon },
            { "UCT",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "VST", Indochina },
            { "WET", Europe_Western },
            { "Cuba", Cuba },
            { "Eire",
                new String[] {
                    "GMT",
                    "GMT",
                    "ናይ መደበኛ አይሪሽ ግዘ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "GMT0", GMT },
            { "Iran", Iran },
            { "W-SU", Moscow },
            { "Zulu",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Egypt", Europe_Eastern },
            { "Japan", Japan },
            { "Libya", Europe_Eastern },
            { "Israel", Israel },
            { "Navajo", America_Mountain },
            { "Poland", Europe_Central },
            { "CST6CDT", America_Central },
            { "EST5EDT", America_Eastern },
            { "Etc/GMT", GMT },
            { "Etc/UCT",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Etc/UTC", ETC_UTC },
            { "GB-Eire",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Iceland", GMT },
            { "Jamaica", America_Eastern },
            { "MST7MDT", America_Mountain },
            { "NZ-CHAT", Chatham },
            { "PST8PDT", America_Pacific },
            { "Etc/GMT0", GMT },
            { "Etc/Zulu",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Hongkong", Hong_Kong },
            { "Portugal", Europe_Western },
            { "US/Samoa", Samoa },
            { "Asia/Aden", Arabian },
            { "Asia/Baku", Azerbaijan },
            { "Asia/Dili", East_Timor },
            { "Asia/Gaza", Europe_Eastern },
            { "Asia/Hovd", Hovd },
            { "Asia/Omsk", Omsk },
            { "Asia/Oral", Kazakhstan },
            { "Etc/GMT+0", GMT },
            { "Etc/GMT-0", GMT },
            { "Greenwich", GMT },
            { "Kwajalein", Marshall_Islands },
            { "Singapore", Singapore },
            { "US/Alaska", Alaska },
            { "US/Hawaii", Hawaii },
            { "Universal",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Asia/Aqtau", Kazakhstan },
            { "Asia/Chita", Yakutsk },
            { "Asia/Dacca", Bangladesh },
            { "Asia/Dhaka", Bangladesh },
            { "Asia/Dubai", Gulf },
            { "Asia/Kabul", Afghanistan },
            { "Asia/Macao", China },
            { "Asia/Macau", China },
            { "Asia/Qatar", Arabian },
            { "Asia/Seoul", Korea },
            { "Asia/Tomsk", Krasnoyarsk },
            { "US/Arizona", America_Mountain },
            { "US/Central", America_Central },
            { "US/Eastern", America_Eastern },
            { "US/Pacific", America_Pacific },
            { "Africa/Juba", Africa_Central },
            { "Africa/Lome", GMT },
            { "Asia/Almaty", Kazakhstan },
            { "Asia/Aqtobe", Kazakhstan },
            { "Asia/Atyrau", Kazakhstan },
            { "Asia/Beirut", Europe_Eastern },
            { "Asia/Brunei", Brunei },
            { "Asia/Harbin", China },
            { "Asia/Hebron", Europe_Eastern },
            { "Asia/Kuwait", Arabian },
            { "Asia/Manila", Philippines },
            { "Asia/Muscat", Gulf },
            { "Asia/Riyadh", Arabian },
            { "Asia/Saigon", Indochina },
            { "Asia/Taipei", Taipei },
            { "Asia/Tehran", Iran },
            { "Asia/Thimbu", Bhutan },
            { "Asia/Yangon", Cocos },
            { "Brazil/Acre", Acre },
            { "Brazil/East", Brasilia },
            { "Brazil/West", Amazon },
            { "Europe/Kiev", Europe_Eastern },
            { "Europe/Kyiv", Europe_Eastern },
            { "Europe/Oslo", Europe_Central },
            { "Europe/Riga", Europe_Eastern },
            { "Europe/Rome", Europe_Central },
            { "Indian/Mahe", Seychelles },
            { "Pacific/Yap", Papua_New_Guinea },
            { "US/Aleutian", Hawaii_Aleutian },
            { "US/Michigan", America_Eastern },
            { "US/Mountain", America_Mountain },
            { "Africa/Accra", GMT },
            { "Africa/Cairo", Europe_Eastern },
            { "Africa/Ceuta", Europe_Central },
            { "Africa/Dakar", GMT },
            { "Africa/Lagos", Africa_Western },
            { "Africa/Tunis", Europe_Central },
            { "America/Adak", Hawaii_Aleutian },
            { "America/Atka", Hawaii_Aleutian },
            { "America/Lima", Peru },
            { "America/Nome", Alaska },
            { "Asia/Baghdad", Arabian },
            { "Asia/Bahrain", Arabian },
            { "Asia/Bangkok", Indochina },
            { "Asia/Barnaul", Krasnoyarsk },
            { "Asia/Bishkek", Kyrgystan },
            { "Asia/Colombo", India },
            { "Asia/Irkutsk", Irkutsk },
            { "Asia/Jakarta", Indonesia_Western },
            { "Asia/Karachi", Pakistan },
            { "Asia/Kolkata", India },
            { "Asia/Kuching", Brunei },
            { "Asia/Magadan", Magadan },
            { "Asia/Nicosia", Europe_Eastern },
            { "Asia/Rangoon", Myanmar },
            { "Asia/Tbilisi", Georgia },
            { "Asia/Thimphu", Bhutan },
            { "Asia/Yakutsk", Yakutsk },
            { "Asia/Yerevan", Armenia },
            { "Canada/Yukon", Yukon },
            { "Europe/Kirov", Moscow },
            { "Europe/Malta", Europe_Central },
            { "Europe/Minsk", Moscow },
            { "Europe/Sofia", Europe_Eastern },
            { "Europe/Vaduz", Europe_Central },
            { "Indian/Cocos", Cocos },
            { "Pacific/Apia", Apia },
            { "Pacific/Fiji", Fiji },
            { "Pacific/Guam", Chamorro },
            { "Pacific/Niue", Niue },
            { "Pacific/Truk", Truk },
            { "Pacific/Wake", Wake },
            { "SystemV/AST4", Atlantic },
            { "SystemV/CST6", America_Central },
            { "SystemV/EST5", America_Eastern },
            { "SystemV/MST7", America_Mountain },
            { "SystemV/PST8", Pitcairn },
            { "SystemV/YST9", Gambier },
            { "Africa/Asmara", Africa_Eastern },
            { "Africa/Asmera", Africa_Eastern },
            { "Africa/Bamako", GMT },
            { "Africa/Bangui", Africa_Western },
            { "Africa/Banjul", GMT },
            { "Africa/Bissau", GMT },
            { "Africa/Douala", Africa_Western },
            { "Africa/Harare", Africa_Central },
            { "Africa/Kigali", Africa_Central },
            { "Africa/Luanda", Africa_Western },
            { "Africa/Lusaka", Africa_Central },
            { "Africa/Malabo", Africa_Western },
            { "Africa/Maputo", Africa_Central },
            { "Africa/Maseru", Africa_Southern },
            { "Africa/Niamey", Africa_Western },
            { "America/Aruba", Atlantic },
            { "America/Bahia", Brasilia },
            { "America/Belem", Brasilia },
            { "America/Boise", America_Mountain },
            { "America/Jujuy", Argentina },
            { "America/Thule", Atlantic },
            { "Asia/Ashgabat", Turkmenistan },
            { "Asia/Calcutta", India },
            { "Asia/Dushanbe", Tajikistan },
            { "Asia/Jayapura", Indonesia_Eastern },
            { "Asia/Katmandu", Nepal },
            { "Asia/Khandyga", Yakutsk },
            { "Asia/Makassar", Indonesia_Central },
            { "Asia/Qostanay", Kazakhstan },
            { "Asia/Sakhalin", Magadan },
            { "Asia/Tashkent", Uzbekistan },
            { "Asia/Tel_Aviv", Israel },
            { "Asia/Ust-Nera", Vladivostok },
            { "Australia/ACT", Australia_Eastern },
            { "Australia/LHI", Lord_Howe },
            { "Australia/NSW", Australia_Eastern },
            { "Etc/Greenwich", GMT },
            { "Etc/Universal",
                new String[] {
                    "ዝተሳነየ ኣድማሳዊ ግዜ",
                    "UTC",
                    "",
                    "UTC",
                    "",
                    "UTC",
                }
            },
            { "Europe/Athens", Europe_Eastern },
            { "Europe/Berlin", Europe_Central },
            { "Europe/Dublin",
                new String[] {
                    "GMT",
                    "GMT",
                    "ናይ መደበኛ አይሪሽ ግዘ",
                    "IST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Jersey",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Lisbon", Europe_Western },
            { "Europe/London",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Madrid", Europe_Central },
            { "Europe/Monaco", Europe_Central },
            { "Europe/Moscow", Moscow },
            { "Europe/Prague", Europe_Central },
            { "Europe/Skopje", Europe_Central },
            { "Europe/Tirane", Europe_Central },
            { "Europe/Vienna", Europe_Central },
            { "Europe/Warsaw", Europe_Central },
            { "Europe/Zagreb", Europe_Central },
            { "Europe/Zurich", Europe_Central },
            { "Indian/Chagos", Indian_Ocean },
            { "Indian/Comoro", Africa_Eastern },
            { "Pacific/Chuuk", Papua_New_Guinea },
            { "Pacific/Efate", Vanuatu },
            { "Pacific/Nauru", Nauru },
            { "Pacific/Palau", Palau },
            { "Pacific/Samoa", Samoa },
            { "SystemV/HST10", Hawaii },
            { "Africa/Abidjan", GMT },
            { "Africa/Algiers", Europe_Central },
            { "Africa/Conakry", GMT },
            { "Africa/Kampala", Africa_Eastern },
            { "Africa/Mbabane", Africa_Southern },
            { "Africa/Nairobi", Africa_Eastern },
            { "Africa/Tripoli", Europe_Eastern },
            { "America/Belize", America_Central },
            { "America/Bogota", Colombia },
            { "America/Cancun", America_Eastern },
            { "America/Cayman", America_Eastern },
            { "America/Cuiaba", Amazon },
            { "America/Dawson", Yukon },
            { "America/Guyana", Guyana },
            { "America/Havana", Cuba },
            { "America/Inuvik", America_Mountain },
            { "America/Juneau", Alaska },
            { "America/La_Paz", Bolivia },
            { "America/Maceio", Brasilia },
            { "America/Manaus", Amazon },
            { "America/Merida", America_Central },
            { "America/Nassau", America_Eastern },
            { "America/Panama", America_Eastern },
            { "America/Recife", Brasilia },
            { "America/Regina", America_Central },
            { "America/Virgin", Atlantic },
            { "Asia/Ashkhabad", Turkmenistan },
            { "Asia/Chongqing", China },
            { "Asia/Chungking", China },
            { "Asia/Famagusta", Europe_Eastern },
            { "Asia/Hong_Kong", Hong_Kong },
            { "Asia/Kathmandu", Nepal },
            { "Asia/Pontianak", Indonesia_Western },
            { "Asia/Pyongyang", Korea },
            { "Asia/Qyzylorda", Kazakhstan },
            { "Asia/Samarkand", Uzbekistan },
            { "Asia/Singapore", Singapore },
            { "Asia/Vientiane", Indochina },
            { "Atlantic/Faroe", Europe_Western },
            { "Australia/West", Australia_Western },
            { "Canada/Central", America_Central },
            { "Canada/Eastern", America_Eastern },
            { "Canada/Pacific", America_Pacific },
            { "Europe/Andorra", Europe_Central },
            { "Europe/Belfast",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Nicosia", Europe_Eastern },
            { "Europe/Tallinn", Europe_Eastern },
            { "Europe/Vatican", Europe_Central },
            { "Europe/Vilnius", Europe_Eastern },
            { "Indian/Mayotte", Africa_Eastern },
            { "Indian/Reunion", Reunion },
            { "Mexico/BajaSur", Mexico_Pacific },
            { "Mexico/General", America_Central },
            { "Pacific/Easter", Easter },
            { "Pacific/Kanton", Phoenix_Islands },
            { "Pacific/Kosrae", Kosrae },
            { "Pacific/Majuro", Marshall_Islands },
            { "Pacific/Midway", Samoa },
            { "Pacific/Noumea", New_Caledonia },
            { "Pacific/Ponape", Solomon },
            { "Pacific/Saipan", Chamorro },
            { "Pacific/Tahiti", Tahiti },
            { "Pacific/Tarawa", Marshall_Islands },
            { "Pacific/Wallis", Gilbert_Islands },
            { "Africa/Blantyre", Africa_Central },
            { "Africa/Djibouti", Africa_Eastern },
            { "Africa/Freetown", GMT },
            { "Africa/Gaborone", Africa_Central },
            { "Africa/Khartoum", Africa_Central },
            { "Africa/Kinshasa", Africa_Western },
            { "Africa/Monrovia", GMT },
            { "Africa/Ndjamena", Africa_Western },
            { "Africa/Sao_Tome", GMT },
            { "Africa/Timbuktu", GMT },
            { "Africa/Windhoek", Africa_Central },
            { "America/Antigua", Atlantic },
            { "America/Caracas", Venezuela },
            { "America/Cayenne", French_Guiana },
            { "America/Cordoba", Argentina },
            { "America/Creston", America_Mountain },
            { "America/Curacao", Atlantic },
            { "America/Detroit", America_Eastern },
            { "America/Grenada", Atlantic },
            { "America/Iqaluit", America_Eastern },
            { "America/Jamaica", America_Eastern },
            { "America/Knox_IN", America_Central },
            { "America/Managua", America_Central },
            { "America/Marigot", Atlantic },
            { "America/Mendoza", Argentina },
            { "America/Moncton", Atlantic },
            { "America/Nipigon", America_Eastern },
            { "America/Noronha", Noronha },
            { "America/Ojinaga", America_Central },
            { "America/Tijuana", America_Pacific },
            { "America/Toronto", America_Eastern },
            { "America/Tortola", Atlantic },
            { "America/Yakutat", Alaska },
            { "Asia/Choibalsan", Mongolia },
            { "Asia/Phnom_Penh", Indochina },
            { "Asia/Ulan_Bator", Mongolia },
            { "Atlantic/Azores", Azores },
            { "Atlantic/Canary", Europe_Western },
            { "Atlantic/Faeroe", Europe_Western },
            { "Australia/Eucla", Australia_CentralWestern },
            { "Australia/North", Australia_Central },
            { "Australia/Perth", Australia_Western },
            { "Australia/South", Australia_Central },
            { "Canada/Atlantic", Atlantic },
            { "Canada/Mountain", America_Mountain },
            { "Europe/Belgrade", Europe_Central },
            { "Europe/Brussels", Europe_Central },
            { "Europe/Budapest", Europe_Central },
            { "Europe/Busingen", Europe_Central },
            { "Europe/Chisinau", Europe_Eastern },
            { "Europe/Guernsey",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Helsinki", Europe_Eastern },
            { "Europe/Sarajevo", Europe_Central },
            { "Europe/Tiraspol", Europe_Eastern },
            { "Europe/Uzhgorod", Europe_Eastern },
            { "Indian/Maldives", French_Southern },
            { "Pacific/Chatham", Chatham },
            { "Pacific/Fakaofo", Tokelau },
            { "Pacific/Gambier", Gambier },
            { "Pacific/Norfolk", Norfolk },
            { "Pacific/Pohnpei", Solomon },
            { "SystemV/AST4ADT", Atlantic },
            { "SystemV/CST6CDT", America_Central },
            { "SystemV/EST5EDT", America_Eastern },
            { "SystemV/MST7MDT", America_Mountain },
            { "SystemV/PST8PDT", America_Pacific },
            { "SystemV/YST9YDT", Alaska },
            { "Africa/Bujumbura", Africa_Central },
            { "Africa/Mogadishu", Africa_Eastern },
            { "America/Anguilla", Atlantic },
            { "America/Asuncion", Paraguay },
            { "America/Atikokan", America_Eastern },
            { "America/Barbados", Atlantic },
            { "America/Dominica", Atlantic },
            { "America/Edmonton", America_Mountain },
            { "America/Eirunepe", Acre },
            { "America/Ensenada", America_Pacific },
            { "America/Mazatlan", Mexico_Pacific },
            { "America/Miquelon", Pierre_Miquelon },
            { "America/Montreal", America_Eastern },
            { "America/Resolute", America_Central },
            { "America/Santarem", Brasilia },
            { "America/Santiago", Chile },
            { "America/Shiprock", America_Mountain },
            { "America/St_Kitts", Atlantic },
            { "America/St_Lucia", Atlantic },
            { "America/Winnipeg", America_Central },
            { "Antarctica/Casey", Australia_Western },
            { "Antarctica/Davis", Davis },
            { "Antarctica/Syowa", Syowa },
            { "Antarctica/Troll", GMT },
            { "Asia/Ho_Chi_Minh", Indochina },
            { "Asia/Krasnoyarsk", Krasnoyarsk },
            { "Asia/Novosibirsk", Krasnoyarsk },
            { "Asia/Ulaanbaatar", Mongolia },
            { "Asia/Vladivostok", Vladivostok },
            { "Atlantic/Bermuda", Atlantic },
            { "Atlantic/Madeira", Europe_Western },
            { "Atlantic/Stanley", Falkland },
            { "Australia/Currie", Australia_Eastern },
            { "Australia/Darwin", Australia_Central },
            { "Australia/Hobart", Australia_Eastern },
            { "Australia/Sydney", Australia_Eastern },
            { "Brazil/DeNoronha", Noronha },
            { "Europe/Amsterdam", Europe_Central },
            { "Europe/Gibraltar", Europe_Central },
            { "Europe/Ljubljana", Europe_Central },
            { "Europe/Mariehamn", Europe_Eastern },
            { "Europe/Podgorica", Europe_Central },
            { "Europe/Stockholm", Europe_Central },
            { "Europe/Volgograd", Moscow },
            { "Indian/Christmas", Christmas },
            { "Indian/Kerguelen", French_Southern },
            { "Indian/Mauritius", Mauritius },
            { "Mexico/BajaNorte", America_Pacific },
            { "Pacific/Auckland", New_Zealand },
            { "Pacific/Funafuti", Tuvalu },
            { "Pacific/Johnston", Hawaii },
            { "Pacific/Pitcairn", Pitcairn },
            { "Africa/Libreville", Africa_Western },
            { "Africa/Lubumbashi", Africa_Central },
            { "Africa/Nouakchott", GMT },
            { "Africa/Porto-Novo", Africa_Western },
            { "America/Araguaina", Brasilia },
            { "America/Boa_Vista", Amazon },
            { "America/Catamarca", Argentina },
            { "America/Chihuahua", America_Central },
            { "America/Fortaleza", Brasilia },
            { "America/Glace_Bay", Atlantic },
            { "America/Goose_Bay", Atlantic },
            { "America/Guatemala", America_Central },
            { "America/Guayaquil", Ecuador },
            { "America/Matamoros", America_Central },
            { "America/Menominee", America_Central },
            { "America/Monterrey", America_Central },
            { "America/Sao_Paulo", Brasilia },
            { "America/St_Thomas", Atlantic },
            { "America/Vancouver", America_Pacific },
            { "Antarctica/Mawson", Mawson },
            { "Antarctica/Vostok", Vostok },
            { "Asia/Kuala_Lumpur", Malaysia },
            { "Asia/Novokuznetsk", Krasnoyarsk },
            { "Chile/Continental", Chile },
            { "Europe/Bratislava", Europe_Central },
            { "Europe/Copenhagen", Europe_Central },
            { "Europe/Luxembourg", Europe_Central },
            { "Europe/San_Marino", Europe_Central },
            { "Europe/Simferopol", Moscow },
            { "Europe/Zaporozhye", Europe_Eastern },
            { "Pacific/Enderbury", Phoenix_Islands },
            { "Pacific/Galapagos", Galapagos },
            { "Pacific/Kwajalein", Marshall_Islands },
            { "Pacific/Marquesas", Marquesas },
            { "Pacific/Pago_Pago", Samoa },
            { "Pacific/Rarotonga", Cook },
            { "Pacific/Tongatapu", Tonga },
            { "US/Indiana-Starke", America_Central },
            { "Africa/Addis_Ababa", Africa_Eastern },
            { "Africa/Brazzaville", Africa_Western },
            { "Africa/Ouagadougou", GMT },
            { "America/Costa_Rica", America_Central },
            { "America/Grand_Turk", America_Eastern },
            { "America/Guadeloupe", Atlantic },
            { "America/Hermosillo", Mexico_Pacific },
            { "America/Kralendijk", Atlantic },
            { "America/Louisville", America_Eastern },
            { "America/Martinique", Atlantic },
            { "America/Metlakatla", Alaska },
            { "America/Montevideo", Uruguay },
            { "America/Montserrat", Atlantic },
            { "America/Paramaribo", Suriname },
            { "America/Porto_Acre", Acre },
            { "America/Rio_Branco", Acre },
            { "America/St_Vincent", Atlantic },
            { "America/Whitehorse", Yukon },
            { "Antarctica/McMurdo", New_Zealand },
            { "Antarctica/Rothera", Rothera },
            { "Asia/Srednekolymsk", Magadan },
            { "Asia/Ujung_Pandang", Indonesia_Central },
            { "Asia/Yekaterinburg", Yekaterinburg },
            { "Atlantic/Jan_Mayen", Europe_Central },
            { "Atlantic/Reykjavik", GMT },
            { "Atlantic/St_Helena", GMT },
            { "Australia/Adelaide", Australia_Central },
            { "Australia/Brisbane", Australia_Eastern },
            { "Australia/Canberra", Australia_Eastern },
            { "Australia/Lindeman", Australia_Eastern },
            { "Australia/Tasmania", Australia_Eastern },
            { "Australia/Victoria", Australia_Eastern },
            { "Chile/EasterIsland", Easter },
            { "Europe/Isle_of_Man",
                new String[] {
                    "GMT",
                    "GMT",
                    "ግዜ ክረምቲ ብሪጣንያ",
                    "BST",
                    "",
                    "GMT",
                }
            },
            { "Europe/Kaliningrad", Europe_Eastern },
            { "Pacific/Kiritimati", Line_Islands },
            { "Africa/Johannesburg", Africa_Southern },
            { "America/El_Salvador", America_Central },
            { "America/Fort_Nelson", America_Mountain },
            { "America/Mexico_City", America_Central },
            { "America/Pangnirtung", America_Eastern },
            { "America/Porto_Velho", Amazon },
            { "America/Puerto_Rico", Atlantic },
            { "America/Rainy_River", America_Central },
            { "America/Tegucigalpa", America_Central },
            { "America/Thunder_Bay", America_Eastern },
            { "America/Yellowknife", America_Mountain },
            { "Arctic/Longyearbyen", Europe_Central },
            { "Atlantic/Cape_Verde", Cape_Verde },
            { "Australia/Lord_Howe", Lord_Howe },
            { "Australia/Melbourne", Australia_Eastern },
            { "Canada/Newfoundland", Newfoundland },
            { "Canada/Saskatchewan", America_Central },
            { "Indian/Antananarivo", Africa_Eastern },
            { "Pacific/Guadalcanal", Solomon },
            { "Africa/Dar_es_Salaam", Africa_Eastern },
            { "America/Blanc-Sablon", Atlantic },
            { "America/Buenos_Aires", Argentina },
            { "America/Campo_Grande", Amazon },
            { "America/Danmarkshavn", GMT },
            { "America/Dawson_Creek", America_Mountain },
            { "America/Indiana/Knox", America_Central },
            { "America/Rankin_Inlet", America_Central },
            { "America/Santa_Isabel", America_Pacific },
            { "Antarctica/Macquarie", Australia_Eastern },
            { "Australia/Queensland", Australia_Eastern },
            { "Australia/Yancowinna", Australia_Central },
            { "Pacific/Port_Moresby", DumontDUrville },
            { "America/Cambridge_Bay", America_Mountain },
            { "America/Ciudad_Juarez", America_Mountain },
            { "America/Coral_Harbour", America_Eastern },
            { "America/Indiana/Vevay", America_Eastern },
            { "America/Lower_Princes", Atlantic },
            { "America/Port_of_Spain", Atlantic },
            { "America/Santo_Domingo", Atlantic },
            { "America/St_Barthelemy", Atlantic },
            { "America/Swift_Current", America_Central },
            { "Antarctica/South_Pole", New_Zealand },
            { "Australia/Broken_Hill", Australia_Central },
            { "America/Bahia_Banderas", America_Central },
            { "America/Port-au-Prince", America_Eastern },
            { "Atlantic/South_Georgia", South_Georgia },
            { "America/Argentina/Jujuy", Argentina },
            { "America/Argentina/Salta", Argentina },
            { "America/Indiana/Marengo", America_Eastern },
            { "America/Indiana/Winamac", America_Eastern },
            { "America/Argentina/Cordoba", Argentina },
            { "America/Argentina/Mendoza", Argentina },
            { "America/Argentina/Tucuman", Argentina },
            { "America/Argentina/Ushuaia", Argentina },
            { "America/Indiana/Tell_City", America_Central },
            { "America/Indiana/Vincennes", America_Eastern },
            { "Antarctica/DumontDUrville", DumontDUrville },
            { "timezone.excity.Asia/Aden", "ዓደን" },
            { "timezone.excity.Asia/Baku", "ባኩ" },
            { "timezone.excity.Asia/Dili", "ዲሊ" },
            { "timezone.excity.Asia/Gaza", "ቓዛ" },
            { "timezone.excity.Asia/Hovd", "ሆቭድ" },
            { "timezone.excity.Asia/Omsk", "ኦምስክ" },
            { "timezone.excity.Asia/Oral", "ኦራል" },
            { "America/Argentina/La_Rioja", Argentina },
            { "America/Argentina/San_Juan", Argentina },
            { "America/Argentina/San_Luis", Argentina },
            { "America/Indiana/Petersburg", America_Eastern },
            { "timezone.excity.Asia/Amman", "ዓማን" },
            { "timezone.excity.Asia/Aqtau", "ኣክታው" },
            { "timezone.excity.Asia/Chita", "ቺታ" },
            { "timezone.excity.Asia/Dhaka", "ዳካ" },
            { "timezone.excity.Asia/Dubai", "ዱባይ" },
            { "timezone.excity.Asia/Kabul", "ካቡል" },
            { "timezone.excity.Asia/Macau", "ማካው" },
            { "timezone.excity.Asia/Qatar", "ቐጠር" },
            { "timezone.excity.Asia/Seoul", "ሶውል" },
            { "timezone.excity.Asia/Tokyo", "ቶክዮ" },
            { "timezone.excity.Asia/Tomsk", "ቶምስክ" },
            { "America/Argentina/Catamarca", Argentina },
            { "America/Kentucky/Louisville", America_Eastern },
            { "America/Kentucky/Monticello", America_Eastern },
            { "America/North_Dakota/Beulah", America_Central },
            { "America/North_Dakota/Center", America_Central },
            { "timezone.excity.Africa/Juba", "ጁባ" },
            { "timezone.excity.Africa/Lome", "ሎመ" },
            { "timezone.excity.Asia/Almaty", "ኣልማቲ" },
            { "timezone.excity.Asia/Anadyr", "ኣናዲር" },
            { "timezone.excity.Asia/Aqtobe", "ኣክቶበ" },
            { "timezone.excity.Asia/Atyrau", "ኣቲራው" },
            { "timezone.excity.Asia/Beirut", "በይሩት" },
            { "timezone.excity.Asia/Brunei", "ብሩነይ" },
            { "timezone.excity.Asia/Hebron", "ኬብሮን" },
            { "timezone.excity.Asia/Kuwait", "ኩዌት" },
            { "timezone.excity.Asia/Manila", "ማኒላ" },
            { "timezone.excity.Asia/Muscat", "ሙስካት" },
            { "timezone.excity.Asia/Riyadh", "ርያድ" },
            { "timezone.excity.Asia/Saigon", "ከተማ ሆ ቺ ሚን" },
            { "timezone.excity.Asia/Taipei", "ታይፐይ" },
            { "timezone.excity.Asia/Tehran", "ተህራን" },
            { "timezone.excity.Asia/Urumqi", "ኡሩምኪ" },
            { "timezone.excity.Etc/Unknown", "ዘይተፈልጠ ከተማ" },
            { "timezone.excity.Europe/Kiev", "ክየቭ" },
            { "timezone.excity.Europe/Oslo", "ኦስሎ" },
            { "timezone.excity.Europe/Riga", "ሪጋ" },
            { "timezone.excity.Europe/Rome", "ሮማ" },
            { "timezone.excity.Indian/Mahe", "ማሄ" },
            { "America/Indiana/Indianapolis", America_Eastern },
            { "timezone.excity.Africa/Accra", "ኣክራ" },
            { "timezone.excity.Africa/Cairo", "ካይሮ" },
            { "timezone.excity.Africa/Ceuta", "ሴውታ" },
            { "timezone.excity.Africa/Dakar", "ዳካር" },
            { "timezone.excity.Africa/Lagos", "ሌጎስ" },
            { "timezone.excity.Africa/Tunis", "ቱኒስ" },
            { "timezone.excity.America/Adak", "ኣዳክ" },
            { "timezone.excity.America/Lima", "ሊማ" },
            { "timezone.excity.America/Nome", "ነውም" },
            { "timezone.excity.Asia/Baghdad", "ባቕዳድ" },
            { "timezone.excity.Asia/Bahrain", "ባሕሬን" },
            { "timezone.excity.Asia/Bangkok", "ባንግኮክ" },
            { "timezone.excity.Asia/Barnaul", "ባርናውል" },
            { "timezone.excity.Asia/Bishkek", "ቢሽኬክ" },
            { "timezone.excity.Asia/Colombo", "ኮሎምቦ" },
            { "timezone.excity.Asia/Irkutsk", "ኢርኩትስክ" },
            { "timezone.excity.Asia/Jakarta", "ጃካርታ" },
            { "timezone.excity.Asia/Karachi", "ካራቺ" },
            { "timezone.excity.Asia/Kuching", "ኩቺንግ" },
            { "timezone.excity.Asia/Magadan", "ማጋዳን" },
            { "timezone.excity.Asia/Nicosia", "ኒኮስያ" },
            { "timezone.excity.Asia/Rangoon", "ያንጎን" },
            { "timezone.excity.Asia/Tbilisi", "ትቢሊሲ" },
            { "timezone.excity.Asia/Thimphu", "ቲምፉ" },
            { "timezone.excity.Asia/Yakutsk", "ያኩትስክ" },
            { "timezone.excity.Asia/Yerevan", "የረቫን" },
            { "timezone.excity.Europe/Kirov", "ኪሮቭ" },
            { "timezone.excity.Europe/Malta", "ማልታ" },
            { "timezone.excity.Europe/Minsk", "ሚንስክ" },
            { "timezone.excity.Europe/Paris", "ፓሪስ" },
            { "timezone.excity.Europe/Sofia", "ሶፍያ" },
            { "timezone.excity.Europe/Vaduz", "ቫዱዝ" },
            { "timezone.excity.Indian/Cocos", "ኮኮስ" },
            { "timezone.excity.Pacific/Apia", "ኣፕያ" },
            { "timezone.excity.Pacific/Fiji", "ፊጂ" },
            { "timezone.excity.Pacific/Guam", "ጓም" },
            { "timezone.excity.Pacific/Niue", "ኒዩ" },
            { "timezone.excity.Pacific/Truk", "ቹክ" },
            { "timezone.excity.Pacific/Wake", "ዌክ" },
            { "timezone.excity.Africa/Asmera", "ኣስመራ" },
            { "timezone.excity.Africa/Bamako", "ባማኮ" },
            { "timezone.excity.Africa/Bangui", "ባንጊ" },
            { "timezone.excity.Africa/Banjul", "ባንጁል" },
            { "timezone.excity.Africa/Bissau", "ቢሳው" },
            { "timezone.excity.Africa/Douala", "ዱዋላ" },
            { "timezone.excity.Africa/Harare", "ሃራረ" },
            { "timezone.excity.Africa/Kigali", "ኪጋሊ" },
            { "timezone.excity.Africa/Luanda", "ሉዋንዳ" },
            { "timezone.excity.Africa/Lusaka", "ሉሳካ" },
            { "timezone.excity.Africa/Malabo", "ማላቦ" },
            { "timezone.excity.Africa/Maputo", "ማፑቶ" },
            { "timezone.excity.Africa/Maseru", "ማሰሩ" },
            { "timezone.excity.Africa/Niamey", "ንያመይ" },
            { "timezone.excity.America/Aruba", "ኣሩባ" },
            { "timezone.excity.America/Bahia", "ባህያ" },
            { "timezone.excity.America/Belem", "በለም" },
            { "timezone.excity.America/Boise", "ቦይዚ" },
            { "timezone.excity.America/Jujuy", "ሁሁይ" },
            { "timezone.excity.America/Sitka", "ሲትካ" },
            { "timezone.excity.America/Thule", "ዙል" },
            { "timezone.excity.Asia/Ashgabat", "ኣሽጋባት" },
            { "timezone.excity.Asia/Calcutta", "ኮልካታ" },
            { "timezone.excity.Asia/Damascus", "ደማስቆ" },
            { "timezone.excity.Asia/Dushanbe", "ዱሻንበ" },
            { "timezone.excity.Asia/Jayapura", "ጃያፑራ" },
            { "timezone.excity.Asia/Katmandu", "ካትማንዱ" },
            { "timezone.excity.Asia/Khandyga", "ካንዲጋ" },
            { "timezone.excity.Asia/Makassar", "ማካሳር" },
            { "timezone.excity.Asia/Qostanay", "ኮስታናይ" },
            { "timezone.excity.Asia/Sakhalin", "ሳካሊን" },
            { "timezone.excity.Asia/Shanghai", "ሻንግሃይ" },
            { "timezone.excity.Asia/Tashkent", "ታሽከንት" },
            { "timezone.excity.Asia/Ust-Nera", "ኡስት-ኔራ" },
            { "timezone.excity.Europe/Athens", "ኣቴንስ" },
            { "timezone.excity.Europe/Berlin", "በርሊን" },
            { "timezone.excity.Europe/Dublin", "ደብሊን" },
            { "timezone.excity.Europe/Jersey", "ጀርዚ" },
            { "timezone.excity.Europe/Lisbon", "ሊዝበን" },
            { "timezone.excity.Europe/London", "ሎንደን" },
            { "timezone.excity.Europe/Madrid", "ማድሪድ" },
            { "timezone.excity.Europe/Monaco", "ሞናኮ" },
            { "timezone.excity.Europe/Moscow", "ሞስኮ" },
            { "timezone.excity.Europe/Prague", "ፕራግ" },
            { "timezone.excity.Europe/Samara", "ሳማራ" },
            { "timezone.excity.Europe/Skopje", "ስኮፕየ" },
            { "timezone.excity.Europe/Tirane", "ቲራና" },
            { "timezone.excity.Europe/Vienna", "ቭየና" },
            { "timezone.excity.Europe/Warsaw", "ዋርሳው" },
            { "timezone.excity.Europe/Zagreb", "ዛግረብ" },
            { "timezone.excity.Europe/Zurich", "ዙሪክ" },
            { "timezone.excity.Indian/Chagos", "ቻጎስ" },
            { "timezone.excity.Indian/Comoro", "ኮሞሮ" },
            { "timezone.excity.Pacific/Efate", "ኤፋቴ" },
            { "timezone.excity.Pacific/Nauru", "ናውሩ" },
            { "timezone.excity.Pacific/Palau", "ፓላው" },
            { "America/Argentina/Buenos_Aires", Argentina },
            { "America/Argentina/Rio_Gallegos", Argentina },
            { "America/North_Dakota/New_Salem", America_Central },
            { "timezone.excity.Africa/Abidjan", "ኣቢጃን" },
            { "timezone.excity.Africa/Algiers", "ኣልጀርስ" },
            { "timezone.excity.Africa/Conakry", "ኮናክሪ" },
            { "timezone.excity.Africa/Kampala", "ካምፓላ" },
            { "timezone.excity.Africa/Mbabane", "ምባባነ" },
            { "timezone.excity.Africa/Nairobi", "ናይሮቢ" },
            { "timezone.excity.Africa/Tripoli", "ትሪፖሊ" },
            { "timezone.excity.America/Belize", "በሊዝ" },
            { "timezone.excity.America/Bogota", "ቦጎታ" },
            { "timezone.excity.America/Cancun", "ካንኩን" },
            { "timezone.excity.America/Cayman", "ካይማን" },
            { "timezone.excity.America/Cuiaba", "ኩያባ" },
            { "timezone.excity.America/Dawson", "ዳውሰን" },
            { "timezone.excity.America/Denver", "ደንቨር" },
            { "timezone.excity.America/Guyana", "ጉያና" },
            { "timezone.excity.America/Havana", "ሃቫና" },
            { "timezone.excity.America/Inuvik", "ኢኑቪክ" },
            { "timezone.excity.America/Juneau", "ጁነው" },
            { "timezone.excity.America/La_Paz", "ላ ፓዝ" },
            { "timezone.excity.America/Maceio", "ማሰዮ" },
            { "timezone.excity.America/Manaus", "ማናውስ" },
            { "timezone.excity.America/Merida", "መሪዳ" },
            { "timezone.excity.America/Nassau", "ናሳው" },
            { "timezone.excity.America/Panama", "ፓናማ" },
            { "timezone.excity.America/Recife", "ረሲፈ" },
            { "timezone.excity.America/Regina", "ረጂና" },
            { "timezone.excity.Asia/Famagusta", "ፋማጉስታ" },
            { "timezone.excity.Asia/Hong_Kong", "ሆንግ ኮንግ" },
            { "timezone.excity.Asia/Jerusalem", "የሩሳሌም" },
            { "timezone.excity.Asia/Kamchatka", "ካምቻትካ" },
            { "timezone.excity.Asia/Pontianak", "ፖንትያናክ" },
            { "timezone.excity.Asia/Pyongyang", "ፕዮንግያንግ" },
            { "timezone.excity.Asia/Qyzylorda", "ኪዚሎርዳ" },
            { "timezone.excity.Asia/Samarkand", "ሳማርካንድ" },
            { "timezone.excity.Asia/Singapore", "ሲንጋፖር" },
            { "timezone.excity.Asia/Vientiane", "ቭየንትያን" },
            { "timezone.excity.Europe/Andorra", "ኣንዶራ" },
            { "timezone.excity.Europe/Saratov", "ሳራቶቭ" },
            { "timezone.excity.Europe/Tallinn", "ታሊን" },
            { "timezone.excity.Europe/Vatican", "ቫቲካን" },
            { "timezone.excity.Europe/Vilnius", "ቪልንየስ" },
            { "timezone.excity.Indian/Mayotte", "ማዮት" },
            { "timezone.excity.Indian/Reunion", "ርዩንየን" },
            { "timezone.excity.Pacific/Easter", "ደሴት ፋሲካ" },
            { "timezone.excity.Pacific/Kosrae", "ኮስሬ" },
            { "timezone.excity.Pacific/Majuro", "ማጁሮ" },
            { "timezone.excity.Pacific/Midway", "ሚድወይ" },
            { "timezone.excity.Pacific/Noumea", "ኑመያ" },
            { "timezone.excity.Pacific/Ponape", "ፖንፐይ" },
            { "timezone.excity.Pacific/Saipan", "ሳይፓን" },
            { "timezone.excity.Pacific/Tahiti", "ታሂቲ" },
            { "timezone.excity.Pacific/Tarawa", "ታራዋ" },
            { "timezone.excity.Pacific/Wallis", "ዋሊስ" },
            { "timezone.excity.Africa/Blantyre", "ብላንታየር" },
            { "timezone.excity.Africa/Djibouti", "ጅቡቲ" },
            { "timezone.excity.Africa/El_Aaiun", "ኤል ኣዩን" },
            { "timezone.excity.Africa/Freetown", "ፍሪታውን" },
            { "timezone.excity.Africa/Gaborone", "ጋቦሮን" },
            { "timezone.excity.Africa/Khartoum", "ካርቱም" },
            { "timezone.excity.Africa/Kinshasa", "ኪንሻሳ" },
            { "timezone.excity.Africa/Monrovia", "ሞንሮቭያ" },
            { "timezone.excity.Africa/Ndjamena", "ንጃመና" },
            { "timezone.excity.Africa/Sao_Tome", "ሳኦ ቶመ" },
            { "timezone.excity.Africa/Windhoek", "ዊንድሆክ" },
            { "timezone.excity.America/Antigua", "ኣንቲጓ" },
            { "timezone.excity.America/Caracas", "ካራካስ" },
            { "timezone.excity.America/Cayenne", "ካየን" },
            { "timezone.excity.America/Chicago", "ቺካጎ" },
            { "timezone.excity.America/Cordoba", "ኮርዶባ" },
            { "timezone.excity.America/Creston", "ክረስተን" },
            { "timezone.excity.America/Curacao", "ኩራሳው" },
            { "timezone.excity.America/Detroit", "ዲትሮይት" },
            { "timezone.excity.America/Godthab", "ኑክ" },
            { "timezone.excity.America/Grenada", "ግረናዳ" },
            { "timezone.excity.America/Halifax", "ሃሊፋክስ" },
            { "timezone.excity.America/Iqaluit", "ኢቃልዊት" },
            { "timezone.excity.America/Jamaica", "ጃማይካ" },
            { "timezone.excity.America/Managua", "ማናጓ" },
            { "timezone.excity.America/Marigot", "ማሪጎት" },
            { "timezone.excity.America/Mendoza", "መንዶዛ" },
            { "timezone.excity.America/Moncton", "ሞንክተን" },
            { "timezone.excity.America/Noronha", "ኖሮንያ" },
            { "timezone.excity.America/Ojinaga", "ኦጂናጋ" },
            { "timezone.excity.America/Phoenix", "ፊኒክስ" },
            { "timezone.excity.America/Tijuana", "ቲጅዋና" },
            { "timezone.excity.America/Toronto", "ቶሮንቶ" },
            { "timezone.excity.America/Tortola", "ቶርቶላ" },
            { "timezone.excity.America/Yakutat", "ያኩታት" },
            { "timezone.excity.Asia/Phnom_Penh", "ፕኖም ፐን" },
            { "timezone.excity.Atlantic/Azores", "ኣዞረስ" },
            { "timezone.excity.Atlantic/Canary", "ካናሪ" },
            { "timezone.excity.Atlantic/Faeroe", "ደሴታት ፋሮ" },
            { "timezone.excity.Australia/Eucla", "ዩክላ" },
            { "timezone.excity.Australia/Perth", "ፐርዝ" },
            { "timezone.excity.Europe/Belgrade", "በልግሬድ" },
            { "timezone.excity.Europe/Brussels", "ብራስልስ" },
            { "timezone.excity.Europe/Budapest", "ቡዳፐስት" },
            { "timezone.excity.Europe/Busingen", "ቡሲንገን" },
            { "timezone.excity.Europe/Chisinau", "ኪሺናው" },
            { "timezone.excity.Europe/Guernsey", "ገርንዚ" },
            { "timezone.excity.Europe/Helsinki", "ሄልሲንኪ" },
            { "timezone.excity.Europe/Istanbul", "ኢስታንቡል" },
            { "timezone.excity.Europe/Sarajevo", "ሳራየቮ" },
            { "timezone.excity.Indian/Maldives", "ማልዲቭስ" },
            { "timezone.excity.Pacific/Chatham", "ቻታም" },
            { "timezone.excity.Pacific/Fakaofo", "ፋካኦፎ" },
            { "timezone.excity.Pacific/Gambier", "ጋምብየር" },
            { "timezone.excity.Pacific/Norfolk", "ኖርፎልክ" },
            { "timezone.excity.Africa/Bujumbura", "ቡጁምቡራ" },
            { "timezone.excity.Africa/Mogadishu", "ሞቓድሾ" },
            { "timezone.excity.America/Anguilla", "ኣንጒላ" },
            { "timezone.excity.America/Asuncion", "ኣሱንስዮን" },
            { "timezone.excity.America/Barbados", "ባርባዶስ" },
            { "timezone.excity.America/Dominica", "ዶሚኒካ" },
            { "timezone.excity.America/Edmonton", "ኤድመንተን" },
            { "timezone.excity.America/Eirunepe", "ኤይሩኔፒ" },
            { "timezone.excity.America/Mazatlan", "ማዛትላን" },
            { "timezone.excity.America/Miquelon", "ሚከሎን" },
            { "timezone.excity.America/New_York", "ኒው ዮርክ" },
            { "timezone.excity.America/Resolute", "ረዞሉት" },
            { "timezone.excity.America/Santarem", "ሳንታረም" },
            { "timezone.excity.America/Santiago", "ሳንትያጎ" },
            { "timezone.excity.America/St_Johns", "ቅዱስ ዮሃንስ" },
            { "timezone.excity.America/St_Kitts", "ቅዱስ ኪትስ" },
            { "timezone.excity.America/St_Lucia", "ቅድስቲ ሉስያ" },
            { "timezone.excity.America/Winnipeg", "ዊኒፐግ" },
            { "timezone.excity.Antarctica/Casey", "ከይዚ" },
            { "timezone.excity.Antarctica/Davis", "ደቪስ" },
            { "timezone.excity.Antarctica/Syowa", "ስዮዋ" },
            { "timezone.excity.Antarctica/Troll", "ትሮል" },
            { "timezone.excity.Asia/Krasnoyarsk", "ክራስኖያርስክ" },
            { "timezone.excity.Asia/Novosibirsk", "ኖቮሲቢርስክ" },
            { "timezone.excity.Asia/Ulaanbaatar", "ኡላን ባቶር" },
            { "timezone.excity.Asia/Vladivostok", "ቭላዲቮስቶክ" },
            { "timezone.excity.Atlantic/Bermuda", "በርሙዳ" },
            { "timezone.excity.Atlantic/Madeira", "ማደይራ" },
            { "timezone.excity.Atlantic/Stanley", "ስታንሊ" },
            { "timezone.excity.Australia/Darwin", "ዳርዊን" },
            { "timezone.excity.Australia/Hobart", "ሆባርት" },
            { "timezone.excity.Australia/Sydney", "ሲድኒ" },
            { "timezone.excity.Europe/Amsterdam", "ኣምስተርዳም" },
            { "timezone.excity.Europe/Astrakhan", "ኣስትራካን" },
            { "timezone.excity.Europe/Bucharest", "ቡካረስት" },
            { "timezone.excity.Europe/Gibraltar", "ጂብራልታር" },
            { "timezone.excity.Europe/Ljubljana", "ልዩብልያና" },
            { "timezone.excity.Europe/Mariehamn", "ማሪሃምን" },
            { "timezone.excity.Europe/Podgorica", "ፖድጎሪጻ" },
            { "timezone.excity.Europe/Stockholm", "ስቶክሆልም" },
            { "timezone.excity.Europe/Ulyanovsk", "ኡልያኖቭስክ" },
            { "timezone.excity.Europe/Volgograd", "ቮልጎግራድ" },
            { "timezone.excity.Indian/Christmas", "ክሪስማስ" },
            { "timezone.excity.Indian/Kerguelen", "ከርጉለን" },
            { "timezone.excity.Indian/Mauritius", "ማውሪሸስ" },
            { "timezone.excity.Pacific/Auckland", "ኦክላንድ" },
            { "timezone.excity.Pacific/Funafuti", "ፉናፉቲ" },
            { "timezone.excity.Pacific/Honolulu", "ሆኖሉሉ" },
            { "timezone.excity.Pacific/Pitcairn", "ፒትከርን" },
            { "timezone.excity.Africa/Casablanca", "ካዛብላንካ" },
            { "timezone.excity.Africa/Libreville", "ሊብረቪል" },
            { "timezone.excity.Africa/Lubumbashi", "ሉቡምባሺ" },
            { "timezone.excity.Africa/Nouakchott", "ንዋክሾት" },
            { "timezone.excity.Africa/Porto-Novo", "ፖርቶ ኖቮ" },
            { "timezone.excity.America/Anchorage", "ኣንኮረጅ" },
            { "timezone.excity.America/Araguaina", "ኣራጓይና" },
            { "timezone.excity.America/Boa_Vista", "ቦዋ ቪስታ" },
            { "timezone.excity.America/Catamarca", "ካታማርካ" },
            { "timezone.excity.America/Chihuahua", "ቺዋዋ" },
            { "timezone.excity.America/Coyhaique", "ኮሃይክ" },
            { "timezone.excity.America/Fortaleza", "ፎርታለዛ" },
            { "timezone.excity.America/Glace_Bay", "ግሌስ በይ" },
            { "timezone.excity.America/Goose_Bay", "ጉዝ በይ" },
            { "timezone.excity.America/Guatemala", "ጓቲማላ" },
            { "timezone.excity.America/Guayaquil", "ጓያኪል" },
            { "timezone.excity.America/Matamoros", "ማታሞሮስ" },
            { "timezone.excity.America/Menominee", "ሜኖሚኒ" },
            { "timezone.excity.America/Monterrey", "ሞንተረይ" },
            { "timezone.excity.America/Sao_Paulo", "ሳኦ ፓውሎ" },
            { "timezone.excity.America/St_Thomas", "ቅዱስ ቶማስ" },
            { "timezone.excity.America/Vancouver", "ቫንኩቨር" },
            { "timezone.excity.Antarctica/Mawson", "ማውሰን" },
            { "timezone.excity.Antarctica/Palmer", "ፓልመር" },
            { "timezone.excity.Antarctica/Vostok", "ቮስቶክ" },
            { "timezone.excity.Asia/Kuala_Lumpur", "ኳላ ሉምፑር" },
            { "timezone.excity.Asia/Novokuznetsk", "ኖቮኩዝነትስክ" },
            { "timezone.excity.Europe/Bratislava", "ብራቲስላቫ" },
            { "timezone.excity.Europe/Copenhagen", "ኮፐንሃገን" },
            { "timezone.excity.Europe/Luxembourg", "ሉክሰምበርግ" },
            { "timezone.excity.Europe/San_Marino", "ሳን ማሪኖ" },
            { "timezone.excity.Europe/Simferopol", "ሲምፈሮፖል" },
            { "timezone.excity.Pacific/Enderbury", "ካንቶን" },
            { "timezone.excity.Pacific/Galapagos", "ጋላፓጎስ" },
            { "timezone.excity.Pacific/Kwajalein", "ክዋጃሊን" },
            { "timezone.excity.Pacific/Marquesas", "ማርኬሳስ" },
            { "timezone.excity.Pacific/Pago_Pago", "ፓጎ ፓጎ" },
            { "timezone.excity.Pacific/Rarotonga", "ራሮቶንጋ" },
            { "timezone.excity.Pacific/Tongatapu", "ቶንጋታፑ" },
            { "timezone.excity.Africa/Addis_Ababa", "ኣዲስ ኣበባ" },
            { "timezone.excity.Africa/Brazzaville", "ብራዛቪል" },
            { "timezone.excity.Africa/Ouagadougou", "ዋጋዱጉ" },
            { "timezone.excity.America/Costa_Rica", "ኮስታ ሪካ" },
            { "timezone.excity.America/Grand_Turk", "ግራንድ ቱርክ" },
            { "timezone.excity.America/Guadeloupe", "ጓደሉፕ" },
            { "timezone.excity.America/Hermosillo", "ኤርሞስዮ" },
            { "timezone.excity.America/Kralendijk", "ክራለንዳይክ" },
            { "timezone.excity.America/Louisville", "ልዊቪል" },
            { "timezone.excity.America/Martinique", "ማርቲኒክ" },
            { "timezone.excity.America/Metlakatla", "መትላካትላ" },
            { "timezone.excity.America/Montevideo", "ሞንተቪደዮ" },
            { "timezone.excity.America/Montserrat", "ሞንትሰራት" },
            { "timezone.excity.America/Paramaribo", "ፓራማሪቦ" },
            { "timezone.excity.America/Rio_Branco", "ርዮ ብራንኮ" },
            { "timezone.excity.America/St_Vincent", "ቅዱስ ቪንሰንት" },
            { "timezone.excity.America/Whitehorse", "ዋይትሆዝ" },
            { "timezone.excity.Antarctica/McMurdo", "ማክሙርዶ" },
            { "timezone.excity.Antarctica/Rothera", "ሮዘራ" },
            { "timezone.excity.Asia/Srednekolymsk", "ስሬድነኮሊምስክ" },
            { "timezone.excity.Asia/Yekaterinburg", "የካተሪንበርግ" },
            { "timezone.excity.Atlantic/Reykjavik", "ረይክያቪክ" },
            { "timezone.excity.Atlantic/St_Helena", "ቅድስቲ ሄለና" },
            { "timezone.excity.Australia/Adelaide", "ኣደለይድ" },
            { "timezone.excity.Australia/Brisbane", "ብሪዝቤን" },
            { "timezone.excity.Australia/Lindeman", "ሊንድማን" },
            { "timezone.excity.Europe/Isle_of_Man", "ኣይል ኦፍ ማን" },
            { "timezone.excity.Europe/Kaliningrad", "ካሊኒንግራድ" },
            { "timezone.excity.Pacific/Kiritimati", "ኪሪቲማቲ" },
            { "timezone.excity.Africa/Johannesburg", "ጆሃንስበርግ" },
            { "timezone.excity.America/El_Salvador", "ኤል ሳልቫዶር" },
            { "timezone.excity.America/Fort_Nelson", "ፎርት ነልሰን" },
            { "timezone.excity.America/Los_Angeles", "ሎስ ኣንጀለስ" },
            { "timezone.excity.America/Mexico_City", "ከተማ ሜክሲኮ" },
            { "timezone.excity.America/Porto_Velho", "ፖርቶ ቨልዮ" },
            { "timezone.excity.America/Puerto_Rico", "ፖርቶ ሪኮ" },
            { "timezone.excity.America/Tegucigalpa", "ተጉሲጋልፓ" },
            { "timezone.excity.Arctic/Longyearbyen", "ሎንግየርባየን" },
            { "timezone.excity.Atlantic/Cape_Verde", "ኬፕ ቨርደ" },
            { "timezone.excity.Australia/Lord_Howe", "ሎርድ ሃው" },
            { "timezone.excity.Australia/Melbourne", "መልበርን" },
            { "timezone.excity.Indian/Antananarivo", "ኣንታናናሪቮ" },
            { "timezone.excity.Pacific/Guadalcanal", "ጓዳልካናል" },
            { "timezone.excity.Africa/Dar_es_Salaam", "ዳር ኤስ ሳላም" },
            { "timezone.excity.America/Blanc-Sablon", "ብላንክ-ሳብሎን" },
            { "timezone.excity.America/Buenos_Aires", "ብወኖስ ኣይረስ" },
            { "timezone.excity.America/Campo_Grande", "ካምፖ ግራንደ" },
            { "timezone.excity.America/Danmarkshavn", "ዳንማርክሻቭን" },
            { "timezone.excity.America/Dawson_Creek", "ዳውሰን ክሪክ" },
            { "timezone.excity.America/Indiana/Knox", "ኖክስ፣ ኢንድያና" },
            { "timezone.excity.America/Indianapolis", "ኢንድያናፖሊስ" },
            { "timezone.excity.America/Punta_Arenas", "ፑንታ ኣረናስ" },
            { "timezone.excity.America/Rankin_Inlet", "ራንኪን ኢንለት" },
            { "timezone.excity.America/Scoresbysund", "ኢቶቆርቶሚት" },
            { "timezone.excity.Antarctica/Macquarie", "ማኳሪ" },
            { "timezone.excity.Pacific/Bougainville", "ቡገንቪል" },
            { "timezone.excity.Pacific/Port_Moresby", "ፖርት ሞርስቢ" },
            { "timezone.excity.America/Cambridge_Bay", "ካምብሪጅ በይ" },
            { "timezone.excity.America/Ciudad_Juarez", "ሲዩዳድ ጁዋረዝ" },
            { "timezone.excity.America/Coral_Harbour", "ኣቲኮካን" },
            { "timezone.excity.America/Indiana/Vevay", "ቪቪ፣ ኢንድያና" },
            { "timezone.excity.America/Lower_Princes", "ለወር ፕሪንሰስ ኳርተር" },
            { "timezone.excity.America/Port_of_Spain", "ፖርት ኦፍ ስፔን" },
            { "timezone.excity.America/Santo_Domingo", "ሳንቶ ዶሚንጎ" },
            { "timezone.excity.America/St_Barthelemy", "ቅዱስ ባርተለሚ" },
            { "timezone.excity.America/Swift_Current", "ስዊፍት ካረንት" },
            { "timezone.excity.Australia/Broken_Hill", "ብሮክን ሂል" },
            { "timezone.excity.America/Bahia_Banderas", "ባእያ ደ ባንደራስ" },
            { "timezone.excity.America/Port-au-Prince", "ፖርት-ኦ-ፕሪንስ" },
            { "timezone.excity.Atlantic/South_Georgia", "ደቡብ ጆርጅያ" },
            { "timezone.excity.America/Argentina/Salta", "ሳልታ" },
            { "timezone.excity.America/Indiana/Marengo", "ማረንጎ፣ ኢንድያና" },
            { "timezone.excity.America/Indiana/Winamac", "ዊናማክ፣ ኢንድያና" },
            { "timezone.excity.America/Argentina/Tucuman", "ቱኩማን" },
            { "timezone.excity.America/Argentina/Ushuaia", "ኡሽዋያ" },
            { "timezone.excity.America/Indiana/Tell_City", "ተል ሲቲ፣ ኢንድያና" },
            { "timezone.excity.America/Indiana/Vincennes", "ቪንሰንስ፣ ኢንድያና" },
            { "timezone.excity.Antarctica/DumontDUrville", "ዱሞንት ዲኡርቪል" },
            { "timezone.excity.America/Argentina/La_Rioja", "ላ ርዮሃ" },
            { "timezone.excity.America/Argentina/San_Juan", "ሳን ህዋን" },
            { "timezone.excity.America/Argentina/San_Luis", "ሳን ልዊስ" },
            { "timezone.excity.America/Indiana/Petersburg", "ፒተርስበርግ፣ ኢንድያና" },
            { "timezone.excity.America/Kentucky/Monticello", "ሞንቲቸሎ፣ ከንታኪ" },
            { "timezone.excity.America/North_Dakota/Beulah", "ብዩላ፣ ሰሜን ዳኮታ" },
            { "timezone.excity.America/North_Dakota/Center", "ሰንተር፣ ሰሜን ዳኮታ" },
            { "timezone.excity.America/Argentina/Rio_Gallegos", "ርዮ ጋየጎስ" },
            { "timezone.excity.America/North_Dakota/New_Salem", "ኒው ሳለም፣ ሰሜን ዳኮታ" },
        };
        return data;
    }
}
